/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.factories;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosDocCategory;

public class AbsPOSSalesInvoiceFactory {
    public static <T extends AbsPOSSales> void updatePOSDataFromDTO(T invoice, DTOAbsPOSSalesDoc dtoNamaDoc) {
        invoice.setId(ServerStringUtils.strToUUID((String)dtoNamaDoc.getId()));
        invoice.setCode(dtoNamaDoc.getInvCode());
        invoice.setCustomer(POSMasterFile.findPOSRef(POSCustomer.class, dtoNamaDoc.getCustomer()));
        invoice.setSalesMan(POSMasterFile.findPOSRef(POSEmployee.class, dtoNamaDoc.getSalesMan()));
        invoice.setDiscountPercent(dtoNamaDoc.getMoney().getHeaderDiscount().getPercentage());
        invoice.setDiscountValue(dtoNamaDoc.getMoney().getHeaderDiscount().getValue());
        invoice.setWarehouse(POSMasterFile.findPOSRef(POSWarehouse.class, dtoNamaDoc.getWarehouse()));
        invoice.setLocation(POSMasterFile.findPOSRef(POSLocation.class, dtoNamaDoc.getLocator()));
        invoice.setCurrency(POSMasterFile.findPOSRef(POSCurrency.class, dtoNamaDoc.getMoney().getCurrency()));
        invoice.setValueDate(dtoNamaDoc.getValueDate());
        invoice.setValueTime(dtoNamaDoc.getValueDate());
        invoice.setNetPrice(dtoNamaDoc.getMoney().getNetValue());
        invoice.setPosInvoiceClassification(POSMasterFile.findPOSRef(POSInvoiceClassification.class, dtoNamaDoc.getInvoiceClassification()));
        invoice.setTotalPrice(dtoNamaDoc.getMoney().getTotal());
        invoice.setRemainingChange(dtoNamaDoc.getMoney().getRemaining());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoNamaDoc.getShiftId())) {
            invoice.setShiftId(ServerStringUtils.strToUUID((String)dtoNamaDoc.getShiftId()));
        }
        invoice.setShiftCode(dtoNamaDoc.getShiftCode());
        invoice.setPriceClassifier1(POSMasterFile.findPOSRef(POSSalesPriceClassifier1.class, dtoNamaDoc.getPriceClassifier1()));
        invoice.setPriceClassifier2(POSMasterFile.findPOSRef(POSSalesPriceClassifier2.class, dtoNamaDoc.getPriceClassifier2()));
        invoice.setPriceClassifier3(POSMasterFile.findPOSRef(POSSalesPriceClassifier3.class, dtoNamaDoc.getPriceClassifier3()));
        invoice.setPriceClassifier4(POSMasterFile.findPOSRef(POSSalesPriceClassifier4.class, dtoNamaDoc.getPriceClassifier4()));
        invoice.setPriceClassifier5(POSMasterFile.findPOSRef(POSSalesPriceClassifier5.class, dtoNamaDoc.getPriceClassifier5()));
        invoice.setTotalPaid(dtoNamaDoc.getMoney().getTotalPaid());
        invoice.setDocCategory(POSMasterFile.findPOSRef(PosDocCategory.class, dtoNamaDoc.getDocCategory()));
        invoice.setRegisterId(ServerStringUtils.strToUUID((String)dtoNamaDoc.getRegister().getId()));
        invoice.setPaidCash(dtoNamaDoc.getMoney().getPaidCash());
    }
}

