/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.factories;

import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.details.DTOAbsPOSSalesLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.valueobjects.POSDiscountTax;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;

public class AbsPOSSalesLineFactory {
    public static <T extends AbsPOSSalesLine, E extends AbsPOSSales> void copyPOSLineDataFromDTO(T invoiceLine, DTOAbsPOSSalesLine dtoLine, E invoice) {
        invoiceLine.setId(ServerStringUtils.strToUUID((String)dtoLine.getId()));
        invoiceLine.setUnitPrice(dtoLine.getPrice().getUnitPrice());
        invoiceLine.setDiscount1(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getDiscount1()));
        invoiceLine.setDiscount2(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getDiscount2()));
        invoiceLine.setDiscount3(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getDiscount3()));
        invoiceLine.setDiscount4(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getDiscount4()));
        invoiceLine.setDiscount5(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getDiscount5()));
        invoiceLine.setDiscount6(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getDiscount6()));
        invoiceLine.setDiscount7(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getDiscount7()));
        invoiceLine.setDiscount8(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getDiscount8()));
        invoiceLine.setHeaderDicount(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getHeaderDicount()));
        invoiceLine.setNetPrice(dtoLine.getPrice().getNetValue());
        invoiceLine.setQty(POSQuantity.fromDTORawQuantity(dtoLine.getQuantity().getQuantity().getPrimeQty(), invoice));
        invoiceLine.setTax1(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getTax1()));
        invoiceLine.setTax2(POSDiscountTax.fromDiscountEffect(dtoLine.getPrice().getTax2()));
        invoiceLine.setCurrency(invoice.getCurrency());
        invoiceLine.setFreeLine(dtoLine.getFreeLine());
        invoiceLine.setItem(POSMasterFile.findPOSRef(POSItem.class, dtoLine.getItem().getItem()));
        invoiceLine.setItemCode(dtoLine.getItem().getItemCode());
        invoiceLine.setItemActualCode(dtoLine.getItem().getItem().getCode());
        invoiceLine.setItemName(invoiceLine.getItem().nameByLanguage());
        invoiceLine.setItemDimensions(POSItemSpecificDimensions.fromDTOItemSpecificDimensions(dtoLine.getSpecificDimensions()));
        invoiceLine.getItemDimensions().setSizeName(dtoLine.getSizeName());
        invoiceLine.getItemDimensions().setColorName(dtoLine.getColorName());
        invoiceLine.setWarehouse(POSMasterFile.findPOSRef(POSWarehouse.class, dtoLine.getSpecificDimensions().getWarehouse()));
        invoiceLine.setLocation(POSMasterFile.findPOSRef(POSLocation.class, dtoLine.getSpecificDimensions().getLocator()));
        invoiceLine.setRemarks(dtoLine.getRemarks());
    }
}

