/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.orm;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.unique.AlterTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.mapping.Table;

public class NaMaSQLServerDialect
extends SQLServerDialect {
    private final UniqueDelegate uniqueDelegate = new NamaUniqueDelegate((Dialect)this);

    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case 1 -> "nchar(1)";
            case 12 -> "nvarchar($l)";
            case -1 -> "ntext";
            case 2005 -> "nvarchar(MAX)";
            default -> super.columnType(sqlTypeCode);
        };
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public static String hashedName(String name) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(name.getBytes());
            byte[] digest = md.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            return bigInt.toString(35);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HibernateException("Unable to generate a hashed Constraint name", (Throwable)e);
        }
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    public static class NamaUniqueDelegate
    extends AlterTableUniqueDelegate {
        public NamaUniqueDelegate(Dialect dialect) {
            super(dialect);
        }

        public String getTableCreationUniqueConstraintsFragment(Table table, SqlStringGenerationContext context) {
            String name = "CI" + NaMaSQLServerDialect.hashedName(table.getName() + "`clustring`");
            return " ,clustringColumn int NOT NULL IDENTITY (1, 1) CONSTRAINT " + name + " UNIQUE CLUSTERED";
        }
    }
}

