/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.entities.POSRegistery;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;

public class CashDrawerUtil {
    private static PrintService pservice;

    public static void openDrawer() {
        POSRegistery posRegistery = POSResourcesUtil.fetchMainRegister();
        String printerName = posRegistery.getPrinterName();
        String openCodeCSV = posRegistery.getOpenDrawerCmd();
        if (ObjectChecker.isEmptyOrNull((Object)printerName)) {
            printerName = "Epson";
        }
        if (ObjectChecker.isEmptyOrNull((Object)openCodeCSV)) {
            openCodeCSV = "27,112,48,55,221";
        }
        String[] parts = openCodeCSV.split(",");
        byte[] openCode = new byte[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            int intValue = Integer.valueOf(parts[i]);
            if (intValue > 127) {
                intValue = 127 - intValue;
            }
            openCode[i] = (byte)intValue;
            System.out.println(openCode[i]);
        }
        if (pservice == null) {
            pservice = CashDrawerUtil.findPrinter(printerName);
        }
        DocPrintJob job = pservice.createPrintJob();
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        SimpleDoc doc = new SimpleDoc(openCode, flavor, null);
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        try {
            job.print(doc, aset);
        }
        catch (PrintException ex) {
            System.out.print(ex);
        }
    }

    private static PrintService findPrinter(String printer) {
        pservice = printer != null ? CashDrawerUtil.findPrinterByName(printer) : PrintServiceLookup.lookupDefaultPrintService();
        return pservice;
    }

    private static PrintService findPrinterByName(String printer) {
        HashPrintServiceAttributeSet printserviceattributeset = new HashPrintServiceAttributeSet();
        printserviceattributeset.add(new PrinterName(printer, null));
        PrintService[] printservice = PrintServiceLookup.lookupPrintServices(null, printserviceattributeset);
        PrintService pservice = printservice.length > 0 ? printservice[0] : PrintServiceLookup.lookupDefaultPrintService();
        return pservice;
    }
}

