/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.util.POSResult;
import com.namasoft.upgrader.Platform;

public class LoginUtil {
    public static POSUser authenticateUser(String userId, String password, POSResult result) {
        return LoginUtil.authenticateUser(userId, password, POSResourcesUtil.fetchMainRegister(), result);
    }

    public static POSUser authenticateUser(String userId, String password, POSRegistery register, POSResult result) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{userId, password})) {
            return null;
        }
        POSUser user = POSPersister.findUser(userId);
        if (Platform.isInDebugMode()) {
            return user;
        }
        if (ObjectChecker.isEmptyOrNull((Object)user)) {
            return null;
        }
        if (ObjectChecker.areNotEqual((Object)user.getPassword(), (Object)ServerStringUtils.hash((String)password))) {
            return null;
        }
        if (ObjectChecker.isEmptyOrNull(register.getAllowedUsers())) {
            return user;
        }
        boolean authorizedUser = register.getAllowedUsers().stream().anyMatch(l -> ObjectChecker.areEqual((Object)l.getPosUser(), (Object)user));
        if (authorizedUser) {
            return user;
        }
        result.failure("User ({0}) can not access this register ({1})", user.nameByLanguage(), register.nameByLanguage());
        return null;
    }
}

