/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.basic.enums.YesNo;
import com.namasoft.modules.supplychain.enums.YesNoInheritedPolicy;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoice;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;

public class POSConfigurationUtil {
    public static boolean shouldAddDeliveryItemAutomaticallyInInv() {
        return POSConfigurationUtil.shouldAddSpecialItem(POSResourcesUtil.fetchMainRegister().getAddDeliveryItemAutomaticallyInInv(), POSResourcesUtil.fetchPOSConfig().getAddDeliveryItemAutomaticallyInInv());
    }

    public static boolean shouldAddDeliveryItemWithInvoiceClassification() {
        return POSConfigurationUtil.shouldAddSpecialItem(POSResourcesUtil.fetchMainRegister().getAddDeliveryItemByInvoiceClassification(), POSResourcesUtil.fetchPOSConfig().getAddDeliveryByInvoiceClassification());
    }

    public static boolean shouldAddDeliveryItemWithCustomer() {
        return POSConfigurationUtil.shouldAddSpecialItem(POSResourcesUtil.fetchMainRegister().getAddDeliveryItemWithCustomer(), POSResourcesUtil.fetchPOSConfig().getAddDeliveryItemWithCustomer());
    }

    public static boolean shouldAddServiceItemAutomaticallyInInv() {
        return POSConfigurationUtil.shouldAddSpecialItem(POSResourcesUtil.fetchMainRegister().getAddServiceItemAutomaticallyInInv(), POSResourcesUtil.fetchPOSConfig().getAddServiceItemAutomaticallyInInv());
    }

    public static boolean shouldAddServiceItemWithInvoiceClassification() {
        return POSConfigurationUtil.shouldAddSpecialItem(POSResourcesUtil.fetchMainRegister().getAddServiceItemByInvClassification(), POSResourcesUtil.fetchPOSConfig().getAddServiceChargeByInvClassification());
    }

    public static boolean shouldAddServiceItemWhenSelectingTable() {
        return POSConfigurationUtil.shouldAddSpecialItem(POSResourcesUtil.fetchMainRegister().getAddServiceItemWhenSelectingTable(), POSResourcesUtil.fetchPOSConfig().getAddServiceChargeWhenSelectingTable());
    }

    public static boolean shouldAddMinChargeItemWithInvoiceClassification() {
        return POSConfigurationUtil.shouldAddSpecialItem(POSResourcesUtil.fetchMainRegister().getAddMinChargeItemByInvClassification(), POSResourcesUtil.fetchPOSConfig().getAddMinChargeByInvClassification());
    }

    private static boolean shouldAddSpecialItem(String registerOptionVal, String configOptionVal) {
        if (ObjectChecker.isEmptyOrNull((Object)registerOptionVal) || ObjectChecker.areEqual((Object)registerOptionVal, (Object)YesNoInheritedPolicy.Inherited.name())) {
            return ObjectChecker.areEqual((Object)configOptionVal, (Object)YesNo.Yes.name());
        }
        return ObjectChecker.areEqual((Object)registerOptionVal, (Object)YesNoInheritedPolicy.Yes.name());
    }

    private static boolean shouldAddSpecialItem(String registerOptionVal, Boolean configOptionVal) {
        if (ObjectChecker.isEmptyOrNull((Object)registerOptionVal) || ObjectChecker.areEqual((Object)registerOptionVal, (Object)YesNoInheritedPolicy.Inherited.name())) {
            return ObjectChecker.isTrue((Boolean)configOptionVal);
        }
        return ObjectChecker.areEqual((Object)registerOptionVal, (Object)YesNoInheritedPolicy.Yes.name());
    }

    public static void useUserAsSalesmanIfNeeded(AbsPOSSales salesDoc, POSUser user, Callback<?> callback) {
        boolean canUseUserAsSalesman;
        if (ObjectChecker.isNotEmptyOrNull((Object)salesDoc.getSalesMan()) || user == null) {
            return;
        }
        boolean bl = canUseUserAsSalesman = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseUserAsSalesMan()) && user.getEmpId() != null;
        if (!canUseUserAsSalesman) {
            return;
        }
        POSEmployee employee = POSPersister.findByID(POSEmployee.class, ObjectChecker.toStringOrEmpty((Object)user.getEmpId()));
        if (ObjectChecker.isNotEmptyOrNull((Object)employee) && employee.getSalesMan().booleanValue()) {
            salesDoc.setSalesMan(employee);
            callback.done(null);
        }
    }

    public static void useUserAsSalesmanIfNeeded(AbsPOSSales salesDoc, Callback<?> callback) {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        POSConfigurationUtil.useUserAsSalesmanIfNeeded(salesDoc, currentUser, callback);
    }

    public static boolean shouldCheckReturnAndReplacementOnServer(IPOSDocFromInvoice invoice) {
        return invoice.isFromInvoiceOnServer() != false || POSResourcesUtil.fetchPOSConfig().getReturnAndReplaceInvoicesUsingNamaServer() != false;
    }

    public static Boolean shouldAllowCustomerToOverpayByNonCash(POSRegistery register) {
        String allowCustomerToOverpayByNonCash = register.getAllowCustomerToOverpayByNonCash();
        if (ObjectChecker.areEqual((Object)allowCustomerToOverpayByNonCash, (Object)YesNoInheritedPolicy.Yes.name())) {
            return true;
        }
        if (ObjectChecker.areEqual((Object)allowCustomerToOverpayByNonCash, (Object)YesNoInheritedPolicy.No.name())) {
            return false;
        }
        return ObjectChecker.areEqual((Object)POSResourcesUtil.fetchPOSConfig().getAllowCustomerToOverpayByNonCash(), (Object)YesNo.Yes.name());
    }
}

