/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.util.POSDataWriterUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class POSDataWriterRunner
implements Runnable {
    private ThreadFactory daemonThreadFactory = r -> {
        Thread thread = new Thread(r);
        thread.setName("POSDataWriterRunner");
        thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        thread.setDaemon(true);
        return thread;
    };
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(this.daemonThreadFactory);
    private static POSDataWriterRunner instance = new POSDataWriterRunner();

    public static POSDataWriterRunner instance() {
        return instance;
    }

    private POSDataWriterRunner() {
    }

    @Override
    public void run() {
        try {
            POSDataWriterUtil.internalWriteData(POSResourcesUtil.fetchMainRegister());
        }
        finally {
            this.executor.schedule(POSDataWriterRunner.instance(), 1L, TimeUnit.HOURS);
        }
    }

    public static void stop() {
        if (POSDataWriterRunner.instance().executor != null) {
            NaMaLogger.info((Object)"***************///// Shutting dow POSDataWriterRunner \\\\\\\\\\********");
            POSDataWriterRunner.instance().executor.shutdownNow();
        }
    }

    public static void start() {
        POSDataWriterRunner.instance().executor.schedule(POSDataWriterRunner.instance(), 0L, TimeUnit.MILLISECONDS);
    }
}

