/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;
import com.namasoft.modules.namapos.enums.POSSalesHeaderField;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.modules.supplychain.enums.DimensionPolicy;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.PaymentDialogHelper;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSActionLine;
import com.namasoft.pos.domain.details.POSItemUnit;
import com.namasoft.pos.domain.details.POSSalesPriceListLine;
import com.namasoft.pos.domain.details.POSSalesRepalcementLine;
import com.namasoft.pos.domain.details.POSSizesAndColors;
import com.namasoft.pos.domain.entities.IPosDocWithoutPayment;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemSection;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSecurity;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.domain.valueobjects.POSDiscountTax;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.PosSalesUtil;
import com.namasoft.pos.util.ValidateDocRequest;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;

public class POSEntityUtil {
    private static Map<DiscountLocation, String> discountCapabilitiesMap = new HashMap<DiscountLocation, String>();
    private static HashMap<DiscountLocation, Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>>> discountsMap = new HashMap();
    private static HashMap<DiscountLocation, String> discountsMessages = new HashMap();

    public static boolean isReturn(POSDocumentType docType) {
        return ObjectChecker.isNotEmptyOrNull((Object)((Object)docType)) && docType.equals((Object)POSDocumentType.Return);
    }

    public static boolean isShortfallsDoc(POSDocumentType docType) {
        return ObjectChecker.isNotEmptyOrNull((Object)((Object)docType)) && docType.equals((Object)POSDocumentType.ShortfallsDoc);
    }

    public static boolean isScrapDoc(POSDocumentType docType) {
        return ObjectChecker.isNotEmptyOrNull((Object)((Object)docType)) && docType.equals((Object)POSDocumentType.ScrapDoc);
    }

    public static boolean isCancelReservation(POSDocumentType docType) {
        return docType.equals((Object)POSDocumentType.POSCancelReservation);
    }

    public static boolean isOrderReservation(POSDocumentType docType) {
        return docType.equals((Object)POSDocumentType.POSOrderReservation);
    }

    public static boolean isNotReservation(POSDocumentType docType) {
        return !POSEntityUtil.isOrderReservation(docType) && !POSEntityUtil.isCancelReservation(docType);
    }

    public static boolean isInvoice(POSDocumentType docType) {
        return ObjectChecker.isNotEmptyOrNull((Object)((Object)docType)) && docType.equals((Object)POSDocumentType.Invoice);
    }

    public static boolean isStockTransfer(POSDocumentType docType) {
        return ObjectChecker.isNotEmptyOrNull((Object)((Object)docType)) && docType.equals((Object)POSDocumentType.StockTransferReq);
    }

    public static boolean isReplacement(POSDocumentType docType) {
        return ObjectChecker.isNotEmptyOrNull((Object)((Object)docType)) && docType.equals((Object)POSDocumentType.Replacement);
    }

    public static boolean isStockTakingDetails(POSDocumentType docType) {
        return docType.equals((Object)POSDocumentType.StockTakingDetails);
    }

    public static boolean isStockReceipt(POSDocumentType docType) {
        return docType.equals((Object)POSDocumentType.POSStockReceipt);
    }

    public static boolean isPersistedDoc(POSDocumentType type, AbsPOSSales salesDoc) {
        Class klass = null;
        if (type.equals((Object)POSDocumentType.Invoice)) {
            klass = POSSalesInvoice.class;
        }
        if (type.equals((Object)POSDocumentType.POSOrderReservation)) {
            klass = POSOrderReservation.class;
        }
        if (type.equals((Object)POSDocumentType.Return)) {
            klass = POSSalesReturn.class;
        }
        if (type.equals((Object)POSDocumentType.Replacement)) {
            klass = POSSalesReplacement.class;
        }
        if (type.equals((Object)POSDocumentType.POSOrderReservation)) {
            klass = POSOrderReservation.class;
        }
        if (type.equals((Object)POSDocumentType.POSCancelReservation)) {
            klass = PosCancelReservation.class;
        }
        return POSPersister.count(klass, " WHERE id=:id", POSPersister.params("id", salesDoc.getId())).intValue() > 0;
    }

    public static <T extends AbsPOSSalesLine> POSResult validateInvoice(ValidateDocRequest request) {
        POSResult result = new POSResult();
        POSEntityUtil.validateDocCategory(request.getDocCategoryCode(), request.getSalesDoc(), result);
        POSEntityUtil.checkShift(request.getRegister(), request.getSalesDoc(), result);
        POSEntityUtil.checkTable(request.getTableCode(), result);
        POSEntityUtil.checkSalesMan(request.getSalesmanCode(), request.getSalesDoc(), request.getDocType(), result);
        if (POSEntityUtil.isStockTransfer(request.getDocType())) {
            POSEntityUtil.validateStockTransfer(request.getToWarehouseCode(), request.getFromWarehouseCode(), request.getDocCategoryCode(), request.getDocType(), result);
        } else {
            POSEntityUtil.validateHeader(request, result);
            POSEntityUtil.validateDisc(request.getSalesDoc(), request.getDiscPercent(), request.getDiscVal(), request.getDisc2Val(), result);
            POSEntityUtil.validateLines(request.getItems(), request.getSalesDoc(), request.getDocType(), result);
            POSEntityUtil.validateMinCharge(result, request.getSalesDoc(), request.getDocType());
        }
        if (POSEntityUtil.isOrderReservation(request.getDocType()) && ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotValidateReservationDateAndTime())) {
            POSEntityUtil.validateReservationDate(request.getSalesDoc(), request.getDocType(), request.getReservationDate(), request.getFromTime(), request.getToTime(), result);
        }
        request.getSalesDoc().hasEmptyReqFields(result);
        return result;
    }

    private static void validateDocCategory(String docCategoryCode, AbsPOSSales salesDoc, POSResult result) {
        if (ObjectChecker.isEmptyOrNull((Object)docCategoryCode)) {
            return;
        }
        PosDocCategory posDocCategory = (PosDocCategory)POSPersister.findByCode(PosDocCategory.class, docCategoryCode);
        if (ObjectChecker.isEmptyOrNull((Object)posDocCategory)) {
            result.failure("Invalid Invoice document Category code", new Object[0]);
            return;
        }
        String entityType = salesDoc.calcNamaEntityType();
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{posDocCategory.getForType(), posDocCategory.getTypeListTypes()})) {
            return;
        }
        String types = "," + ObjectChecker.toStringOrEmpty((Object)posDocCategory.getForType()) + ",";
        if (posDocCategory.getTypeListTypes() != null) {
            types = types + posDocCategory.getTypeListTypes();
        }
        if (!types.contains("," + entityType + ",")) {
            result.failure(POSResourcesUtil.id("Document category type incompatible with screen type ", new Object[0]), new Object[0]);
        }
    }

    private static void checkShift(POSRegistery register, AbsPOSSales salesDoc, POSResult result) {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        POSShiftOpen lastShift = POSResourcesUtil.fetchLastOpenShift(register);
        if (ObjectChecker.isEmptyOrNull((Object)lastShift)) {
            result.failure("Please open shift firstly", new Object[0]);
        } else if (ObjectChecker.areNotEqual((Object)lastShift.getPosUser().getId(), (Object)currentUser.getId()) && !salesDoc.canSaveInAnotherUserShift()) {
            result.failure("Another user shift. User: {0} opened shift at: {1} {2}", lastShift.getPosUser().nameByLanguage(), lastShift.getTime(), LocalDateUtils.dateToLocalDate((Date)lastShift.getShiftDate()));
        }
    }

    private static void checkTable(String tableCode, POSResult result) {
        POSTable table;
        if (ObjectChecker.isNotEmptyOrNull((Object)tableCode) && ObjectChecker.isFalseOrNull((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getUseMultiTableAsDefault()) && ObjectChecker.isEmptyOrNull((Object)(table = (POSTable)POSPersister.findByCode(POSTable.class, tableCode)))) {
            result.failure("Invalid table code", new Object[0]);
        }
    }

    public static void checkSalesMan(String salesmanCode, AbsPOSSales salesDoc, POSDocumentType docType, POSResult result) {
        if (ObjectChecker.isNotEmptyOrNull((Object)salesmanCode)) {
            POSEmployee salesMan = (POSEmployee)POSPersister.findByCode(POSEmployee.class, salesmanCode);
            if (ObjectChecker.isEmptyOrNull((Object)salesMan)) {
                result.failure("Invalid salesman code", new Object[0]);
            } else if (!salesMan.getSalesMan().booleanValue()) {
                result.failure("This employee is not a salesman", new Object[0]);
            }
            if (result.isSucceeded().booleanValue()) {
                salesDoc.setSalesMan(salesMan);
            }
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getSalesManIsRequired()) && POSEntityUtil.isEmpty(salesDoc.getSalesMan(), POSSalesHeaderField.SalesMan, docType) && POSEntityUtil.isEmptySalesmanInLines(salesDoc.fetchDetails())) {
            result.failure("Salesman is required", new Object[0]);
        }
    }

    private static boolean isEmpty(Object o, POSSalesHeaderField fieldId, POSDocumentType documentType) {
        List<String> pageFields = POSUISettingsUtil.mainLinesForTypes(documentType);
        List allFields = Stream.concat(pageFields.stream(), POSUISettingsUtil.otherLinesForTypes(documentType).stream()).distinct().collect(Collectors.toList());
        if (ObjectChecker.isEmptyOrNull(allFields)) {
            return ObjectChecker.isEmptyOrNull((Object)o);
        }
        return ObjectChecker.isEmptyOrNull((Object)o) && allFields.contains(fieldId.toString());
    }

    private static boolean isEmptySalesmanInLines(List<? extends AbsPOSSalesLine> details) {
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fillSalesManInDetails())) {
            return false;
        }
        Long emptyLinesCount = details.stream().filter(l -> ObjectChecker.isEmptyOrNull((Object)l.getSalesman())).count();
        return ObjectChecker.areNotEqual((Object)emptyLinesCount.intValue(), (Object)0);
    }

    private static void validateStockTransfer(String toWarehouseCode, String fromWarehouseCode, String docCategoryCode, POSDocumentType docType, POSResult result) {
        if (POSEntityUtil.isEmpty(toWarehouseCode, POSSalesHeaderField.Warehouse, docType)) {
            result.failure(POSResourcesUtil.id("To warehouse is required", new Object[0]), new Object[0]);
        }
        if (ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{fromWarehouseCode, toWarehouseCode}) && ObjectChecker.areEqual((Object)fromWarehouseCode, (Object)toWarehouseCode)) {
            result.failure(POSResourcesUtil.id("Same warehouse", new Object[0]), new Object[0]);
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getStockTransferDocCategoryIsRequired()) && POSEntityUtil.isEmpty(docCategoryCode, POSSalesHeaderField.DocCategory, docType)) {
            result.failure(POSResourcesUtil.id("Document category is required", new Object[0]), new Object[0]);
        }
    }

    private static void validateHeader(ValidateDocRequest request, POSResult result) {
        POSWarehouse warehouse;
        POSInvoiceClassification classification;
        if (ObjectChecker.isEmptyOrNull((Object)request.getSalesDoc().getPosInvoiceClassification()) && ObjectChecker.isNotEmptyOrNull((Object)request.getInvoiceClassificationCode()) && ObjectChecker.isEmptyOrNull((Object)(classification = (POSInvoiceClassification)POSPersister.findByCode(POSInvoiceClassification.class, request.getInvoiceClassificationCode())))) {
            result.failure("Invalid Invoice Classification code", new Object[0]);
        }
        if (ObjectChecker.isEmptyOrNull((Object)request.getInvCode())) {
            result.failure("Please enter code", new Object[0]);
        }
        if (ObjectChecker.isEmptyOrNull((Object)request.getSalesDoc().getCurrency())) {
            result.failure("Please enter currency", new Object[0]);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)request.getCurrencyCode()) && ObjectChecker.isEmptyOrNull(POSPersister.findByCode(POSCurrency.class, request.getCurrencyCode()))) {
            result.failure("Invalid currency code", new Object[0]);
        }
        if (ObjectChecker.isEmptyOrNull((Object)request.getSalesDoc().getWarehouse())) {
            result.failure("Please enter warehouse", new Object[0]);
        } else if (ObjectChecker.isNotEmptyOrNull((Object)request.getWarehouseCode()) && ObjectChecker.isEmptyOrNull((Object)(warehouse = (POSWarehouse)POSPersister.findByCode(POSWarehouse.class, request.getWarehouseCode())))) {
            result.failure("Invalid warehouse code", new Object[0]);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)request.getToWarehouseCode()) && ObjectChecker.isEmptyOrNull(POSPersister.findByCode(POSWarehouse.class, request.getToWarehouseCode()))) {
            result.failure("Invalid warehouse code", new Object[0]);
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getCustomerRequiredInPOS()) && POSEntityUtil.isEmpty(request.getCustomerCode(), POSSalesHeaderField.Customer, request.getDocType()) && ObjectChecker.isEmptyOrNull((Object)request.getSubsidiaryCode())) {
            result.failure("Customer or subsidiary required", new Object[0]);
        }
        if (request.getSalesDoc().getCustomer() == null && ObjectChecker.isNotEmptyOrNull((Object)request.getCustomerCode())) {
            POSMasterFile customer = (POSMasterFile)CollectionsUtility.getFirst(POSPersister.selectTop(POSCustomer.class, "WHERE " + POSCustomer.filteringCondition("", " = ", "value"), 1, POSPersister.params("value", request.getCustomerCode())));
            if (ObjectChecker.isNotEmptyOrNull((Object)request.getCustomerCode()) && ObjectChecker.isEmptyOrNull((Object)customer)) {
                result.failure("Could not find a customer with the code {0}", request.getCustomerCode());
            }
        } else if (request.getSalesDoc().getCustomer() != null && ObjectChecker.areNotEqual((Object)request.getSalesDoc().getCustomer().getCode(), (Object)request.getCustomerCode())) {
            result.failure("The customer in the sales document ({0}) does not match the selected customer ({1}). Please verify your selection.", request.getSalesDoc().getCustomer().getCode(), request.getCustomerCode());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)request.getLocationCode()) && ObjectChecker.isEmptyOrNull(POSPersister.findByCode(POSLocation.class, request.getLocationCode())) && ObjectChecker.isFalse((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddLocatorToLines())) {
            result.failure("Invalid location code", new Object[0]);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)request.getToLocationCode()) && ObjectChecker.isEmptyOrNull(POSPersister.findByCode(POSLocation.class, request.getToLocationCode())) && ObjectChecker.isFalse((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddLocatorToLines())) {
            result.failure("Invalid location code", new Object[0]);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)request.getItemCode()) && ObjectChecker.isEmptyOrNull(POSPersister.findByCode(POSItem.class, request.getItemCode()))) {
            result.failure("Invalid item code", new Object[0]);
        }
    }

    private static void validateDisc(AbsPOSSales salesDoc, BigDecimal discPercent, BigDecimal discVal, BigDecimal disc2Val, POSResult result) {
        if (ObjectChecker.areAllEmptyOrZero((BigDecimal[])new BigDecimal[]{discPercent, discVal, disc2Val})) {
            return;
        }
        POSEmployee posEmployee = POSEntityUtil.fetchEmployeeForPricing(salesDoc, null);
        if (ObjectChecker.isNotEmptyOrNull((Object)discPercent)) {
            if (discPercent.compareTo(BigDecimal.ZERO) < 0) {
                result.failure("Discount percentage cannot be negative", new Object[0]);
            }
            if (discPercent.compareTo(BigDecimal.valueOf(100L)) > 0) {
                result.failure("Discount percentage cannot exceed 100%", new Object[0]);
            }
            if (posEmployee != null && discPercent.compareTo(posEmployee.getMaxHeaderDiscPercentage()) > 0) {
                result.failure("Header discount percentage cannot exceed sales man maximum percentage", new Object[0]);
            }
        }
        POSEntityUtil.validateDiscount(result, salesDoc, discVal, null, true, posEmployee);
        POSEntityUtil.validateDiscount(result, salesDoc, disc2Val, ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{POSResourcesUtil.fetchMainRegister().getMaxFractionDiscountValue(), POSResourcesUtil.fetchPOSConfig().getMaxFractionDiscountValue()}), false, posEmployee);
    }

    private static POSEmployee fetchEmployeeForPricing(AbsPOSSales salesDoc, DiscountLocation discountLocation) {
        POSEmployee discountApplier = POSEntityUtil.fetchDiscountApplier(salesDoc, discountLocation);
        if (discountApplier != null) {
            return discountApplier;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)salesDoc.getSalesMan())) {
            return salesDoc.getSalesMan();
        }
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        if (ObjectChecker.isNotEmptyOrNull((Object)currentUser.getEmpId())) {
            return POSPersister.findByID(POSEmployee.class, currentUser.getEmpId().toString());
        }
        return null;
    }

    private static Map<DiscountLocation, String> fetchDiscountCapabilitiesMap() {
        if (ObjectChecker.isNotEmptyOrNull(discountCapabilitiesMap)) {
            return discountCapabilitiesMap;
        }
        discountCapabilitiesMap.put(DiscountLocation.Discount1, POSResourcesUtil.idToEnglish(POSSecurityCapability.CanMakeLineDisc.name(), new Object[0]));
        discountCapabilitiesMap.put(DiscountLocation.Discount2, POSResourcesUtil.idToEnglish(POSSecurityCapability.CanMakeLineDisc2.name(), new Object[0]));
        discountCapabilitiesMap.put(DiscountLocation.Discount3, POSResourcesUtil.idToEnglish(POSSecurityCapability.CanMakeLineDisc3.name(), new Object[0]));
        discountCapabilitiesMap.put(DiscountLocation.Discount4, POSResourcesUtil.idToEnglish(POSSecurityCapability.CanMakeLineDisc4.name(), new Object[0]));
        discountCapabilitiesMap.put(DiscountLocation.Discount5, POSResourcesUtil.idToEnglish(POSSecurityCapability.CanMakeLineDisc5.name(), new Object[0]));
        discountCapabilitiesMap.put(DiscountLocation.Discount6, POSResourcesUtil.idToEnglish(POSSecurityCapability.CanMakeLineDisc6.name(), new Object[0]));
        discountCapabilitiesMap.put(DiscountLocation.Discount7, POSResourcesUtil.idToEnglish(POSSecurityCapability.CanMakeLineDisc7.name(), new Object[0]));
        discountCapabilitiesMap.put(DiscountLocation.Discount8, POSResourcesUtil.idToEnglish(POSSecurityCapability.CanMakeLineDisc8.name(), new Object[0]));
        return discountCapabilitiesMap;
    }

    private static POSEmployee fetchDiscountApplier(AbsPOSSales salesDoc, DiscountLocation discountLocation) {
        if (!(salesDoc instanceof POSSalesInvoice)) {
            return null;
        }
        if (discountLocation == null) {
            UUID discountApplier = ((POSSalesInvoice)salesDoc).getDiscountApplier();
            if (discountApplier == null) {
                return null;
            }
            return POSPersister.findByID(POSEmployee.class, discountApplier);
        }
        List<?> actionLines = POSPersister.searchFor(" FROM " + POSActionLine.class.getSimpleName() + " WHERE docId=: docId  AND docType=: docType ", POSPersister.params("docId", salesDoc.getId(), "docType", salesDoc.calcNamaEntityType()));
        if (ObjectChecker.isEmptyOrNull(actionLines)) {
            return null;
        }
        POSActionLine actionLine = actionLines.stream().filter(l -> ObjectChecker.areEqual((Object)POSEntityUtil.fetchDiscountCapabilitiesMap().get(discountLocation), (Object)l.getCapability())).findFirst().orElse(null);
        if (ObjectChecker.isEmptyOrNull((Object)actionLine)) {
            return null;
        }
        return POSPersister.findByID(POSEmployee.class, ((POSActionLine)actionLines.getFirst()).getAuthorizedUser().getEmpId());
    }

    private static void validateDiscount(POSResult result, AbsPOSSales salesDoc, BigDecimal discountVal, BigDecimal maxDiscValue, boolean basicDiscount, POSEmployee discountApplier) {
        if (ObjectChecker.isEmptyOrNull((Object)discountVal)) {
            return;
        }
        if (discountVal.compareTo(ObjectChecker.toZeroIfNull((BigDecimal)salesDoc.getTotalPrice())) > 0) {
            result.failure("Invalid discount", new Object[0]);
        }
        if (discountApplier != null && basicDiscount && discountVal.compareTo(discountApplier.getMaxHeaderDiscValue()) > 0) {
            result.failure("Header discount value cannot exceed sales man maximum value", new Object[0]);
        }
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)maxDiscValue) && discountVal.compareTo(maxDiscValue) > 0) {
            result.failure(basicDiscount ? "Discount value exceed max allowed value {0}" : "Fraction Discount value exceed max allowed value {0}", maxDiscValue);
        }
    }

    private static void validateLines(List<AbsPOSSalesLine> items, AbsPOSSales salesDoc, POSDocumentType docType, POSResult result) {
        if (ObjectChecker.isEmptyOrNull(items) && POSEntityUtil.isNotReservation(docType)) {
            result.failure("Empty Lines", new Object[0]);
        }
        if (ObjectChecker.isEmptyOrNull(items)) {
            return;
        }
        POSWarehouse warehouse = POSResourcesUtil.fetchRegisterWarehouse();
        HashMap<String, BigDecimal> itemsQtys = new HashMap<String, BigDecimal>();
        for (int i = 0; i < items.size(); ++i) {
            AbsPOSSalesLine line = items.get(i);
            if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotValidateOnLocatorInSales()) && ObjectChecker.areEqual((Object)warehouse.getLocatorPolicy(), (Object)DimensionPolicy.Required.toString()) && ObjectChecker.isEmptyOrNull((Object)line.getLocation())) {
                result.failure("Line without locator {0}", i + 1);
            }
            if (ObjectChecker.isEmptyOrNull((Object)line.getItemCode())) {
                result.failure("Line without Item code {0}", i + 1);
            }
            if (ObjectChecker.isEmptyOrNull((Object)line.getQty()) || ObjectChecker.isEmptyOrZero((BigDecimal)line.getQty().getValue())) {
                result.failure("Line without quantity {0}", i + 1);
            }
            if (ObjectChecker.isEmptyOrNull((Object)line.getQty().getUom())) {
                result.failure("Line {0} without UOM ", i + 1);
            }
            if (ObjectChecker.isEmptyOrZero((BigDecimal)line.getUnitPrice()) && !line.getFreeLine().booleanValue() && ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getAllowSaveWithZeroItemPrice()) && ObjectChecker.areNotEqual((Object)line.getItem(), (Object)AbsPOSSales.fetchServiceItem()) && ObjectChecker.areNotEqual((Object)line.getWarehouseIssueMethod(), (Object)"ToBeIssued") && !(salesDoc instanceof IPosDocWithoutPayment)) {
                result.failure("Line without price {0}", i + 1);
            }
            POSEntityUtil.validateLinesColorsAndSizes(result, i, line);
            POSEntityUtil.checkDiscount(result, line, line.getDiscount1(), DiscountLocation.Discount1, salesDoc);
            POSEntityUtil.checkDiscount(result, line, line.getDiscount2(), DiscountLocation.Discount2, salesDoc);
            POSEntityUtil.checkDiscount(result, line, line.getDiscount3(), DiscountLocation.Discount3, salesDoc);
            POSEntityUtil.checkDiscount(result, line, line.getDiscount4(), DiscountLocation.Discount4, salesDoc);
            POSEntityUtil.checkDiscount(result, line, line.getDiscount5(), DiscountLocation.Discount5, salesDoc);
            POSEntityUtil.checkDiscount(result, line, line.getDiscount6(), DiscountLocation.Discount6, salesDoc);
            POSEntityUtil.checkDiscount(result, line, line.getDiscount7(), DiscountLocation.Discount7, salesDoc);
            POSEntityUtil.checkDiscount(result, line, line.getDiscount8(), DiscountLocation.Discount8, salesDoc);
            POSEntityUtil.validatePercentageBetween0And100_ValueNotNegative(result, line, line.getTax1(), "Tax");
            POSEntityUtil.validatePercentageBetween0And100_ValueNotNegative(result, line, line.getTax2(), "Tax");
            POSEntityUtil.constructItemQtiesMap(itemsQtys, line);
            if (!POSEntityUtil.isInvoice(salesDoc.docType()) && ObjectChecker.isNotEmptyOrNull((Object)line.getItem())) {
                POSEntityUtil.checkItemWithType(result, line, docType);
            }
            POSEntityUtil.checkLinePriceFromPriceLists(result, line, i);
            POSEntityUtil.checkLinePriceFromItemUnits(result, line, i);
            POSEntityUtil.checkPriceAfterDiscountsWithMin(result, line, i);
        }
        if (!POSEntityUtil.isReplacement(docType)) {
            BigDecimal totalQty = BigDecimal.ZERO;
            for (Map.Entry entry : itemsQtys.entrySet()) {
                String itemCode = ((String)entry.getKey()).split("_#_")[0];
                if (((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) < 0) {
                    result.failure("Item quantity cannot be negative {0}", itemCode);
                }
                totalQty = totalQty.add((BigDecimal)entry.getValue());
            }
            if (totalQty.compareTo(BigDecimal.ZERO) <= 0) {
                result.failure("Cannot save invoice with zero or negative quantities", new Object[0]);
            }
        }
    }

    private static void validateLinesColorsAndSizes(POSResult result, int i, AbsPOSSalesLine line) {
        if (ObjectChecker.isEmptyOrNull((Object)line.getItem())) {
            return;
        }
        POSItem item = line.getItem();
        if (ObjectChecker.isNotEmptyOrNull((Object)item.getItemConfig())) {
            if (ObjectChecker.isEmptyOrNull((Object)line.getItemDimensions().getColor()) && ObjectChecker.areEqual((Object)item.getItemConfig().getColorPolicy(), (Object)"Required")) {
                result.failure("Color is required in line ", i + 1);
            }
            if (ObjectChecker.isEmptyOrNull((Object)line.getItemDimensions().getSize()) && ObjectChecker.areEqual((Object)item.getItemConfig().getSizePolicy(), (Object)"Required")) {
                result.failure("Size is required in line ", i + 1);
            }
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getEnableNotSellableAndNotPurchasableOnColorAndSizeLines())) {
            POSEntityUtil.validateSizeAndColorNotSellable(result, i, line);
        }
    }

    private static void validateSizeAndColorNotSellable(POSResult result, int i, AbsPOSSalesLine line) {
        String size = line.getItemDimensions().getSize();
        String color = line.getItemDimensions().getColor();
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{size, color})) {
            return;
        }
        POSSizesAndColors sizesAndColorsLine = line.fetchItem().getSizesAndColors().stream().filter(l -> ObjectChecker.areEqual((Object)l.getColor(), (Object)color) && ObjectChecker.areEqual((Object)l.getSize(), (Object)size)).findFirst().orElse(null);
        if (sizesAndColorsLine == null) {
            return;
        }
        if (ObjectChecker.isTrue((Boolean)sizesAndColorsLine.getNotSellable())) {
            result.failure("The size {0} with color {1} at line {2} not sellable.", size, color, i + 1);
        }
    }

    private static void checkDiscount(POSResult result, AbsPOSSalesLine line, POSDiscountTax discountOrTax, DiscountLocation discLocation, AbsPOSSales salesDoc) {
        POSEntityUtil.validatePercentageBetween0And100_ValueNotNegative(result, line, discountOrTax, "Discount");
        POSEntityUtil.validateDiscountPercentageWithEmployee(result, line, discLocation, salesDoc);
    }

    private static void validatePercentageBetween0And100_ValueNotNegative(POSResult result, AbsPOSSalesLine line, POSDiscountTax discountOrTax, String discOrTax) {
        if (discountOrTax.getPercentage().compareTo(BigDecimal.ZERO) < 0) {
            result.failure("{0} cannot be negative", discOrTax);
        }
        if (discountOrTax.getValue().compareTo(BigDecimal.ZERO) < 0 && line.getQty().getValue().compareTo(BigDecimal.ZERO) > 0) {
            result.failure("{0} cannot be negative", discOrTax);
        }
        if (discountOrTax.getPercentage().compareTo(BigDecimal.valueOf(100L)) > 0) {
            result.failure("{0} percentage cannot be greater than 100", discOrTax);
        }
    }

    private static void validateDiscountPercentageWithEmployee(POSResult result, AbsPOSSalesLine line, DiscountLocation discLocation, AbsPOSSales salesDoc) {
        if (salesDoc instanceof POSSalesReturn) {
            return;
        }
        if (salesDoc instanceof POSSalesReplacement && ((POSSalesRepalcementLine)line).getReturnedLine().booleanValue()) {
            return;
        }
        if (line.getDeactivateEmpDiscountsValidations().booleanValue()) {
            return;
        }
        POSDiscountTax discountTax = (POSDiscountTax)((Function)POSEntityUtil.discountsMap(discLocation).getKey()).apply(line);
        if (discountTax.isEmptyOrZero()) {
            return;
        }
        POSEmployee posEmployee = POSEntityUtil.fetchEmployeeForPricing(salesDoc, discLocation);
        if (posEmployee == null) {
            return;
        }
        BigDecimal maxEmpPercent = (BigDecimal)((Function)((Pair)POSEntityUtil.discountsMap(discLocation).getValue()).getKey()).apply(posEmployee);
        BigDecimal maxEmpValue = (BigDecimal)((Function)((Pair)POSEntityUtil.discountsMap(discLocation).getValue()).getValue()).apply(posEmployee);
        if (discountTax.getPercentage().compareTo(maxEmpPercent) > 0) {
            result.failure(POSEntityUtil.discountsMessages(discLocation), discountTax.getPercentage(), maxEmpPercent);
        }
        if (discountTax.getValue().compareTo(maxEmpValue) > 0) {
            result.failure(POSEntityUtil.discountsMessages(discLocation), discountTax.getValue(), maxEmpValue);
        }
    }

    private static Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>> discountsMap(DiscountLocation location) {
        if (discountsMap.size() > 0) {
            return discountsMap.get(location);
        }
        discountsMap.put(DiscountLocation.Discount1, (Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>>)new Pair(AbsPOSSalesLine::getDiscount1, (Object)new Pair(POSEmployee::getMaxDisc1Percentage, POSEmployee::getMaxDisc1Value)));
        discountsMap.put(DiscountLocation.Discount2, (Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>>)new Pair(AbsPOSSalesLine::getDiscount2, (Object)new Pair(POSEmployee::getMaxDisc2Percentage, POSEmployee::getMaxDisc2Value)));
        discountsMap.put(DiscountLocation.Discount3, (Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>>)new Pair(AbsPOSSalesLine::getDiscount3, (Object)new Pair(POSEmployee::getMaxDisc3Percentage, POSEmployee::getMaxDisc3Value)));
        discountsMap.put(DiscountLocation.Discount4, (Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>>)new Pair(AbsPOSSalesLine::getDiscount4, (Object)new Pair(POSEmployee::getMaxDisc4Percentage, POSEmployee::getMaxDisc4Value)));
        discountsMap.put(DiscountLocation.Discount5, (Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>>)new Pair(AbsPOSSalesLine::getDiscount5, (Object)new Pair(POSEmployee::getMaxDisc5Percentage, POSEmployee::getMaxDisc5Value)));
        discountsMap.put(DiscountLocation.Discount6, (Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>>)new Pair(AbsPOSSalesLine::getDiscount6, (Object)new Pair(POSEmployee::getMaxDisc6Percentage, POSEmployee::getMaxDisc6Value)));
        discountsMap.put(DiscountLocation.Discount7, (Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>>)new Pair(AbsPOSSalesLine::getDiscount7, (Object)new Pair(POSEmployee::getMaxDisc7Percentage, POSEmployee::getMaxDisc7Value)));
        discountsMap.put(DiscountLocation.Discount8, (Pair<Function<AbsPOSSalesLine, POSDiscountTax>, Pair<Function<POSEmployee, BigDecimal>, Function<POSEmployee, BigDecimal>>>)new Pair(AbsPOSSalesLine::getDiscount8, (Object)new Pair(POSEmployee::getMaxDisc8Percentage, POSEmployee::getMaxDisc8Value)));
        return discountsMap.get(location);
    }

    private static String discountsMessages(DiscountLocation location) {
        if (discountsMessages.size() > 0) {
            return discountsMessages.get(location);
        }
        discountsMessages.put(DiscountLocation.Discount1, "Discount 1 {0} cannot exceed sales man maximum {1}");
        discountsMessages.put(DiscountLocation.Discount2, "Discount 2 {0} cannot exceed sales man maximum {1}");
        discountsMessages.put(DiscountLocation.Discount3, "Discount 3 {0} cannot exceed sales man maximum {1}");
        discountsMessages.put(DiscountLocation.Discount4, "Discount 4 {0} cannot exceed sales man maximum {1}");
        discountsMessages.put(DiscountLocation.Discount5, "Discount 5 {0} cannot exceed sales man maximum {1}");
        discountsMessages.put(DiscountLocation.Discount6, "Discount 6 {0} cannot exceed sales man maximum {1}");
        discountsMessages.put(DiscountLocation.Discount7, "Discount 7 {0} cannot exceed sales man maximum {1}");
        discountsMessages.put(DiscountLocation.Discount8, "Discount 8 {0} cannot exceed sales man maximum {1}");
        return discountsMessages.get(location);
    }

    public static void constructItemQtiesMap(HashMap<String, BigDecimal> itemsQtys, AbsPOSSalesLine line) {
        BigDecimal value = line.getQty().getValue();
        if (line instanceof POSSalesRepalcementLine && value.compareTo(BigDecimal.ZERO) > 0) {
            return;
        }
        value = value.abs();
        String key = POSEntityUtil.generateSalesLineKey(line);
        if (ObjectChecker.isEmptyOrNull((Object)itemsQtys.get(key))) {
            itemsQtys.put(key, value);
        } else {
            itemsQtys.put(key, itemsQtys.get(key).add(value));
        }
    }

    public static String generateSalesLineKey(AbsPOSSalesLine line) {
        String itemId = line.getItem() != null ? line.getItem().getId().toString() : line.getItemCode();
        return itemId + "_#_" + (ObjectChecker.isNotEmptyOrNull((Object)line.getQty().getUom()) ? line.getQty().getUom().getId().toString() : "") + "_#_" + line.getItemDimensions().getBox() + "_#_" + line.getItemDimensions().getColor() + "_#_" + line.getItemDimensions().getLotId() + "_#_" + line.getItemDimensions().getRevisionId() + "_#_" + line.getItemDimensions().getSecondSerial() + "_#_" + line.getItemDimensions().getSerialNumber() + "_#_" + line.getItemDimensions().getSize() + "_#_";
    }

    private static void checkItemWithType(POSResult result, AbsPOSSalesLine line, POSDocumentType docType) {
        if (POSEntityUtil.isReturn(docType) && !line.getItem().getReturnable().booleanValue()) {
            result.failure("item {0} is not returnable", line.getItem().getCode());
        }
        if (POSEntityUtil.isReplacement(docType)) {
            POSItemSection section = line.getItem().getSection();
            Boolean replaceable = line.getItem().getReplaceable() != false || section != null && section.getReplaceable() != false;
            if (!replaceable.booleanValue()) {
                result.failure("item {0} is not replaceable", line.getItem().getCode());
            }
        }
    }

    private static void checkLinePriceFromPriceLists(POSResult result, AbsPOSSalesLine line, int index) {
        Boolean forcePriceList = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getForcePriceLists());
        if (!forcePriceList.booleanValue()) {
            return;
        }
        Boolean ignoreFreeItemForcePriceList = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getIgnoreForcePriceListWithFreeItem());
        if (ignoreFreeItemForcePriceList.booleanValue() && line.getFreeLine().booleanValue()) {
            return;
        }
        UUID priceListLineId = line.getPriceListLineId();
        if (priceListLineId == null) {
            return;
        }
        POSSalesPriceListLine priceListLine = POSPersister.findByID(POSSalesPriceListLine.class, priceListLineId);
        BigDecimal unitPrice = line.getUnitPrice().abs();
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)priceListLine.getMinPrice()) && unitPrice.compareTo(priceListLine.getMinPrice()) < 0) {
            result.failure("line {0} unit price {1} less than minimum price {2}", index + 1, unitPrice, priceListLine.getMinPrice());
        }
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)priceListLine.getMaxPrice()) && unitPrice.compareTo(priceListLine.getMaxPrice()) > 0) {
            result.failure("line {0} unit price {1} more than max price {2}", index + 1, unitPrice, priceListLine.getMaxPrice());
        }
    }

    private static void checkLinePriceFromItemUnits(POSResult result, AbsPOSSalesLine line, int i) {
        Boolean forcePriceFromItemUnits = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getForceItemPricesFromUnits());
        if (!forcePriceFromItemUnits.booleanValue()) {
            return;
        }
        POSItem item = POSPersister.findByID(POSItem.class, line.getItem().getId());
        List matchUnitLines = item.getUnits().stream().filter(l -> ObjectChecker.areEqual((Object)l.getUnit(), (Object)line.getQty().getUom())).collect(Collectors.toList());
        if (ObjectChecker.isEmptyOrNull(matchUnitLines)) {
            return;
        }
        BigDecimal unitPrice = line.getUnitPrice().abs();
        BigDecimal minPrice = ObjectChecker.toZeroIfNull((BigDecimal)((POSItemUnit)matchUnitLines.get(0)).getMinPrice());
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)minPrice) && unitPrice.compareTo(minPrice) < 0) {
            result.failure("line {0} unit price {1} less than minimum price {2}", i + 1, unitPrice, minPrice);
        }
    }

    private static void checkPriceAfterDiscountsWithMin(POSResult result, AbsPOSSalesLine line, int i) {
        BigDecimal minPriceByUomFactor;
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        if (ObjectChecker.isEmptyOrNull((Object)currentUser)) {
            return;
        }
        POSSecurity security = currentUser.getSecurity();
        if (ObjectChecker.isEmptyOrNull((Object)security)) {
            return;
        }
        Boolean forceMinPriceWithDiscounts = security.getForceMinPriceWithDiscounts();
        if (ObjectChecker.isFalseOrNull((Boolean)forceMinPriceWithDiscounts)) {
            return;
        }
        UUID priceListLineId = line.getPriceListLineId();
        if (priceListLineId == null) {
            return;
        }
        POSSalesPriceListLine priceListLine = POSPersister.findByID(POSSalesPriceListLine.class, priceListLineId);
        BigDecimal priceFactor = POSSalesPriceUtil.findUOMPriceFactor(line.getItem(), line.getQty().getUom(), priceListLine.getQty().getUom());
        BigDecimal linePriceAfterDiscs = line.getTotalPrice().abs().subtract(line.getHeaderDicount().getValue()).subtract(line.getDiscount1().getValue()).subtract(line.getDiscount2().getValue()).subtract(line.getDiscount3().getValue()).subtract(line.getDiscount4().getValue()).subtract(line.getDiscount5().getValue()).subtract(line.getDiscount6().getValue()).subtract(line.getDiscount7().getValue()).subtract(line.getDiscount8().getValue());
        if (linePriceAfterDiscs.compareTo(minPriceByUomFactor = priceListLine.getMinPrice().multiply(priceFactor).multiply(line.getQty().getValue())) < 0) {
            result.failure("line {0} price after discounts {1} less than minimum price {2}", i + 1, linePriceAfterDiscs, minPriceByUomFactor);
        }
    }

    private static void validateMinCharge(POSResult result, AbsPOSSales salesDoc, POSDocumentType docType) {
        if (POSEntityUtil.isInvoice(docType) && ObjectChecker.isNotEmptyOrNull((Object)PosSalesUtil.fetchMinChargeSettings()) && PaymentDialogHelper.minChargeItemMustBeReCalculated(salesDoc, (AbsPosSalesScreen)POSResourcesUtil.currentScreen, result)) {
            result.failure(POSResourcesUtil.id("Minimum charge item has been recalculated ", salesDoc.calculateMinChargeVal()), new Object[0]);
        }
    }

    private static void validateReservationDate(AbsPOSSales salesDoc, POSDocumentType docType, Date reservationDate, String fromTime, String toTime, POSResult result) {
        List<POSTable> tables = salesDoc.calcTables();
        if (!POSEntityUtil.isOrderReservation(docType) || ObjectChecker.isEmptyOrNull(tables)) {
            return;
        }
        if (ObjectChecker.isEmptyOrNull((Object)reservationDate)) {
            result.failure(POSResourcesUtil.id("Reservation date is required", new Object[0]), new Object[0]);
        } else if (LocalDateUtils.dateToLocalDate((Date)reservationDate).isBefore(LocalDate.now())) {
            result.failure(POSResourcesUtil.id("Reservation Invalid date", new Object[0]), new Object[0]);
        }
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{fromTime, toTime})) {
            result.failure(POSResourcesUtil.id("Reservation from and to time is required", new Object[0]), new Object[0]);
        }
    }
}

