/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.NodeOrientation;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.imageio.ImageIO;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class POSImgUtil {
    public static String fetchItemImagePathName(String id, String itemCode, Integer preferredWidth) {
        Object fileName = id;
        if (ObjectChecker.isTrue((Boolean)POSImgUtil.useSizeAndColorAttachmentAsImageInPOS()) && ObjectChecker.isNotEmptyOrNull((Object)itemCode)) {
            fileName = (String)fileName + itemCode;
        } else if (preferredWidth != null) {
            fileName = (String)fileName + "_#_" + preferredWidth;
        }
        return POSGeneralSettings.getImagesFolderPath() + "/" + (String)fileName + ".png";
    }

    public static boolean useSizeAndColorAttachmentAsImageInPOS() {
        return ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUseSizeAndColorAttachmentAsImageInPOS());
    }

    public static Image scaleItemImg(String id, String itemCode, Integer preferredWidth, Integer preferredHeight) {
        try {
            String saveTo = POSImgUtil.fetchItemImagePathName(id, itemCode, preferredWidth);
            return POSImgUtil.resizeImage(new File(POSImgUtil.fetchItemImagePathName(id, itemCode, preferredWidth)), preferredWidth, preferredHeight, new File(saveTo));
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    private static Image resizeImage(File file, Integer scaledWidth, Integer scaledHeight, File saveTo) throws IOException {
        if (!file.exists()) {
            return null;
        }
        BufferedImage originalImage = ImageIO.read(file);
        if (originalImage == null) {
            return null;
        }
        int originalHeight = originalImage.getHeight();
        int originalWidth = originalImage.getWidth();
        if (originalHeight <= scaledHeight && originalWidth <= scaledWidth) {
            return POSImgUtil.saveImgWithNewSize(originalWidth, originalHeight, saveTo, originalImage);
        }
        if (originalHeight > originalWidth) {
            scaledWidth = scaledHeight * originalWidth / originalHeight;
        } else {
            scaledHeight = scaledWidth * originalHeight / originalWidth;
        }
        return POSImgUtil.saveImgWithNewSize(scaledWidth, scaledHeight, saveTo, originalImage);
    }

    public static Image saveImgWithNewSize(int scaledWidth, int scaledHeight, File saveTo, BufferedImage originalImage) throws IOException {
        BufferedImage scaledImage = new BufferedImage(scaledWidth, scaledHeight, originalImage.getType());
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g2d.dispose();
        ImageIO.write((RenderedImage)scaledImage, "png", saveTo);
        return SwingFXUtils.toFXImage((BufferedImage)scaledImage, null);
    }

    public static InputStream convertToInputStream(Image image) {
        try {
            BufferedImage bImage = SwingFXUtils.fromFXImage((Image)image, null);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bImage, "png", outputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (IOException e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    public static ImageView createSVGImageView(String imageName) {
        ImageView imageView = new ImageView(POSImgUtil.fetchSVGImage(imageName));
        imageView.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        return imageView;
    }

    public static Image fetchSVGImage(String imageName) {
        Image fxImage = null;
        try {
            String svgURI = POSImgUtil.class.getClassLoader().getResource(imageName).toURI().toString();
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
            SVGDocument doc = factory.createSVGDocument(svgURI);
            UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
            BridgeContext bridgeContext = new BridgeContext((UserAgent)userAgentAdapter);
            bridgeContext.setDynamicState(2);
            GVTBuilder builder = new GVTBuilder();
            builder.build(bridgeContext, (Document)doc);
            POSImageTranscoder transcoder = new POSImageTranscoder();
            TranscoderInput input = new TranscoderInput((Document)doc);
            transcoder.transcode(input, null);
            fxImage = transcoder.getFXImage();
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        return fxImage;
    }

    private static class POSImageTranscoder
    extends ImageTranscoder {
        private BufferedImage image;

        private POSImageTranscoder() {
        }

        public BufferedImage createImage(int width, int height) {
            this.image = new BufferedImage(width, height, 2);
            return this.image;
        }

        public void writeImage(BufferedImage img, TranscoderOutput out) {
            this.image = img;
        }

        public Image getFXImage() {
            return SwingFXUtils.toFXImage((BufferedImage)this.image, null);
        }
    }
}

