/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.MoneyEffectType;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.SafeBigDecimal;
import com.namasoft.common.utilities.SimpleEntry;
import com.namasoft.contracts.common.dtos.ListOfGenericValues;
import com.namasoft.contracts.common.dtos.config.DTOGlobalConfig;
import com.namasoft.modules.commonbasic.contracts.entities.DTOTaxPlan;
import com.namasoft.modules.commonbasic.contracts.invoicing.IDTOInvoiceLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGlobalConfigInfo;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvoiceLineMoney;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvoiceMoney;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOMoneyEffectDetails;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxConfiguration;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxEffectOnDiscount;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;
import com.namasoft.modules.commonbasic.enums.TaxApplyType;
import com.namasoft.modules.commonbasic.enums.TaxLocation;
import com.namasoft.modules.commonbasic.enums.TaxLocation2;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class POSMoneyUtils {
    public static Integer fractionalDecimalPlaces = 2;
    public static Integer displayDecimalPlaces = 2;
    private static final List<String> salesParamsList = Arrays.asList("qtyValue", "unitPrice", "totalPrice", "discount1Percent", "discount1Value", "afterDisc1", "discount2Percent", "discount2Value", "afterDisc2", "discount3Percent", "discount3Value", "afterDisc3", "discount4Percent", "discount4Value", "afterDisc4", "discount5Percent", "discount5Value", "afterDisc5", "discount6Percent", "discount6Value", "afterDisc6", "discount7Percent", "discount7Value", "afterDisc7", "discount8Percent", "discount8Value", "afterDisc8", "tax1Percent", "tax1Value", "afterTax1", "tax2Percent", "tax2Value", "afterTax2", "headerDiscPercent", "headerDiscValue", "netPrice");
    private static HashMap<String, Function<AbsPOSSalesLine, Object>> salesLineParams = new HashMap();
    public static Integer percentageScale = null;

    public static ListOfGenericValues applyLinePricesInMoney(ListOfGenericValues genericValues, List details, DTOInvoiceMoney money, boolean singleLine, DTOTaxConfiguration taxConfiguration) {
        return POSMoneyUtils.applyLinePricesInMoney(genericValues, details, null, money, singleLine, true, taxConfiguration);
    }

    public static BigDecimal calculateTotalFor(MoneyEffectType effectType, List<AbsPOSSalesLine> lines, AbsPOSSales doc) {
        BigDecimal total = BigDecimal.ZERO;
        EntityReferenceData legalEntity = POSResourcesUtil.fetchMainRegister().fetchLegalEntityRef();
        DTOTaxPlan headerTaxPlan = POSResourcesUtil.fetchPosConfigDtoTaxPlan();
        DTOGlobalConfigInfo info = POSResourcesUtil.fetchGlobalConfig().getInfo();
        String entityType = doc.calcNamaEntityType();
        for (AbsPOSSalesLine line : lines) {
            DTOTaxConfiguration taxConfiguration = DTOTaxPlan.fetchTaxConfiguration((DTOTaxPlan)headerTaxPlan, (DTOTaxPlan)POSResourcesUtil.fetchItemDtoTaxPlanFrom(line == null ? null : line.getItem()), (EntityReferenceData)legalEntity, (Date)doc.getValueDate(), (DTOGlobalConfigInfo)info, (String)entityType);
            DTOInvoiceLineMoney price = line.fetchPrice();
            if (price == null) {
                price = line.getPrice();
            }
            List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects = POSMoneyUtils.sortEffects(price, taxConfiguration);
            BigDecimal previous = price.getPrice();
            for (int i = 0; i < effects.size(); ++i) {
                if (!ObjectChecker.areEqual((Object)effects.get(i).getKey(), (Object)effectType)) continue;
                if (i <= 0) break;
                previous = ((DTOMoneyEffectDetails)effects.get(i - 1).getValue()).getAfterValue();
                break;
            }
            AbsPOSSalesLine dto = line;
            total = total.add(POSMoneyUtils.calculateTotalFor(effectType, previous, effects, price.getPrice(), price.getCustom(), dto.unitQuantity(), taxConfiguration, dto));
        }
        return total;
    }

    private static ListOfGenericValues applyLinePricesInMoney(ListOfGenericValues genericValues, List details, List newItems, DTOInvoiceMoney money, boolean singleLine, Boolean taxable, DTOTaxConfiguration taxConfiguration) {
        if (newItems != null) {
            details.addAll(newItems);
        }
        if (ObjectChecker.isFalse((Boolean)taxable)) {
            money.setTax3Per(BigDecimal.ZERO);
            money.setTax4Per(BigDecimal.ZERO);
        }
        DTOGlobalConfigInfo globalConfigInfo = POSResourcesUtil.fetchGlobalConfig().getInfo();
        money.resetAccumualtingValues();
        for (int i = 0; i < details.size(); ++i) {
            boolean freeLineWithNotAllowedTaxes;
            IDTOInvoiceLine dto = (IDTOInvoiceLine)details.get(i);
            DTOInvoiceLineMoney price = dto.getPrice();
            if (price == null) {
                dto.setPrice(new DTOInvoiceLineMoney());
            }
            price.updateNulls();
            boolean bl = freeLineWithNotAllowedTaxes = ObjectChecker.isTrue((Boolean)dto.isFreeLine()) && ObjectChecker.isTrue((Boolean)globalConfigInfo.getNoTaxesForFreeItem());
            if (ObjectChecker.isFalse((Boolean)taxable) || freeLineWithNotAllowedTaxes) {
                price.getTax1().setPercentage(BigDecimal.ZERO);
                price.getTax1().setMaxNormalPercent(BigDecimal.ZERO);
                price.getTax2().setPercentage(BigDecimal.ZERO);
                price.getTax2().setMaxNormalPercent(BigDecimal.ZERO);
            }
            POSMoneyUtils.updateLineMoney(money, price, dto.unitQuantity(), dto.isFreeLine(), taxConfiguration, dto);
            if (freeLineWithNotAllowedTaxes) {
                price.setUnitPrice(BigDecimal.ZERO);
            }
            dto.setPrice(price);
        }
        money.updateInvoiceMoney();
        return genericValues;
    }

    private static BigDecimal applyEffects(List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects, DTOInvoiceMoney money, BigDecimal total, BigDecimal custom, BigDecimal qty, Boolean freeLine, DTOTaxConfiguration taxConfiguration, IDTOInvoiceLine line) {
        BigDecimal mainPrice = total;
        for (SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails> entry : effects) {
            DTOMoneyEffectDetails effect = (DTOMoneyEffectDetails)entry.getValue();
            BigDecimal percentage = effect.getPercentage();
            MoneyEffectType effectType = (MoneyEffectType)entry.getKey();
            if (POSMoneyUtils.isTaxPercentage(effectType)) {
                percentage = effect.getMaxNormalPercent();
            }
            BigDecimal discountValue = BigDecimal.ZERO;
            discountValue = POSMoneyUtils.isTaxValueNotPercentage(effectType, taxConfiguration) ? POSMoneyUtils.calcEffectByValueNotPercentage(qty, percentage, effectType, taxConfiguration) : POSMoneyUtils.calcEffectByPercentage(effects, total, mainPrice, custom, percentage, effectType, qty, taxConfiguration, line);
            if (ObjectChecker.isTrue((Boolean)freeLine) && !POSMoneyUtils.isTaxPercentage(effectType)) {
                discountValue = BigDecimal.ZERO;
            }
            effect.setValue(discountValue);
            if (POSMoneyUtils.shouldIncludedEffectInTotal(effectType, taxConfiguration)) {
                if (POSMoneyUtils.shouldSubtract(effectType, taxConfiguration)) {
                    effect.setAfterValue(total.subtract(discountValue));
                } else {
                    effect.setAfterValue(total.add(discountValue));
                }
            } else {
                effect.setAfterValue(total);
            }
            total = effect.getAfterValue();
            money.updateAccumulatingField(total, discountValue, effectType);
        }
        return total;
    }

    private static BigDecimal calcEffectByPercentage(List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects, BigDecimal total, BigDecimal mainPrice, BigDecimal custom, BigDecimal percentage, MoneyEffectType effectType, BigDecimal qty, DTOTaxConfiguration taxConfiguration, IDTOInvoiceLine line) {
        BigDecimal totalForEffect = POSMoneyUtils.calculateTotalFor(effectType, total, effects, mainPrice, custom, qty, taxConfiguration, line);
        BigDecimal discountValue = POSMoneyUtils.isTaxIncludedInPrice(effectType, taxConfiguration) ? SafeBigDecimal.n((BigDecimal)totalForEffect).subtract(SafeBigDecimal.n((BigDecimal)totalForEffect).multiply(Integer.valueOf(100)).divide(SafeBigDecimal.n((Integer)100).add(percentage)).v()).v() : NaMaMath.calcPercentageValue((BigDecimal)totalForEffect, (BigDecimal)percentage, (Integer)fractionalDecimalPlaces);
        return discountValue;
    }

    private static BigDecimal calcEffectByValueNotPercentage(BigDecimal qty, BigDecimal percentage, MoneyEffectType effectType, DTOTaxConfiguration taxConfiguration) {
        BigDecimal qtyForTax = qty;
        if (POSMoneyUtils.isTaxIsValueForTotal(effectType, taxConfiguration)) {
            qtyForTax = BigDecimal.ONE;
        }
        BigDecimal discountValue = ObjectChecker.toZeroIfNull((BigDecimal)percentage).multiply(qtyForTax);
        return discountValue;
    }

    private static boolean isTaxValueNotPercentage(MoneyEffectType effectType, DTOTaxConfiguration taxConfiguration) {
        if (effectType == null) {
            return false;
        }
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        switch (effectType) {
            case Tax1: {
                return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax1IsValue());
            }
            case Tax2: {
                return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax2IsValue());
            }
            case Tax3: {
                return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax3IsValue());
            }
            case Tax4: {
                return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax4IsValue());
            }
        }
        return false;
    }

    private static boolean isTaxIsValueForTotal(MoneyEffectType effectType, DTOTaxConfiguration taxConfiguration) {
        if (effectType == null) {
            return false;
        }
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        switch (effectType) {
            case Tax1: {
                return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax1ValueIsForTotal());
            }
            case Tax2: {
                return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax2ValueIsForTotal());
            }
            case Tax3: {
                return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax3ValueIsForTotal());
            }
            case Tax4: {
                return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax4ValueIsForTotal());
            }
        }
        return false;
    }

    private static boolean isTaxIncludedInPrice(MoneyEffectType effectType, DTOTaxConfiguration taxConfiguration) {
        if (ObjectChecker.isAnyEqualToFirst((Object)effectType, (Object[])new MoneyEffectType[]{MoneyEffectType.Tax1, MoneyEffectType.Tax2, MoneyEffectType.Tax3, MoneyEffectType.Tax4})) {
            switch (effectType) {
                case Tax1: {
                    return ObjectChecker.isTrue((Boolean)taxConfiguration.getPriceIncludesTax());
                }
                case Tax2: {
                    return ObjectChecker.isTrue((Boolean)taxConfiguration.getPriceIncludesTax2());
                }
                case Tax3: {
                    return ObjectChecker.isTrue((Boolean)taxConfiguration.getPriceIncludesTax3());
                }
                case Tax4: {
                    return ObjectChecker.isTrue((Boolean)taxConfiguration.getPriceIncludesTax4());
                }
            }
            return ObjectChecker.isTrue((Boolean)taxConfiguration.getPriceIncludesTax());
        }
        return false;
    }

    private static BigDecimal calculateTotalFor(MoneyEffectType effectType, BigDecimal currentTotal, List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects, BigDecimal mainPrice, BigDecimal custom, BigDecimal qty, DTOTaxConfiguration taxConfiguration, IDTOInvoiceLine line) {
        if (line != null && line.customTotalFor(effectType)) {
            return line.totalFor(effectType, currentTotal, effects, mainPrice, taxConfiguration);
        }
        if (POSMoneyUtils.isDiscount(effectType) && ObjectChecker.isNotEmptyOrNull((Object)POSMoneyUtils.getDiscountApplyOn(effectType))) {
            BigDecimal totalFromLocation = POSMoneyUtils.getTotalFromLocation(currentTotal, effects, mainPrice, custom, POSMoneyUtils.getDiscountApplyOn(effectType));
            totalFromLocation = POSMoneyUtils.addOrSubtractTaxesForDiscount(effects, effectType, totalFromLocation, qty, mainPrice, custom, taxConfiguration, line);
            return totalFromLocation;
        }
        if (!POSMoneyUtils.isTaxPercentage(effectType)) {
            return currentTotal;
        }
        TaxLocation location = POSMoneyUtils.calcTaxLocation(effectType, taxConfiguration);
        return POSMoneyUtils.getTotalFromLocation(currentTotal, effects, mainPrice, custom, ObjectChecker.toStringOrEmpty((Object)location));
    }

    private static BigDecimal addOrSubtractTaxesForDiscount(List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects, MoneyEffectType effectType, BigDecimal totalFromLocation, BigDecimal qty, BigDecimal mainParice, BigDecimal custom, DTOTaxConfiguration taxConfiguration, IDTOInvoiceLine line) {
        DTOTaxEffectOnDiscount effectOnDiscount = POSMoneyUtils.calcTaxEffectOnDiscount(effectType);
        if (effectOnDiscount == null) {
            return totalFromLocation;
        }
        totalFromLocation = POSMoneyUtils.considerTax(effects, totalFromLocation, MoneyEffectType.Tax1, effectOnDiscount.getConsiderTax1(), qty, mainParice, custom, taxConfiguration, line);
        totalFromLocation = POSMoneyUtils.considerTax(effects, totalFromLocation, MoneyEffectType.Tax2, effectOnDiscount.getConsiderTax2(), qty, mainParice, custom, taxConfiguration, line);
        totalFromLocation = POSMoneyUtils.considerTax(effects, totalFromLocation, MoneyEffectType.Tax3, effectOnDiscount.getConsiderTax3(), qty, mainParice, custom, taxConfiguration, line);
        totalFromLocation = POSMoneyUtils.considerTax(effects, totalFromLocation, MoneyEffectType.Tax4, effectOnDiscount.getConsiderTax4(), qty, mainParice, custom, taxConfiguration, line);
        return totalFromLocation;
    }

    private static BigDecimal considerTax(List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects, BigDecimal totalFromLocation, MoneyEffectType taxEffect, Boolean option, BigDecimal qty, BigDecimal mainPrice, BigDecimal custom, DTOTaxConfiguration taxConfiguration, IDTOInvoiceLine line) {
        if (ObjectChecker.isFalseOrNull((Boolean)option)) {
            return totalFromLocation;
        }
        DTOMoneyEffectDetails tax = POSMoneyUtils.findEffect(effects, taxEffect);
        BigDecimal taxValue = POSMoneyUtils.isTaxValueNotPercentage(taxEffect, taxConfiguration) ? POSMoneyUtils.calcEffectByValueNotPercentage(qty, tax.getMaxNormalPercent(), taxEffect, taxConfiguration) : POSMoneyUtils.calcEffectByPercentage(effects, totalFromLocation, mainPrice, custom, tax.getMaxNormalPercent(), taxEffect, qty, taxConfiguration, line);
        return totalFromLocation.subtract(taxValue);
    }

    private static DTOMoneyEffectDetails findEffect(List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects, MoneyEffectType effectType) {
        return (DTOMoneyEffectDetails)effects.stream().filter(e -> e.getKey() == effectType).findFirst().get().getValue();
    }

    private static DTOTaxEffectOnDiscount calcTaxEffectOnDiscount(MoneyEffectType effectType) {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        switch (effectType) {
            case Discount1: {
                return config.getInfo().getDiscount1();
            }
            case Discount2: {
                return config.getInfo().getDiscount2();
            }
            case Discount3: {
                return config.getInfo().getDiscount3();
            }
            case Discount4: {
                return config.getInfo().getDiscount4();
            }
            case Discount5: {
                return config.getInfo().getDiscount5();
            }
            case Discount6: {
                return config.getInfo().getDiscount6();
            }
            case Discount7: {
                return config.getInfo().getDiscount7();
            }
            case Discount8: {
                return config.getInfo().getDiscount8();
            }
        }
        return null;
    }

    public static String getDiscountApplyOn(MoneyEffectType effectType) {
        if (ObjectChecker.isEmptyOrNull((Object)effectType)) {
            return null;
        }
        switch (effectType) {
            case Discount1: {
                return POSMoneyUtils.convertDiscountApplyTypeToLocation(POSMoneyUtils.getDiscount1ApplyType());
            }
            case Discount2: {
                return POSMoneyUtils.convertDiscountApplyTypeToLocation(POSMoneyUtils.getDiscount2ApplyType());
            }
            case Discount3: {
                return POSMoneyUtils.convertDiscountApplyTypeToLocation(POSMoneyUtils.getDiscount3ApplyType());
            }
            case Discount4: {
                return POSMoneyUtils.convertDiscountApplyTypeToLocation(POSMoneyUtils.getDiscount4ApplyType());
            }
            case Discount5: {
                return POSMoneyUtils.convertDiscountApplyTypeToLocation(POSMoneyUtils.getDiscount5ApplyType());
            }
            case Discount6: {
                return POSMoneyUtils.convertDiscountApplyTypeToLocation(POSMoneyUtils.getDiscount6ApplyType());
            }
            case Discount7: {
                return POSMoneyUtils.convertDiscountApplyTypeToLocation(POSMoneyUtils.getDiscount7ApplyType());
            }
            case Discount8: {
                return POSMoneyUtils.convertDiscountApplyTypeToLocation(POSMoneyUtils.getDiscount8ApplyType());
            }
            case HeaderDiscount: {
                return POSMoneyUtils.convertDiscountApplyTypeToLocation(POSMoneyUtils.getHeaderDiscountApplyType());
            }
        }
        return null;
    }

    private static String getDiscount1ApplyType() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        return config.getInfo().getDiscount1ApplyType();
    }

    private static String getDiscount2ApplyType() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        return config.getInfo().getDiscount2ApplyType();
    }

    private static String getDiscount3ApplyType() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        return config.getInfo().getDiscount3ApplyType();
    }

    private static String getDiscount4ApplyType() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        return config.getInfo().getDiscount4ApplyType();
    }

    private static String getDiscount5ApplyType() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        return config.getInfo().getDiscount5ApplyType();
    }

    private static String getDiscount6ApplyType() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        return config.getInfo().getDiscount6ApplyType();
    }

    private static String getDiscount7ApplyType() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        return config.getInfo().getDiscount7ApplyType();
    }

    private static String getDiscount8ApplyType() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        return config.getInfo().getDiscount8ApplyType();
    }

    private static String getHeaderDiscountApplyType() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        return config.getInfo().getHeaderDiscountApplyType();
    }

    private static boolean isDiscount(MoneyEffectType effectType) {
        return ObjectChecker.isAnyEqualToFirst((Object)effectType, (Object[])new MoneyEffectType[]{MoneyEffectType.Discount1, MoneyEffectType.Discount2, MoneyEffectType.Discount3, MoneyEffectType.Discount4, MoneyEffectType.Discount5, MoneyEffectType.Discount6, MoneyEffectType.Discount7, MoneyEffectType.Discount8, MoneyEffectType.HeaderDiscount});
    }

    private static BigDecimal getTotalFromLocation(BigDecimal currentTotal, List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects, BigDecimal mainPrice, BigDecimal custom, String location) {
        if (ObjectChecker.areEqual((Object)(location = ObjectChecker.toStringOrEmpty((Object)location)), (Object)TaxLocation.MainPrice.toString())) {
            return mainPrice;
        }
        if (ObjectChecker.areEqual((Object)location, (Object)TaxLocation2.Custom.toString())) {
            return custom;
        }
        for (SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails> entry : effects) {
            if (ObjectChecker.areEqual((Object)((MoneyEffectType)entry.getKey()).toString(), (Object)location)) {
                return ((DTOMoneyEffectDetails)entry.getValue()).getAfterValue();
            }
            if (!ObjectChecker.areEqual((Object)(String.valueOf(entry.getKey()) + "Value"), (Object)location)) continue;
            return ((DTOMoneyEffectDetails)entry.getValue()).getValue();
        }
        return currentTotal;
    }

    private static TaxLocation calcTaxLocation(MoneyEffectType effectType, DTOTaxConfiguration taxConfiguration) {
        switch (effectType) {
            case Tax1: {
                return POSMoneyUtils.calcLocationFromTaxApplyType(taxConfiguration.getTax1ApplyType());
            }
            case Tax2: {
                return POSMoneyUtils.calcLocationFromTaxApplyType(taxConfiguration.getTax2ApplyType());
            }
            case Tax3: {
                return POSMoneyUtils.calcLocationFromTaxApplyType(taxConfiguration.getTax3ApplyType());
            }
            case Tax4: {
                return POSMoneyUtils.calcLocationFromTaxApplyType(taxConfiguration.getTax4ApplyType());
            }
        }
        return null;
    }

    private static List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> sortEffects(DTOInvoiceLineMoney lineMoney, DTOTaxConfiguration taxConfiguration) {
        ArrayList<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects = new ArrayList<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>>();
        POSMoneyUtils.addDiscount(lineMoney, effects, DiscountLocation.Discount1, taxConfiguration);
        POSMoneyUtils.addDiscount(lineMoney, effects, DiscountLocation.Discount2, taxConfiguration);
        POSMoneyUtils.addDiscount(lineMoney, effects, DiscountLocation.Discount3, taxConfiguration);
        POSMoneyUtils.addDiscount(lineMoney, effects, DiscountLocation.Discount4, taxConfiguration);
        POSMoneyUtils.addDiscount(lineMoney, effects, DiscountLocation.Discount5, taxConfiguration);
        POSMoneyUtils.addDiscount(lineMoney, effects, DiscountLocation.Discount6, taxConfiguration);
        POSMoneyUtils.addDiscount(lineMoney, effects, DiscountLocation.Discount7, taxConfiguration);
        POSMoneyUtils.addDiscount(lineMoney, effects, DiscountLocation.Discount8, taxConfiguration);
        return effects;
    }

    private static void addDiscount(DTOInvoiceLineMoney lineMoney, List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects, DiscountLocation discount, DTOTaxConfiguration taxConfiguration) {
        effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.valueOf((String)discount.toString()), (Object)lineMoney.fetchDiscountEffect(discount)));
        DiscountLocation headerDiscointLocation = POSMoneyUtils.getInvoiceDiscountLocation();
        TaxLocation tax1Location = POSMoneyUtils.getTaxLocation(taxConfiguration.getTax1Location());
        TaxLocation tax2Location = POSMoneyUtils.getTaxLocation(taxConfiguration.getTax2Location());
        TaxLocation tax3Location = POSMoneyUtils.getTaxLocation(taxConfiguration.getTax3Location());
        TaxLocation tax4Location = POSMoneyUtils.getTaxLocation(taxConfiguration.getTax4Location());
        if (ObjectChecker.areEqual((Object)headerDiscointLocation, (Object)discount)) {
            DTOMoneyEffectDetails mainDetails;
            effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.HeaderDiscount, (Object)lineMoney.getHeaderDicount()));
            if (ObjectChecker.areEqual((Object)tax1Location, (Object)TaxLocation.HeaderDiscount)) {
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax1, (Object)lineMoney.getTax1()));
            }
            if (ObjectChecker.areEqual((Object)tax2Location, (Object)TaxLocation.HeaderDiscount)) {
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax2, (Object)lineMoney.getTax2()));
            }
            if (ObjectChecker.areEqual((Object)tax3Location, (Object)TaxLocation.HeaderDiscount)) {
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax3, (Object)lineMoney.getTax3()));
            }
            if (ObjectChecker.areEqual((Object)tax4Location, (Object)TaxLocation.HeaderDiscount)) {
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax4, (Object)lineMoney.getTax4()));
            }
            if (ObjectChecker.areEqual((Object)tax1Location, (Object)TaxLocation.MainPrice)) {
                mainDetails = new DTOMoneyEffectDetails();
                mainDetails.setMaxNormalPercent(BigDecimal.valueOf(100L));
                mainDetails.setAfterValue(lineMoney.getPrice());
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.MainPrice, (Object)mainDetails));
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax1, (Object)lineMoney.getTax1()));
            }
            if (ObjectChecker.areEqual((Object)tax2Location, (Object)TaxLocation.MainPrice)) {
                mainDetails = new DTOMoneyEffectDetails();
                mainDetails.setMaxNormalPercent(BigDecimal.valueOf(100L));
                mainDetails.setAfterValue(lineMoney.getPrice());
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.MainPrice, (Object)mainDetails));
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax2, (Object)lineMoney.getTax2()));
            }
            if (ObjectChecker.areEqual((Object)tax3Location, (Object)TaxLocation.MainPrice)) {
                mainDetails = new DTOMoneyEffectDetails();
                mainDetails.setMaxNormalPercent(BigDecimal.valueOf(100L));
                mainDetails.setAfterValue(lineMoney.getPrice());
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.MainPrice, (Object)mainDetails));
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax3, (Object)lineMoney.getTax3()));
            }
            if (ObjectChecker.areEqual((Object)tax4Location, (Object)TaxLocation.MainPrice)) {
                mainDetails = new DTOMoneyEffectDetails();
                mainDetails.setMaxNormalPercent(BigDecimal.valueOf(100L));
                mainDetails.setAfterValue(lineMoney.getPrice());
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.MainPrice, (Object)mainDetails));
                effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax4, (Object)lineMoney.getTax4()));
            }
        }
        if (ObjectChecker.areEqual((Object)tax1Location, (Object)discount)) {
            effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax1, (Object)lineMoney.getTax1()));
        }
        if (ObjectChecker.areEqual((Object)tax2Location, (Object)discount)) {
            effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax2, (Object)lineMoney.getTax2()));
        }
        if (ObjectChecker.areEqual((Object)tax3Location, (Object)discount)) {
            effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax3, (Object)lineMoney.getTax3()));
        }
        if (ObjectChecker.areEqual((Object)tax4Location, (Object)discount)) {
            effects.add((SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>)new SimpleEntry((Object)MoneyEffectType.Tax4, (Object)lineMoney.getTax4()));
        }
    }

    public static void updateLineMoney(DTOInvoiceMoney money, DTOInvoiceLineMoney lineMoney, BigDecimal qty, Boolean freeLine, DTOTaxConfiguration taxConfiguration, IDTOInvoiceLine dto) {
        qty = NaMaMath.zeroIfNull((BigDecimal)qty);
        if (lineMoney == null) {
            return;
        }
        lineMoney.updateNulls();
        BigDecimal currentLineTotal = NaMaMath.round((BigDecimal)NaMaMath.zeroIfNull((BigDecimal)lineMoney.getUnitPrice()).multiply(qty), (Integer)fractionalDecimalPlaces);
        money.updateNulls();
        lineMoney.setHeaderDicount(money.getHeaderDiscount().cloneValue());
        if (ObjectChecker.isFalseOrNull((Boolean)freeLine)) {
            lineMoney.setPrice(currentLineTotal);
            money.setTotal(money.getTotal().add(currentLineTotal));
        }
        List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects = POSMoneyUtils.sortEffects(lineMoney, taxConfiguration);
        BigDecimal custom = POSMoneyUtils.calcCustomDisc(dto);
        dto.getPrice().setCustom(custom);
        lineMoney.setCustom(custom);
        BigDecimal netValue = POSMoneyUtils.applyEffects(effects, money, currentLineTotal, custom, qty, freeLine, taxConfiguration, dto);
        if (ObjectChecker.isTrue((Boolean)freeLine)) {
            netValue = netValue.subtract(currentLineTotal);
            lineMoney.getDiscount1().setAfterValue(BigDecimal.ZERO);
            lineMoney.getDiscount2().setAfterValue(BigDecimal.ZERO);
            lineMoney.getDiscount3().setAfterValue(BigDecimal.ZERO);
            lineMoney.getDiscount4().setAfterValue(BigDecimal.ZERO);
            lineMoney.getDiscount5().setAfterValue(BigDecimal.ZERO);
            lineMoney.getDiscount6().setAfterValue(BigDecimal.ZERO);
            lineMoney.getDiscount7().setAfterValue(BigDecimal.ZERO);
            lineMoney.getDiscount8().setAfterValue(BigDecimal.ZERO);
            money.setAfterDiscount1(money.getAfterDiscount1().subtract(currentLineTotal));
            money.setAfterDiscount2(money.getAfterDiscount2().subtract(currentLineTotal));
            money.setAfterDiscount3(money.getAfterDiscount3().subtract(currentLineTotal));
            money.setAfterDiscount4(money.getAfterDiscount4().subtract(currentLineTotal));
            money.setAfterDiscount5(money.getAfterDiscount5().subtract(currentLineTotal));
            money.setAfterDiscount6(money.getAfterDiscount6().subtract(currentLineTotal));
            money.setAfterDiscount7(money.getAfterDiscount7().subtract(currentLineTotal));
            money.setAfterDiscount8(money.getAfterDiscount8().subtract(currentLineTotal));
            money.setAfterTaxValue(money.getAfterTaxValue().subtract(currentLineTotal));
            money.setAfterHTaxValue(money.getAfterHTaxValue().subtract(currentLineTotal));
            money.updateInvoiceMoney();
        }
        lineMoney.setNetValue(netValue);
        money.setNetValue(money.getNetValue().add(netValue));
        money.updateInvoiceMoney();
    }

    private static BigDecimal calcCustomDisc(IDTOInvoiceLine dto) {
        String customEquation = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{POSResourcesUtil.fetchMainRegister().getCustomPriceQuery(), POSResourcesUtil.fetchPOSConfig().getCustomPriceQuery()});
        if (ObjectChecker.isBlankOrNull((String)customEquation)) {
            return BigDecimal.ZERO;
        }
        for (String paramId : salesParamsList) {
            if (!customEquation.contains(paramId)) continue;
            customEquation = customEquation.replace(":" + paramId, String.valueOf(POSMoneyUtils.salesLineParams(paramId).apply((AbsPOSSalesLine)dto)));
        }
        return (BigDecimal)POSPersister.runPreparedStatement(customEquation).getY();
    }

    private static Function<AbsPOSSalesLine, Object> salesLineParams(String paramId) {
        if (ObjectChecker.isNotEmptyOrNull(salesLineParams)) {
            return salesLineParams.get(paramId);
        }
        salesLineParams.put("qtyValue", l -> l.getQty().getValue());
        salesLineParams.put("unitPrice", l -> l.getUnitPrice());
        salesLineParams.put("totalPrice", l -> l.getTotalPrice());
        salesLineParams.put("discount1Percent", l -> l.getDiscount1().getPercentage());
        salesLineParams.put("discount1Value", l -> l.getDiscount1().getValue());
        salesLineParams.put("afterDisc1", l -> l.getAfterDisc1());
        salesLineParams.put("discount2Percent", l -> l.getDiscount2().getPercentage());
        salesLineParams.put("discount2Value", l -> l.getDiscount2().getValue());
        salesLineParams.put("afterDisc2", l -> l.getAfterDisc2());
        salesLineParams.put("discount3Percent", l -> l.getDiscount3().getPercentage());
        salesLineParams.put("discount3Value", l -> l.getDiscount3().getValue());
        salesLineParams.put("afterDisc3", l -> l.getAfterDisc3());
        salesLineParams.put("discount4Percent", l -> l.getDiscount4().getPercentage());
        salesLineParams.put("discount4Value", l -> l.getDiscount4().getValue());
        salesLineParams.put("afterDisc4", l -> l.getAfterDisc4());
        salesLineParams.put("discount5Percent", l -> l.getDiscount5().getPercentage());
        salesLineParams.put("discount5Value", l -> l.getDiscount5().getValue());
        salesLineParams.put("afterDisc5", l -> l.getAfterDisc5());
        salesLineParams.put("discount6Percent", l -> l.getDiscount6().getPercentage());
        salesLineParams.put("discount6Value", l -> l.getDiscount6().getValue());
        salesLineParams.put("afterDisc6", l -> l.getAfterDisc6());
        salesLineParams.put("discount7Percent", l -> l.getDiscount7().getPercentage());
        salesLineParams.put("discount7Value", l -> l.getDiscount7().getValue());
        salesLineParams.put("afterDisc7", l -> l.getAfterDisc7());
        salesLineParams.put("discount8Percent", l -> l.getDiscount8().getPercentage());
        salesLineParams.put("discount8Value", l -> l.getDiscount8().getValue());
        salesLineParams.put("afterDisc8", l -> l.getAfterDisc8());
        salesLineParams.put("tax1Percent", l -> l.getTax1().getPercentage());
        salesLineParams.put("tax1Value", l -> l.getTax1().getValue());
        salesLineParams.put("afterTax1", l -> l.getAfterTax1());
        salesLineParams.put("tax2Percent", l -> l.getTax2().getPercentage());
        salesLineParams.put("tax2Value", l -> l.getTax2().getValue());
        salesLineParams.put("afterTax2", l -> l.getAfterTax2());
        salesLineParams.put("headerDiscPercent", l -> l.getHeaderDicount().getPercentage());
        salesLineParams.put("headerDiscValue", l -> l.getHeaderDicount().getValue());
        salesLineParams.put("netPrice", l -> l.getNetPrice());
        return salesLineParams.get(paramId);
    }

    private static boolean shouldSubtract(MoneyEffectType type, DTOTaxConfiguration taxConfiguration) {
        boolean taxPercentage = POSMoneyUtils.isTaxPercentage(type);
        if (taxPercentage) {
            return POSMoneyUtils.isDiscountTax(type, taxConfiguration);
        }
        return !taxPercentage;
    }

    private static boolean shouldIncludedEffectInTotal(MoneyEffectType effectType, DTOTaxConfiguration taxConfiguration) {
        if (!POSMoneyUtils.isTaxPercentage(effectType)) {
            return true;
        }
        if (ObjectChecker.areEqual((Object)effectType, (Object)MoneyEffectType.Tax1)) {
            return ObjectChecker.isFalseOrNull((Boolean)taxConfiguration.getTax1NotIncludedInTotal());
        }
        if (ObjectChecker.areEqual((Object)effectType, (Object)MoneyEffectType.Tax2)) {
            return ObjectChecker.isFalseOrNull((Boolean)taxConfiguration.getTax2NotIncludedInTotal());
        }
        if (ObjectChecker.areEqual((Object)effectType, (Object)MoneyEffectType.Tax3)) {
            return ObjectChecker.isFalseOrNull((Boolean)taxConfiguration.getTax3NotIncludedInTotal());
        }
        if (ObjectChecker.areEqual((Object)effectType, (Object)MoneyEffectType.Tax4)) {
            return ObjectChecker.isFalseOrNull((Boolean)taxConfiguration.getTax4NotIncludedInTotal());
        }
        return false;
    }

    private static boolean isDiscountTax(MoneyEffectType effectType, DTOTaxConfiguration taxConfiguration) {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        if (ObjectChecker.areEqual((Object)effectType, (Object)MoneyEffectType.Tax1)) {
            return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax1IsDiscount());
        }
        if (ObjectChecker.areEqual((Object)effectType, (Object)MoneyEffectType.Tax2)) {
            return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax2IsDiscount());
        }
        if (ObjectChecker.areEqual((Object)effectType, (Object)MoneyEffectType.Tax3)) {
            return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax3IsDiscount());
        }
        if (ObjectChecker.areEqual((Object)effectType, (Object)MoneyEffectType.Tax4)) {
            return ObjectChecker.isTrue((Boolean)taxConfiguration.getTax4IsDiscount());
        }
        return false;
    }

    private static boolean isTaxPercentage(MoneyEffectType type) {
        return ObjectChecker.isNotEmptyOrNull((Object)type) && type.toString().startsWith("Tax");
    }

    public static DiscountLocation getInvoiceDiscountLocation() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        DiscountLocation discountLocation = DiscountLocation.Discount4;
        if (config != null && ObjectChecker.isNotEmptyOrNull((Object)config.getDiscountLocation())) {
            discountLocation = DiscountLocation.valueOf((String)config.getDiscountLocation());
        }
        return discountLocation;
    }

    public static TaxLocation getTaxLocation(String taxLocation) {
        TaxLocation discountLocation = TaxLocation.HeaderDiscount;
        if (ObjectChecker.isNotEmptyOrNull((Object)taxLocation)) {
            discountLocation = TaxLocation.valueOf((String)taxLocation);
        }
        return discountLocation;
    }

    public static TaxLocation getHTaxLocation() {
        DTOGlobalConfig config = POSResourcesUtil.fetchGlobalConfig();
        TaxLocation discountLocation = TaxLocation.HeaderDiscount;
        if (config != null && ObjectChecker.isNotEmptyOrNull((Object)config.getInfo()) && ObjectChecker.isNotEmptyOrNull((Object)config.getInfo().getHTaxLocation())) {
            discountLocation = TaxLocation.valueOf((String)config.getInfo().getHTaxLocation());
        }
        return discountLocation;
    }

    private static TaxLocation calcLocationFromTaxApplyType(String taxApplyType) {
        TaxLocation discountLocation = TaxLocation.HeaderDiscount;
        if (ObjectChecker.isNotEmptyOrNull((Object)taxApplyType)) {
            discountLocation = TaxLocation.valueOf((String)POSMoneyUtils.convertApplyTypeToLocation(taxApplyType));
        }
        return discountLocation;
    }

    private static String convertDiscountApplyTypeToLocation(String discountApplyType) {
        if (ObjectChecker.isEmptyOrNull((Object)discountApplyType)) {
            return null;
        }
        return POSMoneyUtils.convertApplyTypeToLocation(discountApplyType);
    }

    private static String convertApplyTypeToLocation(String applyOn) {
        if (ObjectChecker.isEmptyOrNull((Object)applyOn)) {
            return TaxLocation.Discount8.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.TotalPrice, (Object)applyOn)) {
            return TaxLocation.MainPrice.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.AfterHeaderDiscount, (Object)applyOn)) {
            return TaxLocation.HeaderDiscount.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.AfterDiscount1Price, (Object)applyOn)) {
            return TaxLocation.Discount1.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.AfterDiscount2Price, (Object)applyOn)) {
            return TaxLocation.Discount2.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.AfterDiscount3Price, (Object)applyOn)) {
            return TaxLocation.Discount3.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.AfterDiscount4Price, (Object)applyOn)) {
            return TaxLocation.Discount4.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.AfterDiscount5Price, (Object)applyOn)) {
            return TaxLocation.Discount5.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.AfterDiscount6Price, (Object)applyOn)) {
            return TaxLocation.Discount6.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.AfterDiscount7Price, (Object)applyOn)) {
            return TaxLocation.Discount7.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.AfterDiscount8Price, (Object)applyOn)) {
            return TaxLocation.Discount8.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Custom, (Object)applyOn)) {
            return TaxLocation2.Custom.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Discount1Value, (Object)applyOn)) {
            return TaxLocation2.Discount1Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Discount2Value, (Object)applyOn)) {
            return TaxLocation2.Discount2Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Discount3Value, (Object)applyOn)) {
            return TaxLocation2.Discount3Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Discount4Value, (Object)applyOn)) {
            return TaxLocation2.Discount4Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Discount5Value, (Object)applyOn)) {
            return TaxLocation2.Discount5Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Discount6Value, (Object)applyOn)) {
            return TaxLocation2.Discount6Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Discount7Value, (Object)applyOn)) {
            return TaxLocation2.Discount7Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Discount8Value, (Object)applyOn)) {
            return TaxLocation2.Discount8Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Tax1Value, (Object)applyOn)) {
            return TaxLocation2.Tax1Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Tax2Value, (Object)applyOn)) {
            return TaxLocation2.Tax2Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Tax3Value, (Object)applyOn)) {
            return TaxLocation2.Tax3Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.Tax4Value, (Object)applyOn)) {
            return TaxLocation2.Tax4Value.toString();
        }
        if (ObjectChecker.areEqual((Object)TaxApplyType.InvoiceDiscountValue, (Object)applyOn)) {
            return TaxLocation2.HeaderDiscountValue.toString();
        }
        return TaxLocation.Discount8.toString();
    }

    public static BigDecimal getBeforeHeaderDiscountTotalValue(DTOInvoiceMoney money) {
        if (money == null) {
            return null;
        }
        DiscountLocation invoiceDiscountLocation = POSMoneyUtils.getInvoiceDiscountLocation();
        if (ObjectChecker.areEqual((Object)invoiceDiscountLocation, (Object)DiscountLocation.Discount1)) {
            return money.getAfterDiscount1();
        }
        if (ObjectChecker.areEqual((Object)invoiceDiscountLocation, (Object)DiscountLocation.Discount2)) {
            return money.getAfterDiscount2();
        }
        if (ObjectChecker.areEqual((Object)invoiceDiscountLocation, (Object)DiscountLocation.Discount3)) {
            return money.getAfterDiscount3();
        }
        if (ObjectChecker.areEqual((Object)invoiceDiscountLocation, (Object)DiscountLocation.Discount4)) {
            return money.getAfterDiscount4();
        }
        if (ObjectChecker.areEqual((Object)invoiceDiscountLocation, (Object)DiscountLocation.Discount5)) {
            return money.getAfterDiscount5();
        }
        if (ObjectChecker.areEqual((Object)invoiceDiscountLocation, (Object)DiscountLocation.Discount6)) {
            return money.getAfterDiscount6();
        }
        if (ObjectChecker.areEqual((Object)invoiceDiscountLocation, (Object)DiscountLocation.Discount7)) {
            return money.getAfterDiscount7();
        }
        if (ObjectChecker.areEqual((Object)invoiceDiscountLocation, (Object)DiscountLocation.Discount8)) {
            return money.getAfterDiscount8();
        }
        return null;
    }

    public static BigDecimal getPreviousTotal(String effectId, AbsPOSSalesLine line, DTOTaxConfiguration taxConfiguration) {
        List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects = POSMoneyUtils.sortEffects(line.fetchPrice(), taxConfiguration);
        BigDecimal previousTotal = line.fetchPrice().getPrice();
        for (SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails> entry : effects) {
            if (((MoneyEffectType)entry.getKey()).toString().equalsIgnoreCase(effectId)) {
                previousTotal = POSMoneyUtils.calculateTotalFor((MoneyEffectType)entry.getKey(), previousTotal, effects, line.fetchPrice().getPrice(), line.fetchPrice().getCustom(), line.unitQuantity(), taxConfiguration, line);
                return previousTotal;
            }
            previousTotal = ((DTOMoneyEffectDetails)entry.getValue()).getAfterValue();
        }
        return previousTotal;
    }

    public static String getEffectIdFromFieldId(String fielId) {
        return fielId.replace("details.price", "").replace("afterValue", "").replace("value", "").replace(".", "");
    }

    public static BigDecimal getBeforeTaxValue(DTOInvoiceMoney money) {
        if (money == null) {
            return null;
        }
        TaxLocation invoiceTaxLocation = POSMoneyUtils.getHTaxLocation();
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.Discount1)) {
            return money.getAfterDiscount1();
        }
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.Discount2)) {
            return money.getAfterDiscount2();
        }
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.Discount3)) {
            return money.getAfterDiscount3();
        }
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.Discount4)) {
            return money.getAfterDiscount4();
        }
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.Discount5)) {
            return money.getAfterDiscount5();
        }
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.Discount6)) {
            return money.getAfterDiscount6();
        }
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.Discount7)) {
            return money.getAfterDiscount7();
        }
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.Discount8)) {
            return money.getAfterDiscount8();
        }
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.MainPrice)) {
            return money.getTotal();
        }
        if (ObjectChecker.areEqual((Object)invoiceTaxLocation, (Object)TaxLocation.HeaderDiscount)) {
            return money.getHeaderDiscount().getAfterValue();
        }
        return null;
    }

    public static int getPercentageScale() {
        if (percentageScale != null) {
            return percentageScale;
        }
        DTOGlobalConfig globalCOnfig = POSResourcesUtil.fetchGlobalConfig();
        if (globalCOnfig == null || globalCOnfig.getInfo() == null || globalCOnfig.getInfo().getPercentageFractionalDecimalPlaces() == null) {
            percentageScale = 2;
            return percentageScale;
        }
        percentageScale = NaMaMath.max((int[])new int[]{globalCOnfig.getInfo().getPercentageFractionalDecimalPlaces(), fractionalDecimalPlaces});
        return percentageScale;
    }
}

