/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.constants.Language;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.modules.namapos.contracts.common.POSOnlineOrderRequest;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.controllers.NamaJSON;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.utils.ServerSideExceptionDescriber;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.util.Duration;
import org.controlsfx.control.Notifications;

public class POSOnlineOrderWriterRunner
implements Runnable {
    private final ThreadFactory daemonThreadFactory = r -> {
        Thread thread = new Thread(r, "POSOnlineOrderWriterRunner");
        thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        thread.setDaemon(true);
        return thread;
    };
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(this.daemonThreadFactory);
    private static final POSOnlineOrderWriterRunner instance = new POSOnlineOrderWriterRunner();

    public static POSOnlineOrderWriterRunner instance() {
        return instance;
    }

    private POSOnlineOrderWriterRunner() {
    }

    @Override
    public void run() {
        try {
            NaMaLogger.info((Object)"POSOnlineOrderWriterRunner: Starting online order writer cycle");
            List<POSSalesInvoice> invoices = POSPersister.listAll(POSSalesInvoice.class, " Where hold = true and orderRegisterId is not null ");
            if (ObjectChecker.isEmptyOrNull(invoices)) {
                return;
            }
            NaMaLogger.info((String)"POSOnlineOrderWriterRunner: Found {0} pending online orders to process", (Object[])new Object[]{invoices.size()});
            for (POSSalesInvoice invoice : invoices) {
                String invoiceCode = invoice.getCode();
                try {
                    POSOnlineOrderRequest onlineOrderReq = new POSOnlineOrderRequest();
                    onlineOrderReq.setOrderId(ServerStringUtils.toUUIDStr((Object)invoice.getId()));
                    onlineOrderReq.setRegisterId(ServerStringUtils.toUUIDStr((Object)invoice.getOrderRegisterId()));
                    onlineOrderReq.setOrderJson(NamaJSON.toString(invoice.toDTO()));
                    ServiceResponse serviceResponse = POSWSClient.instance.writePOSOnlineOrder((SendRequest<POSOnlineOrderRequest>)new SendRequest((Object)onlineOrderReq));
                    if (serviceResponse.succeded()) {
                        NaMaLogger.info((String)"POSOnlineOrderWriterRunner: Successfully sent online order {0} to server", (Object[])new Object[]{invoiceCode});
                        POSPersister.delete(invoice);
                        Platform.runLater(() -> {
                            String entityType = POSResourcesUtil.id(invoice.calcNamaEntityType(), new Object[0]);
                            String orderCode = ObjectChecker.toStringOrEmpty((Object)invoice.getCode());
                            POSRegistery targetRegister = POSResourcesUtil.fetchRegisterIgnoringInActiveAndPreventUsage(invoice.getOrderRegisterId());
                            String notification = String.format("%s %s\n%s\n%s", entityType, orderCode, POSResourcesUtil.id("Transferred Successfully", new Object[0]), POSResourcesUtil.id("Target Register {0}", targetRegister.nameByLanguage()));
                            Notifications.create().title(POSResourcesUtil.id("Call Center - Order Sent", new Object[0])).text(notification).hideAfter(Duration.seconds((double)6.0)).styleClass("notification-success").showInformation();
                        });
                        continue;
                    }
                    String errorDescription = ServerSideExceptionDescriber.describeResult((ResultDTO)serviceResponse.getResult(), (Language)Language.English);
                    NaMaLogger.error((String)"POSOnlineOrderWriterRunner: Failed to send online order {0} to server. Error: {1}", (Object[])new Object[]{invoiceCode, errorDescription});
                    POSDataWriterUtil.saveErrorAndShowNotification(POSResourcesUtil.fetchMainRegister(), invoice, serviceResponse.getResult(), "NamaPOSSalesInvoice", true);
                }
                catch (NaMaServiceExcepption e) {
                    NaMaLogger.errorWithException((Throwable)e, (String)"POSOnlineOrderWriterRunner: Service exception while processing invoice {0}.", (Object[])new Object[0]);
                    POSDataWriterUtil.saveErrorAndShowNotification(POSResourcesUtil.fetchMainRegister(), invoice, e.getFaultInfo(), "NamaPOSSalesInvoice", true);
                }
                catch (Exception e) {
                    NaMaLogger.errorWithException((Throwable)e, (String)"POSOnlineOrderWriterRunner: Unexpected error while processing invoice {0}.", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            NaMaLogger.errorWithException((Throwable)e, (String)"POSOnlineOrderReaderRunner: Fatal error during reader cycle.", (Object[])new Object[0]);
        }
    }

    public static void stop() {
        NaMaLogger.info((Object)"***************///// Shutting down POSOnlineOrderWriterRunner \\\\\\\\\\********");
        POSOnlineOrderWriterRunner.instance().executor.shutdownNow();
    }

    public static void start() {
        POSOnlineOrderWriterRunner.instance().executor.scheduleWithFixedDelay(POSOnlineOrderWriterRunner.instance(), 0L, 1L, TimeUnit.MINUTES);
    }
}

