/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.details.POSInventoryLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.valueobjects.POSFinancialSysLine;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class POSPaymentMethodsUtil {
    public static List<AbsPOSInventoryLine> calcShiftTotals(POSRegistery register, Class<? extends AbsPOSInventoryLine> lineKlass, Consumer<String> currentShiftCashAmount) {
        POSShiftClose lastClosedShift;
        ArrayList<AbsPOSInventoryLine> shiftLines = new ArrayList<AbsPOSInventoryLine>();
        POSShiftOpen lastOpenShift = POSResourcesUtil.fetchLastOpenShift(register);
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{lastOpenShift, lastClosedShift = POSResourcesUtil.fetchLastCloseShift(register)})) {
            POSPaymentMethodsUtil.constructLinesFromMethodsAndCurrencies(lineKlass, shiftLines);
        } else {
            String lastShiftCode = ObjectChecker.isNotEmptyOrNull((Object)lastOpenShift) ? lastOpenShift.getCode() : POSCodeGenerator.generateShiftCode(register);
            String preDefinedCashMethodQuery = "select sum(value), currency.id,paymentMethodId from " + POSFinancialSysLine.class.getSimpleName() + " where paymentMethodId is not null and cash = true and registerId = :registerId group by currency.id,paymentMethodId";
            String preDefinedMethodsQuery = "select sum(value), currency.id,paymentMethodId from " + POSFinancialSysLine.class.getSimpleName() + " where paymentMethodId is not null and cash = false and shiftCode = :shiftCode and registerId = :registerId group by currency.id,paymentMethodId";
            String defaultCashQuery = "select sum(value), currency.id from " + POSFinancialSysLine.class.getSimpleName() + " where cash = true and paymentMethodId is null and registerId = :registerId  group by currency.id";
            String defaultDebitQuery = "select sum(value), currency.id from " + POSFinancialSysLine.class.getSimpleName() + " where debit = true and shiftCode = :shiftCode  and registerId = :registerId group by currency.id";
            POSPaymentMethodsUtil.constructLinesFromPredefinedMethods(register, lineKlass, shiftLines, preDefinedCashMethodQuery, POSPersister.params("registerId", register.getId()));
            POSPaymentMethodsUtil.constructLinesFromPredefinedMethods(register, lineKlass, shiftLines, preDefinedMethodsQuery, POSPersister.params("shiftCode", lastShiftCode, "registerId", register.getId()));
            if (ObjectChecker.isEmptyOrNull((Object)MultiplePaymentDialog.searchForCashMethod())) {
                POSPaymentMethodsUtil.constructDefaultCashOrCreditLines(register, lineKlass, shiftLines, defaultCashQuery, "cash", POSPersister.params("registerId", register.getId()));
            }
            POSPaymentMethodsUtil.constructDefaultCashOrCreditLines(register, lineKlass, shiftLines, defaultDebitQuery, "debitValue", POSPersister.params("shiftCode", lastShiftCode, "registerId", register.getId()));
        }
        return POSPaymentMethodsUtil.updateShiftCashAndAddMissingThenSort(register, lineKlass, currentShiftCashAmount, lastOpenShift, shiftLines);
    }

    private static List<AbsPOSInventoryLine> updateShiftCashAndAddMissingThenSort(POSRegistery register, Class<? extends AbsPOSInventoryLine> lineKlass, Consumer<String> currentShiftCashAmount, POSShiftOpen lastOpenShift, List<AbsPOSInventoryLine> shiftLines) {
        if (ObjectChecker.isNotEmptyOrNull((Object)lastOpenShift)) {
            BigDecimal currentShiftCash = (BigDecimal)POSPersister.searchFor("select sum(value) from " + POSFinancialSysLine.class.getSimpleName() + " where cash = true and shiftCode = :code and currency = :curr", POSPersister.params("code", lastOpenShift.getCode(), "curr", POSPersister.findByID(POSCurrency.class, register.getCurrencyId()))).get(0);
            currentShiftCashAmount.accept(ObjectChecker.toZeroIfNull((BigDecimal)currentShiftCash).toString());
        }
        POSPaymentMethodsUtil.constructLinesFromMethodsAndCurrencies(lineKlass, shiftLines);
        List staticMethodsLines = shiftLines.stream().filter(l -> ObjectChecker.isEmptyOrNull((Object)l.getPaymentMethodId())).collect(Collectors.toList());
        List nonStaticMethodsLines = shiftLines.stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getPaymentMethodId())).collect(Collectors.toList());
        Collections.sort(nonStaticMethodsLines, (o1, o2) -> {
            POSPaymentMethod p1 = POSPersister.findByID(POSPaymentMethod.class, o1.getPaymentMethodId());
            POSPaymentMethod p2 = POSPersister.findByID(POSPaymentMethod.class, o2.getPaymentMethodId());
            return p1.getOrderInPOS().compareTo(p2.getOrderInPOS());
        });
        return CollectionsUtility.join((List[])new List[]{staticMethodsLines, nonStaticMethodsLines});
    }

    public static void constructLinesFromMethodsAndCurrencies(Class<? extends AbsPOSInventoryLine> lineKlass, List<AbsPOSInventoryLine> shiftLines) {
        for (POSCurrency currency : POSResourcesUtil.currencies) {
            boolean useDefaultCash;
            if (currency == null) continue;
            for (POSPaymentMethod method : POSResourcesUtil.methods) {
                if (ObjectChecker.isTrue((Boolean)method.getHideInShifts()) || CollectionsUtility.filter(shiftLines, object -> ObjectChecker.areEqual((Object)object.getPaymentMethodId(), (Object)method.getId()) && object.getCurrency().equals(currency.getCode() + " - " + currency.nameByLanguage())).size() != 0) continue;
                AbsPOSInventoryLine shiftLine = (AbsPOSInventoryLine)ObjectCreatorUtil.creator(lineKlass).create();
                shiftLine.setCurrency(currency.getCode() + " - " + currency.nameByLanguage());
                shiftLine.setCurrencyId(currency.getId());
                shiftLine.setPaymentWay(method.nameByLanguage());
                shiftLine.setPaymentMethodId(method.getId());
                shiftLine.setDisableActualBalance(method.getDisableActualBalance());
                shiftLines.add(shiftLine);
            }
            if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getHideDefaultSystemDebitMethod()) && CollectionsUtility.filter(shiftLines, object -> object.getPaymentWay().equals(POSResourcesUtil.id("debitValue", new Object[0])) && object.getCurrency().equals(currency.getCode() + " - " + currency.nameByLanguage())).size() == 0) {
                AbsPOSInventoryLine debitLine = (AbsPOSInventoryLine)ObjectCreatorUtil.creator(lineKlass).create();
                debitLine.setCurrency(currency.getCode() + " - " + currency.nameByLanguage());
                debitLine.setCurrencyId(currency.getId());
                debitLine.setPaymentWay(POSResourcesUtil.id("debitValue", new Object[0]));
                debitLine.setDisableActualBalance(true);
                shiftLines.add(debitLine);
            }
            if (!(useDefaultCash = ObjectChecker.isEmptyOrNull((Object)MultiplePaymentDialog.searchForCashMethod()) && ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getHideDefaultSystemCashMethod())) || CollectionsUtility.filter(shiftLines, object -> object.getPaymentWay().equals(POSResourcesUtil.id("cash", new Object[0])) && object.getCurrency().equals(currency.getCode() + " - " + currency.nameByLanguage())).size() != 0) continue;
            AbsPOSInventoryLine cashLine = (AbsPOSInventoryLine)ObjectCreatorUtil.creator(lineKlass).create();
            cashLine.setCurrency(currency.getCode() + " - " + currency.nameByLanguage());
            cashLine.setPaymentWay(POSResourcesUtil.id("cash", new Object[0]));
            cashLine.setCurrencyId(currency.getId());
            cashLine.setDisableActualBalance(false);
            shiftLines.add(cashLine);
        }
    }

    public static void constructLinesFromPredefinedMethods(POSRegistery register, Class<? extends AbsPOSInventoryLine> lineKlass, List<AbsPOSInventoryLine> shiftLines, String linesWithMethodsQuery, HashMap<String, Object> params) {
        List<Object[]> linesWithMethods = POSPersister.searchFor(linesWithMethodsQuery, params);
        Boolean fillActualWithAccountantInShifts = POSResourcesUtil.fetchPOSConfig().getFillActualWithSystemValueInShifts();
        for (Object[] line : linesWithMethods) {
            POSPaymentMethod method;
            String paymentMethodName = "";
            Boolean disableActualBalance = false;
            if (ObjectChecker.isNotEmptyOrNull((Object)line[2]) && ObjectChecker.isNotEmptyOrNull((Object)(method = POSPersister.findByID(POSPaymentMethod.class, (UUID)line[2])))) {
                if (ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{method.getHideInShifts(), method.getPreventUsage()})) continue;
                paymentMethodName = method.nameByLanguage();
                disableActualBalance = method.getDisableActualBalance();
            }
            POSPaymentMethodsUtil.updateShiftLineData(register, lineKlass, shiftLines, paymentMethodName, disableActualBalance, fillActualWithAccountantInShifts, line, (UUID)line[2]);
        }
    }

    public static void constructDefaultCashOrCreditLines(POSRegistery register, Class<? extends AbsPOSInventoryLine> lineKlass, List<AbsPOSInventoryLine> shiftLines, String linesWithDefaultCashQuery, String paymentWay, HashMap<String, Object> params) {
        List<Object[]> linesWithDefaultCash = POSPersister.searchFor(linesWithDefaultCashQuery, params);
        Boolean fillActualWithAccountantInShifts = POSResourcesUtil.fetchPOSConfig().getFillActualWithSystemValueInShifts();
        for (Object[] line : linesWithDefaultCash) {
            AbsPOSInventoryLine shiftLine = POSPaymentMethodsUtil.updateShiftLineData(register, lineKlass, shiftLines, paymentWay, false, fillActualWithAccountantInShifts, line, null);
            if (!ObjectChecker.areEqual((Object)paymentWay, (Object)"debitValue")) continue;
            shiftLine.setActualRemaining(shiftLine.getAccountantRemaining());
            shiftLine.setDisableActualBalance(true);
        }
    }

    private static AbsPOSInventoryLine updateShiftLineData(POSRegistery register, Class<? extends AbsPOSInventoryLine> lineKlass, List<AbsPOSInventoryLine> shiftLines, String paymentWay, Boolean disableActualBalance, Boolean fillActualWithAccountantInShifts, Object[] line, UUID paymentMethodId) {
        POSCurrency currency;
        AbsPOSInventoryLine shiftLine = (AbsPOSInventoryLine)ObjectCreatorUtil.creator(lineKlass).create();
        shiftLine.setAccountantRemaining((BigDecimal)line[0]);
        if (ObjectChecker.isTrue((Boolean)fillActualWithAccountantInShifts)) {
            shiftLine.setActualRemaining(shiftLine.getAccountantRemaining());
        }
        if ((currency = POSPersister.findByID(POSCurrency.class, (UUID)line[1])) == null) {
            currency = POSPersister.findByID(POSCurrency.class, register.getCurrencyId());
        }
        shiftLine.setCurrency(currency.getCode() + " - " + currency.nameByLanguage());
        shiftLine.setCurrencyId(currency.getId());
        shiftLine.setPaymentWay(POSResourcesUtil.id(paymentWay, new Object[0]));
        shiftLine.setPaymentMethodId(paymentMethodId);
        shiftLine.setDisableActualBalance(disableActualBalance);
        shiftLines.add(shiftLine);
        return shiftLine;
    }

    public static void checkAvailableCash(POSRegistery register, POSResult result, BigDecimal amountVal) {
        List<AbsPOSInventoryLine> totals = POSPaymentMethodsUtil.calcShiftTotals(register, POSInventoryLine.class, t -> {});
        List cashLines = CollectionsUtility.filter(totals, object -> object.isCash());
        BigDecimal accountantRemaining = ((AbsPOSInventoryLine)cashLines.get(0)).getAccountantRemaining();
        if (ObjectChecker.isNotEmptyOrNull((Object)cashLines) && accountantRemaining.compareTo(amountVal) < 0) {
            if (POSSecurityUtil.userCan(POSSecurityCapability.CanViewAccountant).isSucceeded().booleanValue()) {
                result.failure(POSResourcesUtil.id("Not enough cash, current cash amount is {0}", NaMaMath.round((BigDecimal)accountantRemaining, (Integer)POSMoneyUtils.displayDecimalPlaces)), new Object[0]);
            } else {
                result.failure(POSResourcesUtil.id("Not enough cash", new Object[0]), new Object[0]);
            }
        }
    }

    public static void recalcAllShiftCloseDocsFromDate(POSRegistery register, Date date) {
        List<POSShiftClose> shifts = POSPersister.listAll(POSShiftClose.class, " WHERE shiftDate >= :date ", POSPersister.params("date", date), "shiftDate ASC");
        shifts.forEach(s -> POSPersister.saveOrUpdate(s));
        for (POSShiftClose shiftClose : shifts) {
            POSShiftOpen shiftOpen = (POSShiftOpen)POSPersister.findByCode(POSShiftOpen.class, shiftClose.getCode());
            shiftClose.setSent(false);
            Date toDate = LocalDateUtils.localDateTimeToDateTime((LocalDateTime)LocalDateUtils.dateToLocalDate((Date)shiftClose.getShiftDate()).atTime(LocalDateUtils.dateToLocalTime((Date)shiftClose.fetchTime())));
            shiftClose.recalcDetails(POSPaymentMethodsUtil.calcShiftTotals(register, shiftClose.createLine().getClass(), s -> {}, shiftOpen, shiftClose, toDate));
            POSPersister.saveOrUpdate(shiftClose);
        }
    }

    private static List<AbsPOSInventoryLine> calcShiftTotals(POSRegistery register, Class<? extends AbsPOSInventoryLine> lineKlass, Consumer<String> currentShiftCashAmount, POSShiftOpen lastOpenShift, POSShiftClose lastClosedShift, Date toDate) {
        ArrayList<AbsPOSInventoryLine> shiftLines = new ArrayList<AbsPOSInventoryLine>();
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{lastOpenShift, lastClosedShift})) {
            POSPaymentMethodsUtil.constructLinesFromMethodsAndCurrencies(lineKlass, shiftLines);
        } else {
            String lastShiftCode = ObjectChecker.isNotEmptyOrNull((Object)lastOpenShift) ? lastOpenShift.getCode() : POSCodeGenerator.generateShiftCode(register);
            String preDefinedCashMethodQuery = "select sum(value), currency.id,paymentMethodId from " + POSFinancialSysLine.class.getSimpleName() + " where paymentMethodId is not null and cash = true and (valueDate < :valueDate or (shiftCode = :shiftCode and originCode <> :shiftCode))  and registerId = :registerId group by currency.id,paymentMethodId";
            String preDefinedMethodsQuery = "select sum(value), currency.id,paymentMethodId from " + POSFinancialSysLine.class.getSimpleName() + " where paymentMethodId is not null and cash = false and shiftCode = :shiftCode and originCode <> :shiftCode  and registerId = :registerId group by currency.id,paymentMethodId";
            String defaultCashQuery = "select sum(value), currency.id from " + POSFinancialSysLine.class.getSimpleName() + " where cash = true and paymentMethodId is null and (valueDate < :valueDate or (shiftCode = :shiftCode and originCode <> :shiftCode))  and registerId = :registerId group by currency.id";
            String defaultDebitQuery = "select sum(value), currency.id from " + POSFinancialSysLine.class.getSimpleName() + " where debit = true and shiftCode = :shiftCode and originCode <> :shiftCode  and registerId = :registerId group by currency.id";
            POSPaymentMethodsUtil.constructLinesFromPredefinedMethods(register, lineKlass, shiftLines, preDefinedCashMethodQuery, POSPersister.params("valueDate", toDate, "shiftCode", lastShiftCode, "registerId", register.getId()));
            POSPaymentMethodsUtil.constructLinesFromPredefinedMethods(register, lineKlass, shiftLines, preDefinedMethodsQuery, POSPersister.params("shiftCode", lastShiftCode, "registerId", register.getId()));
            if (ObjectChecker.isEmptyOrNull((Object)MultiplePaymentDialog.searchForCashMethod())) {
                POSPaymentMethodsUtil.constructDefaultCashOrCreditLines(register, lineKlass, shiftLines, defaultCashQuery, "cash", POSPersister.params("valueDate", toDate, "shiftCode", lastShiftCode, "registerId", register.getId()));
            }
            POSPaymentMethodsUtil.constructDefaultCashOrCreditLines(register, lineKlass, shiftLines, defaultDebitQuery, "debitValue", POSPersister.params("shiftCode", lastShiftCode, "registerId", register.getId()));
        }
        return POSPaymentMethodsUtil.updateShiftCashAndAddMissingThenSort(register, lineKlass, currentShiftCashAmount, lastOpenShift, shiftLines);
    }
}

