/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSCustomerClass;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceResDetail;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.PosPriceCachedObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class POSPricesCachingUtil {
    public static Map<String, PosPriceCachedObject> priceEntries = new ConcurrentHashMap<String, PosPriceCachedObject>();
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static void clearCache() {
        priceEntries.clear();
        POSItem.clearUnitPriceCache();
    }

    public static void addEntryToCache(AbsPOSSalesLine line, AbsPOSSales posSales, POSItemSalesPriceResDetail posItemSalesPriceResDetail) {
        String stopPricesCaching = POSGeneralSettings.getStopPricesCaching();
        if (ObjectChecker.isNotEmptyOrNull((Object)stopPricesCaching) && ObjectChecker.areEqual((Object)stopPricesCaching.trim(), (Object)"1")) {
            return;
        }
        String key = POSPricesCachingUtil.createKey(line, posSales);
        PosPriceCachedObject.appendOrCreate(line.getQty().getValue(), key, posItemSalesPriceResDetail);
        POSResourcesUtil.clearSomeCachedObjectsIfNeeded();
    }

    private static String createKey(AbsPOSSalesLine line, AbsPOSSales posSales) {
        Object key = line.getItem() == null ? line.getItemCode() : "";
        POSCustomerClass customerClass = posSales.getCustomer() == null ? null : posSales.getCustomer().getCustomerClass();
        key = (String)key + POSPricesCachingUtil.constructPriceCacheKey(line.getItem(), posSales.getCustomer(), customerClass, posSales.getPosInvoiceClassification(), posSales.getPriceClassifier1(), posSales.getPriceClassifier2(), posSales.getPriceClassifier3(), posSales.getPriceClassifier4(), posSales.getPriceClassifier5(), line.getQty().getUom());
        key = (String)key + POSPricesCachingUtil.constructPriceCacheKey(line.getItemDimensions().getRevisionId(), line.getItemDimensions().getColor(), line.getItemDimensions().getSize(), ServerStringUtils.toUUIDStr((Object)posSales.getSubsidiaryID()), posSales.getSubsidiaryType());
        return key;
    }

    private static String constructPriceCacheKey(POSMasterFile ... files) {
        Object key = dateFormat.format(LocalDate.now());
        for (POSMasterFile file : files) {
            if (file == null) continue;
            key = (String)key + "_#_" + file.getId().toString().replace("-", "");
        }
        return key;
    }

    private static String constructPriceCacheKey(String ... strs) {
        Object key = "";
        for (String str : strs) {
            if (!ObjectChecker.isNotEmptyOrNull((Object)str)) continue;
            key = (String)key + "_#_" + str;
        }
        return key;
    }

    public static POSItemSalesPriceResDetail searchForPrice(AbsPOSSalesLine line, AbsPOSSales posSales) {
        PosPriceCachedObject posPriceCachedObject = priceEntries.get(POSPricesCachingUtil.createKey(line, posSales));
        if (posPriceCachedObject == null) {
            return null;
        }
        POSResourcesUtil.updatePosCachedObjDate(posPriceCachedObject);
        return posPriceCachedObject.findApprPriceResDetail(line.getQty().getValue());
    }
}

