/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.Pair;
import com.namasoft.common.ResultDTO;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.common.DTOPOSConfiguration;
import com.namasoft.modules.supplychain.enums.ItemType;
import com.namasoft.namacontrols.NamaProgressBarDialog;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemQtyUpdateConfig;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.valueobjects.POSItemCurrentQuantitySysEntry;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.PosSalesUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.concurrent.Task;

public class POSQuantitiesUtils {
    public static void checkOverDraftQuantitiesOffline(final POSSalesInvoice salesDoc, final POSResult result) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                this.updateTitle(POSResourcesUtil.id("validateQty", new Object[0]));
                List details = salesDoc.getDetails().stream().filter(line -> line.getItem() != null && ObjectChecker.areNotEqual((Object)line.getItem().getItemType(), (Object)ItemType.Service)).collect(Collectors.toList());
                double workDone = 0.0;
                this.updateProgress(workDone, details.size());
                POSItemQtyUpdateConfig config = POSQuantitiesUtils.qtyUpdateConfig();
                List<POSItem> items = details.stream().map(AbsPOSSalesLine::getItem).distinct().collect(Collectors.toList());
                List<POSSalesInvoice> holdInvoices = PosSalesUtil.collectHoldInvoices(config, salesDoc.getWarehouse(), salesDoc.getLocation(), salesDoc.getId(), items, result);
                ArrayList lines = new ArrayList(details);
                ArrayList<POSSalesInvoiceLine> invoiceLines = new ArrayList<POSSalesInvoiceLine>();
                HashSet<String> level1Keys = new HashSet<String>();
                for (POSSalesInvoiceLine line2 : details) {
                    this.updateProgress(workDone += 0.8, details.size());
                    if (!level1Keys.add(POSQuantitiesUtils.createKey(config, line2))) continue;
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    Date date = POSPersister.max(POSItemCurrentQuantitySysEntry.class, "lastUpdateTime", POSQuantitiesUtils.createItemQuantitySysEntryWhereClause(line2, config, params), params, Date.class);
                    if (date == null) {
                        ResultDTO fail = ResultDTO.fail();
                        fail.setArabicMessage("\u0644\u0627 \u064a\u0648\u062c\u062f \u0643\u0645\u064a\u0629 \u0644\u0644\u0635\u0646\u0641 " + line2.getItem().getCode() + " : " + line2.getItem().getName1());
                        fail.setEnglishMessage("Item " + line2.getItem().getCode() + " : " + line2.getItem().getName2() + " does not have  any available quantities");
                        result.accumulate(new POSResult().failure(fail));
                        continue;
                    }
                    List<POSSalesInvoice> invoices = PosSalesUtil.collectActualInvoiceAfterDate(config, salesDoc.getWarehouse(), salesDoc.getLocation(), salesDoc.getId(), date, Arrays.asList(line2.getItem()), result);
                    invoices.addAll(holdInvoices);
                    String key = POSQuantitiesUtils.createKey(config, line2);
                    for (POSSalesInvoice invoice : invoices) {
                        for (POSSalesInvoiceLine detail : invoice.getDetails()) {
                            if (!ObjectChecker.areEqual((Object)key, (Object)POSQuantitiesUtils.createKey(config, detail))) continue;
                            invoiceLines.add(detail);
                        }
                    }
                }
                if (result.isFailed().booleanValue()) {
                    this.updateProgress(1L, 1L);
                    return null;
                }
                invoiceLines.addAll(lines);
                HashMap<POSSalesInvoiceLine, Pair> map = new HashMap<POSSalesInvoiceLine, Pair>();
                HashSet<String> keys = new HashSet<String>();
                for (POSSalesInvoiceLine pOSSalesInvoiceLine : lines) {
                    this.updateProgress(workDone += 0.2, details.size());
                    if (!keys.add(POSQuantitiesUtils.createKey(config, pOSSalesInvoiceLine))) continue;
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    POSItemCurrentQuantitySysEntry matched = (POSItemCurrentQuantitySysEntry)CollectionsUtility.getFirst(POSPersister.searchFor(POSQuantitiesUtils.createItemQuantitySysEntryQuery(pOSSalesInvoiceLine, config, params), params));
                    map.put(pOSSalesInvoiceLine, new Pair((Object)matched, (Object)POSQuantitiesUtils.totalQtyOfMatchedLines(pOSSalesInvoiceLine, invoiceLines, config)));
                }
                for (Map.Entry entry : map.entrySet()) {
                    POSQuantitiesUtils.validateQuantities((POSSalesInvoiceLine)entry.getKey(), (POSItemCurrentQuantitySysEntry)((Pair)entry.getValue()).getX(), (BigDecimal)((Pair)entry.getValue()).getY(), result);
                }
                this.updateProgress(1L, 1L);
                return null;
            }
        };
        NamaProgressBarDialog progressBarDialog = new NamaProgressBarDialog();
        progressBarDialog.constructNamaProgressBarDialog((Task)task);
        progressBarDialog.headerText("validateQty");
        progressBarDialog.closeAfterTask();
        progressBarDialog.showAndWait();
    }

    private static String createKey(POSItemQtyUpdateConfig config, POSSalesInvoiceLine line) {
        StringBuilder key = new StringBuilder(line.getItem().getId().toString());
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderWarehouse())) {
            key.append("#").append(line.getWarehouse() == null ? null : line.getWarehouse().getId().toString());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderLocator())) {
            key.append("#").append(line.getLocation() == null ? null : line.getLocation().getId().toString());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderBox())) {
            key.append("#").append(line.getBox());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderColor())) {
            key.append("#").append(line.getItemDimensions().getColor());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderLotId())) {
            key.append("#").append(line.getItemDimensions().getLotId());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderRevisionId())) {
            key.append("#").append(line.getItemDimensions().getRevisionId());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderSize())) {
            key.append("#").append(line.getItemDimensions().getSize());
        }
        return key.toString();
    }

    private static BigDecimal totalQtyOfMatchedLines(POSSalesInvoiceLine line, List<POSSalesInvoiceLine> invoiceLines, POSItemQtyUpdateConfig config) {
        return NaMaMath.totalizeDecimalStream(invoiceLines.stream().filter(l -> POSQuantitiesUtils.areLinesMatched(config, line, l)).map(POSQuantitiesUtils::getBaseQty));
    }

    public static boolean areLinesMatched(POSItemQtyUpdateConfig config, POSSalesInvoiceLine l1, POSSalesInvoiceLine l2) {
        if (ObjectChecker.areNotEqual((Object)l1.getItem(), (Object)l2.getItem())) {
            return false;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderWarehouse()) && ObjectChecker.areNotEqual((Object)l1.getWarehouse(), (Object)l2.getWarehouse())) {
            return false;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderLocator()) && ObjectChecker.areNotEqual((Object)l1.getLocation(), (Object)l2.getLocation())) {
            return false;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderSize()) && ObjectChecker.arePairsNotEqual((Object[])new Object[]{l1.getItemDimensions().getSize(), l2.getItemDimensions().getSize(), l1.getItemDimensions().getSizeName(), l2.getItemDimensions().getSizeName()})) {
            return false;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderColor()) && ObjectChecker.arePairsNotEqual((Object[])new Object[]{l1.getItemDimensions().getColor(), l2.getItemDimensions().getColor(), l1.getItemDimensions().getColorName(), l2.getItemDimensions().getColorName()})) {
            return false;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderRevisionId()) && ObjectChecker.areNotEqual((Object)l1.getItemDimensions().getRevisionId(), (Object)l2.getItemDimensions().getRevisionId())) {
            return false;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderLotId()) && ObjectChecker.areNotEqual((Object)l1.getItemDimensions().getLotId(), (Object)l2.getItemDimensions().getLotId())) {
            return false;
        }
        return !ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderBox()) || !ObjectChecker.areNotEqual((Object)l1.getItemDimensions().getBox(), (Object)l2.getItemDimensions().getBox());
    }

    public static POSItemQtyUpdateConfig qtyUpdateConfig() {
        POSItemQtyUpdateConfig config;
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        DTOPOSConfiguration posConfig = POSResourcesUtil.fetchPOSConfig();
        POSItemQtyUpdateConfig pOSItemQtyUpdateConfig = config = posConfig == null ? null : (POSItemQtyUpdateConfig)new POSItemQtyUpdateConfig().fromReference(posConfig.getItemQtyUpdateConfig());
        if (register != null && ObjectChecker.isNotEmptyOrNull((Object)register.getPosItemQtyUpdateConfigId())) {
            config = POSPersister.findByID(POSItemQtyUpdateConfig.class, register.getPosItemQtyUpdateConfigId());
        }
        return config;
    }

    private static String createItemQuantitySysEntryQuery(POSSalesInvoiceLine line, POSItemQtyUpdateConfig config, Map<String, Object> params) {
        String whereClause = POSQuantitiesUtils.createItemQuantitySysEntryWhereClause(line, config, params);
        return "from ".concat(POSItemCurrentQuantitySysEntry.class.getSimpleName()).concat(" where ").concat(whereClause);
    }

    private static String createItemQuantitySysEntryWhereClause(POSSalesInvoiceLine line, POSItemQtyUpdateConfig config, Map<String, Object> params) {
        StringBuilder query = new StringBuilder("item_id = :itemId");
        params.put("itemId", line.getItem().getId());
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderWarehouse()) && line.getWarehouse() != null) {
            query.append(" and warehouse_id = :warehouseId");
            params.put("warehouseId", line.getWarehouse() == null ? null : line.getWarehouse().getId());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderLocator()) && line.getLocation() != null) {
            query.append(" and location_id = :locatorId");
            params.put("locatorId", line.getLocation() == null ? null : line.getLocation().getId());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderBox()) && ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getBox())) {
            query.append(" and specificDimensions.box = :box");
            params.put("box", line.getItemDimensions().getBox());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderColor()) && ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getColor())) {
            query.append(" and specificDimensions.color = :color");
            params.put("color", line.getItemDimensions().getColor());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderLotId()) && ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getLotId())) {
            query.append(" and specificDimensions.lotId = :lotId");
            params.put("lotId", line.getItemDimensions().getLotId());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderRevisionId()) && ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getRevisionId())) {
            query.append(" and specificDimensions.revisionId = :revisionId");
            params.put("revisionId", line.getItemDimensions().getRevisionId());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderSize()) && ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getSize())) {
            query.append(" and specificDimensions.size =:size");
            params.put("size", line.getItemDimensions().getSize());
        }
        return query.toString();
    }

    private static void validateQuantities(POSSalesInvoiceLine line, POSItemCurrentQuantitySysEntry matched, BigDecimal totalQty, POSResult result) {
        if (matched != null && matched.getCurrentQty().compareTo(totalQty) >= 0) {
            return;
        }
        BigDecimal requiredQty = line.getQty().getValue();
        BigDecimal soldQty = totalQty.subtract(requiredQty);
        BigDecimal available = matched == null ? BigDecimal.ZERO : matched.getCurrentQty().subtract(soldQty);
        POSResult qtyResult = new POSResult();
        qtyResult.failure("Insufficient quantity for item {0}. required quantity {1}. available quantity {2}", line.getItem().getCode(), requiredQty, available);
        result.accumulate(qtyResult);
    }

    private static BigDecimal getBaseQty(POSSalesInvoiceLine line) {
        POSItem item = POSPersister.findByID(POSItem.class, line.getItem().getId());
        if (ObjectChecker.areEqual((Object)line.getQty().getUom().getId(), (Object)item.fetchBaseUnitId())) {
            return line.getQty().getValue();
        }
        return POSSalesPriceUtil.calcRateToBase(item.getUnits(), line.getQty().getUom()).multiply(line.getQty().getValue());
    }
}

