/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.upgrader.Platform;
import java.util.List;

public class POSResult {
    private String arMessage = "";
    private String enMessage = "";
    private Boolean failed;
    private String log;

    public POSResult() {
        this.setFailed(false);
    }

    public String getArMessage() {
        return this.arMessage;
    }

    public void setArMessage(String arMessage) {
        this.arMessage = arMessage;
    }

    public String getEnMessage() {
        return this.enMessage;
    }

    public void setEnMessage(String enMessage) {
        this.enMessage = enMessage;
    }

    public POSResult failure(String message, Object ... params) {
        this.setFailed(true);
        this.setArMessage(this.getArMessage() + POSResourcesUtil.id(message, params) + "\n");
        this.setEnMessage(this.getEnMessage() + POSResourcesUtil.id(message, params) + "\n");
        if (Platform.isInDebugMode() && ObjectChecker.NOTisAnyEqualToFirst((Object)message, (Object[])new String[]{"Service charge recalculated"})) {
            new RuntimeException(POSResourcesUtil.id(message, new Object[0])).printStackTrace();
        }
        return this;
    }

    public POSResult failure(ResultDTO resultDTO) {
        this.setFailed(true);
        if (resultDTO == null) {
            return this;
        }
        this.setArMessage(this.getArMessage() + POSResourcesUtil.id(resultDTO.getArabicMessage(), new Object[0]) + "\n");
        this.setEnMessage(this.getEnMessage() + POSResourcesUtil.id(resultDTO.getEnglishMessage(), new Object[0]) + "\n");
        if (Platform.isInDebugMode()) {
            new RuntimeException(resultDTO.getOriginalMessage()).printStackTrace();
        }
        return this;
    }

    public POSResult failure(List<ResultDTO> resultDTOS) {
        for (ResultDTO resultDTO : resultDTOS) {
            this.failure(resultDTO);
        }
        return this;
    }

    public Boolean isFailed() {
        return this.failed;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public Boolean isSucceeded() {
        return this.isFailed() == false;
    }

    public void setFailed(Boolean failed) {
        this.failed = failed;
    }

    public String getMessageByLanguage() {
        if (ObjectChecker.areEqual((Object)POSResourcesUtil.getCurrentLang(), (Object)Language.Arabic)) {
            return this.arMessage;
        }
        return this.enMessage;
    }

    public POSResult accumulate(List<ResultDTO> failures) {
        for (ResultDTO failure : failures) {
            this.accumulate(new POSResult().failure(failure));
        }
        return this;
    }

    public void addToAccumulateResult(POSResult result) {
        result.accumulate(this);
    }

    public POSResult accumulate(POSResult result) {
        return this.accumulate(result.getArMessage(), result.getEnMessage(), result.isFailed());
    }

    public POSResult accumulate(String arMessage, String enMessage, Boolean failed) {
        if (ObjectChecker.isFalseOrNull((Boolean)failed)) {
            return this;
        }
        this.setFailed(true);
        this.setArMessage(this.getArMessage().concat(this.getArMessage().isEmpty() ? "" : "\n").concat(arMessage));
        this.setEnMessage(this.getEnMessage().concat(this.getArMessage().isEmpty() ? "" : "\n").concat(enMessage));
        return this;
    }
}

