/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.Pair;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.common.flatobjects.IHasPriceListDefaultPrice;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.DimensionsUtil;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.SafeBigDecimal;
import com.namasoft.common.utilities.SimpleEntry;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.basic.enums.DiscountType;
import com.namasoft.modules.basic.enums.PriceListDefaultPrice;
import com.namasoft.modules.commonbasic.contracts.entities.DTOTaxPlan;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGlobalConfigInfo;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxConfiguration;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;
import com.namasoft.modules.commonbasic.enums.TaxApplyType;
import com.namasoft.modules.commonbasic.enums.TaxLocation;
import com.namasoft.modules.namapos.contracts.common.DTOPOSConfiguration;
import com.namasoft.modules.supplychain.enums.InvoiceOfferDiscountType;
import com.namasoft.modules.supplychain.enums.OfferItemsCountMechanism;
import com.namasoft.modules.supplychain.enums.SalesPriceReqType;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IPOSHasDims;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.AbsSCPriceListSysLine;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.IPOSFreeItemOfferLine;
import com.namasoft.pos.domain.details.POSFreeGroupLine;
import com.namasoft.pos.domain.details.POSFreeItemLine;
import com.namasoft.pos.domain.details.POSInvoiceDiscountLine;
import com.namasoft.pos.domain.details.POSInvoiceFreeItemLine;
import com.namasoft.pos.domain.details.POSItemDiscountLine;
import com.namasoft.pos.domain.details.POSItemUnit;
import com.namasoft.pos.domain.details.POSOfferCouponLine;
import com.namasoft.pos.domain.details.POSOfferOnItemsCountLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.details.POSSalesPriceListLine;
import com.namasoft.pos.domain.details.POSSizesAndColors;
import com.namasoft.pos.domain.entities.IHasPOSItemClasses;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoiceLine;
import com.namasoft.pos.domain.entities.IPOSOfferSysLine;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemRevision;
import com.namasoft.pos.domain.entities.POSPricingRange;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.valueobjects.POSDiscountTax;
import com.namasoft.pos.domain.valueobjects.POSEntityRefData;
import com.namasoft.pos.domain.valueobjects.POSFreeItemData;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.domain.valueobjects.POSItemSalesFreeItem;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceReq;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceRes;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceResDetail;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.domain.valueobjects.POSSalesDiscountResultUnit;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceReqDetail;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceReqType;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceResult;
import com.namasoft.pos.util.IHasMaxQty;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSSalesHeaderDiscountResp;
import com.namasoft.pos.util.POSSalesPriceFromListSearcher;
import com.namasoft.pos.util.POSSalesPriceFromUnitsSearcher;
import com.namasoft.pos.util.POSSalesPriceSearcher;
import com.namasoft.pos.util.POSXMLSerializer;
import com.namasoft.pos.util.PosSalesUtil;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;

public class POSSalesPriceUtil {
    public static Function<AbsPOSSales, Void> updateDocPriceFun(POSRegistery register, Function<DTOPOSConfiguration, Boolean> isNotAllowed, AbsPosSalesScreen salesScreen) {
        return doc -> {
            Boolean allowed = ObjectChecker.isFalseOrNull((Boolean)((Boolean)isNotAllowed.apply(POSResourcesUtil.fetchPOSConfig())));
            if (allowed.booleanValue()) {
                doc.updateSalesPrices(register, salesScreen);
            }
            return null;
        };
    }

    public static POSSalesPriceListLine calculateUnitPrice(POSItemSalesPriceReq req, int index, POSItem item, BigDecimal qty) {
        Object criteria = " where itemID = :itemId and (targetId is null or targetId = :customerId or targetId = :customerClassId or targetId = :customerCategId)  and (invoiceClassification is null or invoiceClassification = :invClassification)  and fromDate <= :date and toDate >= :date";
        criteria = POSSalesPriceUtil.addPriceClassifiersToCriteria((String)criteria);
        String revisionId = req.getDetails().get(index).getSpecificDimensions().getRevisionId();
        String size = req.getDetails().get(index).getSpecificDimensions().getSize();
        String color = req.getDetails().get(index).getSpecificDimensions().getColor();
        HashMap<String, Object> params = POSPersister.params("itemId", item.getId(), "customerId", ObjectChecker.isNotEmptyOrNull((Object)req.getCustomer()) ? req.getCustomer().getId() : null, "customerClassId", ObjectChecker.isNotEmptyOrNull((Object)req.getCustomer()) && ObjectChecker.isNotEmptyOrNull((Object)req.getCustomer().getCustomerClass()) ? req.getCustomer().getCustomerClass().getId() : null, "customerCategId", req.customerCategoryId(), "invClassification", req.getInvoiceClassification(), "date", req.getValueDate());
        POSSalesPriceUtil.addPriceClassifiersToParams(req, params);
        criteria = POSSalesPriceUtil.addSubsidiaryToCriteriaAndParams((String)criteria, req, params);
        POSUnit uom = req.getDetails().get(index).getUom();
        if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.currentSetting)) {
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getIncludeRevisionIdInItemPriceSearch())) {
                criteria = (String)criteria + " and (itemDimensions.revisionId = :revId or itemDimensions.revisionId is null or itemDimensions.revisionId = '')";
                params.put("revId", revisionId);
            }
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getIncludeSizeInItemPriceSearch())) {
                criteria = (String)criteria + " and (itemDimensions.size = :size or itemDimensions.size is null or itemDimensions.size = '')";
                params.put("size", size);
            }
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getIncludeColorInItemPriceSearch())) {
                criteria = (String)criteria + " and (itemDimensions.color = :color or itemDimensions.color is null or itemDimensions.color = '')";
                params.put("color", color);
            }
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getMustMatchLineUomWithSalesPriceListUom()) && ObjectChecker.isNotEmptyOrNull((Object)uom)) {
                criteria = (String)criteria + " and (qty.uom = :uom or qty.uom is null) ";
                params.put("uom", uom);
            }
        }
        List<POSSalesPriceListLine> matches = POSPersister.listAll(POSSalesPriceListLine.class, (String)criteria, params, "priority");
        POSSalesPriceUtil.filterMatchesByQty(item, qty, matches, req.getDetails().get(index).getUom());
        POSSalesPriceUtil.filterByDimensions(matches);
        POSSalesPriceUtil.filterByApplyOnAndApplyOnlyIfItemInInvoice(matches, req, req.getDetails().get(index));
        if (ObjectChecker.isEmptyOrNull(matches)) {
            return null;
        }
        for (int i = matches.size() - 1; i >= 0; --i) {
            if (!POSSalesPriceUtil.notApplicableForEmployee((AbsSCPriceListSysLine)matches.get(i), req.getEmployee())) continue;
            matches.remove(i);
        }
        if (params.containsKey("revId") || params.containsKey("size") || params.containsKey("color")) {
            return POSSalesPriceUtil.getBestMatchLineWithDims(matches, req.getDetails().get(index).getSpecificDimensions(), params, req.getDetails().get(index).getUom());
        }
        return POSSalesPriceUtil.getBestMatchLine(matches, req.getDetails().get(index).getSpecificDimensions(), req.getDetails().get(index).getUom());
    }

    private static String addSubsidiaryToCriteriaAndParams(String criteria, POSItemSalesPriceReq req, HashMap<String, Object> params) {
        return POSSalesPriceUtil.addSubsidiaryToCriteriaAndParams(criteria, params, req.getSubsidiaryId(), req.getSubsidiaryType());
    }

    private static String addSubsidiaryToCriteriaAndParams(String criteria, HashMap<String, Object> params, UUID subsidiaryID, String subsidiaryType) {
        if (ObjectChecker.isEmptyOrNull((Object)subsidiaryID)) {
            criteria = (String)criteria + " and subsidiaryId is null";
        } else {
            ArrayList<UUID> list = new ArrayList<UUID>();
            list.add(subsidiaryID);
            if (ObjectChecker.areEqual((Object)subsidiaryType, (Object)"Employee")) {
                POSEmployee emp = POSPersister.findByID(POSEmployee.class, subsidiaryID);
                list.addAll(Arrays.asList(emp.getJobPositionId(), emp.getOrganizationPositionId(), emp.getEmployeeDepartmentId(), emp.getDepartmentSectionId()));
                list.removeIf(l -> l == null);
            }
            criteria = (String)criteria + " and (subsidiaryId is null or subsidiaryId in :subsidiaryId)";
            params.put("subsidiaryId", list);
        }
        return criteria;
    }

    private static <T extends AbsSCPriceListSysLine> void filterMatchesByQty(POSItem item, BigDecimal qty, List<T> matches, POSUnit uom) {
        matches.sort(Comparator.comparing(AbsSCPriceListSysLine::fetchPriority).thenComparing(AbsSCPriceListSysLine::getNegateQtyInBaseUOM).thenComparing(AbsSCPriceListSysLine::getLineNumber));
        for (int i = matches.size() - 1; i >= 0; --i) {
            BigDecimal maxQty;
            AbsSCPriceListSysLine sysLine = (AbsSCPriceListSysLine)matches.get(i);
            BigDecimal qtyInUOM = qty;
            if (ObjectChecker.areNotEqual((Object)sysLine.getQty().getUom(), (Object)uom) && uom != null) {
                qtyInUOM = qty.multiply(POSSalesPriceUtil.findUOMPriceFactor(item, uom, sysLine.getQty().getUom()));
                qtyInUOM = NaMaMath.round((BigDecimal)qtyInUOM, (Integer)uom.getFractionDecimalPlaces());
            }
            if (qtyInUOM.compareTo(sysLine.getQty().getValue()) < 0) {
                matches.remove(i);
                continue;
            }
            if (!(sysLine instanceof IHasMaxQty) || !ObjectChecker.isNotEmptyOrZero((BigDecimal)(maxQty = ((IHasMaxQty)((Object)sysLine)).fetchMaxQty())) || qtyInUOM.compareTo(maxQty) <= 0) continue;
            matches.remove(i);
        }
    }

    public static void addPriceClassifiersToParams(POSItemSalesPriceReq req, HashMap<String, Object> params) {
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier1())) {
            params.put("priceClassifier1", req.getPriceClassifier1());
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier2())) {
            params.put("priceClassifier2", req.getPriceClassifier2());
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier3())) {
            params.put("priceClassifier3", req.getPriceClassifier3());
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier4())) {
            params.put("priceClassifier4", req.getPriceClassifier4());
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier5())) {
            params.put("priceClassifier5", req.getPriceClassifier5());
        }
    }

    private static POSSalesPriceListLine getBestMatchLineWithDims(List<POSSalesPriceListLine> matches, POSItemSpecificDimensions specificDimensions, HashMap<String, Object> params, POSUnit uom) {
        for (POSSalesPriceListLine priceSysLine : matches) {
            if (!POSSalesPriceUtil.areSpecificDimensionsMatched(priceSysLine.getItemDimensions(), specificDimensions) || !priceSysLine.matches(params)) continue;
            return priceSysLine;
        }
        return POSSalesPriceUtil.getBestMatchLine(matches, specificDimensions, uom);
    }

    public static void filterByDimensions(List<? extends IPOSHasDims> matches) {
        if (POSResourcesUtil.fetchMainRegister() == null) {
            return;
        }
        POSGenericDims genericDims = POSResourcesUtil.fetchMainRegister().getGenericDims();
        for (int i = matches.size() - 1; i >= 0; --i) {
            boolean nullAnalysisSet;
            boolean nullDept;
            boolean nullBranch;
            boolean nullSector;
            boolean nullLegalEntity;
            POSGenericDims dims = matches.get(i).fetchGenericDims();
            if (ObjectChecker.isNotEmptyOrNull((Object)dims.getLegalEntity()) && !(nullLegalEntity = POSSalesPriceUtil.isNullDim(dims.getLegalEntity().getCode())) && !ObjectChecker.areEqual((Object)genericDims.getLegalEntity().getId(), (Object)dims.getLegalEntity().getId())) {
                matches.remove(i);
                continue;
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)dims.getSector()) && !(nullSector = POSSalesPriceUtil.isNullDim(dims.getSector().getCode())) && !ObjectChecker.areEqual((Object)genericDims.getSector().getId(), (Object)dims.getSector().getId())) {
                matches.remove(i);
                continue;
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)dims.getBranch()) && !(nullBranch = POSSalesPriceUtil.isNullDim(dims.getBranch().getCode())) && !ObjectChecker.areEqual((Object)genericDims.getBranch().getId(), (Object)dims.getBranch().getId())) {
                matches.remove(i);
                continue;
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)dims.getDepartment()) && !(nullDept = POSSalesPriceUtil.isNullDim(dims.getDepartment().getCode())) && !ObjectChecker.areEqual((Object)genericDims.getDepartment().getId(), (Object)dims.getDepartment().getId())) {
                matches.remove(i);
                continue;
            }
            if (!ObjectChecker.isNotEmptyOrNull((Object)dims.getAnalysisSet()) || (nullAnalysisSet = POSSalesPriceUtil.isNullDim(dims.getAnalysisSet().getCode())) || ObjectChecker.areEqual((Object)genericDims.getAnalysisSet().getId(), (Object)dims.getAnalysisSet().getId())) continue;
            matches.remove(i);
        }
    }

    private static boolean isNullDim(String code) {
        FlatObject flatObject = new FlatObject();
        flatObject.getValuesMap().put("code", code);
        boolean nullLegalEntity = DimensionsUtil.isNullDimension((FlatObject)flatObject);
        return nullLegalEntity;
    }

    private static <T extends AbsSCPriceListSysLine> T getBestMatchLine(List<T> matches, POSItemSpecificDimensions dimensions, POSUnit uom) {
        List linesWithSameUOM;
        if (ObjectChecker.isNotEmptyOrNull((Object)uom) && ObjectChecker.isNotEmptyOrNull(linesWithSameUOM = matches.stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getQty()) && ObjectChecker.areEqual((Object)l.getQty().getUom(), (Object)uom)).collect(Collectors.toList()))) {
            matches = linesWithSameUOM;
        }
        for (AbsSCPriceListSysLine priceSysLine : matches) {
            if (!POSSalesPriceUtil.areSpecificDimensionsMatched(priceSysLine.getItemDimensions(), dimensions)) continue;
            return (T)priceSysLine;
        }
        return null;
    }

    private static boolean areSpecificDimensionsMatched(POSItemSpecificDimensions sysLineDimensions, POSItemSpecificDimensions documetLineDimenions) {
        if (documetLineDimenions == null) {
            return true;
        }
        if (sysLineDimensions == null) {
            return true;
        }
        if (!POSSalesPriceUtil.areSpecificDimensionsMatched(sysLineDimensions.getColor(), documetLineDimenions.getColor())) {
            return false;
        }
        if (!POSSalesPriceUtil.areSpecificDimensionsMatched(sysLineDimensions.getLotId(), documetLineDimenions.getLotId())) {
            return false;
        }
        if (!POSSalesPriceUtil.areSpecificDimensionsMatched(sysLineDimensions.getRevisionId(), documetLineDimenions.getRevisionId())) {
            return false;
        }
        return POSSalesPriceUtil.areSpecificDimensionsMatched(sysLineDimensions.getSize(), documetLineDimenions.getSize());
    }

    private static boolean areSpecificDimensionsMatched(String sysLineDimensions, String documetLineDimenions) {
        if (ObjectChecker.isEmptyOrNull((Object)sysLineDimensions)) {
            return true;
        }
        return ObjectChecker.areEqual((Object)ObjectChecker.toStringOrEmpty((Object)sysLineDimensions), (Object)ObjectChecker.toStringOrEmpty((Object)documetLineDimenions));
    }

    public static boolean notApplicableForEmployee(UUID empTargetId, String empTargetType, POSUser targetEmp) {
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{empTargetId, empTargetType})) {
            if (ObjectChecker.areEqual((Object)empTargetType, (Object)"Employee") && ObjectChecker.areNotEqual((Object)empTargetId, (Object)targetEmp.getId())) {
                return true;
            }
            if (ObjectChecker.areEqual((Object)empTargetType, (Object)"EmployeeDepartment") && ObjectChecker.isNotEmptyOrNull((Object)targetEmp.getEmpDepartmentId()) && ObjectChecker.areNotEqual((Object)empTargetId, (Object)targetEmp.getEmpDepartmentId())) {
                return true;
            }
            if (ObjectChecker.areEqual((Object)empTargetType, (Object)"JobPosition") && ObjectChecker.isNotEmptyOrNull((Object)targetEmp.getEmpJobPositionId()) && ObjectChecker.areNotEqual((Object)empTargetId, (Object)targetEmp.getEmpJobPositionId())) {
                return true;
            }
            if (ObjectChecker.areEqual((Object)empTargetType, (Object)"OrganizationPosition") && ObjectChecker.isNotEmptyOrNull((Object)targetEmp.getEmpOrgPositionId()) && ObjectChecker.areNotEqual((Object)empTargetId, (Object)targetEmp.getEmpOrgPositionId())) {
                return true;
            }
        }
        return false;
    }

    public static boolean notApplicableForEmployee(AbsSCPriceListSysLine l, POSUser targetEmp) {
        return POSSalesPriceUtil.notApplicableForEmployee(l.getEmpTargetId(), l.getEmpTargetType(), targetEmp);
    }

    /*
     * WARNING - void declaration
     */
    public static POSItemSalesPriceRes updateLinePriceAndDiscounts(POSItemSalesPriceReq itemPriceReq) {
        POSItemSalesPriceRes priceResult = new POSItemSalesPriceRes();
        priceResult.setQty(BigDecimal.valueOf(-1L));
        priceResult.setDetails(new ArrayList<POSItemSalesPriceResDetail>());
        if (ObjectChecker.areEqual((Object)((Object)itemPriceReq.getRequestType()), (Object)((Object)POSSalesPriceReqType.GetFreeItems)) || ObjectChecker.areEqual((Object)((Object)itemPriceReq.getRequestType()), (Object)((Object)POSSalesPriceReqType.ReplaceFreeItems))) {
            return POSSalesPriceUtil.calculateFreeItemsOnly(itemPriceReq, priceResult);
        }
        int i = 0;
        ArrayList<DiscountCalculator> calculators = new ArrayList<DiscountCalculator>();
        BigDecimal total = POSSalesPriceUtil.calcualteTotalBeforeHeader(itemPriceReq);
        EntityReferenceData legalEntity = POSResourcesUtil.fetchMainRegister().fetchLegalEntityRef();
        for (POSSalesPriceReqDetail requestLine : itemPriceReq.getDetails()) {
            PriceListDefaultPrice priceListDefaultPrice;
            DTOTaxConfiguration taxConfiguration = DTOTaxPlan.fetchTaxConfiguration((DTOTaxPlan)POSResourcesUtil.fetchPosConfigDtoTaxPlan(), (DTOTaxPlan)POSResourcesUtil.fetchItemDtoTaxPlanFrom(requestLine.getItem()), (EntityReferenceData)legalEntity, (Date)itemPriceReq.getValueDate(), (DTOGlobalConfigInfo)POSResourcesUtil.fetchGlobalConfig().getInfo(), (String)itemPriceReq.getEntityType());
            SimpleEntry pricePair = null;
            BigDecimal defaultPrice = BigDecimal.ZERO;
            Boolean useDiscounts = true;
            BigDecimal customPrice = BigDecimal.ZERO;
            BigDecimal n1 = BigDecimal.ZERO;
            BigDecimal n2 = BigDecimal.ZERO;
            BigDecimal n3 = BigDecimal.ZERO;
            BigDecimal n4 = BigDecimal.ZERO;
            BigDecimal n5 = BigDecimal.ZERO;
            POSSalesPriceResult priceRes = POSSalesPriceUtil.searchForPrice(itemPriceReq, i, requestLine, pricePair, defaultPrice, useDiscounts, customPrice, n1, n2, n3, n4, n5);
            defaultPrice = priceRes.getDefaultPrice();
            pricePair = priceRes.getPricePair();
            customPrice = priceRes.getCustomPrice();
            n1 = priceRes.getN1();
            n2 = priceRes.getN2();
            n3 = priceRes.getN3();
            n4 = priceRes.getN4();
            n5 = priceRes.getN5();
            useDiscounts = priceRes.getUseDiscounts();
            POSItemSalesPriceResDetail resultLine = new POSItemSalesPriceResDetail();
            resultLine.setPriceListLineID(priceRes.getPriceListLineID());
            if (pricePair == null) {
                if (requestLine.getSpecificDimensions() != null && pricePair == null && ObjectChecker.isTrue((Boolean)requestLine.getItem().isHasRevisions()) && ObjectChecker.isNotEmptyOrNull((Object)requestLine.getSpecificDimensions().getRevisionId())) {
                    for (POSItemRevision pOSItemRevision : requestLine.getItem().getRevisions()) {
                        if (!ObjectChecker.areEqual((Object)requestLine.getSpecificDimensions().getRevisionId(), (Object)pOSItemRevision.getRevisionId()) || !ObjectChecker.isNotEmptyOrZero((BigDecimal)pOSItemRevision.getDefaultPrice())) continue;
                        pricePair = new SimpleEntry((Object)pOSItemRevision.getDefaultPrice(), (Object)pOSItemRevision.getDefaultPrice());
                        defaultPrice = pOSItemRevision.getDefaultPrice();
                        break;
                    }
                }
                if (pricePair == null && requestLine.getSpecificDimensions() != null && ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{requestLine.getItem().isHasSize(), requestLine.getItem().isHasColor()}) && ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{requestLine.getSpecificDimensions().getSize(), requestLine.getSpecificDimensions().getColor()})) {
                    POSItem item = POSPersister.findByID(POSItem.class, requestLine.getItem().getId());
                    for (POSSizesAndColors szcLine : item.getSizesAndColors()) {
                        if (!ObjectChecker.areEqual((Object)requestLine.getSpecificDimensions().getSize(), (Object)szcLine.getSize()) || !ObjectChecker.areEqual((Object)requestLine.getSpecificDimensions().getColor(), (Object)szcLine.getColor()) || !ObjectChecker.isNotEmptyOrZero((BigDecimal)szcLine.getDefaultPrice())) continue;
                        pricePair = new SimpleEntry((Object)szcLine.getDefaultPrice(), (Object)szcLine.getDefaultPrice());
                        defaultPrice = szcLine.getDefaultPrice();
                        break;
                    }
                }
            }
            if ((priceListDefaultPrice = itemPriceReq.getPriceListDefaultPrice()) == null) {
                priceListDefaultPrice = PriceListDefaultPrice.DefaultPrice;
            }
            switch (priceListDefaultPrice) {
                case DefaultPrice: {
                    defaultPrice = priceRes.getDefaultPrice();
                    break;
                }
                case MinPrice: {
                    defaultPrice = pricePair != null ? (BigDecimal)pricePair.getKey() : BigDecimal.ZERO;
                    break;
                }
                case MaxPrice: {
                    defaultPrice = pricePair != null ? (BigDecimal)pricePair.getValue() : BigDecimal.ZERO;
                    break;
                }
                case N1: {
                    defaultPrice = n1;
                    break;
                }
                case N2: {
                    defaultPrice = n2;
                    break;
                }
                case N3: {
                    defaultPrice = n3;
                    break;
                }
                case N4: {
                    defaultPrice = n4;
                    break;
                }
                case N5: {
                    defaultPrice = n5;
                    break;
                }
                case CustomPrice: {
                    defaultPrice = customPrice;
                }
            }
            resultLine.setDefaultPrice(defaultPrice);
            resultLine.setCustomPrice(customPrice);
            resultLine.setN1(n1);
            resultLine.setN2(n2);
            resultLine.setN3(n3);
            resultLine.setN4(n4);
            resultLine.setN5(n5);
            if (requestLine.getFree().booleanValue()) {
                BigDecimal bigDecimal = POSSalesPriceUtil.calculateReplacedItemPrice(itemPriceReq, i, requestLine, defaultPrice, null);
                pricePair = new SimpleEntry((Object)bigDecimal, (Object)bigDecimal);
                useDiscounts = false;
            }
            BigDecimal bigDecimal = requestLine.getCurrentPrice();
            if (pricePair != null) {
                void var21_21;
                resultLine.setMinPrice((BigDecimal)pricePair.getKey());
                resultLine.setMaxPrice((BigDecimal)pricePair.getValue());
                if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getIgnoreCurrentPriceWhenCalculatingPrices()) || ObjectChecker.isEmptyOrZero((BigDecimal)bigDecimal)) {
                    BigDecimal bigDecimal2 = defaultPrice;
                }
                resultLine.setPrice(POSSalesPriceUtil.determineAppropriatePrice((BigDecimal)var21_21, (BigDecimal)pricePair.getKey(), (BigDecimal)pricePair.getValue()));
            } else {
                if (ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getForcePriceList()) && itemPriceReq.getForcePriceList().booleanValue()) {
                    resultLine.setPrice(BigDecimal.valueOf(-1L));
                    priceResult.getDetails().add(resultLine);
                    continue;
                }
                resultLine.setPrice(bigDecimal);
            }
            resultLine.setId(requestLine.getId());
            DiscountCalculator calculator = new DiscountCalculator(itemPriceReq, i, resultLine.getPrice(), useDiscounts);
            calculators.add(calculator);
            calculator.calculateDiscountsBeforeHeader(taxConfiguration);
            if (!itemPriceReq.isPriceOnly()) {
                resultLine.setDiscounts(calculator.discounts);
            }
            total = total.add(calculator.currentPrice.multiply(itemPriceReq.getDetails().get(i).getQty()));
            priceResult.getDetails().add(resultLine);
            ++i;
        }
        POSSalesHeaderDiscountResp discountPercent = POSSalesPriceUtil.calculateHeaderDicount(itemPriceReq, total, total);
        BigDecimal userPer = itemPriceReq.getHeaderPercent();
        BigDecimal headerDiscount = POSSalesPriceUtil.determineAppropiatDiscount(userPer, discountPercent.getMinDiscountPercent(), discountPercent.getMinDiscountPercent(), discountPercent.getMaxDiscountPercent());
        priceResult.setHeaderDiscount(headerDiscount);
        priceResult.setMaxHeaderDiscount(discountPercent.getMaxDiscountPercent());
        priceResult.setMinHeaderDiscount(discountPercent.getMinDiscountPercent());
        i = 0;
        for (POSSalesPriceReqDetail detail : itemPriceReq.getDetails()) {
            POSItemSalesPriceResDetail resDetail = priceResult.getDetails().get(i);
            if (resDetail.getPrice().compareTo(BigDecimal.ZERO) < 0) continue;
            if (!detail.getFree().booleanValue() && ObjectChecker.areNotEqual((Object)((Object)itemPriceReq.getRequestType()), (Object)((Object)POSSalesPriceReqType.RelatedItemPrice)) && !itemPriceReq.isPriceOnly()) {
                resDetail.setFreeItems(POSSalesPriceUtil.calculateFreeItems(itemPriceReq, i));
            }
            ++i;
        }
        return priceResult;
    }

    public static POSSalesHeaderDiscountResp calculateHeaderDicount(POSItemSalesPriceReq itemPriceReq, BigDecimal total, BigDecimal valueToCalcFrom) {
        if (ObjectChecker.isFalse((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getActivateInvDiscountCalculationFromOffers())) {
            return new POSSalesHeaderDiscountResp(BigDecimal.ZERO, BigDecimal.ZERO, false, false);
        }
        List<POSInvoiceDiscountLine> lines = POSSalesPriceUtil.createHeaderDiscountsListCriteria(itemPriceReq, valueToCalcFrom);
        POSSalesPriceUtil.removeUnUsedLines(lines);
        Collections.sort(lines, new Comparator<POSInvoiceDiscountLine>(){

            @Override
            public int compare(POSInvoiceDiscountLine o1, POSInvoiceDiscountLine o2) {
                return this.weightOfLine(o1).compareTo(this.weightOfLine(o2));
            }

            protected String weightOfLine(POSInvoiceDiscountLine o1) {
                Object ret = "";
                ret = (String)ret + ServerStringUtils.leftPad((Long)o1.getPriority(), (Integer)10);
                ret = (String)ret + ServerStringUtils.leftPad((Integer)o1.getLineNumber(), (Integer)5);
                return ret;
            }
        });
        BigDecimal currentMinValue = total;
        BigDecimal currentMaxValue = total;
        for (POSInvoiceDiscountLine sysLine : lines) {
            BigDecimal invoiceValue = ObjectChecker.toZeroIfNull((BigDecimal)sysLine.getMinInvoiceValue());
            BigDecimal minDiscountValue = ObjectChecker.toZeroIfNull((BigDecimal)sysLine.getDiscountMinValue());
            BigDecimal maxDiscountValue = ObjectChecker.toZeroIfNull((BigDecimal)sysLine.getDiscountMaxValue());
            if (ObjectChecker.areEqual((Object)sysLine.getDiscountType(), (Object)InvoiceOfferDiscountType.Percentage)) {
                minDiscountValue = NaMaMath.calcPercentageValue((BigDecimal)total, (BigDecimal)minDiscountValue, (Integer)POSMoneyUtils.fractionalDecimalPlaces);
                maxDiscountValue = NaMaMath.calcPercentageValue((BigDecimal)total, (BigDecimal)maxDiscountValue, (Integer)POSMoneyUtils.fractionalDecimalPlaces);
            }
            if (ObjectChecker.areEqual((Object)sysLine.getDiscountType(), (Object)InvoiceOfferDiscountType.ValueMultiple)) {
                int times = valueToCalcFrom.divide(invoiceValue, 1).intValue();
                minDiscountValue = minDiscountValue.multiply(BigDecimal.valueOf(times));
                maxDiscountValue = maxDiscountValue.multiply(BigDecimal.valueOf(times));
            }
            currentMinValue = currentMinValue.subtract(minDiscountValue);
            currentMaxValue = currentMaxValue.subtract(maxDiscountValue);
        }
        BigDecimal minDiscountPercent = NaMaMath.calcPercentage((BigDecimal)total, (BigDecimal)total.subtract(currentMinValue), (Integer)POSMoneyUtils.getPercentageScale());
        BigDecimal maxDiscountPercent = NaMaMath.calcPercentage((BigDecimal)total, (BigDecimal)total.subtract(currentMaxValue), (Integer)POSMoneyUtils.getPercentageScale());
        Boolean ignoreOtherOffers = lines.stream().anyMatch(l -> ObjectChecker.isTrue((Boolean)l.getIgnoreOtherOffers()));
        Boolean stopOtherDiscounts = lines.stream().anyMatch(l -> ObjectChecker.isTrue((Boolean)l.getStopOtherDiscounts()));
        return new POSSalesHeaderDiscountResp(minDiscountPercent, maxDiscountPercent, ignoreOtherOffers, stopOtherDiscounts);
    }

    private static List<POSInvoiceDiscountLine> createHeaderDiscountsListCriteria(POSItemSalesPriceReq itemPriceReq, BigDecimal total) {
        String criteria = " where fromDate <= :date and toDate >= :date and minInvoiceValue <= :total and (targetId is null or targetId = :customerId or targetId = :customerClassId or targetId = :customerCategId)and (invoiceClassification is null or invoiceClassification = :invClassification)";
        criteria = POSSalesPriceUtil.addPriceClassifiersToCriteria(criteria);
        HashMap<String, Object> params = POSPersister.params("date", itemPriceReq.getValueDate(), "total", total, "customerId", ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer()) ? itemPriceReq.getCustomer().getId() : null, "customerClassId", ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer()) && ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer().getCustomerClass()) ? itemPriceReq.getCustomer().getCustomerClass().getId() : null, "customerCategId", itemPriceReq.customerCategoryId(), "invClassification", itemPriceReq.getInvoiceClassification());
        POSSalesPriceUtil.addPriceClassifiersToParams(itemPriceReq, params);
        criteria = POSSalesPriceUtil.addSubsidiaryToCriteriaAndParams(criteria, itemPriceReq, params);
        List<POSInvoiceDiscountLine> lines = POSPersister.listAll(POSInvoiceDiscountLine.class, criteria, params, "priority");
        POSSalesPriceUtil.filterByDimensions(lines);
        return lines;
    }

    private static BigDecimal calcualteTotalBeforeHeader(POSItemSalesPriceReq itemPriceReq) {
        if (ObjectChecker.areEqual((Object)((Object)itemPriceReq.getRequestType()), (Object)SalesPriceReqType.All)) {
            return BigDecimal.ZERO;
        }
        DiscountLocation headerLocation = DiscountCalculator.getHeaderDiscountLocation();
        if (ObjectChecker.areEqual((Object)headerLocation, (Object)DiscountLocation.Discount1)) {
            return ObjectChecker.toZeroIfNull((BigDecimal)itemPriceReq.getAfterDiscount1());
        }
        if (ObjectChecker.areEqual((Object)headerLocation, (Object)DiscountLocation.Discount2)) {
            return ObjectChecker.toZeroIfNull((BigDecimal)itemPriceReq.getAfterDiscount2());
        }
        if (ObjectChecker.areEqual((Object)headerLocation, (Object)DiscountLocation.Discount3)) {
            return ObjectChecker.toZeroIfNull((BigDecimal)itemPriceReq.getAfterDiscount3());
        }
        if (ObjectChecker.areEqual((Object)headerLocation, (Object)DiscountLocation.Discount4)) {
            return ObjectChecker.toZeroIfNull((BigDecimal)itemPriceReq.getAfterDiscount4());
        }
        if (ObjectChecker.areEqual((Object)headerLocation, (Object)DiscountLocation.Discount5)) {
            return ObjectChecker.toZeroIfNull((BigDecimal)itemPriceReq.getAfterDiscount5());
        }
        if (ObjectChecker.areEqual((Object)headerLocation, (Object)DiscountLocation.Discount6)) {
            return ObjectChecker.toZeroIfNull((BigDecimal)itemPriceReq.getAfterDiscount6());
        }
        if (ObjectChecker.areEqual((Object)headerLocation, (Object)DiscountLocation.Discount7)) {
            return ObjectChecker.toZeroIfNull((BigDecimal)itemPriceReq.getAfterDiscount7());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal determineAppropiatDiscount(BigDecimal currentValue, BigDecimal defaultValue, BigDecimal minValue, BigDecimal maxValue) {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)defaultValue)) {
            defaultValue = minValue;
        }
        if (ObjectChecker.isEmptyOrZero((BigDecimal)currentValue)) {
            return ObjectChecker.toZeroIfNull((BigDecimal)defaultValue);
        }
        if (currentValue.compareTo(minValue) < 0 || currentValue.compareTo(maxValue) > 0) {
            return defaultValue;
        }
        return currentValue;
    }

    public static <PriceSearcher extends POSSalesPriceSearcher> POSSalesPriceResult searchForPrice(POSItemSalesPriceReq itemPriceReq, int i, POSSalesPriceReqDetail requestLine, SimpleEntry<BigDecimal, BigDecimal> pricePair, BigDecimal defaultPrice, Boolean useDiscounts, BigDecimal customPrice, BigDecimal n1, BigDecimal n2, BigDecimal n3, BigDecimal n4, BigDecimal n5) {
        ArrayList searchers = new ArrayList<PriceSearcher>(){
            {
                this.add(new POSSalesPriceFromListSearcher());
                this.add(new POSSalesPriceFromUnitsSearcher());
            }
        };
        Collections.sort(searchers, Comparator.comparingInt(POSSalesPriceSearcher::order));
        POSSalesPriceResult salesPriceResult = new POSSalesPriceResult();
        salesPriceResult.setPricePair(pricePair);
        salesPriceResult.setDefaultPrice(defaultPrice);
        salesPriceResult.setCustomPrice(customPrice);
        salesPriceResult.setN1(n1);
        salesPriceResult.setN2(n2);
        salesPriceResult.setN3(n3);
        salesPriceResult.setN4(n4);
        salesPriceResult.setN5(n5);
        salesPriceResult.setUseDiscounts(useDiscounts);
        for (POSSalesPriceSearcher searcher : searchers) {
            salesPriceResult = searcher.search(itemPriceReq, i, requestLine, salesPriceResult);
        }
        return salesPriceResult;
    }

    public static POSSalesPriceResult searchInItemUnitsGrid(POSItemSalesPriceReq itemPriceReq, int i, POSSalesPriceReqDetail requestLine, POSSalesPriceResult priceResult) {
        if (priceResult.getPricePair() != null) {
            return priceResult;
        }
        POSItemUnit firstUnitWithPrice = null;
        POSItem item = requestLine.getItem();
        item = POSPersister.findByID(POSItem.class, item.getId().toString());
        List<POSItemUnit> units = item.getUnits();
        units.removeIf(Objects::isNull);
        for (POSItemUnit itemUOMLine : units) {
            if (firstUnitWithPrice == null && ObjectChecker.isNotEmptyOrZero((BigDecimal)itemUOMLine.getDefaultPrice())) {
                firstUnitWithPrice = itemUOMLine;
            }
            if (!ObjectChecker.areEqual((Object)itemUOMLine.getUnit(), (Object)requestLine.getUom()) || !ObjectChecker.isNotEmptyOrZero((BigDecimal)itemUOMLine.getDefaultPrice())) continue;
            priceResult.setPricePair((SimpleEntry<BigDecimal, BigDecimal>)new SimpleEntry((Object)itemUOMLine.getMinPrice(), (Object)NaMaMath.getMax((BigDecimal)itemUOMLine.getDefaultPrice(), (BigDecimal)itemUOMLine.getMaxPrice())));
            priceResult.setDefaultPrice(NaMaMath.round((BigDecimal)itemUOMLine.getDefaultPrice(), (Integer)itemPriceReq.getFractionalDecimalPlaces()));
            break;
        }
        if (priceResult.getPricePair() == null && firstUnitWithPrice != null) {
            BigDecimal price = firstUnitWithPrice.getDefaultPrice();
            BigDecimal priceFactor = POSSalesPriceUtil.findUOMPriceFactor(item, requestLine.getUom(), firstUnitWithPrice.getUnit());
            price = NaMaMath.round((BigDecimal)price.multiply(priceFactor), (Integer)itemPriceReq.getFractionalDecimalPlaces());
            priceResult.setPricePair((SimpleEntry<BigDecimal, BigDecimal>)new SimpleEntry((Object)price, (Object)price));
            priceResult.setDefaultPrice(price);
        }
        return priceResult;
    }

    public static POSSalesPriceResult searchInPriceLists(POSItemSalesPriceReq itemPriceReq, int i, POSSalesPriceReqDetail requestLine, POSSalesPriceResult priceResult) {
        POSItem item;
        if (priceResult.getPricePair() != null) {
            return priceResult;
        }
        POSSalesPriceListLine line = POSSalesPriceUtil.calculateUnitPrice(itemPriceReq, i);
        if (line != null && ObjectChecker.isNotEmptyOrNull((Object)(item = POSPersister.findByID(POSItem.class, ServerStringUtils.toUUIDStr((Object)line.getItemID()))))) {
            BigDecimal linePriceFactor = POSSalesPriceUtil.findUOMPriceFactor(item, requestLine.getUom(), line.getQty().getUom());
            priceResult.setPricePair((SimpleEntry<BigDecimal, BigDecimal>)new SimpleEntry((Object)NaMaMath.round((BigDecimal)line.getMinPrice().multiply(linePriceFactor), (Integer)itemPriceReq.getFractionalDecimalPlaces()), (Object)NaMaMath.round((BigDecimal)line.getMaxPrice().multiply(linePriceFactor), (Integer)itemPriceReq.getFractionalDecimalPlaces())));
            Function<BigDecimal, BigDecimal> fixer = v -> POSSalesPriceUtil.factorAndRoundPricePart(v, linePriceFactor, itemPriceReq.getFractionalDecimalPlaces());
            priceResult.setDefaultPrice(fixer.apply(line.getDefaultPrice()));
            priceResult.setCustomPrice(fixer.apply(line.getCustomPrice()));
            priceResult.setN1(fixer.apply(line.getN1()));
            priceResult.setN2(fixer.apply(line.getN2()));
            priceResult.setN3(fixer.apply(line.getN3()));
            priceResult.setN4(fixer.apply(line.getN4()));
            priceResult.setN5(fixer.apply(line.getN5()));
            priceResult.setUseDiscounts(line.getStopDiscounts() == false);
            priceResult.setPriceListLineID(line.getId());
        }
        return priceResult;
    }

    private static BigDecimal factorAndRoundPricePart(BigDecimal value, BigDecimal linePriceFactor, Integer fractionalDecimalPlaces) {
        value = ObjectChecker.toZeroIfNull((BigDecimal)value).multiply(linePriceFactor);
        return NaMaMath.round((BigDecimal)value, (Integer)fractionalDecimalPlaces);
    }

    private static HashMap<DiscountLocation, List<POSItemDiscountLine>> readDiscountLines(boolean useDiscounts, POSSalesPriceReqDetail requestLine, POSItemSalesPriceReq itemPriceReq, BigDecimal currentPrice) {
        HashMap<DiscountLocation, List<POSItemDiscountLine>> discountsMap = new HashMap<DiscountLocation, List<POSItemDiscountLine>>();
        if (!useDiscounts) {
            return discountsMap;
        }
        List<POSItemDiscountLine> lines = POSSalesPriceUtil.createItemsDiscountsCriteria(requestLine, itemPriceReq);
        POSSalesPriceUtil.filterDiscountLinesInMemory(requestLine, itemPriceReq, lines);
        lines = POSSalesPriceUtil.filterLinesByValueRanges(lines, requestLine, currentPrice, itemPriceReq.getInvoiceTotal());
        lines.sort(Comparator.comparing(POSSalesPriceUtil::weightOfLine));
        discountsMap.put(DiscountLocation.Discount1, new ArrayList());
        discountsMap.put(DiscountLocation.Discount2, new ArrayList());
        discountsMap.put(DiscountLocation.Discount3, new ArrayList());
        discountsMap.put(DiscountLocation.Discount4, new ArrayList());
        discountsMap.put(DiscountLocation.Discount5, new ArrayList());
        discountsMap.put(DiscountLocation.Discount6, new ArrayList());
        discountsMap.put(DiscountLocation.Discount7, new ArrayList());
        discountsMap.put(DiscountLocation.Discount8, new ArrayList());
        for (POSItemDiscountLine sysLine : lines) {
            discountsMap.get(DiscountLocation.valueOf((String)sysLine.getDiscountLocation())).add(sysLine);
        }
        return discountsMap;
    }

    public static boolean isAnyDiscountApplicableOnLine(List<POSItemDiscountLine> discountlines, AbsPOSSalesLine l) {
        discountlines = discountlines.stream().filter(d -> d.getItem() == null || ObjectChecker.areEqual((Object)d.getItem(), (Object)l.getItem())).collect(Collectors.toList());
        POSSalesPriceUtil.filterMatchesByQty(l.getItem(), l.getQty().getValue(), discountlines, l.getQty().getUom());
        POSSalesPriceUtil.removeMismatchedItemDimenions(discountlines, l.getItemDimensions());
        discountlines.removeIf(d -> POSSalesPriceUtil.shouldNotApplyDiscountOnApplyOnItems(d, l.getItem(), null, null));
        POSSalesPriceUtil.removeUnUsedLines(discountlines);
        POSSalesPriceUtil.removeMismatchedItemClasses(discountlines, l.getItem());
        return !discountlines.isEmpty();
    }

    private static void filterDiscountLinesInMemory(POSSalesPriceReqDetail requestLine, POSItemSalesPriceReq itemPriceReq, List<POSItemDiscountLine> lines) {
        POSSalesPriceUtil.filterMatchesByQty(requestLine.getItem(), requestLine.getQty(), lines, requestLine.getUom());
        POSSalesPriceUtil.removeMismatchedItemDimenions(lines, requestLine.getSpecificDimensions());
        POSSalesPriceUtil.filterByDimensions(lines);
        POSSalesPriceUtil.filterByApplyOnAndApplyOnlyIfItemInInvoice(lines, itemPriceReq, requestLine);
        POSSalesPriceUtil.removeUnUsedLines(lines);
        POSSalesPriceUtil.removeMismatchedItemClasses(lines, requestLine.getItem());
    }

    private static void filterByApplyOnAndApplyOnlyIfItemInInvoice(List<? extends AbsSCPriceListSysLine> lines, POSItemSalesPriceReq req, POSSalesPriceReqDetail requestLine) {
        if (ObjectChecker.isEmptyOrNull(req.getItems())) {
            return;
        }
        for (int i = lines.size() - 1; i >= 0; --i) {
            AbsSCPriceListSysLine discountLine = lines.get(i);
            if (POSSalesPriceUtil.shouldNotApplyDiscountOnApplyOnItems(discountLine, requestLine.getItem(), req, requestLine)) {
                lines.remove(i);
                continue;
            }
            if (!POSSalesPriceUtil.shouldNotApplyDiscountOnApplyOnlyIfItemInInvoice(discountLine, req)) continue;
            lines.remove(i);
        }
    }

    private static boolean shouldNotApplyDiscountOnApplyOnlyIfItemInInvoice(AbsSCPriceListSysLine discountLine, POSItemSalesPriceReq req) {
        if (discountLine.getApplyOnlyIfItemInInvoice() == null) {
            return false;
        }
        List<UUID> groupItemIds = discountLine.getApplyOnlyIfItemInInvoice().getDetails().stream().map(l -> l.getItem().getId()).toList();
        return !req.getItems().containsAll(groupItemIds);
    }

    private static boolean shouldNotApplyDiscountOnApplyOnItems(AbsSCPriceListSysLine discountLine, POSItem item, POSItemSalesPriceReq req, POSSalesPriceReqDetail requestLine) {
        POSEntityRefData applyOnItems = discountLine.getApplyOnItems();
        if (ObjectChecker.isEmptyOrNull((Object)applyOnItems)) {
            return false;
        }
        POSMasterFile<?> pOSMasterFile = applyOnItems.toReal();
        if (pOSMasterFile instanceof POSFreeItemGroup) {
            POSFreeItemGroup itemGroup = (POSFreeItemGroup)pOSMasterFile;
            return itemGroup.getDetails().stream().noneMatch(l -> ObjectChecker.areEqual((Object)l.getItem(), (Object)item));
        }
        pOSMasterFile = applyOnItems.toReal();
        if (pOSMasterFile instanceof POSPricingRange) {
            POSPricingRange pricingRange = (POSPricingRange)pOSMasterFile;
            return POSSalesPriceUtil.shouldNotApplyDiscountOnPricingRange(pricingRange, requestLine, req);
        }
        return false;
    }

    private static boolean shouldNotApplyDiscountOnPricingRange(POSPricingRange pricingRange, POSSalesPriceReqDetail requestLine, POSItemSalesPriceReq req) {
        if (ObjectChecker.isEmptyOrNull((Object)pricingRange)) {
            return false;
        }
        if (ObjectChecker.isNotEmptyOrNull(pricingRange.getIncludedItems()) && pricingRange.getIncludedItems().stream().noneMatch(l -> l.applicableLine(requestLine))) {
            return true;
        }
        if (pricingRange.getExcludedItems().stream().anyMatch(l -> l.applicableLine(requestLine))) {
            return true;
        }
        if (ObjectChecker.isNotEmptyOrNull(pricingRange.getIncludedInvoices()) && pricingRange.getIncludedInvoices().stream().noneMatch(l -> l.applicableLine(req))) {
            return true;
        }
        return pricingRange.getExcludedInvoices().stream().anyMatch(l -> l.applicableLine(req));
    }

    private static List<POSItemDiscountLine> filterLinesByValueRanges(List<POSItemDiscountLine> lines, POSSalesPriceReqDetail reqLine, BigDecimal currentPrice, BigDecimal invoiceTotal) {
        BigDecimal lineTotal = ObjectChecker.toZeroIfNull((BigDecimal)currentPrice).multiply(ObjectChecker.toZeroIfNull((BigDecimal)reqLine.getQty()));
        BigDecimal invoiceTotal_ = NaMaMath.add((BigDecimal[])new BigDecimal[]{invoiceTotal, lineTotal});
        return lines.stream().filter(l -> NaMaMath.betweenExcludingUpper((BigDecimal)lineTotal, (BigDecimal)ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{l.getMinItemValueToApplyDiscount(), BigDecimal.valueOf(Long.MIN_VALUE)}), (BigDecimal)ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{l.getMaxItemValueToApplyDiscount(), BigDecimal.valueOf(Long.MAX_VALUE)}))).filter(l -> NaMaMath.betweenExcludingUpper((BigDecimal)invoiceTotal_, (BigDecimal)ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{l.getMinInvValueToApplyDiscount(), BigDecimal.valueOf(Long.MIN_VALUE)}), (BigDecimal)ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{l.getMaxInvValueToApplyDiscount(), BigDecimal.valueOf(Long.MAX_VALUE)}))).collect(Collectors.toList());
    }

    private static void removeMismatchedItemClasses(List<? extends IHasPOSItemClasses> lines, POSItem item) {
        for (int i = lines.size() - 1; i >= 0; --i) {
            IHasPOSItemClasses line = lines.get(i);
            if (!ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{POSSalesPriceUtil.differentItemClass(line.getItemClass1(), item.fetchClass1Id()), POSSalesPriceUtil.differentItemClass(line.getItemClass2(), item.fetchClass2Id()), POSSalesPriceUtil.differentItemClass(line.getItemClass3(), item.fetchClass3Id()), POSSalesPriceUtil.differentItemClass(line.getItemClass4(), item.fetchClass4Id()), POSSalesPriceUtil.differentItemClass(line.getItemClass5(), item.fetchClass5Id()), POSSalesPriceUtil.differentItemClass(line.getItemClass6(), item.fetchClass6Id()), POSSalesPriceUtil.differentItemClass(line.getItemClass7(), item.fetchClass7Id()), POSSalesPriceUtil.differentItemClass(line.getItemClass8(), item.fetchClass8Id()), POSSalesPriceUtil.differentItemClass(line.getItemClass9(), item.fetchClass9Id()), POSSalesPriceUtil.differentItemClass(line.getItemClass10(), item.fetchClass10Id())})) continue;
            lines.remove(i);
        }
    }

    private static boolean differentItemClass(POSMasterFile lineClass, UUID itemClassId) {
        return ObjectChecker.isNotEmptyOrNull((Object)lineClass) && ObjectChecker.areNotEqual((Object)lineClass.getId(), (Object)itemClassId);
    }

    private static void removeUnUsedLines(List<? extends IPOSOfferSysLine> lines) {
        if (ObjectChecker.isEmptyOrNull(lines)) {
            return;
        }
        int firstUnusedIndex = POSSalesPriceUtil.calcFirstUnUsedDiscountIndex(lines);
        if (firstUnusedIndex < 0) {
            lines = new ArrayList<IPOSOfferSysLine>();
        }
        for (int i = lines.size() - 1; i >= firstUnusedIndex; --i) {
            if (ObjectChecker.isTrue((Boolean)lines.get(firstUnusedIndex).getStopOtherDiscounts())) {
                lines.remove(i);
                continue;
            }
            if (!ObjectChecker.areEqual((Object)lines.get(i).fetchDiscountLocation(), (Object)lines.get(firstUnusedIndex).fetchDiscountLocation())) continue;
            lines.remove(i);
        }
    }

    private static int calcFirstUnUsedDiscountIndex(List<? extends IPOSOfferSysLine> lines) {
        boolean stopFound = false;
        UUID refId = null;
        for (int i = 0; i < lines.size(); ++i) {
            if (!stopFound && ObjectChecker.isTrue((Boolean)lines.get(i).getStopOtherDiscounts()) || ObjectChecker.isTrue((Boolean)lines.get(i).fetchStopSameTypeOtherDiscounts())) {
                stopFound = true;
                refId = lines.get(i).getRefId();
                continue;
            }
            if (!stopFound || !ObjectChecker.areNotEqual((Object)lines.get(i).getRefId(), (Object)refId)) continue;
            return i;
        }
        return lines.size();
    }

    protected static String weightOfLine(POSItemDiscountLine o1) {
        Object ret = "";
        if (ObjectChecker.areEqual((Object)DiscountLocation.Discount1, (Object)o1.getDiscountLocation())) {
            ret = (String)ret + "E";
        } else if (ObjectChecker.areEqual((Object)DiscountLocation.Discount2, (Object)o1.getDiscountLocation())) {
            ret = (String)ret + "M";
        }
        ret = o1.getSpecialDiscount() != false ? (String)ret + "5" : (String)ret + "3";
        ret = (String)ret + ServerStringUtils.leftPad((Long)o1.getPriority(), (Integer)10);
        ret = (String)ret + ServerStringUtils.leftPad((Integer)o1.getLineNumber(), (Integer)5);
        return ret;
    }

    private static List<POSItemDiscountLine> createItemsDiscountsCriteria(POSSalesPriceReqDetail requestLine, POSItemSalesPriceReq itemPriceReq) {
        POSItem item = requestLine.getItem();
        Object criteria = " where ( itemID is null or itemID = :item ) and (targetId is null or targetId = :customerId or targetId = :customerClassId or targetId = :customerCategId) and (invoiceClassification is null or invoiceClassification = :invClassification)  and fromDate <= :date and toDate >= :date and (category1 is null or category1 = :category1) and (fromTime is null or fromTime <= :time) and (toTime is null or toTime >= :time) and (category2 is null or category2 = :category2) and (category3 is null or category3 = :category3) and (category4 is null or category4 = :category4) and (category5 is null or category5 = :category5) and (brand is null or brand = :brand) and (discountLocation = :disc1 or discountLocation = :disc2 or discountLocation = :disc3 or discountLocation = :disc4 or discountLocation = :disc5 or discountLocation = :disc6 or discountLocation = :disc7 or discountLocation = :disc8)  ";
        criteria = (String)criteria + " and (section is null or section = :section)";
        criteria = POSSalesPriceUtil.addPriceClassifiersToCriteria((String)criteria);
        Date time = itemPriceReq.getValueDateTime();
        if (time == null) {
            time = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.set(1970, 0, 1, time.getHours(), time.getMinutes());
        time = c.getTime();
        HashMap<String, Object> params = POSPersister.params("item", item.getId(), "customerId", ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer()) ? itemPriceReq.getCustomer().getId() : null, "customerClassId", ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer()) && ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer().getCustomerClass()) ? itemPriceReq.getCustomer().getCustomerClass().getId() : null, "customerCategId", itemPriceReq.customerCategoryId(), "invClassification", itemPriceReq.getInvoiceClassification(), "date", itemPriceReq.getValueDate(), "time", time, "category1", item.fetchCategory1Proxy(), "category2", item.fetchCategory2Proxy(), "category3", item.fetchCategory3Proxy(), "category4", item.fetchCategory4Proxy(), "category5", item.fetchCategory5Proxy(), "brand", item.fetchBrandProxy(), "disc1", DiscountLocation.Discount1.toString(), "disc2", DiscountLocation.Discount2.toString(), "disc3", DiscountLocation.Discount3.toString(), "disc4", DiscountLocation.Discount4.toString(), "disc5", DiscountLocation.Discount5.toString(), "disc6", DiscountLocation.Discount6.toString(), "disc7", DiscountLocation.Discount7.toString(), "disc8", DiscountLocation.Discount8.toString(), "section", item.fetchItemSectionProxy());
        POSSalesPriceUtil.addPriceClassifiersToParams(itemPriceReq, params);
        criteria = POSSalesPriceUtil.addSubsidiaryToCriteriaAndParams((String)criteria, itemPriceReq, params);
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getMustMatchLineUomWithOfferUom())) {
            criteria = (String)criteria + " and qty.uom = :lineUom";
            params.put("lineUom", requestLine.getUom());
        }
        List<POSItemDiscountLine> lines = POSPersister.listAll(POSItemDiscountLine.class, (String)criteria, params, "priority");
        return lines;
    }

    public static BigDecimal findUOMPriceFactor(POSItem item, POSUnit requestUOMPrice, POSUnit fromUOMPrice) {
        BigDecimal factor = BigDecimal.ONE;
        item = POSPersister.findByID(POSItem.class, item.getId().toString());
        if (ObjectChecker.areNotEqual((Object)fromUOMPrice, (Object)requestUOMPrice) && ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{fromUOMPrice, requestUOMPrice})) {
            BigDecimal lineUniRateToBaseUOM = POSSalesPriceUtil.calcRateToBase(item.getUnits(), requestUOMPrice);
            BigDecimal priceUnitRateToUOM = POSSalesPriceUtil.calcRateToBase(item.getUnits(), fromUOMPrice);
            factor = NaMaMath.divide((BigDecimal)lineUniRateToBaseUOM, (BigDecimal)priceUnitRateToUOM, (Integer)10);
        }
        return factor;
    }

    public static BigDecimal calcRateToBase(List<POSItemUnit> units, POSUnit unit) {
        for (POSItemUnit posItemUnit : units) {
            if (!ObjectChecker.areEqual((Object)posItemUnit.getUnit(), (Object)unit)) continue;
            return posItemUnit.getReteToBase();
        }
        return BigDecimal.ONE;
    }

    private static BigDecimal determineAppropriatePrice(BigDecimal currentValue, BigDecimal minValue, BigDecimal maxValue) {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)currentValue)) {
            return ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{maxValue, minValue});
        }
        if (currentValue.compareTo(minValue) < 0) {
            return minValue;
        }
        if (currentValue.compareTo(maxValue) > 0) {
            return maxValue;
        }
        return currentValue;
    }

    private static POSItemSalesPriceRes calculateFreeItemsOnly(POSItemSalesPriceReq itemPriceReq, POSItemSalesPriceRes priceResult) {
        if (ObjectChecker.areEqual((Object)((Object)itemPriceReq.getRequestType()), (Object)((Object)POSSalesPriceReqType.GetFreeItems))) {
            List<POSItemSalesFreeItem> freeItems = POSSalesPriceUtil.calculateFreeItems(itemPriceReq, 0);
            POSItemSalesPriceResDetail result = new POSItemSalesPriceResDetail();
            result.setFreeItems(freeItems);
            priceResult.getDetails().add(result);
        } else if (ObjectChecker.areEqual((Object)((Object)itemPriceReq.getRequestType()), (Object)SalesPriceReqType.ReplaceFreeItems)) {
            SimpleEntry<BigDecimal, BigDecimal> qtyAndPrice = POSSalesPriceUtil.calculateGroupQtyAndPrice(itemPriceReq);
            if (qtyAndPrice != null && qtyAndPrice.getKey() != null) {
                priceResult.setQty((BigDecimal)qtyAndPrice.getKey());
                POSItemSalesPriceResDetail result = new POSItemSalesPriceResDetail();
                result.setPrice(BigDecimal.ZERO);
                priceResult.getDetails().add(result);
            } else {
                BigDecimal freePrice = null;
                if (qtyAndPrice != null && qtyAndPrice.getValue() != null) {
                    freePrice = (BigDecimal)qtyAndPrice.getValue();
                }
                BigDecimal replacingPrice = BigDecimal.ZERO;
                POSSalesPriceReqDetail itemPriceReqDetail = itemPriceReq.getDetails().get(0);
                POSSalesPriceListLine line = POSSalesPriceUtil.calculateUnitPrice(itemPriceReq, 0);
                if (line != null) {
                    replacingPrice = ObjectChecker.toZeroIfNull((BigDecimal)line.getDefaultPrice());
                }
                if (ObjectChecker.isEmptyOrNull((Object)replacingPrice)) {
                    return priceResult;
                }
                BigDecimal diffPrice = POSSalesPriceUtil.calculateReplacedItemPrice(itemPriceReq, 0, itemPriceReqDetail, replacingPrice, freePrice);
                POSItemSalesPriceResDetail result = new POSItemSalesPriceResDetail();
                result.setPrice(diffPrice);
                priceResult.getDetails().add(result);
            }
        }
        return priceResult;
    }

    private static SimpleEntry<BigDecimal, BigDecimal> calculateGroupQtyAndPrice(POSItemSalesPriceReq itemPriceReq) {
        POSSalesPriceReqDetail itemPriceReqDetail = itemPriceReq.getDetails().get(0);
        UUID freeId = itemPriceReqDetail.getFreeItemId();
        if (ObjectChecker.areNotEqual((Object)freeId, (Object)itemPriceReqDetail.getFreeItemGroupId())) {
            POSFreeItemGroup group = POSPersister.findByID(POSFreeItemGroup.class, itemPriceReqDetail.getFreeItemGroupId().toString());
            BigDecimal price = null;
            BigDecimal qty = null;
            if (ObjectChecker.areNotEqual((Object)group.getGroupPolicy(), (Object)"One")) {
                return null;
            }
            price = group.getStandardPrice();
            UUID newItemId = itemPriceReqDetail.getItem().getId();
            BigDecimal freeQty = BigDecimal.ONE;
            BigDecimal newQty = BigDecimal.ONE;
            boolean found = false;
            for (POSFreeGroupLine line : group.getDetails()) {
                if (ObjectChecker.areEqual((Object)line.getItem().getId(), (Object)freeId)) {
                    freeQty = line.getQty().getValue();
                }
                if (!ObjectChecker.areEqual((Object)line.getItem().getId(), (Object)newItemId)) continue;
                found = true;
                newQty = line.getQty().getValue();
            }
            if (ObjectChecker.isNotEmptyOrZero((BigDecimal)freeQty)) {
                price = price.divide(freeQty, 10);
            }
            if (!found) {
                return new SimpleEntry(qty, (Object)price);
            }
            BigDecimal originQty = itemPriceReqDetail.getFreeQty().divide(freeQty, 5);
            qty = originQty.multiply(newQty);
            return new SimpleEntry((Object)qty, (Object)price);
        }
        return null;
    }

    private static BigDecimal calculateReplacedItemPrice(POSItemSalesPriceReq itemPriceReq, int i, POSSalesPriceReqDetail requestLine, BigDecimal replacingItemPrice, BigDecimal freeItemPrice) {
        BigDecimal price = BigDecimal.ZERO;
        if (freeItemPrice == null) {
            POSItem freeItem = POSPersister.findByID(POSItem.class, requestLine.getFreeItemId());
            if (freeItem == null) {
                return price;
            }
            POSSalesPriceListLine freeLine = POSSalesPriceUtil.calculateUnitPrice(itemPriceReq, i, freeItem, requestLine.getFreeQty());
            if (freeLine != null) {
                freeItemPrice = ObjectChecker.toZeroIfNull((BigDecimal)freeLine.getDefaultPrice());
            }
        }
        freeItemPrice = ObjectChecker.toZeroIfNull((BigDecimal)freeItemPrice);
        freeItemPrice = freeItemPrice.multiply(requestLine.getFreeQty());
        BigDecimal otherItemPrice = ObjectChecker.toZeroIfNull((BigDecimal)replacingItemPrice).multiply(requestLine.getQty());
        BigDecimal diff = otherItemPrice.subtract(freeItemPrice);
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)(diff = ObjectChecker.toZeroIfNigative((BigDecimal)diff)))) {
            price = diff.divide(requestLine.getQty(), requestLine.getUom().getFractionDecimalPlaces());
        }
        return price;
    }

    private static List<POSItemSalesFreeItem> calculateFreeItems(POSItemSalesPriceReq itemPriceReq, int i) {
        List<?> lines;
        Object criteria = " where ( itemID is null or itemID = :item ) and (targetId is null or targetId = :customerId or targetId = :customerClassId or targetId = :customerCategId) and (invoiceClassification is null or invoiceClassification = :invClassification)  and fromDate <= :date and toDate >= :date and (category1 is null or category1 = :category1) and (category2 is null or category2 = :category2) and (category3 is null or category3 = :category3) and (category4 is null or category4 = :category4) and (category5 is null or category5 = :category5) and (brand is null or brand = :brand)";
        criteria = POSSalesPriceUtil.addPriceClassifiersToCriteria((String)criteria);
        POSItem item = itemPriceReq.getDetails().get(i).getItem();
        BigDecimal qty = itemPriceReq.getDetails().get(i).getQty();
        HashMap<String, Object> params = POSPersister.params("item", item.getId(), "customerId", ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer()) ? itemPriceReq.getCustomer().getId() : null, "customerClassId", ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer()) && ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer().getCustomerClass()) ? itemPriceReq.getCustomer().getCustomerClass().getId() : null, "customerCategId", itemPriceReq.customerCategoryId(), "invClassification", itemPriceReq.getInvoiceClassification(), "date", itemPriceReq.getValueDate(), "category1", item.fetchCategory1Proxy(), "category2", item.fetchCategory2Proxy(), "category3", item.fetchCategory3Proxy(), "category4", item.fetchCategory4Proxy(), "category5", item.fetchCategory5Proxy(), "brand", item.fetchBrandProxy());
        POSSalesPriceUtil.addPriceClassifiersToParams(itemPriceReq, params);
        criteria = POSSalesPriceUtil.addSubsidiaryToCriteriaAndParams((String)criteria, itemPriceReq, params);
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getMustMatchLineUomWithOfferUom())) {
            criteria = (String)criteria + " and qty.uom = :lineUom";
            params.put("lineUom", itemPriceReq.getDetails().get(i).getUom());
        }
        if (ObjectChecker.isNotEmptyOrNull(lines = POSPersister.listAll(POSFreeItemLine.class, (String)criteria, params, "freeItemData.manual"))) {
            POSSalesPriceUtil.filterByDimensions(lines);
            POSSalesPriceReqDetail reqLine = itemPriceReq.getDetails().get(i);
            POSSalesPriceUtil.filterMatchesByQty(item, qty, lines, reqLine.getUom());
            POSSalesPriceUtil.removeMismatchedItemDimenions(lines, reqLine.getSpecificDimensions());
            POSSalesPriceUtil.removeMismatchedItemClasses(lines, reqLine.getItem());
            POSSalesPriceUtil.makeFreeItemSameAsMainItemIfNeeded(reqLine, lines);
            List<POSItemSalesFreeItem> result = POSSalesPriceUtil.convertFreeOfferToResultFreeItems(reqLine.getQty(), lines, itemPriceReq.getItems(), itemPriceReq.getNetValues(), itemPriceReq, reqLine.getUom());
            for (POSItemSalesFreeItem freeItem : result) {
                if (ObjectChecker.isFalse((Boolean)freeItem.getDoNotCopyMasterItemData()) && ObjectChecker.areEqual((Object)item, (Object)freeItem.getItem())) {
                    freeItem.setItemCode(reqLine.getItemCode());
                }
                if (!ObjectChecker.isTrue((Boolean)freeItem.getDoNotCopyMasterItemData())) continue;
                freeItem.setEditableFreeLine(true);
            }
            POSSalesPriceUtil.fillSpecificDimensionsIfNeeded(reqLine, result);
            return result;
        }
        return new ArrayList<POSItemSalesFreeItem>();
    }

    private static void makeFreeItemSameAsMainItemIfNeeded(POSSalesPriceReqDetail reqLine, List<? extends IPOSFreeItemOfferLine> lines) {
        for (IPOSFreeItemOfferLine iPOSFreeItemOfferLine : lines) {
            if (iPOSFreeItemOfferLine.getFreeItemData().getFreeItem() != null || !ObjectChecker.isTrue((Boolean)iPOSFreeItemOfferLine.getFreeItemIsSameAsInvItem())) continue;
            iPOSFreeItemOfferLine.getFreeItemData().setFreeItem(reqLine.getItem());
        }
    }

    private static String addPriceClassifiersToCriteria(String criteria) {
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier1())) {
            criteria = (String)criteria + " and (priceClassifier1 is null or priceClassifier1 = :priceClassifier1) ";
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier2())) {
            criteria = (String)criteria + " and (priceClassifier2 is null or priceClassifier2 = :priceClassifier2) ";
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier3())) {
            criteria = (String)criteria + " and (priceClassifier3 is null or priceClassifier3 = :priceClassifier3) ";
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier4())) {
            criteria = (String)criteria + " and (priceClassifier4 is null or priceClassifier4 = :priceClassifier4) ";
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getUsePriceClassifier5())) {
            criteria = (String)criteria + " and (priceClassifier5 is null or priceClassifier5 = :priceClassifier5) ";
        }
        return criteria;
    }

    private static void removeMismatchedItemDimenions(List<? extends AbsSCPriceListSysLine> lines, POSItemSpecificDimensions specificDimensions) {
        for (int i = lines.size() - 1; i >= 0; --i) {
            AbsSCPriceListSysLine line = lines.get(i);
            if (POSSalesPriceUtil.areSpecificDimensionsMatched(line.getItemDimensions(), specificDimensions)) continue;
            lines.remove(i);
        }
    }

    private static <T extends IPOSFreeItemOfferLine> List<POSItemSalesFreeItem> convertFreeOfferToResultFreeItems(BigDecimal total, List<T> lines, List<UUID> ids, List<BigDecimal> values, POSItemSalesPriceReq itemPriceReq1, POSUnit uom) {
        ArrayList<POSItemSalesFreeItem> freeItems = new ArrayList<POSItemSalesFreeItem>();
        BigDecimal offerTotal = total;
        if (ObjectChecker.isEmptyOrNull(lines)) {
            return freeItems;
        }
        for (IPOSFreeItemOfferLine line : lines) {
            POSFreeItemData freeItemsData = line.getFreeItemData();
            ArrayList<SimpleEntry<POSItem, POSQuantity>> listOfLineFree = new ArrayList<SimpleEntry<POSItem, POSQuantity>>();
            HashMap<UUID, POSItemSpecificDimensions> specifcDimensions = new HashMap<UUID, POSItemSpecificDimensions>();
            Boolean execlusive = POSSalesPriceUtil.expandFreeItems(freeItemsData, listOfLineFree, specifcDimensions);
            for (SimpleEntry simpleEntry : listOfLineFree) {
                POSItemSalesFreeItem freeItem = new POSItemSalesFreeItem();
                freeItem.setItem((POSItem)simpleEntry.getKey());
                freeItem.setDoNotCopyMasterItemData(line.getDoNotCopyMasterItemData());
                freeItem.setManual(freeItemsData.getManual());
                freeItem.setQty(freeItemsData.getFreeQty().cloneData());
                BigDecimal calculatedQty = freeItem.getQty().getValue().multiply(((POSQuantity)simpleEntry.getValue()).getValue());
                BigDecimal perValue = line.fetchPerValue();
                freeItem.getQty().setValue(POSSalesPriceUtil.calculateFreeItemQty(freeItemsData, perValue, calculatedQty, offerTotal, itemPriceReq1.getFractionalDecimalPlaces()));
                if (ObjectChecker.isTrue((Boolean)line.getFreeItemIsSameAsInvItem())) {
                    freeItem.getQty().setUom(uom);
                } else {
                    freeItem.getQty().setUom(((POSQuantity)simpleEntry.getValue()).getUom());
                }
                freeItem.setRefId(line.getRefId());
                freeItem.setGroupId(ObjectChecker.isNotEmptyOrNull((Object)freeItemsData.getFreeItem()) ? freeItemsData.getFreeItem().getId() : null);
                if (ObjectChecker.isNotEmptyOrNull((Object)freeItemsData.getFreeGroup())) {
                    freeItem.setGroupId(freeItemsData.getFreeGroup().getId());
                }
                freeItem.setGroupExeclusive(execlusive);
                freeItem.setFreeOfferLineId(line.getId());
                POSItemSpecificDimensions itemDimensions = specifcDimensions.get(((POSItem)simpleEntry.getKey()).getId());
                if (itemDimensions != null) {
                    POSItemSpecificDimensions specificDimensions = new POSItemSpecificDimensions();
                    POSSalesPriceUtil.updateSizeAndColor(specificDimensions, itemDimensions, freeItem);
                    specificDimensions.setLotId(itemDimensions.getLotId());
                    specificDimensions.setRevisionId(itemDimensions.getRevisionId());
                    specificDimensions.setSerialNumber(itemDimensions.getSerialNumber());
                    freeItem.setSpecificDimensions(specificDimensions);
                }
                POSItemSalesPriceReq itemPriceReq = itemPriceReq1.cloneHeader();
                itemPriceReq.setDetails(CollectionsUtility.toList((Object[])new POSSalesPriceReqDetail[]{POSSalesPriceUtil.createReqLineFromFreeItem(freeItem)}));
                itemPriceReq.setItems(CollectionsUtility.toList((Object[])new UUID[]{freeItem.getItem().getId()}));
                itemPriceReq.setQtys(CollectionsUtility.toList((Object[])new BigDecimal[]{freeItem.getQty().getValue()}));
                itemPriceReq.setNetValues(CollectionsUtility.toList((Object[])new BigDecimal[]{BigDecimal.ZERO}));
                freeItem.setPriceRes(POSSalesPriceUtil.updateLinePriceAndDiscounts(itemPriceReq));
                freeItem.setNotFreeButDiscount(line.notFreeButDiscount());
                freeItem.setDiscLocation(line.discLocation());
                freeItem.setDiscountPercentage(line.discPercent());
                freeItems.add(freeItem);
            }
        }
        return freeItems;
    }

    private static void updateSizeAndColor(POSItemSpecificDimensions specificDimensions, POSItemSpecificDimensions itemDimensions, POSItemSalesFreeItem freeItem) {
        specificDimensions.setColor(itemDimensions.getColor());
        specificDimensions.setSize(itemDimensions.getSize());
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{itemDimensions.getColor(), itemDimensions.getSize()})) {
            return;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)itemDimensions.getColor())) {
            freeItem.getItem().getSizesAndColors().stream().filter(ObjectChecker.equalsPredicate((Object)itemDimensions.getColor(), POSSizesAndColors::getColor)).filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getColorName())).findFirst().ifPresent(sizesAndColors -> specificDimensions.setColorName(sizesAndColors.getColorName()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)itemDimensions.getSize())) {
            freeItem.getItem().getSizesAndColors().stream().filter(ObjectChecker.equalsPredicate((Object)itemDimensions.getSize(), POSSizesAndColors::getSize)).filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getSizeName())).findFirst().ifPresent(sizesAndColors -> specificDimensions.setSizeName(sizesAndColors.getSizeName()));
        }
        freeItem.getItem().getSizesAndColors().stream().filter(s -> ObjectChecker.areEqual((Object)s.getColor(), (Object)itemDimensions.getColor()) && ObjectChecker.areEqual((Object)s.getSize(), (Object)itemDimensions.getSize())).findFirst().ifPresent(sizesAndColors -> {
            freeItem.setItemCode(sizesAndColors.getCode());
            specificDimensions.setColorName((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{sizesAndColors.getColorName(), specificDimensions.getColorName()}));
            specificDimensions.setSizeName((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{sizesAndColors.getSizeName(), specificDimensions.getSizeName()}));
        });
    }

    private static POSSalesPriceReqDetail createReqLineFromFreeItem(POSItemSalesFreeItem freeItem) {
        POSSalesPriceReqDetail line = new POSSalesPriceReqDetail();
        line.setFree(true);
        line.setFreeItemGroupId(freeItem.getGroupId());
        line.setFreeItemId(freeItem.getItem().getId());
        line.setFreeQty(freeItem.getQty().getValue());
        line.setUom(freeItem.getQty().getUom());
        line.setQty(freeItem.getQty().getValue());
        line.setItem(freeItem.getItem());
        line.setSpecificDimensions(freeItem.getSpecificDimensions());
        return line;
    }

    private static BigDecimal calculateFreeItemQty(POSFreeItemData freeItemData, BigDecimal perQty, BigDecimal freeQty, BigDecimal totalValue, Integer fractionalDecimalPlaces) {
        if (ObjectChecker.areEqual((Object)freeItemData.getFreePolicy(), (Object)"Once")) {
            return freeQty;
        }
        BigDecimal thrshold = ObjectChecker.isEmptyOrZero((BigDecimal)perQty) ? BigDecimal.ONE : perQty;
        BigDecimal total = ObjectChecker.toZeroIfNull((BigDecimal)totalValue);
        int times = total.divide(thrshold, RoundingMode.DOWN).intValue();
        return NaMaMath.round((BigDecimal)freeQty.multiply(BigDecimal.valueOf(times)), (Integer)fractionalDecimalPlaces);
    }

    private static Boolean expandFreeItems(POSFreeItemData freeItemsData, List<SimpleEntry<POSItem, POSQuantity>> listOfLineFree, HashMap<UUID, POSItemSpecificDimensions> specifcDimensions) {
        POSItem freeItemRef = freeItemsData.getFreeItem();
        if (ObjectChecker.isNotEmptyOrNull((Object)freeItemRef)) {
            listOfLineFree.add((SimpleEntry<POSItem, POSQuantity>)new SimpleEntry((Object)freeItemRef, (Object)new POSQuantity(BigDecimal.ONE, freeItemsData.getFreeQty().getUom())));
            POSItemSpecificDimensions itemDimensions = new POSItemSpecificDimensions();
            itemDimensions = freeItemsData.getFreeItemDimensions();
            specifcDimensions.put(freeItemRef.getId(), itemDimensions);
            return false;
        }
        POSFreeItemGroup group = freeItemsData.getFreeGroup();
        group = POSPersister.findByID(POSFreeItemGroup.class, group.getId().toString());
        for (POSFreeGroupLine itemLine : group.getDetails()) {
            POSItem item = itemLine.getItem();
            POSQuantity rawQuantity = itemLine.getQty();
            listOfLineFree.add((SimpleEntry<POSItem, POSQuantity>)new SimpleEntry((Object)item, (Object)rawQuantity));
            POSItemSpecificDimensions itemDimensions = new POSItemSpecificDimensions();
            if (ObjectChecker.isNotEmptyOrNull((Object)itemLine.getDimensions())) {
                itemDimensions.setColor(itemLine.getDimensions().getColor());
                itemDimensions.setColorName(itemLine.getDimensions().getColorName());
                itemDimensions.setSize(itemLine.getDimensions().getSize());
                itemDimensions.setSizeName(itemLine.getDimensions().getSizeName());
                itemDimensions.setRevisionId(itemLine.getDimensions().getRevisionId());
                itemDimensions.setLotId(itemLine.getDimensions().getLotId());
                itemDimensions.setSerialNumber(itemLine.getDimensions().getSerialNumber());
            }
            specifcDimensions.put(item.getId(), itemDimensions);
        }
        return ObjectChecker.areEqual((Object)group.getGroupPolicy(), (Object)"One");
    }

    private static void fillSpecificDimensionsIfNeeded(POSSalesPriceReqDetail reqLine, List<POSItemSalesFreeItem> result) {
        for (POSItemSalesFreeItem freeItem : result) {
            POSItemSpecificDimensions masterDimensions;
            if (freeItem.getItem() == null || ObjectChecker.isTrue((Boolean)freeItem.getDoNotCopyMasterItemData())) continue;
            POSItemSpecificDimensions specificDimensions = freeItem.getSpecificDimensions();
            if (specificDimensions == null) {
                specificDimensions = new POSItemSpecificDimensions();
                freeItem.setSpecificDimensions(specificDimensions);
            }
            if ((masterDimensions = reqLine.getSpecificDimensions()) == null) {
                masterDimensions = new POSItemSpecificDimensions();
            }
            POSItem item = freeItem.getItem();
            POSSalesPriceUtil.fillSpecificDimensionsIfNeeded(specificDimensions, masterDimensions, item);
        }
    }

    public static void fillSpecificDimensionsIfNeeded(POSItemSpecificDimensions specificDimensions, POSItemSpecificDimensions masterDimensions, POSItem item) {
        item = POSPersister.findByID(POSItem.class, item.getId().toString());
        if (ObjectChecker.isEmptyOrNull((Object)specificDimensions.getRevisionId()) && ObjectChecker.isNotEmptyOrNull((Object)masterDimensions.getRevisionId()) && item.containsRevsision(masterDimensions.getRevisionId())) {
            specificDimensions.setRevisionId(masterDimensions.getRevisionId());
        }
        if (ObjectChecker.isEmptyOrNull((Object)specificDimensions.getColor()) && ObjectChecker.isNotEmptyOrNull((Object)masterDimensions.getColor()) && item.containsColor(masterDimensions.getColor())) {
            specificDimensions.setColor(masterDimensions.getColor());
            specificDimensions.setColorName(masterDimensions.getColorName());
        }
        if (ObjectChecker.isEmptyOrNull((Object)specificDimensions.getSize()) && ObjectChecker.isNotEmptyOrNull((Object)masterDimensions.getSize()) && item.containsSize(masterDimensions.getSize())) {
            specificDimensions.setSize(masterDimensions.getSize());
            specificDimensions.setSizeName(masterDimensions.getSizeName());
        }
    }

    private static POSSalesPriceListLine calculateUnitPrice(POSItemSalesPriceReq req, int index) {
        POSSalesPriceReqDetail line = req.getDetails().get(index);
        if (ObjectChecker.isEmptyOrNull((Object)line) || ObjectChecker.isEmptyOrNull((Object)line.getItem())) {
            return null;
        }
        BigDecimal qty = req.getDetails().get(index).getQty();
        POSItem item = req.getDetails().get(index).getItem();
        return POSSalesPriceUtil.calculateUnitPrice(req, index, item, qty);
    }

    public static POSItemSalesPriceReq createSalesPriceRequestHeader(List<BigDecimal> qtys, Date valueDate, POSInvoiceClassification invClassifition, POSSalesPriceReqType reqType, POSUser targetEmp, List<? extends AbsPOSSalesLine> lines, String disc, BigDecimal total, String net, AbsPOSSales salesDoc) {
        POSItemSalesPriceReq request = new POSItemSalesPriceReq();
        request.setInvoiceClassification(invClassifition);
        request.setDetails(new ArrayList<POSSalesPriceReqDetail>());
        request.setSubsidiaryType(salesDoc.getSubsidiaryNamaType());
        request.setSubsidiaryId(salesDoc.getSubsidiaryID());
        request.setCustomer(salesDoc.getCustomer());
        request.setPriceListDefaultPrice(PriceListDefaultPrice.valueOf((String)POSSalesPriceUtil.fetchPriceListDefaultPrice(salesDoc)));
        request.setFractionalDecimalPlaces(POSMoneyUtils.fractionalDecimalPlaces);
        request.setEmployee(targetEmp);
        request.setPriceClassifier1(salesDoc.getPriceClassifier1());
        request.setPriceClassifier2(salesDoc.getPriceClassifier2());
        request.setPriceClassifier3(salesDoc.getPriceClassifier3());
        request.setPriceClassifier4(salesDoc.getPriceClassifier4());
        request.setPriceClassifier5(salesDoc.getPriceClassifier5());
        if (ObjectChecker.isNotEmptyOrNull((Object)disc)) {
            request.setHeaderPercent(new BigDecimal(disc));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)net)) {
            request.setNetValue(new BigDecimal(net));
        }
        total = ObjectChecker.toZeroIfNull((BigDecimal)total);
        request.setTotalValue(total);
        request.setValueDate(valueDate);
        request.setValueDateTime(valueDate);
        ArrayList<UUID> items = new ArrayList<UUID>(salesDoc.fetchDetails().stream().map(l -> l.getItem().getId()).toList());
        request.setItems(items);
        request.setQtys(qtys);
        request.setRequestType(reqType);
        request.setEntityType(salesDoc.calcNamaEntityType());
        if (ObjectChecker.areEqual((Object)((Object)reqType), (Object)SalesPriceReqType.SingleLine)) {
            request.setFindRelatedItems(true);
        }
        for (AbsPOSSalesLine absPOSSalesLine : lines) {
            request.getDetails().add(POSSalesPriceUtil.createItemSalesPriceLine(absPOSSalesLine));
        }
        request.setInvoiceTotal(CollectionsUtility.totalize(lines, AbsPOSSalesLine::fetchLineTotalPrice));
        request.setGenericDims(salesDoc.getGenericDims());
        return request;
    }

    private static String fetchPriceListDefaultPrice(AbsPOSSales salesDoc) {
        ArrayList list = new ArrayList();
        list.add(salesDoc.getCustomer());
        if (salesDoc.getCustomer() != null) {
            list.add(salesDoc.getCustomer().getCustomerCategory());
            list.add(salesDoc.getCustomer().getCustomerClass());
        }
        if (salesDoc.getPosInvoiceClassification() != null) {
            list.add(salesDoc.getPosInvoiceClassification());
        }
        list.add(POSResourcesUtil.fetchMainRegister());
        list.add(POSResourcesUtil.fetchPOSConfig());
        list.add(POSResourcesUtil.fetchSupplyChainConfig());
        return list.stream().filter(ObjectChecker::isNotEmptyOrNull).map(IHasPriceListDefaultPrice::getPriceListDefaultPrice).filter(ObjectChecker::isNotEmptyOrNull).findFirst().orElse(PriceListDefaultPrice.DefaultPrice.name());
    }

    public static POSSalesPriceReqDetail createItemSalesPriceLine(AbsPOSSalesLine o) {
        POSSalesPriceReqDetail detailLine = new POSSalesPriceReqDetail();
        if (o == null) {
            o = new POSSalesInvoiceLine();
        }
        detailLine.setCurrentPrice(BigDecimal.ZERO);
        DTOPOSConfiguration posConfig = POSResourcesUtil.fetchPOSConfig();
        if (ObjectChecker.isFalseOrNull((Boolean)posConfig.getDoNotConsiderCurrentDiscount1ValuesWhenRecalculating())) {
            detailLine.setDiscount1Percent(o.getDiscount1().getPercentage());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)posConfig.getDoNotConsiderCurrentDiscount2ValuesWhenRecalculating())) {
            detailLine.setDiscount2Percent(o.getDiscount2().getPercentage());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)posConfig.getDoNotConsiderCurrentDiscount3ValuesWhenRecalculating())) {
            detailLine.setDiscount3Percent(o.getDiscount3().getPercentage());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)posConfig.getDoNotConsiderCurrentDiscount4ValuesWhenRecalculating())) {
            detailLine.setDiscount4Percent(o.getDiscount4().getPercentage());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)posConfig.getDoNotConsiderCurrentDiscount5ValuesWhenRecalculating())) {
            detailLine.setDiscount5Percent(o.getDiscount5().getPercentage());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)posConfig.getDoNotConsiderCurrentDiscount6ValuesWhenRecalculating())) {
            detailLine.setDiscount6Percent(o.getDiscount6().getPercentage());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)posConfig.getDoNotConsiderCurrentDiscount7ValuesWhenRecalculating())) {
            detailLine.setDiscount7Percent(o.getDiscount7().getPercentage());
        }
        if (ObjectChecker.isFalseOrNull((Boolean)posConfig.getDoNotConsiderCurrentDiscount8ValuesWhenRecalculating())) {
            detailLine.setDiscount8Percent(o.getDiscount8().getPercentage());
        }
        detailLine.setTax1Percent(o.getTax1().getPercentage());
        detailLine.setTax2Percent(o.getTax2().getPercentage());
        detailLine.setFree(o.getFreeLine());
        detailLine.setFreeItemId(o.getFreeItemId());
        detailLine.setFreeItemGroupId(o.getFreeGroupId());
        detailLine.setFreeQty(NaMaMath.absValue((BigDecimal)o.getQty().getValue()));
        detailLine.setItem(o.fetchItem());
        detailLine.setItemCode(o.getItemCode());
        detailLine.setQty(NaMaMath.absValue((BigDecimal)o.getQty().getValue()));
        detailLine.setUom(o.getQty().getUom());
        detailLine.setSpecificDimensions(o.getItemDimensions());
        detailLine.setId(o.getId());
        return detailLine;
    }

    public static List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> findLinesOfItemToGetFree(AbsPOSSales salesDocument) {
        ArrayList<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> toGetFreeLines = new ArrayList<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>>();
        HashMap<UUID, List<AbsPOSSalesLine>> offerLineWithSalesLines = POSSalesPriceUtil.fetchOffersForInvoice(salesDocument);
        ArrayList<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> mustBeOfferedLines = new ArrayList<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>>();
        for (Map.Entry<UUID, List<AbsPOSSalesLine>> entry : offerLineWithSalesLines.entrySet()) {
            POSSalesPriceUtil.calcMustBeOfferedLines(mustBeOfferedLines, entry, salesDocument);
        }
        toGetFreeLines.addAll(mustBeOfferedLines);
        return toGetFreeLines;
    }

    public static <T extends AbsPOSSalesLine> void cancelOtherOffers(List<T> srcLines, AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        for (int i = srcLines.size() - 1; i >= 0; --i) {
            AbsPOSSalesLine posSalesInvoiceLine;
            ObservableList items = view != null ? view.getSalesTable().getItems() : salesDoc.fetchDetails();
            AbsPOSSalesLine line = (AbsPOSSalesLine)items.get(items.indexOf(posSalesInvoiceLine = (AbsPOSSalesLine)srcLines.get(i)));
            if (ObjectChecker.isTrue((Boolean)line.getFreeLine()) && ObjectChecker.isNotEmptyOrNull((Object)line.getMasterRowId()) && ObjectChecker.areNotEqual((Object)line.getMasterRowId(), (Object)salesDoc.getId())) {
                salesDoc.fetchDetails().remove(line);
                continue;
            }
            line.setDiscount1(new POSDiscountTax());
            line.setDiscount2(new POSDiscountTax());
            line.setDiscount3(new POSDiscountTax());
            line.setDiscount4(new POSDiscountTax());
            line.setDiscount5(new POSDiscountTax());
            line.setDiscount6(new POSDiscountTax());
            line.setDiscount7(new POSDiscountTax());
            line.setDiscount8(new POSDiscountTax());
        }
        salesDoc.updateTotals(view);
    }

    private static void calcMustBeOfferedLines(List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> mustBeAddedLines, Map.Entry<UUID, List<AbsPOSSalesLine>> entry, AbsPOSSales salesDocument) {
        POSOfferOnItemsCountLine offerLine = POSPersister.findByID(POSOfferOnItemsCountLine.class, entry.getKey().toString());
        boolean ignoreFreeItemQty = ObjectChecker.isTrue((Boolean)offerLine.getIgnoreMatchedItemToBeFreeQty());
        if (ignoreFreeItemQty) {
            ArrayList copy = new ArrayList();
            entry.getValue().forEach(l -> copy.add(POSXMLSerializer.instance().clone(l)));
            entry.setValue(PosSalesUtil.mergeLines(copy, l -> POSSalesPriceUtil.itemUOMKeyGenerator(l)));
        }
        offerLine.setSrcLinesNumbers(entry.getValue().stream().map(l -> "" + ((List)entry.getValue()).indexOf(l)).collect(Collectors.joining("_#_")));
        int multiplies = 1;
        if (ObjectChecker.areEqual((Object)offerLine.getFreePolicy(), (Object)"Multiple")) {
            multiplies = POSSalesPriceUtil.calcLinesOrItemsCount(entry, offerLine) / offerLine.getNumOfInvoiceItems();
        }
        offerLine.setMultiplies(multiplies);
        POSSalesPriceUtil.addFreeItemsOnCountByClassification(offerLine, entry.getValue(), mustBeAddedLines, multiplies, salesDocument);
    }

    private static String itemUOMKeyGenerator(AbsPOSSalesLine line) {
        String itemId = ServerStringUtils.toUUIDStr((Object)line.getItem().getId().toString());
        String uomId = ServerStringUtils.toUUIDStr((Object)line.getQty().getUom().getId().toString());
        return itemId + "#" + uomId + "#" + String.valueOf(line.getUnitPrice());
    }

    private static void addFreeItemsOnCountByClassification(POSOfferOnItemsCountLine offerLine, List<AbsPOSSalesLine> lines, List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> mustBeAddedLines, int multiplies, AbsPOSSales salesDocument) {
        if (ObjectChecker.areEqual((Object)offerLine.getFreeItemClassification(), (Object)"ItemFromFreeItemGroup")) {
            POSSalesPriceUtil.addLineWithFreeGroupByQty(offerLine, mustBeAddedLines, salesDocument, new BigDecimal(multiplies).multiply(ObjectChecker.toOneIfNull((BigDecimal)offerLine.getFreeItemQty())));
            return;
        }
        if (ObjectChecker.isAnyEqualToFirst((Object)offerLine.getFreeItemClassification(), (Object[])new String[]{"ItemWithMinPrice", "ItemWithMaxPrice"})) {
            POSSalesPriceUtil.sortLinesByPrice(lines);
        }
        POSSalesPriceUtil.addLinesByMultiplyCount(offerLine, lines, mustBeAddedLines, multiplies, salesDocument);
    }

    private static BigDecimal copyLineAndMultiplyQty(POSOfferOnItemsCountLine offerLine, List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> mustBeAddedLines, BigDecimal freeItemQty, AbsPOSSalesLine sourceLine) {
        BigDecimal srcQty = sourceLine.getQty().getValue();
        if (freeItemQty.compareTo(srcQty) > 0) {
            freeItemQty = srcQty;
        }
        Object newSalesLine = POSSalesPriceUtil.copySalesLine(srcQty, sourceLine);
        ((AbsPOSSalesLine)newSalesLine).setId(UUID.randomUUID());
        ((AbsPOSSalesLine)newSalesLine).setFreeFromItemsCountOffer(true);
        ((AbsPOSSalesLine)newSalesLine).getQty().setValue(freeItemQty);
        ((AbsPOSSalesLine)newSalesLine).setMasterRowId(sourceLine.getId());
        ((AbsPOSSalesLine)newSalesLine).updateItemsCountOfferSrcIds(sourceLine.fetchItemsCountOfferSrcIds());
        mustBeAddedLines.add((Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>)new Pair((Object)offerLine, newSalesLine));
        return freeItemQty;
    }

    private static void addLineWithFreeGroupByQty(POSOfferOnItemsCountLine offerLine, List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> mustBeAddedLines, AbsPOSSales salesDocument, BigDecimal qty) {
        Object line = salesDocument.createBasicLine();
        ((AbsPOSSalesLine)line).setFreeItemGroup(offerLine.getFreeItemGroup());
        ((AbsPOSSalesLine)line).setQty(new POSQuantity());
        ((AbsPOSSalesLine)line).getQty().setValue(qty);
        mustBeAddedLines.add((Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>)new Pair((Object)offerLine, line));
    }

    private static void sortLinesByPrice(List<AbsPOSSalesLine> nonFreeLines) {
        Collections.sort(nonFreeLines, (o1, o2) -> o2.getUnitPrice().compareTo(o1.getUnitPrice()));
    }

    private static void addLinesByMultiplyCount(POSOfferOnItemsCountLine offerLine, List<AbsPOSSalesLine> lines, List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> mustBeAddedLines, int multiplies, AbsPOSSales salesDocument) {
        BigDecimal totalQtyToGet = new BigDecimal(multiplies).multiply(ObjectChecker.toOneIfNull((BigDecimal)offerLine.getFreeItemQty()));
        if (ObjectChecker.isEmptyOrZero((BigDecimal)totalQtyToGet)) {
            return;
        }
        boolean ignoreFreeItemQty = ObjectChecker.isTrue((Boolean)offerLine.getIgnoreMatchedItemToBeFreeQty());
        if (ObjectChecker.isAnyEqualToFirst((Object)offerLine.getFreeItemClassification(), (Object[])new String[]{"FirstItem", "ItemWithMaxPrice"})) {
            for (int i = 0; i < lines.size() && (totalQtyToGet = totalQtyToGet.subtract(POSSalesPriceUtil.copyLineAndMultiplyQty(offerLine, mustBeAddedLines, totalQtyToGet, lines.get(i)))).compareTo(BigDecimal.ZERO) > 0 && !ignoreFreeItemQty; ++i) {
            }
        } else {
            for (int i = lines.size() - 1; i >= 0 && (totalQtyToGet = totalQtyToGet.subtract(POSSalesPriceUtil.copyLineAndMultiplyQty(offerLine, mustBeAddedLines, totalQtyToGet, lines.get(i)))).compareTo(BigDecimal.ZERO) > 0 && !ignoreFreeItemQty; --i) {
            }
        }
    }

    public static <T extends AbsPOSSalesLine> T copySalesLine(BigDecimal multiplies, AbsPOSSalesLine lineSortedByPrice) {
        AbsPOSSalesLine newSalesLine = (AbsPOSSalesLine)ObjectCreatorUtil.creator(lineSortedByPrice.getClass()).create();
        newSalesLine.setId(lineSortedByPrice.getId());
        newSalesLine.setProductionDate(lineSortedByPrice.getProductionDate());
        newSalesLine.setExpiryDate(lineSortedByPrice.getExpiryDate());
        newSalesLine.setItemCode(lineSortedByPrice.getItemCode());
        newSalesLine.setItem(lineSortedByPrice.getItem());
        newSalesLine.setWarehouseIssueMethod(lineSortedByPrice.getWarehouseIssueMethod());
        newSalesLine.setInvoiceOfferId(lineSortedByPrice.getInvoiceOfferId());
        newSalesLine.setFreeLine(lineSortedByPrice.getFreeLine());
        newSalesLine.setUnitPrice(lineSortedByPrice.getUnitPrice());
        newSalesLine.setAfterDisc1(lineSortedByPrice.getAfterDisc1());
        newSalesLine.setAfterDisc2(lineSortedByPrice.getAfterDisc2());
        newSalesLine.setAfterDisc3(lineSortedByPrice.getAfterDisc3());
        newSalesLine.setAfterDisc4(lineSortedByPrice.getAfterDisc4());
        newSalesLine.setAfterDisc5(lineSortedByPrice.getAfterDisc5());
        newSalesLine.setAfterDisc6(lineSortedByPrice.getAfterDisc6());
        newSalesLine.setAfterDisc7(lineSortedByPrice.getAfterDisc7());
        newSalesLine.setAfterDisc8(lineSortedByPrice.getAfterDisc8());
        newSalesLine.setAfterTax1(lineSortedByPrice.getAfterTax1());
        newSalesLine.setAfterTax2(lineSortedByPrice.getAfterTax2());
        newSalesLine.setBox(lineSortedByPrice.getBox());
        newSalesLine.setDiscount1(lineSortedByPrice.getDiscount1());
        newSalesLine.setDiscount2(lineSortedByPrice.getDiscount2());
        newSalesLine.setDiscount3(lineSortedByPrice.getDiscount3());
        newSalesLine.setDiscount4(lineSortedByPrice.getDiscount4());
        newSalesLine.setDiscount5(lineSortedByPrice.getDiscount5());
        newSalesLine.setDiscount6(lineSortedByPrice.getDiscount6());
        newSalesLine.setDiscount7(lineSortedByPrice.getDiscount7());
        newSalesLine.setDiscount8(lineSortedByPrice.getDiscount8());
        newSalesLine.setCurrency(lineSortedByPrice.getCurrency());
        newSalesLine.setHeaderDicount(lineSortedByPrice.getHeaderDicount());
        newSalesLine.setQty(new POSQuantity());
        newSalesLine.setWarehouse(lineSortedByPrice.getWarehouse());
        newSalesLine.setRemarks(lineSortedByPrice.getRemarks());
        newSalesLine.setTotalPrice(lineSortedByPrice.getTotalPrice());
        newSalesLine.setTax1(lineSortedByPrice.getTax1());
        newSalesLine.setTax2(lineSortedByPrice.getTax2());
        newSalesLine.setNetPrice(lineSortedByPrice.getNetPrice());
        newSalesLine.setItemDimensions(lineSortedByPrice.getItemDimensions());
        newSalesLine.setLocation(lineSortedByPrice.getLocation());
        newSalesLine.getQty().setValue(multiplies);
        newSalesLine.getQty().setUom(lineSortedByPrice.getQty().getUom());
        newSalesLine.setSalesman(lineSortedByPrice.getSalesman());
        if (newSalesLine instanceof IPOSDocFromInvoiceLine) {
            ((IPOSDocFromInvoiceLine)((Object)newSalesLine)).setInvoiceLineId(((IPOSDocFromInvoiceLine)((Object)lineSortedByPrice)).getInvoiceLineId());
            ((IPOSDocFromInvoiceLine)((Object)newSalesLine)).setReturnReason(((IPOSDocFromInvoiceLine)((Object)newSalesLine)).getReturnReason());
        }
        if (newSalesLine instanceof POSSalesInvoiceLine) {
            ((POSSalesInvoiceLine)newSalesLine).setReturnedQty(((POSSalesInvoiceLine)lineSortedByPrice).getReturnedQty());
            newSalesLine.setDepreciationReason(lineSortedByPrice.getDepreciationReason());
        }
        return (T)newSalesLine;
    }

    private static HashMap<UUID, List<AbsPOSSalesLine>> fetchOffersForInvoice(AbsPOSSales salesDoc) {
        HashMap<UUID, List<AbsPOSSalesLine>> offerLineWithSalesLines = POSSalesPriceUtil.calcInvoiceOfferForItemsCount(salesDoc);
        Iterator<Map.Entry<UUID, List<AbsPOSSalesLine>>> iter = offerLineWithSalesLines.entrySet().iterator();
        HashMap<String, UUID> appliedOffers = new HashMap<String, UUID>();
        while (iter.hasNext()) {
            Map.Entry<UUID, List<AbsPOSSalesLine>> entry = iter.next();
            POSOfferOnItemsCountLine offerLine = POSPersister.findByID(POSOfferOnItemsCountLine.class, entry.getKey().toString());
            int linesOrItemsCount = POSSalesPriceUtil.calcLinesOrItemsCount(entry, offerLine);
            if (offerLine.getNumOfInvoiceItems() > linesOrItemsCount) {
                iter.remove();
                continue;
            }
            POSSalesPriceUtil.applyOfferWithHigherPriority(appliedOffers, entry, offerLine);
        }
        POSSalesPriceUtil.removeExtraOffers(offerLineWithSalesLines, appliedOffers);
        return offerLineWithSalesLines;
    }

    private static void applyOfferWithHigherPriority(Map<String, UUID> appliedOffers, Map.Entry<UUID, List<AbsPOSSalesLine>> entry, POSOfferOnItemsCountLine offerLine) {
        String key = entry.getValue().stream().map(l -> l.getId().toString()).collect(Collectors.joining(","));
        if (!appliedOffers.containsKey(key)) {
            appliedOffers.put(key, entry.getKey());
            return;
        }
        POSOfferOnItemsCountLine previousOfferLine = POSPersister.findByID(POSOfferOnItemsCountLine.class, appliedOffers.get(key));
        if (previousOfferLine.getPriority().compareTo(offerLine.getPriority()) > 0) {
            appliedOffers.put(key, entry.getKey());
        }
    }

    private static void removeExtraOffers(HashMap<UUID, List<AbsPOSSalesLine>> offerLineWithSalesLines, Map<String, UUID> appliedOffers) {
        Iterator<Map.Entry<UUID, List<AbsPOSSalesLine>>> iter = offerLineWithSalesLines.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<UUID, List<AbsPOSSalesLine>> entry = iter.next();
            if (appliedOffers.containsValue(entry.getKey())) continue;
            iter.remove();
        }
    }

    private static int calcLinesOrItemsCount(Map.Entry<UUID, List<AbsPOSSalesLine>> entry, POSOfferOnItemsCountLine offerLine) {
        int linesOrItemsCount;
        boolean ignoreFreeItemQty = ObjectChecker.isTrue((Boolean)offerLine.getIgnoreMatchedItemToBeFreeQty());
        int n = linesOrItemsCount = ignoreFreeItemQty ? entry.getValue().size() - 1 : entry.getValue().size();
        if (ObjectChecker.areEqual((Object)offerLine.getItemsCountMechanism(), (Object)OfferItemsCountMechanism.ItemsTotalQties)) {
            linesOrItemsCount = POSSalesPriceUtil.calcTotalQtyFromLines(entry.getValue(), offerLine);
        }
        return linesOrItemsCount;
    }

    private static int calcTotalQtyFromLines(List<AbsPOSSalesLine> lines, POSOfferOnItemsCountLine offerLine) {
        BigDecimal total = SafeBigDecimal.totalize(lines, l -> l.getQty().getValue());
        if (ObjectChecker.isTrue((Boolean)offerLine.getIgnoreMatchedItemToBeFreeQty())) {
            total = total.subtract(POSSalesPriceUtil.fetchFirstMatchedItemQty(offerLine, lines));
        }
        return total.intValue();
    }

    private static BigDecimal fetchFirstMatchedItemQty(POSOfferOnItemsCountLine offerLine, List<AbsPOSSalesLine> lines) {
        if (ObjectChecker.isAnyEqualToFirst((Object)offerLine.getFreeItemClassification(), (Object[])new String[]{"ItemWithMinPrice", "ItemWithMaxPrice"})) {
            POSSalesPriceUtil.sortLinesByPrice(lines);
        }
        if (ObjectChecker.isAnyEqualToFirst((Object)offerLine.getFreeItemClassification(), (Object[])new String[]{"FirstItem", "ItemWithMaxPrice"})) {
            return lines.get(0).getQty().getValue();
        }
        return lines.get(lines.size() - 1).getQty().getValue();
    }

    public static HashMap<UUID, List<AbsPOSSalesLine>> calcInvoiceOfferForItemsCount(AbsPOSSales salesDoc) {
        HashMap<UUID, List<AbsPOSSalesLine>> linesWithAppliedOffer = new HashMap<UUID, List<AbsPOSSalesLine>>();
        List<? extends AbsPOSSalesLine> salesLines = salesDoc.fetchDetails();
        for (AbsPOSSalesLine absPOSSalesLine : salesLines) {
            List<POSOfferOnItemsCountLine> offers;
            if (absPOSSalesLine.getFreeLine().booleanValue() && (!ObjectChecker.isTrue((Boolean)absPOSSalesLine.getFreeFromItemsCountOffer()) || !ObjectChecker.isEmptyOrNull((Object)absPOSSalesLine.getFreeItemGroup())) || !ObjectChecker.isNotEmptyOrNull(offers = POSSalesPriceUtil.fetchOffersForInvoice(absPOSSalesLine, salesDoc))) continue;
            for (POSOfferOnItemsCountLine offer : offers) {
                linesWithAppliedOffer.computeIfAbsent(offer.getId(), id -> new ArrayList()).add(absPOSSalesLine);
            }
        }
        return linesWithAppliedOffer;
    }

    public static List<POSOfferOnItemsCountLine> fetchOffersForInvoice(AbsPOSSalesLine line, AbsPOSSales salesDoc) {
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getActivateInvoiceItemsCountOffers())) {
            return null;
        }
        Date invoiceDate = new Date();
        Object query = " where fromDate <= :date and toDate >= :date ";
        POSItem item = POSPersister.findByID(POSItem.class, line.getItem().getId().toString());
        HashMap<String, Object> params = POSPersister.params("date", invoiceDate);
        query = (String)query + " and (brand is null or brand = :brand)";
        params.put("brand", item.fetchBrandProxy());
        query = (String)query + " and (section is null or section = :section)";
        params.put("section", item.fetchItemSectionProxy());
        query = (String)query + " and (category1 is null or category1 = :category1)";
        params.put("category1", item.fetchCategory1Proxy());
        query = (String)query + " and (category2 is null or category2 = :category2)";
        params.put("category2", item.fetchCategory2Proxy());
        query = (String)query + " and (category3 is null or category3 = :category3)";
        params.put("category3", item.fetchCategory3Proxy());
        query = (String)query + " and (category4 is null or category4 = :category4)";
        params.put("category4", item.fetchCategory4Proxy());
        query = (String)query + " and (category5 is null or category5 = :category5)";
        params.put("category5", item.fetchCategory5Proxy());
        query = POSSalesPriceUtil.addPriceClassifiers(salesDoc, (String)query, params);
        query = (String)query + "and (targetId is null or targetId = :customerId or targetId = :customerClassId or targetId = :customerCategId)  and (invoiceClassification is null or invoiceClassification = :invClassification) ";
        params.put("customerId", ObjectChecker.isNotEmptyOrNull((Object)salesDoc.getCustomer()) ? salesDoc.getCustomer().getId() : null);
        params.put("customerClassId", ObjectChecker.isNotEmptyOrNull((Object)salesDoc.getCustomer()) && ObjectChecker.isNotEmptyOrNull((Object)salesDoc.getCustomer().getCustomerClass()) ? salesDoc.getCustomer().getCustomerClass().getId() : null);
        params.put("customerCategId", ObjectChecker.isNotEmptyOrNull((Object)salesDoc.getCustomer()) && ObjectChecker.isNotEmptyOrNull((Object)salesDoc.getCustomer().getCustomerCategory()) ? salesDoc.getCustomer().getCustomerCategory().getId() : null);
        params.put("invClassification", salesDoc.getPosInvoiceClassification());
        query = POSSalesPriceUtil.addSubsidiaryToCriteriaAndParams((String)query, params, salesDoc.getSubsidiaryID(), salesDoc.getSubsidiaryType());
        List<POSOfferOnItemsCountLine> offers = POSPersister.listAll(POSOfferOnItemsCountLine.class, (String)query, params, "priority");
        POSSalesPriceUtil.removeUnUsedLines(offers);
        POSSalesPriceUtil.filterOffersByItemsGroup(offers, item.getId().toString().replaceAll("-", ""));
        POSSalesPriceUtil.removeMismatchedItemClasses(offers, item);
        for (int i = offers.size() - 1; i >= 0; --i) {
            if (!POSSalesPriceUtil.notApplicableForEmployee(offers.get(i).getEmpTargetId(), offers.get(i).getEmpTargetType(), POSSettingsInfo.fetchConfiguration().getCurrentUser())) continue;
            offers.remove(i);
        }
        return offers;
    }

    public static String addPriceClassifiers(AbsPOSSales salesDoc, String query, HashMap<String, Object> params) {
        query = POSSalesPriceUtil.addPriceClassifiersToCriteria(query);
        POSItemSalesPriceReq req = new POSItemSalesPriceReq();
        req.setPriceClassifier1(salesDoc.getPriceClassifier1());
        req.setPriceClassifier2(salesDoc.getPriceClassifier2());
        req.setPriceClassifier3(salesDoc.getPriceClassifier3());
        req.setPriceClassifier4(salesDoc.getPriceClassifier4());
        req.setPriceClassifier5(salesDoc.getPriceClassifier5());
        POSSalesPriceUtil.addPriceClassifiersToParams(req, params);
        return query;
    }

    private static void filterOffersByItemsGroup(List<POSOfferOnItemsCountLine> offers, String itemId) {
        for (int i = offers.size() - 1; i >= 0; --i) {
            POSFreeItemGroup itemsGroup = offers.get(i).getItemsGroup();
            if (!ObjectChecker.isNotEmptyOrNull((Object)itemsGroup) || itemsGroup.getFreeIds().contains(itemId)) continue;
            offers.remove(i);
        }
    }

    public static POSOfferCouponLine fetchOfferToGetCoupon(AbsPOSSales salesDoc) {
        BigDecimal netPrice = salesDoc.getNetPrice();
        List<?> offers = POSPersister.listAll(POSOfferCouponLine.class, " where deactivated = false and fromDate <= :date and toDate >= :date and invoiceValueFrom < :val and (invoiceValueTo >= :val or invoiceValueTo = 0) ", POSPersister.params("date", new Date(), "val", netPrice), "priority");
        if (ObjectChecker.isEmptyOrNull(offers)) {
            return null;
        }
        POSSalesPriceUtil.filterByDimensions(offers);
        Boolean invoiceHasOffersWithStopDiscounts = null;
        for (int i = offers.size() - 1; i >= 0; --i) {
            if (ObjectChecker.isFalse((Boolean)((POSOfferCouponLine)offers.get(i)).getConsiderStopOtherDiscounts())) continue;
            if (invoiceHasOffersWithStopDiscounts == null) {
                invoiceHasOffersWithStopDiscounts = POSSalesPriceUtil.invoiceHasOffersWithStopDiscount(salesDoc);
            }
            if (!invoiceHasOffersWithStopDiscounts.booleanValue()) continue;
            offers.remove(i);
        }
        return (POSOfferCouponLine)CollectionsUtility.getFirst(offers);
    }

    private static boolean invoiceHasOffersWithStopDiscount(AbsPOSSales salesDoc) {
        BigDecimal beforeDiscountTotal;
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        POSItemSalesPriceReq itemPriceReq = POSSalesPriceUtil.createSalesPriceRequestHeader(new ArrayList<BigDecimal>(), new Date(), salesDoc.getPosInvoiceClassification(), POSSalesPriceReqType.All, currentUser, salesDoc.fetchDetails(), salesDoc.getDiscountPercent().toString(), salesDoc.getTotalPrice(), salesDoc.getTotalPrice().toString(), salesDoc);
        POSSalesHeaderDiscountResp discountPair = POSSalesPriceUtil.calculateHeaderDicount(itemPriceReq, beforeDiscountTotal = POSMoneyUtils.getBeforeHeaderDiscountTotalValue(salesDoc.getInvoiceMoney()), beforeDiscountTotal);
        if (ObjectChecker.isTrue((Boolean)discountPair.getStopOtherDiscounts())) {
            return true;
        }
        long countOfFreeItemsWithStopOtherDiscs = salesDoc.fetchDetails().stream().filter(POSSalesPriceUtil.itemsCountWithStopDiscPredicate()).count();
        if (countOfFreeItemsWithStopOtherDiscs > 0L) {
            return true;
        }
        POSItemSalesPriceRes priceRes = POSSalesPriceUtil.updateLinePriceAndDiscounts(itemPriceReq);
        for (POSItemSalesPriceResDetail resLine : priceRes.getDetails()) {
            if (ObjectChecker.isNotEmptyOrNull(resLine.getDiscounts()) && resLine.getDiscounts().stream().anyMatch(POSSalesDiscountResultUnit::getStopOtherDiscounts)) {
                return true;
            }
            long countOfFreeItemsWithStopDiscs = resLine.getFreeItems().stream().filter(POSSalesPriceUtil.freeItemsWithStopDiscPredicate()).count();
            if (countOfFreeItemsWithStopDiscs <= 0L) continue;
            return true;
        }
        return false;
    }

    private static Predicate<AbsPOSSalesLine> itemsCountWithStopDiscPredicate() {
        return l -> {
            if (ObjectChecker.isEmptyOrNull((Object)l.getInvoiceOfferId())) {
                return false;
            }
            POSOfferOnItemsCountLine offerOnItemsCountSysLine = POSPersister.findByID(POSOfferOnItemsCountLine.class, l.getInvoiceOfferId());
            return ObjectChecker.isTrue((Boolean)offerOnItemsCountSysLine.getStopOtherDiscounts());
        };
    }

    private static Predicate<POSItemSalesFreeItem> freeItemsWithStopDiscPredicate() {
        return f -> {
            if (ObjectChecker.isEmptyOrNull((Object)f.getFreeOfferLineId())) {
                return false;
            }
            IPOSFreeItemOfferLine freeItemSysLine = POSPersister.findByID(POSFreeItemLine.class, f.getFreeOfferLineId());
            if (ObjectChecker.isEmptyOrNull((Object)freeItemSysLine)) {
                freeItemSysLine = POSPersister.findByID(POSInvoiceFreeItemLine.class, f.getFreeOfferLineId());
            }
            return ObjectChecker.isNotEmptyOrNull((Object)freeItemSysLine) && ObjectChecker.isTrue((Boolean)freeItemSysLine.getStopOtherDiscounts());
        };
    }

    public static POSItemSalesPriceRes calculateInvoiceFreeItems(POSItemSalesPriceReq itemPriceReq, POSItemSalesPriceRes priceResult) {
        HashMap<String, Object> params = POSPersister.params(new Object[0]);
        String criteria = POSSalesPriceUtil.createInvoiceFreeItemsCriteria(itemPriceReq, params);
        criteria = POSSalesPriceUtil.addPriceClassifiersToCriteria(criteria);
        POSSalesPriceUtil.addPriceClassifiersToParams(itemPriceReq, params);
        criteria = POSSalesPriceUtil.addSubsidiaryToCriteriaAndParams(criteria, itemPriceReq, params);
        List<Object> lines = POSPersister.listAll(POSInvoiceFreeItemLine.class, criteria, params, "");
        lines = lines.stream().filter(l -> NaMaMath.betweenExcludingUpper((BigDecimal)itemPriceReq.getNetValue(), (BigDecimal)ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{l.getMinInvoiceValue(), BigDecimal.valueOf(Long.MIN_VALUE)}), (BigDecimal)ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{l.getMaxInvoiceValue(), BigDecimal.valueOf(Long.MAX_VALUE)}))).collect(Collectors.toList());
        POSSalesPriceUtil.filterByDimensions(lines);
        POSSalesPriceUtil.makeFreeItemSameAsMainItemIfNeeded(itemPriceReq.getDetails().get(0), lines);
        List<POSItemSalesFreeItem> freeList = POSSalesPriceUtil.convertFreeOfferToResultFreeItems(itemPriceReq.getNetValue(), lines, itemPriceReq.getItems(), itemPriceReq.getNetValues(), itemPriceReq, null);
        POSItemSalesPriceResDetail result = new POSItemSalesPriceResDetail();
        result.setFreeItems(freeList);
        priceResult.setIgnoreOtherOffers(lines.stream().anyMatch(l -> ObjectChecker.isTrue((Boolean)l.getIgnoreOtherOffers())));
        priceResult.getDetails().add(result);
        return priceResult;
    }

    private static String createInvoiceFreeItemsCriteria(POSItemSalesPriceReq itemPriceReq, HashMap<String, Object> params) {
        Object query = " where fromDate <= :date and toDate >= :date and minInvoiceValue <= :total ";
        params.put("date", itemPriceReq.getValueDate());
        query = (String)query + "and (targetId is null or targetId = :customerId or targetId = :customerClassId or targetId = :customerCategId)  and (invoiceClassification is null or invoiceClassification = :invClassification) ";
        params.put("customerId", ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer()) ? itemPriceReq.getCustomer().getId() : null);
        params.put("customerClassId", ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer()) && ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer().getCustomerClass()) ? itemPriceReq.getCustomer().getCustomerClass().getId() : null);
        params.put("customerCategId", ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer()) && ObjectChecker.isNotEmptyOrNull((Object)itemPriceReq.getCustomer().getCustomerCategory()) ? itemPriceReq.getCustomer().getCustomerCategory().getId() : null);
        params.put("invClassification", itemPriceReq.getInvoiceClassification());
        params.put("total", itemPriceReq.getNetValue());
        return query;
    }

    private static class DiscountCalculator {
        private POSItemSalesPriceReq itemPriceFromDTOReq;
        private int index;
        private List<BigDecimal> minDiscounts;
        private List<BigDecimal> defaultDiscounts;
        private List<BigDecimal> maxDiscounts;
        private List<BigDecimal> maxNormalDiscounts;
        private List<POSSalesDiscountResultUnit> discounts;
        private List<BigDecimal> prices;
        private HashMap<DiscountLocation, List<POSItemDiscountLine>> discountsMap = new HashMap();
        private BigDecimal startPrice;
        private BigDecimal currentPrice;
        private BigDecimal currentMinPrice;
        private BigDecimal currentMaxPrice;
        private BigDecimal currentDefaultPrice;
        private BigDecimal priceAfterHeader;
        private BigDecimal tax1;
        private BigDecimal tax2;
        private BigDecimal tax3;
        private BigDecimal tax4;
        private boolean useDiscounts;

        public DiscountCalculator(POSItemSalesPriceReq itemPriceReq, int index, BigDecimal price, boolean useDiscounts) {
            this.itemPriceFromDTOReq = itemPriceReq;
            this.index = index;
            this.currentPrice = this.startPrice = ObjectChecker.toZeroIfNull((BigDecimal)price);
            this.useDiscounts = useDiscounts;
            this.minDiscounts = new ArrayList<BigDecimal>();
            this.maxDiscounts = new ArrayList<BigDecimal>();
            this.defaultDiscounts = new ArrayList<BigDecimal>();
            this.maxNormalDiscounts = new ArrayList<BigDecimal>();
            this.discountsMap.put(DiscountLocation.Discount1, new ArrayList());
            this.discountsMap.put(DiscountLocation.Discount2, new ArrayList());
            this.discountsMap.put(DiscountLocation.Discount3, new ArrayList());
            this.discountsMap.put(DiscountLocation.Discount4, new ArrayList());
            this.discountsMap.put(DiscountLocation.Discount5, new ArrayList());
            this.discountsMap.put(DiscountLocation.Discount6, new ArrayList());
            this.discountsMap.put(DiscountLocation.Discount7, new ArrayList());
            this.discountsMap.put(DiscountLocation.Discount8, new ArrayList());
            this.prices = new ArrayList<BigDecimal>();
            this.discounts = new ArrayList<POSSalesDiscountResultUnit>();
            this.minDiscounts.add(BigDecimal.ZERO);
            this.minDiscounts.add(BigDecimal.ZERO);
            this.minDiscounts.add(BigDecimal.ZERO);
            this.minDiscounts.add(BigDecimal.ZERO);
            this.minDiscounts.add(BigDecimal.ZERO);
            this.minDiscounts.add(BigDecimal.ZERO);
            this.minDiscounts.add(BigDecimal.ZERO);
            this.minDiscounts.add(BigDecimal.ZERO);
            this.maxDiscounts.add(BigDecimal.ZERO);
            this.maxDiscounts.add(BigDecimal.ZERO);
            this.maxDiscounts.add(BigDecimal.ZERO);
            this.maxDiscounts.add(BigDecimal.ZERO);
            this.maxDiscounts.add(BigDecimal.ZERO);
            this.maxDiscounts.add(BigDecimal.ZERO);
            this.maxDiscounts.add(BigDecimal.ZERO);
            this.maxDiscounts.add(BigDecimal.ZERO);
            this.maxNormalDiscounts.add(BigDecimal.ZERO);
            this.maxNormalDiscounts.add(BigDecimal.ZERO);
            this.maxNormalDiscounts.add(BigDecimal.ZERO);
            this.maxNormalDiscounts.add(BigDecimal.ZERO);
            this.maxNormalDiscounts.add(BigDecimal.ZERO);
            this.maxNormalDiscounts.add(BigDecimal.ZERO);
            this.maxNormalDiscounts.add(BigDecimal.ZERO);
            this.maxNormalDiscounts.add(BigDecimal.ZERO);
            this.defaultDiscounts.add(BigDecimal.ZERO);
            this.defaultDiscounts.add(BigDecimal.ZERO);
            this.defaultDiscounts.add(BigDecimal.ZERO);
            this.defaultDiscounts.add(BigDecimal.ZERO);
            this.defaultDiscounts.add(BigDecimal.ZERO);
            this.defaultDiscounts.add(BigDecimal.ZERO);
            this.defaultDiscounts.add(BigDecimal.ZERO);
            this.defaultDiscounts.add(BigDecimal.ZERO);
            this.discounts.add(new POSSalesDiscountResultUnit());
            this.discounts.add(new POSSalesDiscountResultUnit());
            this.discounts.add(new POSSalesDiscountResultUnit());
            this.discounts.add(new POSSalesDiscountResultUnit());
            this.discounts.add(new POSSalesDiscountResultUnit());
            this.discounts.add(new POSSalesDiscountResultUnit());
            this.discounts.add(new POSSalesDiscountResultUnit());
            this.discounts.add(new POSSalesDiscountResultUnit());
            this.prices.add(BigDecimal.ZERO);
            this.prices.add(BigDecimal.ZERO);
            this.prices.add(BigDecimal.ZERO);
            this.prices.add(BigDecimal.ZERO);
            this.prices.add(BigDecimal.ZERO);
            this.prices.add(BigDecimal.ZERO);
            this.prices.add(BigDecimal.ZERO);
            this.prices.add(BigDecimal.ZERO);
            this.resetMinAndMax();
        }

        private void resetMinAndMax() {
            this.currentMaxPrice = this.currentPrice;
            this.currentMinPrice = this.currentPrice;
            this.currentDefaultPrice = this.currentPrice;
        }

        public void calculateDiscountsBeforeHeader(DTOTaxConfiguration taxConfiguration) {
            this.discountsMap = POSSalesPriceUtil.readDiscountLines(this.useDiscounts, this.itemPriceFromDTOReq.getDetails().get(this.index), this.itemPriceFromDTOReq, this.startPrice);
            this.calculateDiscounts(true, taxConfiguration);
        }

        public static List<DiscountLocation> discountLocationList() {
            return Arrays.asList(DiscountLocation.Discount1, DiscountLocation.Discount2, DiscountLocation.Discount3, DiscountLocation.Discount4, DiscountLocation.Discount5, DiscountLocation.Discount6, DiscountLocation.Discount7, DiscountLocation.Discount8);
        }

        private void calculateDiscounts(boolean beforeHeader, DTOTaxConfiguration taxConfiguration) {
            List<DiscountLocation> locations = DiscountCalculator.discountLocationList();
            int i = -1;
            for (DiscountLocation location : locations) {
                ++i;
                if (beforeHeader != this.beforeHeaderDiscount(location)) continue;
                List<POSItemDiscountLine> locationLines = this.discountsMap.get(location);
                if (ObjectChecker.isEmptyOrNull(locationLines)) {
                    this.applyUserDiscountToAllValues(i);
                } else {
                    for (POSItemDiscountLine sysLine : locationLines) {
                        this.recalcDiscount(i, sysLine);
                    }
                }
                this.assignAppropiateDiscount(location);
                this.resetMinAndMax();
                this.applyTaxIfNeeded(TaxLocation.valueOf((String)location.toString()), taxConfiguration);
            }
        }

        public static TaxLocation getTaxLocation(String taxLocation) {
            if (ObjectChecker.isEmptyOrNull((Object)taxLocation)) {
                return TaxLocation.HeaderDiscount;
            }
            return TaxLocation.valueOf((String)taxLocation);
        }

        private void applyTaxIfNeeded(TaxLocation currentLocation, DTOTaxConfiguration taxConfiguration) {
            TaxLocation tax4Location;
            TaxLocation tax3Location;
            TaxLocation tax2Location;
            TaxLocation tax1Location = DiscountCalculator.getTaxLocation(taxConfiguration.getTax1Location());
            if (ObjectChecker.areEqual((Object)tax1Location, (Object)currentLocation)) {
                this.applyTax1(taxConfiguration);
            }
            if (ObjectChecker.areEqual((Object)(tax2Location = DiscountCalculator.getTaxLocation(taxConfiguration.getTax2Location())), (Object)currentLocation)) {
                this.applyTax2(taxConfiguration);
            }
            if (ObjectChecker.areEqual((Object)(tax3Location = DiscountCalculator.getTaxLocation(taxConfiguration.getTax3Location())), (Object)currentLocation)) {
                this.applyTax3(taxConfiguration);
            }
            if (ObjectChecker.areEqual((Object)(tax4Location = DiscountCalculator.getTaxLocation(taxConfiguration.getTax4Location())), (Object)currentLocation)) {
                this.applyTax4(taxConfiguration);
            }
        }

        public static TaxApplyType getTaxApplyType(String applyType) {
            if (ObjectChecker.isEmptyOrNull((Object)applyType)) {
                return TaxApplyType.AfterHeaderDiscount;
            }
            return TaxApplyType.valueOf((String)applyType);
        }

        private void applyTax3(DTOTaxConfiguration taxConfiguration) {
            BigDecimal p1 = ObjectChecker.toZeroIfNull((BigDecimal)this.itemPriceFromDTOReq.getHeaderTax3Percent());
            BigDecimal taxTotal = this.calcTaxTotal(DiscountCalculator.getTaxApplyType(taxConfiguration.getTax3ApplyType()));
            BigDecimal p1Value = NaMaMath.calcPercentageValue((BigDecimal)taxTotal, (BigDecimal)p1, (Integer)POSMoneyUtils.fractionalDecimalPlaces);
            this.tax1 = NaMaMath.calcPercentage((BigDecimal)this.currentPrice, (BigDecimal)p1Value, (Integer)POSMoneyUtils.getPercentageScale());
            this.currentPrice = this.currentPrice.subtract(p1Value);
        }

        private void applyTax4(DTOTaxConfiguration taxConfiguration) {
            BigDecimal p2 = ObjectChecker.toZeroIfNull((BigDecimal)this.itemPriceFromDTOReq.getHeaderTax4Percent());
            BigDecimal taxTotal = this.calcTaxTotal(DiscountCalculator.getTaxApplyType(taxConfiguration.getTax4ApplyType()));
            BigDecimal p2Value = NaMaMath.calcPercentageValue((BigDecimal)taxTotal, (BigDecimal)p2, (Integer)POSMoneyUtils.fractionalDecimalPlaces);
            this.tax2 = NaMaMath.calcPercentage((BigDecimal)this.currentPrice, (BigDecimal)p2Value, (Integer)POSMoneyUtils.getPercentageScale());
            this.currentPrice = this.currentPrice.subtract(p2Value);
        }

        private BigDecimal calcTaxTotal(TaxApplyType taxApplyType) {
            if (ObjectChecker.areEqual((Object)taxApplyType, (Object)TaxApplyType.AfterDiscount1Price)) {
                return this.prices.get(0);
            }
            if (ObjectChecker.areEqual((Object)taxApplyType, (Object)TaxApplyType.AfterDiscount2Price)) {
                return this.prices.get(1);
            }
            if (ObjectChecker.areEqual((Object)taxApplyType, (Object)TaxApplyType.AfterDiscount3Price)) {
                return this.prices.get(2);
            }
            if (ObjectChecker.areEqual((Object)taxApplyType, (Object)TaxApplyType.AfterDiscount4Price)) {
                return this.prices.get(3);
            }
            if (ObjectChecker.areEqual((Object)taxApplyType, (Object)TaxApplyType.AfterDiscount5Price)) {
                return this.prices.get(4);
            }
            if (ObjectChecker.areEqual((Object)taxApplyType, (Object)TaxApplyType.AfterDiscount6Price)) {
                return this.prices.get(5);
            }
            if (ObjectChecker.areEqual((Object)taxApplyType, (Object)TaxApplyType.AfterDiscount7Price)) {
                return this.prices.get(6);
            }
            if (ObjectChecker.areEqual((Object)taxApplyType, (Object)TaxApplyType.AfterDiscount8Price)) {
                return this.prices.get(7);
            }
            if (ObjectChecker.areEqual((Object)taxApplyType, (Object)TaxApplyType.AfterHeaderDiscount)) {
                return this.priceAfterHeader;
            }
            return this.currentPrice;
        }

        private void applyTax1(DTOTaxConfiguration taxConfiguration) {
            BigDecimal p1 = ObjectChecker.toZeroIfNull((BigDecimal)this.itemPriceFromDTOReq.getDetails().get(this.index).getTax1Percent());
            BigDecimal taxTotal = this.calcTaxTotal(DiscountCalculator.getTaxApplyType(taxConfiguration.getTax1ApplyType()));
            BigDecimal p1Value = NaMaMath.calcPercentageValue((BigDecimal)taxTotal, (BigDecimal)p1, (Integer)POSMoneyUtils.fractionalDecimalPlaces);
            this.tax3 = NaMaMath.calcPercentage((BigDecimal)this.currentPrice, (BigDecimal)p1Value, (Integer)POSMoneyUtils.getPercentageScale());
            this.currentPrice = this.currentPrice.subtract(p1Value);
        }

        private void applyTax2(DTOTaxConfiguration taxConfiguration) {
            BigDecimal p2 = ObjectChecker.toZeroIfNull((BigDecimal)this.itemPriceFromDTOReq.getDetails().get(this.index).getTax2Percent());
            BigDecimal taxTotal = this.calcTaxTotal(DiscountCalculator.getTaxApplyType(taxConfiguration.getTax2ApplyType()));
            BigDecimal p2Value = NaMaMath.calcPercentageValue((BigDecimal)taxTotal, (BigDecimal)p2, (Integer)POSMoneyUtils.fractionalDecimalPlaces);
            this.tax4 = NaMaMath.calcPercentage((BigDecimal)this.currentPrice, (BigDecimal)p2Value, (Integer)POSMoneyUtils.getPercentageScale());
            this.currentPrice = this.currentPrice.subtract(p2Value);
        }

        private void assignAppropiateDiscount(DiscountLocation currentLocation) {
            int index = DiscountCalculator.toArrayIndex(currentLocation);
            if (index >= 0) {
                BigDecimal minDiscount = this.minDiscounts.get(index);
                BigDecimal maxDiscount = this.maxDiscounts.get(index);
                BigDecimal defaultDiscount = this.defaultDiscounts.get(index);
                BigDecimal userDiscount = this.getUserDiscountPercent(index);
                BigDecimal discount = POSSalesPriceUtil.determineAppropiatDiscount(userDiscount, defaultDiscount, minDiscount, maxDiscount);
                if (ObjectChecker.isNotEmptyOrNull(this.discountsMap.get(currentLocation))) {
                    for (POSItemDiscountLine line : this.discountsMap.get(currentLocation)) {
                        POSSalesDiscountResultUnit salesDiscountResultUnit = ObjectChecker.isEmptyOrNull((Object)this.discounts.get(index)) ? new POSSalesDiscountResultUnit() : this.discounts.get(index);
                        salesDiscountResultUnit.setDiscountValue(discount);
                        if (ObjectChecker.isTrue((Boolean)line.getDeactivateEmpDiscValidations())) {
                            salesDiscountResultUnit.setDeactivateEmpValidations(Boolean.TRUE);
                        }
                        salesDiscountResultUnit.setStopOtherDiscounts(line.getStopOtherDiscounts());
                        if (ObjectChecker.isNotEmptyOrNull((Object)line.getApplyOnlyIfItemInInvoice())) {
                            salesDiscountResultUnit.getApplyOnlyIfItemInInvoiceLines().add(line);
                        }
                        this.discounts.set(index, salesDiscountResultUnit);
                    }
                }
                this.currentPrice = this.currentPrice.subtract(NaMaMath.calcPercentageValue((BigDecimal)this.currentPrice, (BigDecimal)discount, (Integer)POSMoneyUtils.fractionalDecimalPlaces));
                this.prices.set(index, this.currentPrice);
            }
        }

        public static int toArrayIndex(DiscountLocation discountLocation) {
            if (discountLocation == null) {
                return -1;
            }
            if (DiscountLocation.Discount1.equals((Object)discountLocation)) {
                return 0;
            }
            if (DiscountLocation.Discount2.equals((Object)discountLocation)) {
                return 1;
            }
            if (DiscountLocation.Discount3.equals((Object)discountLocation)) {
                return 2;
            }
            if (DiscountLocation.Discount4.equals((Object)discountLocation)) {
                return 3;
            }
            if (DiscountLocation.Discount5.equals((Object)discountLocation)) {
                return 4;
            }
            if (DiscountLocation.Discount6.equals((Object)discountLocation)) {
                return 5;
            }
            if (DiscountLocation.Discount7.equals((Object)discountLocation)) {
                return 6;
            }
            if (DiscountLocation.Discount8.equals((Object)discountLocation)) {
                return 7;
            }
            return -1;
        }

        private void recalcDiscount(int index, POSItemDiscountLine sysLine) {
            BigDecimal discountMinValue = sysLine.getDiscountMinValue();
            BigDecimal discountMaxValue = sysLine.getDiscountMaxValue();
            BigDecimal discountDefaultValue = sysLine.getDiscountDefaultValue();
            BigDecimal newMinDiscountPercent = sysLine.getDiscountMinValue();
            BigDecimal newMaxDiscountPercent = sysLine.getDiscountMaxValue();
            BigDecimal newDefaultValue = sysLine.getDiscountDefaultValue();
            if (ObjectChecker.isAnyEqualToFirst((Object)sysLine.getValueOrPercent(), (Object[])new Serializable[]{DiscountType.Percentage, DiscountType.FixedPercentage})) {
                discountMinValue = NaMaMath.calcPercentageValue((BigDecimal)this.currentMaxPrice, (BigDecimal)sysLine.getDiscountMinValue(), (Integer)POSMoneyUtils.fractionalDecimalPlaces);
                discountMaxValue = NaMaMath.calcPercentageValue((BigDecimal)this.currentMinPrice, (BigDecimal)sysLine.getDiscountMaxValue(), (Integer)POSMoneyUtils.fractionalDecimalPlaces);
                discountDefaultValue = NaMaMath.calcPercentageValue((BigDecimal)this.currentDefaultPrice, (BigDecimal)sysLine.getDiscountDefaultValue(), (Integer)POSMoneyUtils.fractionalDecimalPlaces);
            } else {
                newMinDiscountPercent = NaMaMath.calcPercentage((BigDecimal)this.currentMaxPrice, (BigDecimal)discountMinValue, (Integer)POSMoneyUtils.getPercentageScale());
                newMaxDiscountPercent = NaMaMath.calcPercentage((BigDecimal)this.currentMinPrice, (BigDecimal)discountMaxValue, (Integer)POSMoneyUtils.getPercentageScale());
                newDefaultValue = NaMaMath.calcPercentage((BigDecimal)this.currentDefaultPrice, (BigDecimal)discountDefaultValue, (Integer)POSMoneyUtils.getPercentageScale());
            }
            this.currentMaxPrice = this.currentMaxPrice.subtract(discountMinValue);
            this.currentMinPrice = this.currentMinPrice.subtract(discountMaxValue);
            this.currentDefaultPrice = this.currentDefaultPrice.subtract(discountDefaultValue);
            this.minDiscounts.set(index, DiscountCalculator.applyCompositePercent(this.minDiscounts.get(index), newMinDiscountPercent, DiscountType.valueOf((String)sysLine.getValueOrPercent())));
            this.maxDiscounts.set(index, DiscountCalculator.applyCompositePercent(this.maxDiscounts.get(index), newMaxDiscountPercent, DiscountType.valueOf((String)sysLine.getValueOrPercent())));
            this.defaultDiscounts.set(index, DiscountCalculator.applyCompositePercent(this.defaultDiscounts.get(index), newDefaultValue, DiscountType.valueOf((String)sysLine.getValueOrPercent())));
            if (ObjectChecker.isFalse((Boolean)sysLine.getSpecialDiscount())) {
                this.maxNormalDiscounts.set(index, DiscountCalculator.applyCompositePercent(this.maxNormalDiscounts.get(index), newMaxDiscountPercent, DiscountType.valueOf((String)sysLine.getValueOrPercent())));
            }
        }

        public static BigDecimal applyCompositePercent(BigDecimal currentDiscount, BigDecimal newPercent, DiscountType discountType) {
            if (ObjectChecker.areEqual((Object)DiscountType.FixedPercentage, (Object)discountType)) {
                return ObjectChecker.toZeroIfNull((BigDecimal)currentDiscount).add(newPercent);
            }
            BigDecimal currentValue = BigDecimal.valueOf(100L).subtract(currentDiscount);
            newPercent = ObjectChecker.toZeroIfNull((BigDecimal)newPercent);
            BigDecimal discountValue = NaMaMath.divide((BigDecimal)newPercent.multiply(currentValue), (BigDecimal)BigDecimal.valueOf(100L), (Integer)POSMoneyUtils.fractionalDecimalPlaces);
            return discountValue.add(currentDiscount);
        }

        private void applyUserDiscountToAllValues(int i) {
            BigDecimal maxValue = this.getUserDiscountPercent(i);
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getPreventNonOfferedDiscounts())) {
                maxValue = BigDecimal.ZERO;
            }
            this.minDiscounts.set(i, maxValue);
            this.maxDiscounts.set(i, maxValue);
            this.defaultDiscounts.set(i, maxValue);
            POSSalesDiscountResultUnit salesDiscountResultUnit = new POSSalesDiscountResultUnit();
            salesDiscountResultUnit.setDiscountValue(maxValue);
            salesDiscountResultUnit.setDeactivateEmpValidations(false);
            this.discounts.set(i, salesDiscountResultUnit);
        }

        private BigDecimal getUserDiscountPercent(int i) {
            if (i == 0) {
                return this.itemPriceFromDTOReq.getDetails().get(this.index).getDiscount1Percent();
            }
            if (i == 1) {
                return this.itemPriceFromDTOReq.getDetails().get(this.index).getDiscount2Percent();
            }
            if (i == 2) {
                return this.itemPriceFromDTOReq.getDetails().get(this.index).getDiscount3Percent();
            }
            if (i == 3) {
                return this.itemPriceFromDTOReq.getDetails().get(this.index).getDiscount4Percent();
            }
            if (i == 4) {
                return this.itemPriceFromDTOReq.getDetails().get(this.index).getDiscount5Percent();
            }
            if (i == 5) {
                return this.itemPriceFromDTOReq.getDetails().get(this.index).getDiscount6Percent();
            }
            if (i == 6) {
                return this.itemPriceFromDTOReq.getDetails().get(this.index).getDiscount7Percent();
            }
            return this.itemPriceFromDTOReq.getDetails().get(this.index).getDiscount8Percent();
        }

        private boolean beforeHeaderDiscount(DiscountLocation location) {
            return location.toString().compareTo(DiscountCalculator.getHeaderDiscountLocation().toString()) <= 0;
        }

        public static DiscountLocation getHeaderDiscountLocation() {
            String discountLocation = POSResourcesUtil.fetchGlobalConfig().getDiscountLocation();
            if (ObjectChecker.isEmptyOrNull((Object)discountLocation)) {
                return DiscountLocation.Discount8;
            }
            return DiscountLocation.valueOf((String)discountLocation);
        }
    }
}

