/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.contracts.common.dtos.requests.ChangePasswordRequest;
import com.namasoft.contracts.common.dtos.requests.ListApprovalsRequest;
import com.namasoft.contracts.common.dtos.requests.ReprocessInfo;
import com.namasoft.contracts.common.dtos.requests.SendListRequest;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.requests.ServiceRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.dtos.results.ListResult;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.basic.contracts.entities.DTODiscountCoupon;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTODocsToPayFromPosEntry;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOUserNotification;
import com.namasoft.modules.namapos.contracts.POSUtilityWS;
import com.namasoft.modules.namapos.contracts.common.DTOCheckFromInvQtiesReq;
import com.namasoft.modules.namapos.contracts.common.DTODocToPayReq;
import com.namasoft.modules.namapos.contracts.common.DTOEditInvoiceRemarksReq;
import com.namasoft.modules.namapos.contracts.common.DTOFieldAllowedValuesReq;
import com.namasoft.modules.namapos.contracts.common.DTOInvoiceFromServerReq;
import com.namasoft.modules.namapos.contracts.common.DTOPOSCalcCouponValueRequest;
import com.namasoft.modules.namapos.contracts.common.DTOPOSCompressedReadResp;
import com.namasoft.modules.namapos.contracts.common.DTOPOSConfigResponse;
import com.namasoft.modules.namapos.contracts.common.DTOPOSReadMsg;
import com.namasoft.modules.namapos.contracts.common.DTOPOSReadQueueRequest;
import com.namasoft.modules.namapos.contracts.common.DTOPOSReadQueueResponse;
import com.namasoft.modules.namapos.contracts.common.DTOPOSRequestOTPRequest;
import com.namasoft.modules.namapos.contracts.common.DTOPosGenCodingParamsReq;
import com.namasoft.modules.namapos.contracts.common.DTORegisterUpdater;
import com.namasoft.modules.namapos.contracts.common.DTOUpdateSalesManReq;
import com.namasoft.modules.namapos.contracts.common.POSOnlineOrderRequest;
import com.namasoft.modules.namapos.contracts.common.POSReadOnlineOrderResponse;
import com.namasoft.modules.namapos.contracts.common.POSWriteRequest;
import com.namasoft.modules.namapos.contracts.details.DTOPOSRegisterDocsCodingParam;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesInvoice;
import com.namasoft.modules.namapos.contracts.requests.POSQuantitiesUpdaterReadRequest;
import com.namasoft.modules.namapos.contracts.valueobjects.DTONamaPOSItemQtyUpdater;
import com.namasoft.modules.namapos.contracts.valueobjects.DTOPaymentMethodInfo;
import com.namasoft.modules.supplychain.contracts.dtos.DTOPOSOverDraftValidationRequest;
import com.namasoft.modules.supplychain.contracts.dtos.DTORedeemRequest;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.toolbar.IPOSToolBar;
import com.namasoft.pos.util.POSDataWriterUtil;
import java.math.BigDecimal;
import java.util.function.Supplier;

public class POSWSClient
implements POSUtilityWS {
    private static POSUtilityWS posWS;
    public static POSWSClient instance;

    private static POSUtilityWS getPOSWS() {
        if (posWS == null) {
            posWS = (POSUtilityWS)ServiceUtility.getUtilityServiceClient(POSUtilityWS.class, (String)"namapos");
        }
        return posWS;
    }

    public GetResult<DTOPOSConfigResponse> fetchPOSConfig(SendRequest<String> serviceRequest) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().fetchPOSConfig(serviceRequest));
    }

    public GetResult<Boolean> checkExistRegister(SendRequest<String> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().checkExistRegister(request));
    }

    public ListResult<DTOUserNotification> fetchNotifications(SendRequest<ListApprovalsRequest> sendRequest) throws NaMaServiceExcepption {
        return (ListResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().fetchNotifications(sendRequest));
    }

    public ServiceResponse editInvoice(SendRequest<DTOEditInvoiceRemarksReq> dtoEditInvoiceRemarksReqSendRequest) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().editInvoice(dtoEditInvoiceRemarksReqSendRequest));
    }

    public GetResult<ResultDTO> validateCreditNote(SendRequest<DTOPaymentMethodInfo> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().validateCreditNote(request));
    }

    public GetResult<BigDecimal> calcCreditNoteValue(SendRequest<String> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().calcCreditNoteValue(request));
    }

    public GetResult<String> writeUser(SendRequest<ChangePasswordRequest> dtoUserSendRequest) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().writeUser(dtoUserSendRequest));
    }

    public ServiceResponse writeData(SendRequest<POSWriteRequest> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().writeData(request));
    }

    public ServiceResponse updateRegisterResendOption(SendRequest<DTORegisterUpdater> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().updateRegisterResendOption(request));
    }

    public ServiceResponse updatePOSRegisterProperties(SendRequest<DTORegisterUpdater> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().updatePOSRegisterProperties(request));
    }

    public ServiceResponse updatePOSSalesInvSalesMan(SendRequest<DTOUpdateSalesManReq> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().updatePOSSalesInvSalesMan(request));
    }

    public ServiceResponse updateDownloadReleaseOption(SendRequest<DTORegisterUpdater> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().updateDownloadReleaseOption(request));
    }

    public ListResult<DTOPOSReadQueueResponse> readActionForPOS(SendRequest<DTOPOSReadQueueRequest> request) throws NaMaServiceExcepption {
        return (ListResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().readActionForPOS(request));
    }

    public ServiceResponse updatePOSReadMsgs(SendListRequest<DTOPOSReadMsg> dtoposReadMsgSendListRequest) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().updatePOSReadMsgs(dtoposReadMsgSendListRequest));
    }

    public ServiceResponse advancePOSReadMsgs(SendRequest<ReprocessInfo> reprocessInfoSendRequest) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().advancePOSReadMsgs(reprocessInfoSendRequest));
    }

    public ServiceResponse deleteErrorSysLines(SendRequest<ReprocessInfo> req) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().deleteErrorSysLines(req));
    }

    public ServiceResponse refreshErrors(SendRequest req) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().refreshErrors(req));
    }

    public GetResult<BigDecimal> calcCouponValue(SendRequest<DTOPOSCalcCouponValueRequest> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().calcCouponValue(request));
    }

    public GetResult<ResultDTO> validateCoupon(SendRequest<DTOPaymentMethodInfo> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().validateCoupon(request));
    }

    public GetResult<DTOPOSCompressedReadResp> readFromPOSServerCompressed(SendRequest<DTOPOSReadQueueRequest> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().readFromPOSServerCompressed(request));
    }

    public ListResult<DTOPOSRegisterDocsCodingParam> genDocsCodingParams(SendRequest<DTOPosGenCodingParamsReq> request) throws NaMaServiceExcepption {
        return (ListResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().genDocsCodingParams(request));
    }

    public ServiceResponse readPropertiesFromRegister(SendRequest<DTOPOSReadQueueRequest> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().readPropertiesFromRegister(request));
    }

    public ServiceResponse activePropsReadingFromRegister(SendRequest<String> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().activePropsReadingFromRegister(request));
    }

    public GetResult<DTODocsToPayFromPosEntry> fetchDocToPayInfo(SendRequest<DTODocToPayReq> serviceRequest) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().fetchDocToPayInfo(serviceRequest));
    }

    public GetResult<Long> countDocsToPay(SendRequest<Boolean> serviceRequest) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().countDocsToPay(serviceRequest));
    }

    public ListResult<DTODocsToPayFromPosEntry> fetchListOfDocToPay(SendRequest<DTODocToPayReq> serviceRequest) throws NaMaServiceExcepption {
        return (ListResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().fetchListOfDocToPay(serviceRequest));
    }

    public GetResult<DTONamaPOSSalesInvoice> searchForInvoice(SendRequest<DTOInvoiceFromServerReq> serviceRequest) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().searchForInvoice(serviceRequest));
    }

    public ServiceResponse checkInvRemainingQties(SendRequest<DTOCheckFromInvQtiesReq> serviceRequest) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().checkInvRemainingQties(serviceRequest));
    }

    public ServiceResponse checkQuantitiesForPOS(SendRequest<DTOPOSOverDraftValidationRequest> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().checkQuantitiesForPOS(request));
    }

    public ServiceResponse createPOSItemQtyUpdatersIfNotExist(SendRequest<String> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().createPOSItemQtyUpdatersIfNotExist(request));
    }

    public ListResult<DTONamaPOSItemQtyUpdater> listCurrentPOSQuantities(SendRequest<POSQuantitiesUpdaterReadRequest> request) throws NaMaServiceExcepption {
        return (ListResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().listCurrentPOSQuantities(request));
    }

    public GetResult<String> readFieldAllowedValues(SendRequest<DTOFieldAllowedValuesReq> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().readFieldAllowedValues(request));
    }

    public GetResult<String> requestOTP(SendRequest<DTOPOSRequestOTPRequest> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().requestOTP(request));
    }

    public GetResult<DTODiscountCoupon> redeem(SendRequest<DTORedeemRequest> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().redeem(request));
    }

    public GetResult<String> generatePOSApiKey(ServiceRequest request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().generatePOSApiKey(request));
    }

    public ServiceResponse writePOSOnlineOrder(SendRequest<POSOnlineOrderRequest> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().writePOSOnlineOrder(request));
    }

    public ListResult<POSReadOnlineOrderResponse> readPOSOnlineOrders(SendRequest<String> request) throws NaMaServiceExcepption {
        return (ListResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().readPOSOnlineOrders(request));
    }

    public ServiceResponse deletePOSOnlineOrders(SendRequest<ReprocessInfo> request) throws NaMaServiceExcepption {
        return POSWSClient.execute(() -> POSWSClient.getPOSWS().deletePOSOnlineOrders(request));
    }

    public GetResult<Integer> fetchReturnPeriodExtendedDaysForInvoice(SendRequest<String> request) throws NaMaServiceExcepption {
        return (GetResult)POSWSClient.execute(() -> POSWSClient.getPOSWS().fetchReturnPeriodExtendedDaysForInvoice(request));
    }

    private static <R extends ServiceResponse> R execute(Supplier endpoint) {
        ServiceResponse response;
        try {
            response = (ServiceResponse)endpoint.get();
            POSWSClient.resetElapsedTimeFromLastConnection();
        }
        catch (Exception e) {
            if (!POSDataWriterUtil.isConnectionException(e)) {
                POSWSClient.resetElapsedTimeFromLastConnection();
            }
            throw e;
        }
        return (R)response;
    }

    private static void resetElapsedTimeFromLastConnection() {
        try {
            if (POSResourcesUtil.currentScreen != null && POSResourcesUtil.currentScreen.fetchPaneCreator() != null && POSResourcesUtil.currentScreen.fetchPaneCreator().getToolBar() != null) {
                IPOSToolBar toolBar = (IPOSToolBar)POSResourcesUtil.currentScreen.fetchPaneCreator().getToolBar();
                toolBar.resetElapsedTimeFromLastConnection();
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    static {
        instance = new POSWSClient();
    }
}

