/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.specialserialization.SimpleXMLMarshaller;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;

public class POSXMLSerializer {
    public String objectToXml(Object obj) {
        try {
            JAXBContext context = JAXBContextProvider.newInstance(obj.getClass());
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter xml = new StringWriter();
            m.marshal(obj, (Writer)xml);
            return xml.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T xmlToObject(String xml, Class<T> klass) {
        if (ObjectChecker.isEmptyOrNull((Object)xml)) {
            return null;
        }
        try {
            T unmarshal = this.unmarshal(klass, new ByteArrayInputStream(xml.getBytes("UTF-8")));
            return unmarshal;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T unmarshal(Class<T> klass, InputStream xmlReader) {
        try {
            JAXBContext context = JAXBContextProvider.newInstance(klass);
            Unmarshaller u = context.createUnmarshaller();
            Object returnedObject = u.unmarshal(xmlReader);
            return (T)returnedObject;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static POSXMLSerializer instance() {
        return new POSXMLSerializer();
    }

    public <T> T clone(T original) {
        String xml = SimpleXMLMarshaller.getInstance().marshal(original);
        return (T)this.xmlToObject(xml, original.getClass());
    }

    private static class JAXBContextProvider {
        private static HashMap<String, JAXBContext> cashedContexts = new HashMap();

        private JAXBContextProvider() {
        }

        public static JAXBContext newInstance(Class<?> ... classes) throws JAXBException {
            if (classes == null) {
                return null;
            }
            JAXBContext context = cashedContexts.get(JAXBContextProvider.key(classes));
            if (context == null) {
                context = JAXBContext.newInstance((Class[])classes);
                cashedContexts.put(JAXBContextProvider.key(classes), context);
            }
            return context;
        }

        private static String key(Class<?>[] classes) {
            StringBuilder key = new StringBuilder();
            for (Class<?> class1 : classes) {
                key.append(class1.getName()).append("-");
            }
            return key.toString();
        }

        public static void clearCache() {
            cashedContexts.clear();
        }
    }
}

