/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.constants.Language;
import com.namasoft.common.constants.POSDocsCodePrefix;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.basic.enums.YesNo;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.PaymentDialogHelper;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSCustomerFieldLine;
import com.namasoft.pos.domain.details.POSExtraCodeLine;
import com.namasoft.pos.domain.details.POSFieldFormatLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.details.POSSalesRepalcementLine;
import com.namasoft.pos.domain.details.POSServiceChargeLine;
import com.namasoft.pos.domain.details.PosDeliveryCostLine;
import com.namasoft.pos.domain.details.PosMinChargeLine;
import com.namasoft.pos.domain.details.PosTableLine;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoice;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoiceLine;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSGenericReferenceOverrider;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemQtyUpdateConfig;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSServiceChargeSettings;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.domain.entities.PosDeliveryCost;
import com.namasoft.pos.domain.entities.PosMinCharge;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.specialserialization.ReflectionUtils;
import com.namasoft.utils.ServerSideExceptionDescriber;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PosSalesUtil {
    private static List<POSExtraCodeLine> extraCodes;
    private static List<POSFieldFormatLine> formatLines;
    private static final Set<String> propertiesNotInPOSCustomer;
    private static Map<String, String> namaFieldsWithPOSFields;
    private static PosDeliveryCost deliveryCostSettings;
    private static PosMinCharge minChargeSettings;
    private static POSServiceChargeSettings serviceChargeSettings;

    public static void fromInvoiceAction(AbsPOSSales salesDoc, AbsPOSSales invoice, AbsPosSalesScreen posSalesScreen) {
        salesDoc.setCurrency(invoice.getCurrency());
        salesDoc.setCurrencyRate(invoice.getCurrencyRate());
        salesDoc.setCustomer(invoice.getCustomer());
        salesDoc.setSalesMan(invoice.getSalesMan());
        salesDoc.setDriver(invoice.getDriver());
        salesDoc.setAddressRegion(invoice.getAddressRegion());
        salesDoc.setPosInvoiceClassification(invoice.getPosInvoiceClassification());
        salesDoc.setWarehouse(invoice.getWarehouse());
        salesDoc.setLocation(invoice.getLocation());
        salesDoc.setDiscountPercent(invoice.getDiscountPercent());
        salesDoc.setDiscountValue(invoice.getDiscountValue());
        salesDoc.setNetPrice(invoice.getNetPrice());
        salesDoc.setTotalPrice(invoice.getTotalPrice());
        salesDoc.setPriceClassifier1(invoice.getPriceClassifier1());
        salesDoc.setPriceClassifier2(invoice.getPriceClassifier2());
        salesDoc.setPriceClassifier3(invoice.getPriceClassifier3());
        salesDoc.setPriceClassifier4(invoice.getPriceClassifier4());
        salesDoc.setPriceClassifier5(invoice.getPriceClassifier5());
        salesDoc.setDescription1(invoice.getDescription1());
        salesDoc.setDescription2(invoice.getDescription2());
        salesDoc.setDescription3(invoice.getDescription3());
        salesDoc.setDescription4(invoice.getDescription4());
        salesDoc.setDescription5(invoice.getDescription5());
        salesDoc.setDate1(invoice.getDate1());
        salesDoc.setDate2(invoice.getDate2());
        salesDoc.setDate3(invoice.getDate3());
        salesDoc.setDate4(invoice.getDate4());
        salesDoc.setDate5(invoice.getDate5());
        salesDoc.setN1(invoice.getN1());
        salesDoc.setN2(invoice.getN2());
        salesDoc.setN3(invoice.getN3());
        salesDoc.setN4(invoice.getN4());
        salesDoc.setN5(invoice.getN5());
        salesDoc.setTable(invoice.getTable());
        salesDoc.setRemarks(invoice.getRemarks());
        salesDoc.setStrDeliveryTime(invoice.getStrDeliveryTime());
        salesDoc.setDeliveryDate(invoice.getDeliveryDate());
        salesDoc.updateTables(invoice.fetchTables().stream().map(t -> new PosTableLine(t.getPosTable().getId())).collect(Collectors.toList()));
        List fromInvoiceLines = PosSalesUtil.mergeLines(invoice.fetchDetails());
        if (ObjectChecker.isNotEmptyOrNull(fromInvoiceLines) && fromInvoiceLines.get(0) instanceof POSSalesInvoiceLine) {
            fromInvoiceLines = CollectionsUtility.filter(fromInvoiceLines, object -> object.getQty().getValue().compareTo(object.getReturnedQty()) > 0);
        }
        List returnLines = CollectionsUtility.convert(fromInvoiceLines, object -> {
            Object returnOrReplcementLine = salesDoc.createBasicLine();
            PosSalesUtil.copySalesLine(object, returnOrReplcementLine, salesDoc);
            return returnOrReplcementLine;
        });
        salesDoc.fetchDetails().clear();
        posSalesScreen.getSalesTable().getItems().clear();
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        Boolean doNotDisplayReturnedLines = PosSalesUtil.shouldNotDisplayReturnedLines(register);
        if (ObjectChecker.isAnyEqualToFirst((Object)((Object)salesDoc.docType()), (Object[])new POSDocumentType[]{POSDocumentType.Return, POSDocumentType.Replacement}) && doNotDisplayReturnedLines.booleanValue()) {
            salesDoc.fetchInvLines().addAll(fromInvoiceLines);
        } else {
            doNotDisplayReturnedLines = false;
            salesDoc.fetchDetails().addAll(returnLines);
        }
        for (int i = 0; i < returnLines.size() && !doNotDisplayReturnedLines.booleanValue(); ++i) {
            AbsPOSSalesLine absPOSSalesLine = (AbsPOSSalesLine)returnLines.get(i);
            if (salesDoc instanceof POSSalesReplacement) {
                absPOSSalesLine.getQty().setValue(absPOSSalesLine.getQty().getValue().negate());
                ((POSSalesRepalcementLine)absPOSSalesLine).setReturnedLine(true);
            }
            salesDoc.updateLineValues(absPOSSalesLine);
            posSalesScreen.getSalesTable().getItems().add((Object)absPOSSalesLine);
        }
        posSalesScreen.setCurrentLine(-2);
        posSalesScreen.updateFieldsEvent(Arrays.asList("details", "totalPrice", "discountP", "discountV", "customer", "currency", "currencyRate", "warehouse", "location", "salesMan", "driver", "addressRegion", "posInvoiceClassification", "table", "docCategory", "priceClassifier1", "priceClassifier2", "priceClassifier3", "priceClassifier4", "priceClassifier5", "fromInvCode"), salesDoc);
    }

    private static boolean shouldNotDisplayReturnedLines(POSRegistery register) {
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanDisplayReturnedLinesWhenSelectingInv).isFailed().booleanValue()) {
            return true;
        }
        return ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{register.getDoNotDisplayReturnedLinesWhenSelectingInv(), POSResourcesUtil.fetchPOSConfig().getDoNotDisplayReturnedLinesWhenSelectingInv()});
    }

    public static void copySalesLine(AbsPOSSalesLine line, AbsPOSSalesLine copy, AbsPOSSales salesDoc) {
        copy.assignIds();
        copy.updateInvoice(salesDoc);
        POSItem item = line.getItem();
        if (item == null) {
            item = (POSItem)POSPersister.findByCode(POSItem.class, line.getItemCode());
        }
        copy.setItem(item);
        if (ObjectChecker.isNotEmptyOrNull((Object)item)) {
            copy.setItemName((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{line.getItemName(), item.nameByLanguage()}));
            copy.setItemCode((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{line.getItemCode(), item.getCode()}));
        }
        copy.setQty(new POSQuantity(line.getQty().getValue(), line.getQty().getUom()));
        copy.setUnitPrice(line.getUnitPrice());
        copy.setTotalPrice(line.getTotalPrice());
        copy.setDiscount1(line.getDiscount1());
        copy.setDiscount2(line.getDiscount2());
        copy.setDiscount3(line.getDiscount3());
        copy.setDiscount4(line.getDiscount4());
        copy.setDiscount5(line.getDiscount5());
        copy.setDiscount6(line.getDiscount6());
        copy.setDiscount7(line.getDiscount7());
        copy.setDiscount8(line.getDiscount8());
        copy.setTax1(line.getTax1());
        copy.setTax2(line.getTax2());
        copy.setNetPrice(line.getNetPrice());
        BigDecimal returnedQty = BigDecimal.ZERO;
        if (line instanceof POSSalesInvoiceLine) {
            returnedQty = ((POSSalesInvoiceLine)line).getReturnedQty();
        }
        copy.getQty().setValue(line.getQty().getValue().subtract(returnedQty));
        if (copy instanceof IPOSDocFromInvoiceLine) {
            ((IPOSDocFromInvoiceLine)((Object)copy)).setInvoiceLineId(line.getId());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions())) {
            POSItemSpecificDimensions dimensions = new POSItemSpecificDimensions();
            dimensions.setColor(line.getItemDimensions().getColor());
            dimensions.setBox(line.getItemDimensions().getBox());
            dimensions.setColorName(line.getItemDimensions().getColorName());
            dimensions.setLotId(line.getItemDimensions().getLotId());
            dimensions.setRevisionId(line.getItemDimensions().getRevisionId());
            dimensions.setSerialNumber(line.getItemDimensions().getSerialNumber());
            dimensions.setSecondSerial(line.getItemDimensions().getSecondSerial());
            dimensions.setSize(line.getItemDimensions().getSize());
            dimensions.setSizeName(line.getItemDimensions().getSizeName());
            copy.setItemDimensions(dimensions);
        }
        copy.setCurrency(line.getCurrency());
        copy.setFreeLine(line.getFreeLine());
        if (ObjectChecker.isNotEmptyOrNull((Object)line.getLocation())) {
            copy.setLocation(POSPersister.findByID(POSLocation.class, line.getLocation().getId()));
        }
        copy.setProductionDate(line.getProductionDate());
        copy.setExpiryDate(line.getExpiryDate());
        copy.setRemarks(line.getRemarks());
        copy.setFromFreeItemsOnInvoiceOffer(line.getFromFreeItemsOnInvoiceOffer());
    }

    private static <T extends AbsPOSSalesLine> List<T> mergeLines(List<T> returnLines) {
        return PosSalesUtil.mergeLines(returnLines, line -> PosSalesUtil.generateKey(line));
    }

    public static <T extends AbsPOSSalesLine> List<T> mergeLines(List<T> returnLines, Function<AbsPOSSalesLine, String> keyGenerator) {
        ArrayList<Object> lines = new ArrayList<Object>();
        HashMap map = new HashMap();
        int i = 0;
        for (Object line : returnLines) {
            if (((AbsPOSSalesLine)line).getFreeLine().booleanValue()) {
                lines.add(line);
                ++i;
                continue;
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)((AbsPOSSalesLine)line).getItemCode())) {
                String string = keyGenerator.apply((AbsPOSSalesLine)line);
                if (map.containsKey(string)) {
                    List list = (List)map.get(string);
                    list.add(i);
                } else {
                    ArrayList<Integer> indeces = new ArrayList<Integer>();
                    indeces.add(i);
                    map.put(string, indeces);
                }
            }
            ++i;
        }
        int j = lines.size();
        for (Map.Entry entry : map.entrySet()) {
            AbsPOSSalesLine invoiceLine = (AbsPOSSalesLine)returnLines.get((Integer)((List)entry.getValue()).get(0));
            lines.add(invoiceLine);
            BigDecimal value = BigDecimal.ZERO;
            Object srcLineIds = "";
            for (Integer lineIndex : (List)entry.getValue()) {
                value = value.add(((AbsPOSSalesLine)returnLines.get(lineIndex)).getQty().getValue());
                srcLineIds = (String)srcLineIds + (String)(ObjectChecker.isEmptyOrNull((Object)((AbsPOSSalesLine)returnLines.get(lineIndex)).getId()) ? "" : ((AbsPOSSalesLine)returnLines.get(lineIndex)).getId().toString() + "_#_");
            }
            ((AbsPOSSalesLine)lines.get(j)).getQty().setValue(value);
            ((AbsPOSSalesLine)lines.get(j)).updateItemsCountOfferSrcIds((String)srcLineIds);
            ++j;
        }
        for (int k = lines.size() - 1; k >= 0; --k) {
            if (((AbsPOSSalesLine)lines.get(k)).getQty().getValue().compareTo(BigDecimal.ZERO) > 0) continue;
            lines.remove(k);
        }
        return lines;
    }

    public static String generateKey(AbsPOSSalesLine line) {
        String itemId = ServerStringUtils.toUUIDStr((Object)line.getItem().getId());
        String uomId = ServerStringUtils.toUUIDStr((Object)line.getQty().getUom().getId());
        String colorCode = "";
        String sizeCode = "";
        String revCode = "";
        String lotIdCode = "";
        String serialCode = "";
        String boxCode = "";
        if (ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions())) {
            if (ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getColor())) {
                colorCode = line.getItemDimensions().getColor().toString();
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getSize())) {
                sizeCode = line.getItemDimensions().getSize().toString();
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getRevisionId())) {
                revCode = line.getItemDimensions().getRevisionId().toString();
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getLotId())) {
                lotIdCode = line.getItemDimensions().getLotId().toString();
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getSerialNumber())) {
                serialCode = line.getItemDimensions().getSerialNumber().toString();
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)line.getItemDimensions().getBox())) {
                boxCode = line.getItemDimensions().getBox().toString();
            }
        }
        String key = itemId + "#" + uomId + "#" + colorCode + "#" + sizeCode + "#" + revCode + "#" + lotIdCode + "#" + serialCode + "#" + boxCode;
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getTax1().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getTax2().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getDiscount1().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getDiscount2().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getDiscount3().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getDiscount4().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getDiscount5().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getDiscount6().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getDiscount7().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getDiscount8().getPercentage()));
        key = key + "#" + String.valueOf(ObjectChecker.toZeroIfNull((BigDecimal)line.getPrice().getUnitPrice()));
        return key;
    }

    public static void updateFromInvoice(IPOSDocFromInvoice returnOrReplacement, POSSalesInvoice posSalesInvoice) {
        returnOrReplacement.setFromInvCode(posSalesInvoice.getCode());
        returnOrReplacement.setFromInvoiceId(posSalesInvoice.getId());
        for (AbsPOSSalesLine absPOSSalesLine : returnOrReplacement.fetchDetails()) {
            POSSalesInvoiceLine sourceLine = PosSalesUtil.fetchInvoiceSourceLine(posSalesInvoice, (IPOSDocFromInvoiceLine)((Object)absPOSSalesLine));
            if (!ObjectChecker.isNotEmptyOrNull((Object)sourceLine)) continue;
            sourceLine.setReturnedQty(sourceLine.getReturnedQty().add(absPOSSalesLine.getQty().getValue()));
        }
        if (posSalesInvoice.totalyReturned()) {
            posSalesInvoice.setReturnBefore(true);
        }
    }

    private static POSSalesInvoiceLine fetchInvoiceSourceLine(POSSalesInvoice posSalesInvoice, IPOSDocFromInvoiceLine returnOrReplacementLine) {
        for (POSSalesInvoiceLine invoiceLine : posSalesInvoice.getDetails()) {
            if (!ObjectChecker.areEqual((Object)invoiceLine.getId(), (Object)returnOrReplacementLine.getInvoiceLineId())) continue;
            return invoiceLine;
        }
        return null;
    }

    public static POSSalesInvoice searchForInvoiceLocally(String invCode, String invoiceId, POSResult result) {
        List<String> codes;
        POSResult capResult;
        POSSalesInvoice invoice = null;
        if (invoiceId != null) {
            invoice = POSPersister.findByID(POSSalesInvoice.class, invoiceId);
        }
        if (invoice == null) {
            invoice = (POSSalesInvoice)POSPersister.findByCode(POSSalesInvoice.class, invCode);
        }
        if (ObjectChecker.isEmptyOrNull(invoice) && !(capResult = POSSecurityUtil.userCan(POSSecurityCapability.CanSearchByInvCodePart)).isFailed().booleanValue() && ObjectChecker.isNotEmptyOrNull(codes = PosSalesUtil.searchForCodePart(invCode, POSSalesInvoice.class))) {
            invCode = codes.get(0);
            invoice = (POSSalesInvoice)POSPersister.findByCode(POSSalesInvoice.class, invCode);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)invoice)) {
            if (invoice.getHold() || invoice.getReturnBefore().booleanValue()) {
                result.failure("Invoice: {0} was held or returned before", invoice.getCode());
            }
        } else {
            result.failure(POSResourcesUtil.id("InvalidCodeOrPreventedOperation", new Object[0]), new Object[0]);
        }
        return invoice;
    }

    private static List<String> searchForCodePart(String invCode, Class<?> klass) {
        String patternCode = "";
        if (ObjectChecker.areEqual(klass, POSSalesInvoice.class)) {
            patternCode = POSDocsCodePrefix.InvoicePrefix;
        }
        if (ObjectChecker.areEqual(klass, POSOrderReservation.class)) {
            patternCode = POSDocsCodePrefix.ReservationPrefix;
        }
        if (ObjectChecker.areEqual(klass, POSSalesReturn.class)) {
            patternCode = POSDocsCodePrefix.ReturnPrefix;
        }
        if (ObjectChecker.areEqual(klass, POSSalesReplacement.class)) {
            patternCode = POSDocsCodePrefix.ReplacementPrefix;
        }
        patternCode = patternCode.concat(POSResourcesUtil.fetchMainRegister().getCode());
        return POSPersister.searchFor("SELECT code FROM " + klass.getSimpleName() + " where (code like '" + patternCode + "%' and code like '%" + invCode + "')or (code like '" + POSGeneralSettings.codePrefix() + patternCode + "%' and code like '%" + invCode + "')");
    }

    public static POSRegistery findRegisterByCode(String invCode, String registerCode) {
        POSRegistery register;
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{invCode, registerCode})) {
            return null;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)registerCode) && (register = (POSRegistery)POSPersister.findByCode(POSRegistery.class, registerCode)) != null) {
            return register;
        }
        List<?> registers = POSPersister.searchFor("from " + POSRegistery.class.getSimpleName() + " where :code like code +'%'", POSPersister.params("code", invCode.substring(1)));
        return (POSRegistery)CollectionsUtility.getFirst(registers);
    }

    public static List<POSSalesInvoice> collectHoldInvoices(POSItemQtyUpdateConfig config, POSWarehouse warehouse, POSLocation location, UUID exceptId, List<POSItem> items, POSResult result) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return POSPersister.searchFor(PosSalesUtil.createInvoiceCriteria(config, warehouse, location, exceptId, true, null, params, items, result), params).stream().distinct().collect(Collectors.toList());
    }

    public static List<POSSalesInvoice> collectActualInvoiceAfterDate(POSItemQtyUpdateConfig config, POSWarehouse warehouse, POSLocation location, UUID exceptId, Date afterDate, List<POSItem> items, POSResult result) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return POSPersister.searchFor(PosSalesUtil.createInvoiceCriteria(config, warehouse, location, exceptId, false, afterDate, params, items, result), params).stream().distinct().collect(Collectors.toList());
    }

    private static String createInvoiceCriteria(POSItemQtyUpdateConfig config, POSWarehouse warehouse, POSLocation location, UUID exceptId, boolean hold, Date afterDate, Map<String, Object> params, List<POSItem> items, POSResult result) {
        String tableName = POSSalesInvoice.class.getSimpleName();
        StringBuilder query = new StringBuilder("select h from ".concat(tableName).concat(" h join h.details details where h.hold = :hold and h.id <> :invoiceId"));
        params.put("hold", hold);
        params.put("invoiceId", exceptId);
        if (afterDate != null) {
            query.append(" and (h.valueDate > :afterDate or (h.valueDate = :afterDate and h.creationDate > :afterDateTime))");
            params.put("afterDate", afterDate);
            params.put("afterDateTime", afterDate);
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderWarehouse())) {
            if (warehouse == null) {
                warehouse = POSResourcesUtil.fetchMainRegister().getWarehouse();
            }
            if (warehouse == null) {
                ResultDTO fail = ResultDTO.fail();
                fail.setArabicMessage("\u064a\u0631\u062c\u0649 \u0625\u062f\u062e\u0627\u0644 \u0627\u0644\u0645\u062e\u0632\u0646");
                fail.setEnglishMessage("Please enter the warehouse");
                result.accumulate(new POSResult().failure(fail));
            } else {
                query.append(" and h.warehouse = :warehouseId");
                params.put("warehouseId", warehouse);
            }
        }
        if (ObjectChecker.isFalseOrNull((Boolean)config.isDoNotConsiderLocator()) && location != null) {
            query.append(" and h.location = :locationId");
            params.put("locationId", location);
        }
        if (ObjectChecker.isNotEmptyOrNull(items)) {
            query.append(" and details.item in :items");
            params.put("items", items);
        }
        return query.toString();
    }

    public static List<POSFieldFormatLine> getFormatLines() {
        if (formatLines == null) {
            PosSalesUtil.updateGenericReferenceOverriderData();
        }
        return formatLines;
    }

    public static List<POSExtraCodeLine> getExtraCodes() {
        if (extraCodes == null) {
            PosSalesUtil.updateGenericReferenceOverriderData();
        }
        return extraCodes;
    }

    public static void updateGenericReferenceOverriderData() {
        List<POSGenericReferenceOverrider> overriders = POSPersister.listAll(POSGenericReferenceOverrider.class);
        extraCodes = new ArrayList<POSExtraCodeLine>();
        formatLines = new ArrayList<POSFieldFormatLine>();
        if (ObjectChecker.isEmptyOrNull(overriders)) {
            return;
        }
        extraCodes = overriders.stream().flatMap(o -> o.getExtraCodes().stream()).collect(Collectors.toList());
        formatLines = overriders.stream().flatMap(o -> o.getFieldFormats().stream()).collect(Collectors.toList());
    }

    public static List<String> validateAndCreateIfNeeded(POSRegistery register, POSCustomer customer) {
        ArrayList<String> errors = new ArrayList<String>();
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{customer.getCode(), customer.getName1(), customer.getAddress(), customer.getArea(), customer.getPhoneNumber(), customer.getResidency()})) {
            errors.add("Empty Information");
        }
        PosSalesUtil.checkRequiredFields(customer, errors);
        POSResult posResult = PosSalesUtil.checkCustomerFieldFormats(customer);
        if (posResult.isFailed().booleanValue()) {
            errors.add(posResult.getMessageByLanguage());
        }
        if (ObjectChecker.isNotEmptyOrNull(errors)) {
            return errors;
        }
        if (PosScene.connectionIsUp()) {
            PosSalesUtil.sendCustomerToServerThenSave(register, customer, errors);
        } else if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotAddCustomerWhenOffline())) {
            POSPersister.saveOrUpdateWithActionHistory(customer, null);
        }
        return errors;
    }

    private static void checkRequiredFields(POSCustomer customer, List<String> errors) {
        for (POSCustomerFieldLine line : POSUISettingsUtil.getPosUISettings().getCustomerFields()) {
            if (ObjectChecker.isFalse((Boolean)line.getRequired())) continue;
            try {
                String field = StringUtils.firstLetterUpper((String)line.getField());
                Method method = POSCustomer.class.getMethod("get" + field, null);
                Object val = method.invoke((Object)customer, new Object[0]);
                if (!ObjectChecker.isEmptyOrNull((Object)val)) continue;
                errors.add(field + " is required");
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
            }
        }
    }

    private static POSResult checkCustomerFieldFormats(POSCustomer posCustomer) {
        POSResult posResult = new POSResult();
        List<POSGenericReferenceOverrider> overriders = POSPersister.listAll(POSGenericReferenceOverrider.class);
        if (ObjectChecker.isEmptyOrNull(overriders)) {
            return posResult;
        }
        for (POSGenericReferenceOverrider overrider : overriders) {
            PosSalesUtil.checkCustomerFieldFormats(posCustomer, null, overrider.getFieldFormats(), posResult);
        }
        return posResult;
    }

    public static POSResult checkCustomerFieldFormats(String fieldId, String fieldValue, List<POSFieldFormatLine> formats) {
        POSResult posResult = new POSResult();
        if (ObjectChecker.isEmptyOrNull(formats = formats.stream().filter(l -> ObjectChecker.areEqual((Object)l.getFieldID(), (Object)fieldId)).collect(Collectors.toList()))) {
            posResult.setFailed(true);
            return posResult;
        }
        PosSalesUtil.checkCustomerFieldFormats(null, fieldValue, formats, posResult);
        return posResult;
    }

    public static POSResult checkCustomerFieldFormats(POSCustomer posCustomer, String fieldValue, List<POSFieldFormatLine> formats, POSResult result) {
        for (POSFieldFormatLine formatLine : formats) {
            if (formatLine.getFieldID() == null) continue;
            try {
                String fieldId = PosSalesUtil.constructNamaWithPOSTypesMap().get(formatLine.getFieldID());
                String posFieldId = fieldId == null ? formatLine.getFieldID() : fieldId;
                String value = PosSalesUtil.calcFieldValue(posCustomer, fieldValue, posFieldId);
                if (ObjectChecker.isEmptyOrNull((Object)value)) continue;
                value = value.trim();
                if (ObjectChecker.isNotEmptyOrNull((Object)formatLine.getPrefix()) && !value.startsWith(formatLine.getPrefix())) {
                    result.failure(POSResourcesUtil.id(posFieldId, new Object[0]) + " - " + POSResourcesUtil.id("must start with", new Object[0]) + " " + formatLine.getPrefix(), new Object[0]);
                }
                if (ObjectChecker.isNotEmptyOrNull((Object)formatLine.getSuffix()) && !value.endsWith(formatLine.getSuffix())) {
                    result.failure(POSResourcesUtil.id(posFieldId, new Object[0]) + " - " + POSResourcesUtil.id("must end with", new Object[0]) + " " + formatLine.getSuffix(), new Object[0]);
                }
                if (ObjectChecker.isNotEmptyOrZero((Integer)formatLine.getMinLength()) && value.length() < formatLine.getMinLength()) {
                    result.failure(POSResourcesUtil.id(posFieldId, new Object[0]) + " - " + POSResourcesUtil.id("minimum length is", new Object[0]) + " " + formatLine.getMinLength(), new Object[0]);
                }
                if (ObjectChecker.isNotEmptyOrZero((Integer)formatLine.getMaxLength()) && value.length() > formatLine.getMaxLength()) {
                    result.failure(POSResourcesUtil.id(posFieldId, new Object[0]) + " - " + POSResourcesUtil.id("maximum length is", new Object[0]) + " " + formatLine.getMaxLength(), new Object[0]);
                }
                if (!formatLine.getAllowNumbers().booleanValue() && PosSalesUtil.containNumbers(value)) {
                    result.failure(POSResourcesUtil.id(posFieldId, new Object[0]) + " - " + POSResourcesUtil.id("cannot contain numbers", new Object[0]), new Object[0]);
                }
                if (!formatLine.getAllowAlpha().booleanValue() && PosSalesUtil.containChars(value)) {
                    result.failure(POSResourcesUtil.id(posFieldId, new Object[0]) + " - " + POSResourcesUtil.id("cannot contain characters", new Object[0]), new Object[0]);
                }
                if (!ObjectChecker.isNotEmptyOrNull((Object)formatLine.getLetterCaseType())) continue;
                if (ObjectChecker.areEqual((Object)formatLine.getLetterCaseType(), (Object)"LowerCase") && PosSalesUtil.isUpperCase(value)) {
                    result.failure(POSResourcesUtil.id(posFieldId, new Object[0]) + " " + POSResourcesUtil.id("contains upper case characters", new Object[0]), new Object[0]);
                    continue;
                }
                if (!ObjectChecker.areEqual((Object)formatLine.getLetterCaseType(), (Object)"UpperCase") || !PosSalesUtil.isLowerCase(value)) continue;
                result.failure(POSResourcesUtil.id(posFieldId, new Object[0]) + " " + POSResourcesUtil.id("contains lower case characters", new Object[0]), new Object[0]);
            }
            catch (Exception e) {
                result.failure("There is problem, Please check the log file for more details", new Object[0]);
                NaMaLogger.error((Throwable)e);
            }
        }
        return result;
    }

    private static String calcFieldValue(POSCustomer posCustomer, String fieldValue, String posFieldId) {
        String value = fieldValue;
        if (propertiesNotInPOSCustomer.contains(posFieldId)) {
            return value;
        }
        try {
            if (ObjectChecker.isEmptyOrNull((Object)value) && posCustomer != null) {
                value = (String)ReflectionUtils.getFieldValue((String)posFieldId, (Object)posCustomer);
            }
        }
        catch (Exception e) {
            propertiesNotInPOSCustomer.add(posFieldId);
            return value;
        }
        return value;
    }

    private static boolean containChars(String fieldValue) {
        for (int i = 0; i < fieldValue.length(); ++i) {
            if (Character.isDigit(fieldValue.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean containNumbers(String fieldValue) {
        for (int i = 0; i < fieldValue.length(); ++i) {
            if (!Character.isDigit(fieldValue.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isUpperCase(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isAlphabetic(value.charAt(i)) || !Character.isLowerCase(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isLowerCase(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isAlphabetic(value.charAt(i)) || !Character.isUpperCase(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> constructNamaWithPOSTypesMap() {
        if (namaFieldsWithPOSFields != null) {
            return namaFieldsWithPOSFields;
        }
        namaFieldsWithPOSFields = new ConcurrentHashMap<String, String>();
        namaFieldsWithPOSFields.put("contactInfo.mobile", "phoneNumber");
        namaFieldsWithPOSFields.put("contactInfo.address.address1", "address");
        namaFieldsWithPOSFields.put("contactInfo.address.area", "area");
        namaFieldsWithPOSFields.put("residency.number", "residency");
        namaFieldsWithPOSFields.put("taxInfo.taxRegNo", "taxRegNo");
        return namaFieldsWithPOSFields;
    }

    public static List<UUID> customerToIds(POSCustomer c) {
        ArrayList<UUID> list = new ArrayList<UUID>();
        if (c == null) {
            return list;
        }
        list.add(c.getId());
        if (c.getCustomerClass() != null) {
            list.add(c.getCustomerClass().getId());
        }
        return list;
    }

    private static void sendCustomerToServerThenSave(POSRegistery register, POSCustomer customer, List<String> errors) {
        BorderPaneCreator.setProgressIndicatorVisibility(true);
        ArrayList<ServiceResponse> serviceResponses = POSDataWriterUtil.notSynchronizedWriteSingleDoc(register, POSDataWriterUtil.customerPreparator(register), customer);
        if (ObjectChecker.isNotEmptyOrNull(serviceResponses) && ((ServiceResponse)serviceResponses.getFirst()).succeded()) {
            POSPersister.saveOrUpdateWithActionHistory(customer, null);
        } else if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotAddCustomerWhenOffline())) {
            POSResult result = POSPersister.saveOrUpdateWithActionHistory(customer, null);
            if (result.isFailed().booleanValue()) {
                errors.add(result.getMessageByLanguage());
            }
            for (ServiceResponse response : serviceResponses) {
                POSDataWriterUtil.saveErrorAndShowNotification(register, customer, response.getResult(), customer.calcNamaEntityType(), false);
            }
        } else {
            errors.addAll(serviceResponses.stream().map(r -> ServerSideExceptionDescriber.describeResult((ResultDTO)r.getResult(), (Language)POSResourcesUtil.getCurrentLang())).toList());
            if (ObjectChecker.isEmptyOrNull(errors)) {
                errors.add(POSResourcesUtil.id("\n Can not transfer customer to server, Please review send errors \n", new Object[0]));
            }
        }
        BorderPaneCreator.setProgressIndicatorVisibility(false);
    }

    public static POSResult addOrRemoveMinChargeItemIfNeeded(AbsPosSalesScreen screen, AbsPOSSales salesDoc) {
        POSResult result = new POSResult();
        PosMinCharge minCharge = PosSalesUtil.fetchMinChargeSettings();
        if (minCharge == null) {
            return result;
        }
        for (PosMinChargeLine detail : minCharge.getDetails()) {
            if (!salesDoc.posMinChargeLineMatched(detail)) continue;
            PaymentDialogHelper.minChargeItemMustBeReCalculated(salesDoc, screen, result);
            return result;
        }
        salesDoc.removeMinChargeItem(screen);
        return result;
    }

    public static POSResult addOrRemoveServiceItemIfNeeded(AbsPosSalesScreen screen, AbsPOSSales salesDoc) {
        POSResult result = new POSResult();
        POSServiceChargeSettings serviceCharge = PosSalesUtil.fetchServiceChargeSettings();
        if (serviceCharge == null) {
            return result;
        }
        for (POSServiceChargeLine detail : serviceCharge.getDetails()) {
            if (!salesDoc.posServiceChargeLineMatched(detail)) continue;
            PosSalesUtil.addServiceItemToInvoice(screen, salesDoc, result);
            return result;
        }
        salesDoc.removeServiceItem(screen);
        return result;
    }

    public static POSResult addOrRemoveDeliveryItemIfNeeded(AbsPosSalesScreen screen, AbsPOSSales salesDoc) {
        POSResult result = new POSResult();
        PosDeliveryCost deliveryCost = PosSalesUtil.fetchDeliveryCostSettings();
        if (deliveryCost == null) {
            return result;
        }
        for (PosDeliveryCostLine detail : deliveryCost.getDetails()) {
            if (!salesDoc.posDeliveryCostLineMatched(detail)) continue;
            PosSalesUtil.addDeliveryItemToInvoice(screen, salesDoc, result);
            return result;
        }
        salesDoc.removeDeliveryItem(screen);
        return result;
    }

    public static POSResult addDeliveryItemToInvoice(AbsPosSalesScreen screen, AbsPOSSales salesDoc, POSResult result) {
        boolean isReservation = ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{salesDoc instanceof POSOrderReservation, salesDoc instanceof PosCancelReservation});
        if (isReservation && ObjectChecker.areNotEqual((Object)POSResourcesUtil.fetchPOSConfig().getEnableDeliveryCostInPOSReservationDoc(), (Object)YesNo.Yes)) {
            return result;
        }
        return PosSalesUtil.addServiceItemToInvoice(false, screen, salesDoc, result);
    }

    public static POSResult addServiceItemToInvoice(AbsPosSalesScreen screen, AbsPOSSales salesDoc, POSResult result) {
        boolean isReservation = ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{salesDoc instanceof POSOrderReservation, salesDoc instanceof PosCancelReservation});
        if (isReservation && ObjectChecker.areNotEqual((Object)POSResourcesUtil.fetchPOSConfig().getEnableServiceChargeInPOSReservationDoc(), (Object)YesNo.Yes)) {
            return result;
        }
        return PosSalesUtil.addServiceItemToInvoice(true, screen, salesDoc, result);
    }

    public static POSResult addServiceItemToInvoice(boolean isServiceItem, AbsPosSalesScreen screen, AbsPOSSales salesDoc, POSResult posResult) {
        String msg;
        POSItem item = isServiceItem ? AbsPOSSales.fetchServiceItem() : AbsPOSSales.fetchDeliveryItem();
        String string = msg = isServiceItem ? "No service item defined" : "No delivery item defined";
        if (item == null) {
            return posResult.failure(msg, new Object[0]);
        }
        AbsPOSSalesLine line = PosSalesUtil.fetchItemLine(salesDoc, item);
        if (line != null) {
            salesDoc.calcUnitPriceAndFreeLines(POSResourcesUtil.fetchMainRegister(), line, false, screen);
            return posResult;
        }
        salesDoc.addSalesLine(POSResourcesUtil.fetchMainRegister(), item.getCode(), salesDoc.fetchDetails().size(), BigDecimal.ONE, true, screen, posResult);
        return posResult;
    }

    private static AbsPOSSalesLine fetchItemLine(AbsPOSSales salesDoc, POSItem item) {
        for (AbsPOSSalesLine absPOSSalesLine : salesDoc.fetchDetails()) {
            if (!ObjectChecker.areEqual((Object)absPOSSalesLine.getItem().getId(), (Object)item.getId())) continue;
            return absPOSSalesLine;
        }
        return null;
    }

    public static PosDeliveryCost fetchDeliveryCostSettings() {
        if (deliveryCostSettings != null) {
            return deliveryCostSettings;
        }
        deliveryCostSettings = (PosDeliveryCost)ObjectChecker.getFirstNotNullObj((Object[])new PosDeliveryCost[]{POSResourcesUtil.fetchMainRegister().getDeliveryCost(), (PosDeliveryCost)POSSavable.staticFromReference(POSResourcesUtil.fetchPOSConfig().getDeliveryCost())});
        return deliveryCostSettings;
    }

    public static PosMinCharge fetchMinChargeSettings() {
        if (minChargeSettings != null) {
            return minChargeSettings;
        }
        minChargeSettings = (PosMinCharge)ObjectChecker.getFirstNotNullObj((Object[])new PosMinCharge[]{POSResourcesUtil.fetchMainRegister().getMinChargeSettings(), (PosMinCharge)POSSavable.staticFromReference(POSResourcesUtil.fetchPOSConfig().getMinChargeSettings())});
        return minChargeSettings;
    }

    public static POSServiceChargeSettings fetchServiceChargeSettings() {
        if (serviceChargeSettings != null) {
            return serviceChargeSettings;
        }
        serviceChargeSettings = (POSServiceChargeSettings)ObjectChecker.getFirstNotNullObj((Object[])new POSServiceChargeSettings[]{POSResourcesUtil.fetchMainRegister().getServiceChargeSettings(), (POSServiceChargeSettings)POSSavable.staticFromReference(POSResourcesUtil.fetchPOSConfig().getServiceChargeSettings())});
        return serviceChargeSettings;
    }

    public static void evictChargeItemsAndDeliveryCostCache() {
        deliveryCostSettings = null;
        minChargeSettings = null;
        serviceChargeSettings = null;
    }

    static {
        propertiesNotInPOSCustomer = new HashSet<String>();
        deliveryCostSettings = null;
        minChargeSettings = null;
        serviceChargeSettings = null;
    }
}

