/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.tablecells.POSTableCell;
import com.namasoft.pos.application.NamaObservable;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSTableColumn;
import java.beans.PropertyDescriptor;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Rectangle2D;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;

public class TableCellCreatorUtil {
    private static Rectangle2D primaryScreenBounds = Rectangle2D.EMPTY;
    private static Double defaultCellWidth = primaryScreenBounds.getWidth() / 10.0;
    private Class onKlass;

    public static Rectangle2D getPrimaryScreenBounds() {
        return primaryScreenBounds;
    }

    public static Double getDefaultCellWidth() {
        return defaultCellWidth;
    }

    public TableCellCreatorUtil(Rectangle2D primaryScreenBounds, double defaultCellWidth, Class onKlass) {
        TableCellCreatorUtil.primaryScreenBounds = primaryScreenBounds;
        TableCellCreatorUtil.defaultCellWidth = defaultCellWidth;
        this.onKlass = onKlass;
    }

    public List<POSTableColumn> createColumns(List<String> fields) {
        return this.createColumns(fields, new ArrayList<Double>());
    }

    public List<POSTableColumn> createColumns(List<String> fields, List<Double> divisors) {
        ArrayList<POSTableColumn> tableColumns = new ArrayList<POSTableColumn>();
        for (int i = 0; i < fields.size(); ++i) {
            String columnName = fields.get(i);
            Double divisor = divisors.size() > i ? divisors.get(i) : 0.0;
            POSTableColumn column = new POSTableColumn(TableCellCreatorUtil.getDefaultCellWidth(), TableCellCreatorUtil.getPrimaryScreenBounds(), divisor, columnName);
            column.setId(columnName);
            boolean booleanCol = POSMasterFile.fieldIsFromType(columnName, this.onKlass, Boolean.class);
            column.setCellValueFactory(param -> {
                try {
                    Object invoke = new PropertyDescriptor(columnName, ((TableColumn.CellDataFeatures)param).getValue().getClass()).getReadMethod().invoke(((TableColumn.CellDataFeatures)param).getValue(), new Object[0]);
                    if (booleanCol) {
                        invoke = ObjectChecker.isTrue((Boolean)((Boolean)invoke));
                        CheckBox checkBox = new CheckBox();
                        checkBox.setDisable(true);
                        checkBox.setStyle("-fx-opacity: 1");
                        checkBox.selectedProperty().setValue((Boolean)invoke);
                        return new SimpleObjectProperty((Object)checkBox);
                    }
                    if (ObjectChecker.isNotEmptyOrNull((Object)invoke)) {
                        if (POSMasterFile.class.isInstance(invoke)) {
                            return new NamaObservable<CallSite>((CallSite)((Object)(((POSMasterFile)invoke).getCode() + " - " + ((POSMasterFile)invoke).nameByLanguage())));
                        }
                        if (Collection.class.isInstance(invoke)) {
                            return new NamaObservable<String>(((Collection)invoke).stream().map(e -> e.toString()).collect(Collectors.joining(", ")));
                        }
                        return new NamaObservable<Object>(invoke);
                    }
                }
                catch (Exception e2) {
                    NaMaLogger.error((Throwable)e2);
                }
                return null;
            });
            if (!booleanCol) {
                column.setCellFactory(POSTableCell.defaultCellFactory());
                if (POSMasterFile.fieldIsFromType(columnName, this.onKlass, BigDecimal.class)) {
                    column.setCellFactory(POSTableCell.stringBigDecimalConverter());
                }
            }
            tableColumns.add(column);
        }
        return tableColumns;
    }
}

