/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.layout.metadata.CustomGUIComponentsMetadata;
import com.namasoft.common.layout.metadata.EntityFieldPair;
import com.namasoft.common.layout.metadata.FieldTooltipInfo;
import com.namasoft.common.layout.metadata.FieldTooltipInfoRefList;
import com.namasoft.common.layout.metadata.TooltipMetadata;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.requests.ServiceRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.services.CoreWS;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.namacontrols.PosCustomToolTipUtil;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.entities.POSFieldTooltipInfo;
import com.namasoft.pos.util.POSGeneralSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TooltipFetcherRunner
implements Runnable {
    @Override
    public void run() {
        try {
            TooltipMetadata tooltipMetadata;
            ServiceLoginProvider.loginIfNotLoggedIn((String)POSGeneralSettings.getPOSServerURL(), (String)POSGeneralSettings.getLoginPassword(), (String)POSGeneralSettings.getLoginID(), (String)POSGeneralSettings.getAPIKey());
            CoreWS coreWs = (CoreWS)ServiceUtility.getServiceClient(CoreWS.class);
            GetResult guiComponentsMetadata = coreWs.getCustomGUIComponentsMetadata(new ServiceRequest());
            if (ObjectChecker.isNotEmptyOrNull((Object)guiComponentsMetadata) && ObjectChecker.isNotEmptyOrNull((Object)(tooltipMetadata = ((CustomGUIComponentsMetadata)guiComponentsMetadata.getData()).getTooltipMetadata()))) {
                POSPersister.deleteAll(POSPersister.listAll(POSFieldTooltipInfo.class));
                HashMap tooltips = tooltipMetadata.getFieldsTooltips();
                ArrayList keys = new ArrayList(tooltips.keySet());
                for (int i = keys.size() - 1; i >= 0; --i) {
                    if (ObjectChecker.isAnyEqualToFirst((Object)((EntityFieldPair)keys.get(i)).getEntityType(), (Object[])new String[]{"NamaPOSSalesInvoice", "NamaPOSSalesReturn", "POSPaymentToRegister", "POSReceiptFromRegister", "POSCashDrawer", "POSShiftOpening", "POSShiftClosing"})) continue;
                    tooltips.remove(keys.get(i));
                }
                if (ObjectChecker.isNotEmptyOrNull(tooltips.entrySet())) {
                    for (Map.Entry entry : tooltips.entrySet()) {
                        POSFieldTooltipInfo posFieldTooltipInfo = new POSFieldTooltipInfo();
                        posFieldTooltipInfo.setEntityType(((EntityFieldPair)entry.getKey()).getEntityType());
                        posFieldTooltipInfo.setFieldId(((EntityFieldPair)entry.getKey()).getFieldId());
                        posFieldTooltipInfo.updateData((FieldTooltipInfo)tooltipMetadata.getFieldTooltips().get(((FieldTooltipInfoRefList)entry.getValue()).get(0).getIndex()));
                        POSPersister.saveOrUpdate(posFieldTooltipInfo);
                    }
                }
                PosCustomToolTipUtil.clearTooltipInfosMap();
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public static void startInANewThread() {
        Thread t = new Thread((Runnable)new TooltipFetcherRunner(), "Tooltip-Fetcher");
        t.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        t.setDaemon(true);
        t.start();
    }
}

