/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.namasoft.upgrader.ConsoleProgressHandler;
import com.namasoft.upgrader.FileDownloader;
import com.namasoft.upgrader.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class AttendanceCronUpgrader {
    public static void start(String[] args) throws IOException, InterruptedException {
        AttendanceCronUpgrader.upgradeWarFile(args, "attcron.war", "https://namasoft.com/bin/attcron.war");
    }

    public static void upgradeWarFile(String[] args, String warName, String warURL) throws IOException, InterruptedException {
        File webApps;
        File file = webApps = args.length > 0 && !args[0].isEmpty() ? new File(args[0], "webapps") : new File("webapps");
        if (!webApps.exists()) {
            System.out.println("Please run from inside tomcat folder, current folder is " + new File("").getAbsolutePath());
            return;
        }
        File temp = new File(webApps, warName + ".temp");
        FileDownloader.downloadLarge(warURL, new ConsoleProgressHandler(true), temp);
        File warFile = new File(webApps, warName);
        if (warFile.exists()) {
            AttendanceCronUpgrader.deleteWarFileAndWaitTillFolderIsAlsoDeleted(warFile);
        }
        Files.move(temp.toPath(), warFile.toPath(), new CopyOption[0]);
    }

    private static void deleteWarFileAndWaitTillFolderIsAlsoDeleted(File war) throws IOException {
        File warFolder = new File(war.getParent(), war.getName().substring(0, war.getName().length() - 4));
        Files.delete(war.toPath());
        FileUtils.deleteDir(warFolder);
        for (int count = 0; warFolder.exists() && count < 50; ++count) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            System.out.println("\rWaiting for folder " + warFolder.getPath() + " to be deleted by tomcat " + ".".repeat(count));
        }
        if (warFolder.exists()) {
            System.out.println("Folder " + warFolder.getPath() + " still exists, maybe tomcat is not running! trying to manually delete it now");
            FileUtils.deleteDir(warFolder);
        }
        if (warFolder.exists()) {
            throw new RuntimeException("Could not delete war folder " + warFolder.getPath());
        }
    }
}

