/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import com.namasoft.upgrader.CryptoUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Scanner;
import java.util.regex.Pattern;

public class UpgLcMngr {
    private static final String NLM_SERVER = "https://nlm.namasoft.com";
    private static final String NAMASOFT_NLM_SERVER = "https://www.namasoft.com";
    public static String p = "nama-erp-8874596";
    private JsonObject object;
    private String sr;
    private String st;

    public UpgLcMngr(String tomcatFolder) {
        File nc = UpgLcMngr.getNcFile(tomcatFolder);
        if (!nc.exists()) {
            return;
        }
        try {
            String firstLine = Files.readAllLines(nc.toPath(), StandardCharsets.UTF_8).stream().findFirst().orElse("");
            String ldata = CryptoUtils.decrypt(firstLine, p);
            this.object = (JsonObject)Jsoner.deserialize((String)ldata);
            this.st = (String)this.object.get((Object)"st");
            this.sr = (String)this.object.get((Object)"sr");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static File getNcFile(String tomcatFolder) {
        return new File(new File(tomcatFolder), "lib/nc.jars");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkKey(String key) {
        try (Scanner scanner = new Scanner(new URL(UpgLcMngr.fetchNlmServer() + "/nlm/nlm?operation=validatekey&key=" + key).openStream(), "UTF-8").useDelimiter("\\A");){
            if (scanner.hasNext()) {
                String string = scanner.next().trim();
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            if (!"true".equalsIgnoreCase(System.getProperty("use-namasoft-com-not-crm"))) return "invalid - EXCPTN";
            e.printStackTrace();
            return "invalid - EXCPTN";
        }
    }

    public static String fetchNlmServer() {
        if ("true".equalsIgnoreCase(System.getProperty("use-local-host-for-nlm"))) {
            return "http://localhost:7575";
        }
        if ("true".equalsIgnoreCase(System.getProperty("use-namasoft-com-not-crm"))) {
            return NAMASOFT_NLM_SERVER;
        }
        return NLM_SERVER;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String requestKey(String customerName, String subServer, String IorU) {
        if (subServer == null) {
            subServer = "";
        }
        String spec = UpgLcMngr.fetchNlmServer() + "/nlm/nlm?operation=externalrequestkey&cst=" + customerName + "&ss=" + subServer + "&ioru=" + IorU;
        try (Scanner scanner = new Scanner(new URL(spec).openStream(), "UTF-8").useDelimiter("\\A");){
            if (scanner.hasNext()) {
                String string = scanner.next().trim();
                return string;
            }
            String string = "invalid - server did not respond correctly";
            return string;
        }
        catch (IOException e) {
            if (!"true".equalsIgnoreCase(System.getProperty("use-namasoft-com-not-crm"))) return "invalid - EXCPTN";
            e.printStackTrace();
            return "invalid - EXCPTN";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String tryFetchKey(String keyId) {
        try (Scanner scanner = new Scanner(new URL(UpgLcMngr.fetchNlmServer() + "/nlm/nlm?operation=fetchkey&keyid=" + keyId).openStream(), "UTF-8").useDelimiter("\\A");){
            if (scanner.hasNext()) {
                String string = scanner.next().trim();
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            if (!"true".equalsIgnoreCase(System.getProperty("use-namasoft-com-not-crm"))) return "invalid - EXCPTN";
            e.printStackTrace();
            return "invalid - EXCPTN";
        }
    }

    public static void installKey(String tomcatFolder, String key) throws IOException {
        UpgLcMngr manager = new UpgLcMngr(tomcatFolder);
        if (manager.object == null) {
            manager.object = new JsonObject();
        }
        if (CryptoUtils.isNotEmptyOrNull(UpgLcMngr.subServer(key))) {
            manager.object.put((Object)"ss", (Object)UpgLcMngr.subServer(key));
        } else {
            manager.object.remove((Object)"ss");
        }
        manager.object.put((Object)"rid", (Object)UpgLcMngr.serverToken(key));
        manager.object.put((Object)"st", (Object)UpgLcMngr.serverToken(key));
        manager.object.put((Object)"nt", (Object)UpgLcMngr.currentToken(key));
        manager.object.put((Object)"cn", (Object)UpgLcMngr.customerName(key));
        String json = Jsoner.serialize((Object)manager.object);
        Files.write(UpgLcMngr.getNcFile(tomcatFolder).toPath(), CryptoUtils.encrypt(json, p).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static void installToken(String tomcatFolder, String token) throws IOException {
        UpgLcMngr manager = new UpgLcMngr(tomcatFolder);
        if (manager.object == null) {
            manager.object = new JsonObject();
        }
        manager.object.put((Object)"nt", (Object)token);
        String json = Jsoner.serialize((Object)manager.object);
        Files.write(UpgLcMngr.getNcFile(tomcatFolder).toPath(), CryptoUtils.encrypt(json, p).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fetchSubServers(String customerName) {
        try (Scanner scanner = new Scanner(new URL(UpgLcMngr.fetchNlmServer() + "/nlm/nlm?operation=fetchsubservers&cst=" + customerName).openStream(), "UTF-8").useDelimiter("\\A");){
            if (scanner.hasNext()) {
                String string = scanner.next().trim();
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            return "";
        }
    }

    public boolean invalid() {
        if (this.noLicence()) {
            return true;
        }
        return this.sr != null && !this.sr.isEmpty();
    }

    public boolean noLicence() {
        return this.st == null || this.st.isEmpty();
    }

    public String invalidReason() {
        return this.sr;
    }

    public String getServerToken() {
        return this.st;
    }

    public static String serverToken(String key) {
        String[] parts = UpgLcMngr.splitPWD(key);
        if (parts == null || parts.length < 2) {
            return null;
        }
        return parts[0];
    }

    public static String customerName(String key) {
        String[] parts = UpgLcMngr.splitPWD(key);
        if (parts == null || parts.length < 2) {
            return null;
        }
        return parts[1];
    }

    public static String currentToken(String key) {
        String[] parts = UpgLcMngr.splitPWD(key);
        if (parts == null || parts.length < 3) {
            return null;
        }
        return parts[2];
    }

    public static String subServer(String key) {
        String[] parts = UpgLcMngr.splitPWD(key);
        if (parts == null || parts.length < 4) {
            return null;
        }
        return parts[3];
    }

    public static String[] splitPWD(String key) {
        try {
            String decrypt = CryptoUtils.decrypt(key, p);
            if (!decrypt.contains("@#@$")) {
                return null;
            }
            return decrypt.split(Pattern.quote("@#@$"));
        }
        catch (Exception e) {
            return null;
        }
    }
}

