/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader.migrator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TomcatPathsSelectionDialog {
    public static void promptForTomcatsFoldersSelection(String defaultTomcat9Path, String defaultTomcat10Path, BiConsumer<String, String> callback, List<Image> iconImages) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Select Tomcat Folders");
            frame.setIconImages(iconImages);
            frame.setDefaultCloseOperation(2);
            frame.setSize(800, 200);
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.insets = new Insets(5, 10, 5, 10);
            JTextField tomcat9PathField = new JTextField(40);
            JTextField tomcat10PathField = new JTextField(40);
            String t9 = defaultTomcat9Path;
            if (defaultTomcat9Path == null || defaultTomcat9Path.isEmpty()) {
                t9 = "C:\\Program Files\\Apache Software Foundation\\Tomcat 9.0";
            }
            String t10 = defaultTomcat10Path;
            if (defaultTomcat10Path == null || defaultTomcat10Path.isEmpty()) {
                t10 = "C:\\Program Files\\Apache Software Foundation\\Tomcat 10.1";
            }
            tomcat9PathField.setText(t9);
            tomcat10PathField.setText(t10);
            JButton tomcat9Button = new JButton("Browse ...");
            JButton tomcat10Button = new JButton("Browse ...");
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            tomcat9Button.addActionListener(e -> TomcatPathsSelectionDialog.selectFolder(tomcat9PathField, "Please select tomcat 9 (SOURCE) path"));
            tomcat10Button.addActionListener(e -> TomcatPathsSelectionDialog.selectFolder(tomcat10PathField, "Please select tomcat 10 (TARGET) path"));
            okButton.addActionListener(e -> {
                String tomcat9Path = tomcat9PathField.getText();
                String tomcat10Path = tomcat10PathField.getText();
                frame.setVisible(false);
                frame.dispose();
                callback.accept(tomcat9Path, tomcat10Path);
            });
            cancelButton.addActionListener(e -> {
                frame.setVisible(false);
                frame.dispose();
            });
            constraints.gridx = 0;
            constraints.gridy = 0;
            panel.add((Component)new JLabel("Tomcat 9 (SOURCE):"), constraints);
            constraints.gridx = 1;
            panel.add((Component)tomcat9PathField, constraints);
            constraints.gridx = 2;
            panel.add((Component)tomcat9Button, constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            panel.add((Component)new JLabel("Tomcat 10 (TARGET):"), constraints);
            constraints.gridx = 1;
            panel.add((Component)tomcat10PathField, constraints);
            constraints.gridx = 2;
            panel.add((Component)tomcat10Button, constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 3;
            panel.add((Component)okButton, constraints);
            constraints.gridy = 3;
            panel.add((Component)cancelButton, constraints);
            frame.add(panel);
            frame.setVisible(true);
        });
    }

    public static void selectFolder(JTextField textField, String title) {
        File selected = new File(textField.getText());
        while (!selected.exists() && selected.getParentFile() != null) {
            selected = selected.getParentFile();
        }
        JFileChooser fileChooser = new JFileChooser(selected.getAbsolutePath());
        fileChooser.setDialogTitle(title);
        if (selected.exists()) {
            fileChooser.setSelectedFile(selected);
        }
        fileChooser.setFileSelectionMode(1);
        int result = fileChooser.showOpenDialog(null);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            textField.setText(selectedFile.getAbsolutePath());
        }
    }
}

