/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Convert;
import jakarta.persistence.Converts;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinTable;
import jakarta.persistence.MappedSuperclass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AbstractPropertyHolder;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AttributeConversionInfo;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyInferredData;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;

public class ClassPropertyHolder
extends AbstractPropertyHolder {
    private final PersistentClass persistentClass;
    private Map<String, Join> joins;
    private transient Map<String, Join> joinsPerRealTableName;
    private EntityBinder entityBinder;
    private final Map<XClass, InheritanceState> inheritanceStatePerClass;
    private final Map<String, AttributeConversionInfo> attributeConversionInfoMap;

    public ClassPropertyHolder(PersistentClass persistentClass, XClass entityXClass, Map<String, Join> joins, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        super(persistentClass.getEntityName(), null, entityXClass, context);
        this.persistentClass = persistentClass;
        this.joins = joins;
        this.inheritanceStatePerClass = inheritanceStatePerClass;
        this.attributeConversionInfoMap = this.buildAttributeConversionInfoMap(entityXClass);
    }

    public ClassPropertyHolder(PersistentClass persistentClass, XClass entityXClass, EntityBinder entityBinder, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        this(persistentClass, entityXClass, entityBinder.getSecondaryTables(), context, inheritanceStatePerClass);
        this.entityBinder = entityBinder;
    }

    @Override
    protected String normalizeCompositePath(String attributeName) {
        return attributeName;
    }

    @Override
    protected String normalizeCompositePathForLogging(String attributeName) {
        return this.getEntityName() + "." + attributeName;
    }

    protected Map<String, AttributeConversionInfo> buildAttributeConversionInfoMap(XClass entityXClass) {
        HashMap<String, AttributeConversionInfo> map = new HashMap<String, AttributeConversionInfo>();
        this.collectAttributeConversionInfo(map, entityXClass);
        return map;
    }

    private void collectAttributeConversionInfo(Map<String, AttributeConversionInfo> infoMap, XClass xClass) {
        Converts convertsAnnotation;
        boolean canContainConvert;
        if (xClass == null) {
            return;
        }
        this.collectAttributeConversionInfo(infoMap, xClass.getSuperclass());
        boolean bl = canContainConvert = xClass.isAnnotationPresent(Entity.class) || xClass.isAnnotationPresent(MappedSuperclass.class) || xClass.isAnnotationPresent(Embeddable.class);
        if (!canContainConvert) {
            return;
        }
        Convert convertAnnotation = (Convert)xClass.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation, (XAnnotatedElement)xClass);
            if (StringHelper.isEmpty(info.getAttributeName())) {
                throw new IllegalStateException("@Convert placed on @Entity/@MappedSuperclass must define attributeName");
            }
            infoMap.put(info.getAttributeName(), info);
        }
        if ((convertsAnnotation = (Converts)xClass.getAnnotation(Converts.class)) != null) {
            for (Convert convertAnnotation2 : convertsAnnotation.value()) {
                AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation2, (XAnnotatedElement)xClass);
                if (StringHelper.isEmpty(info.getAttributeName())) {
                    throw new IllegalStateException("@Converts placed on @Entity/@MappedSuperclass must define attributeName");
                }
                infoMap.put(info.getAttributeName(), info);
            }
        }
    }

    @Override
    public void startingProperty(XProperty property) {
        Converts convertsAnnotation;
        if (property == null) {
            return;
        }
        String propertyName = property.getName();
        if (this.attributeConversionInfoMap.containsKey(propertyName)) {
            return;
        }
        Convert convertAnnotation = (Convert)property.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation, (XAnnotatedElement)property);
            if (StringHelper.isEmpty(info.getAttributeName())) {
                this.attributeConversionInfoMap.put(propertyName, info);
            } else {
                this.attributeConversionInfoMap.put(propertyName + "." + info.getAttributeName(), info);
            }
        }
        if ((convertsAnnotation = (Converts)property.getAnnotation(Converts.class)) != null) {
            for (Convert convertAnnotation2 : convertsAnnotation.value()) {
                AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation2, (XAnnotatedElement)property);
                if (StringHelper.isEmpty(info.getAttributeName())) {
                    this.attributeConversionInfoMap.put(propertyName, info);
                    continue;
                }
                this.attributeConversionInfoMap.put(propertyName + "." + info.getAttributeName(), info);
            }
        }
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(XProperty property) {
        return this.locateAttributeConversionInfo(property.getName());
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(String path) {
        return this.attributeConversionInfoMap.get(path);
    }

    @Override
    public String getEntityName() {
        return this.persistentClass.getEntityName();
    }

    @Override
    public void addProperty(Property prop, AnnotatedColumns columns, XClass declaringClass) {
        if (columns != null) {
            if (columns.isSecondary()) {
                this.addPropertyToJoin(prop, declaringClass, columns.getJoin());
            } else {
                this.addProperty(prop, declaringClass);
            }
        } else {
            this.addProperty(prop, declaringClass);
        }
    }

    @Override
    public void addProperty(Property prop, XClass declaringClass) {
        if (prop.getValue() instanceof Component) {
            String tableName = prop.getValue().getTable().getName();
            if (this.getJoinsPerRealTableName().containsKey(tableName)) {
                Join join = this.getJoinsPerRealTableName().get(tableName);
                this.addPropertyToJoin(prop, declaringClass, join);
            } else {
                this.addPropertyToPersistentClass(prop, declaringClass);
            }
        } else {
            this.addPropertyToPersistentClass(prop, declaringClass);
        }
    }

    @Override
    public void movePropertyToJoin(Property property, Join join, XClass declaringClass) {
        if (property.getValue() instanceof Component) {
            String tableName = property.getValue().getTable().getName();
            if (this.getJoinsPerRealTableName().get(tableName) == join) {
                return;
            }
        }
        this.persistentClass.movePropertyToJoin(property, join);
    }

    @Override
    public Join addJoin(JoinTable joinTableAnn, boolean noDelayInPkColumnCreation) {
        Join join = this.entityBinder.addJoin(joinTableAnn, (PropertyHolder)this, noDelayInPkColumnCreation);
        this.joins = this.entityBinder.getSecondaryTables();
        return join;
    }

    @Override
    public Join addJoin(JoinTable joinTable, Table table, boolean noDelayInPkColumnCreation) {
        Join join = this.entityBinder.createJoin(this, noDelayInPkColumnCreation, false, joinTable.joinColumns(), table.getQualifiedTableName(), table);
        this.joins = this.entityBinder.getSecondaryTables();
        return join;
    }

    public static void handleGenericComponentProperty(Property property, MetadataBuildingContext context) {
        Component component;
        Value value = property.getValue();
        if (value instanceof Component && (component = (Component)value).isGeneric() && context.getMetadataCollector().getGenericComponent(component.getComponentClass()) == null) {
            Component copy = component.copy();
            copy.setGeneric(false);
            copy.getProperties().clear();
            for (Property prop : component.getProperties()) {
                ClassPropertyHolder.prepareActualProperty(prop, component.getComponentClass(), true, context, copy::addProperty);
            }
            context.getMetadataCollector().registerGenericComponent(copy);
        }
    }

    private void addPropertyToPersistentClass(Property property, XClass declaringClass) {
        ClassPropertyHolder.handleGenericComponentProperty(property, this.getContext());
        if (declaringClass != null) {
            InheritanceState inheritanceState = this.inheritanceStatePerClass.get(declaringClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + String.valueOf(declaringClass));
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                this.persistentClass.addMappedSuperclassProperty(property);
                ClassPropertyHolder.addPropertyToMappedSuperclass(property, declaringClass, this.getContext());
            } else {
                this.persistentClass.addProperty(property);
            }
        } else {
            this.persistentClass.addProperty(property);
        }
    }

    static void addPropertyToMappedSuperclass(Property prop, XClass declaringClass, MetadataBuildingContext context) {
        Class type = context.getBootstrapContext().getReflectionManager().toClass(declaringClass);
        org.hibernate.mapping.MappedSuperclass superclass = context.getMetadataCollector().getMappedSuperclass(type);
        ClassPropertyHolder.prepareActualProperty(prop, type, true, context, superclass::addDeclaredProperty);
    }

    static void prepareActualProperty(Property prop, Class<?> type, boolean allowCollections, MetadataBuildingContext context, Consumer<Property> propertyConsumer) {
        if (type.getTypeParameters().length == 0) {
            propertyConsumer.accept(prop);
        } else {
            XClass actualDeclaringClass = context.getBootstrapContext().getReflectionManager().toXClass(type);
            for (XProperty declaredProperty : ClassPropertyHolder.getDeclaredProperties(actualDeclaringClass, prop.getPropertyAccessorName())) {
                if (!prop.getName().equals(declaredProperty.getName())) continue;
                final PropertyInferredData inferredData = new PropertyInferredData(actualDeclaringClass, declaredProperty, null, context.getBootstrapContext().getReflectionManager());
                if (declaredProperty.isTypeResolved()) {
                    propertyConsumer.accept(prop);
                    return;
                }
                Property actualProperty = prop.copy();
                actualProperty.setGeneric(true);
                actualProperty.setReturnedClassName(inferredData.getTypeName());
                Value value = actualProperty.getValue().copy();
                if (value instanceof Collection) {
                    if (!allowCollections) {
                        throw new AssertionFailure("Collections are not allowed as identifier properties");
                    }
                    final Collection collection = (Collection)value;
                    collection.setRole(type.getName() + "." + prop.getName());
                    final Value originalValue = prop.getValue();
                    context.getMetadataCollector().addSecondPass(new SecondPass(){

                        public void doSecondPass(Map persistentClasses) throws MappingException {
                            Collection initializedCollection = (Collection)originalValue;
                            Value element = initializedCollection.getElement().copy();
                            ClassPropertyHolder.setTypeName(element, inferredData.getProperty().getElementClass().getName());
                            if (initializedCollection instanceof IndexedCollection) {
                                Value index = ((IndexedCollection)initializedCollection).getIndex().copy();
                                if (inferredData.getProperty().getMapKey() != null) {
                                    ClassPropertyHolder.setTypeName(index, inferredData.getProperty().getMapKey().getName());
                                }
                                ((IndexedCollection)collection).setIndex(index);
                            }
                            collection.setElement(element);
                        }
                    });
                } else {
                    ClassPropertyHolder.setTypeName(value, inferredData.getTypeName());
                }
                if (value instanceof Component) {
                    Component component = (Component)value;
                    Class<?> componentClass = component.getComponentClass();
                    if (component.isGeneric()) {
                        actualProperty.setValue(context.getMetadataCollector().getGenericComponent(componentClass));
                    } else if (componentClass == Object.class) {
                        component.clearProperties();
                    } else {
                        Iterator<Property> propertyIterator = component.getPropertyIterator();
                        while (propertyIterator.hasNext()) {
                            try {
                                propertyIterator.next().getGetter(componentClass);
                            }
                            catch (PropertyNotFoundException e) {
                                propertyIterator.remove();
                            }
                        }
                    }
                }
                actualProperty.setValue(value);
                propertyConsumer.accept(actualProperty);
                break;
            }
        }
    }

    private static List<XProperty> getDeclaredProperties(XClass declaringClass, String accessType) {
        ArrayList<XProperty> properties = new ArrayList<XProperty>();
        for (XClass superclass = declaringClass; superclass != null; superclass = superclass.getSuperclass()) {
            properties.addAll(superclass.getDeclaredProperties(accessType));
        }
        return properties;
    }

    private static String getTypeName(Property property) {
        String typeName = ClassPropertyHolder.getTypeName(property.getValue());
        return typeName != null ? typeName : property.getReturnedClassName();
    }

    private static String getTypeName(Value value) {
        if (value instanceof Component) {
            Component component = (Component)value;
            String typeName = component.getTypeName();
            if (typeName != null) {
                return typeName;
            }
            return component.getComponentClassName();
        }
        return ((SimpleValue)value).getTypeName();
    }

    private static void setTypeName(Value value, String typeName) {
        if (value instanceof ToOne) {
            ToOne toOne = (ToOne)value;
            toOne.setReferencedEntityName(typeName);
            toOne.setTypeName(typeName);
        } else if (value instanceof Component) {
            Component component = (Component)value;
            if (!component.isGeneric()) {
                component.setComponentClassName(typeName);
            }
            if (component.getTypeName() != null) {
                component.setTypeName(typeName);
            }
        } else if (value instanceof SimpleValue) {
            ((SimpleValue)value).setTypeName(typeName);
        }
    }

    private void addPropertyToJoin(Property property, XClass declaringClass, Join join) {
        if (declaringClass != null) {
            InheritanceState inheritanceState = this.inheritanceStatePerClass.get(declaringClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + String.valueOf(declaringClass));
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                join.addMappedSuperclassProperty(property);
                ClassPropertyHolder.addPropertyToMappedSuperclass(property, declaringClass, this.getContext());
            } else {
                join.addProperty(property);
            }
        } else {
            join.addProperty(property);
        }
    }

    private Map<String, Join> getJoinsPerRealTableName() {
        if (this.joinsPerRealTableName == null) {
            this.joinsPerRealTableName = CollectionHelper.mapOfSize(this.joins.size());
            for (Join join : this.joins.values()) {
                this.joinsPerRealTableName.put(join.getTable().getName(), join);
            }
        }
        return this.joinsPerRealTableName;
    }

    @Override
    public String getClassName() {
        return this.persistentClass.getClassName();
    }

    @Override
    public String getEntityOwnerClassName() {
        return this.getClassName();
    }

    @Override
    public Table getTable() {
        return this.persistentClass.getTable();
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public KeyValue getIdentifier() {
        return this.persistentClass.getIdentifier();
    }

    @Override
    public boolean isOrWithinEmbeddedId() {
        return false;
    }

    @Override
    public boolean isWithinElementCollection() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getEntityName() + ")";
    }
}

