/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoadOptions;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SimpleNaturalIdMapping;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class MultiNaturalIdLoaderArrayParam<E>
implements MultiNaturalIdLoader<E>,
SqlArrayMultiKeyLoader {
    private final EntityMappingType entityDescriptor;
    private final Class<?> keyArrayClass;

    public MultiNaturalIdLoaderArrayParam(EntityMappingType entityDescriptor) {
        assert (entityDescriptor.getNaturalIdMapping() instanceof SimpleNaturalIdMapping);
        this.entityDescriptor = entityDescriptor;
        Class<?> keyClass = entityDescriptor.getNaturalIdMapping().getJavaType().getJavaTypeClass();
        this.keyArrayClass = LoaderHelper.createTypedArray(keyClass, 0).getClass();
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    protected SimpleNaturalIdMapping getNaturalIdMapping() {
        return (SimpleNaturalIdMapping)this.entityDescriptor.getNaturalIdMapping();
    }

    protected BasicAttributeMapping getNaturalIdAttribute() {
        return (BasicAttributeMapping)this.getNaturalIdMapping().asAttributeMapping();
    }

    @Override
    public <K> List<E> multiLoad(K[] naturalIds, MultiNaturalIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        if (naturalIds == null) {
            throw new IllegalArgumentException("`naturalIds` is null");
        }
        if (naturalIds.length == 0) {
            return Collections.emptyList();
        }
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("MultiNaturalIdLoaderArrayParam#multiLoadStarting - `%s`", (Object)this.entityDescriptor.getEntityName());
        }
        SessionFactoryImplementor sessionFactory = session.getFactory();
        naturalIds = LoaderHelper.normalizeKeys(naturalIds, this.getNaturalIdAttribute(), session, sessionFactory);
        LockOptions lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        SelectableMapping selectable = this.getNaturalIdAttribute().getSelectable(0);
        JdbcMapping jdbcMapping = selectable.getJdbcMapping();
        Class<?> jdbcArrayClass = Array.newInstance(jdbcMapping.getJdbcJavaType().getJavaTypeClass(), 0).getClass();
        SqlTypedMappingImpl arraySqlTypedMapping = new SqlTypedMappingImpl(selectable.getColumnDefinition(), selectable.getLength(), selectable.getPrecision(), selectable.getScale(), selectable.getTemporalPrecision(), MultiKeyLoadHelper.resolveArrayJdbcMapping(sessionFactory.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(jdbcArrayClass), jdbcMapping, jdbcArrayClass, sessionFactory));
        SqlTypedMappingJdbcParameter jdbcParameter = new SqlTypedMappingJdbcParameter(arraySqlTypedMapping);
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.getNaturalIdAttribute(), session.getLoadQueryInfluencers(), lockOptions, jdbcParameter, sessionFactory);
        JdbcOperationQuerySelect jdbcSelectOperation = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
        return LoaderHelper.loadByArrayParameter(naturalIds, sqlAst, jdbcSelectOperation, jdbcParameter, arraySqlTypedMapping.getJdbcMapping(), null, null, null, lockOptions, session.isDefaultReadOnly(), session);
    }
}

