/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.util;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class MimeMessageUtils {
    private MimeMessageUtils() {
    }

    public static MimeMessage createMimeMessage(Session session, byte[] source) throws MessagingException, IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(source);){
            MimeMessage mimeMessage = new MimeMessage(session, (InputStream)is);
            return mimeMessage;
        }
    }

    public static MimeMessage createMimeMessage(Session session, File source) throws MessagingException, IOException {
        try (FileInputStream is = new FileInputStream(source);){
            MimeMessage mimeMessage = MimeMessageUtils.createMimeMessage(session, is);
            return mimeMessage;
        }
    }

    public static MimeMessage createMimeMessage(Session session, InputStream source) throws MessagingException {
        return new MimeMessage(session, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeMessage createMimeMessage(Session session, String source) throws MessagingException, IOException {
        try (ByteArrayInputStream is = null;){
            byte[] byteSource = source.getBytes(Charset.defaultCharset());
            is = new ByteArrayInputStream(byteSource);
            MimeMessage mimeMessage = MimeMessageUtils.createMimeMessage(session, is);
            return mimeMessage;
        }
    }

    public static void writeMimeMessage(MimeMessage mimeMessage, File resultFile) throws MessagingException, IOException {
        if (!resultFile.getParentFile().exists() && !resultFile.getParentFile().mkdirs()) {
            throw new IOException("Failed to create the following parent directories: " + resultFile.getParentFile());
        }
        try (FileOutputStream fos = new FileOutputStream(resultFile);){
            mimeMessage.writeTo((OutputStream)fos);
            fos.flush();
        }
    }
}

