/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.TwoDimBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.output.Canvas;

public class DefaultTwoDimCanvasLogicHandler
implements TwoDimBarcodeLogicHandler {
    private AbstractBarcodeBean bcBean;
    private Canvas canvas;
    private double x = 0.0;
    private double y = 0.0;

    public DefaultTwoDimCanvasLogicHandler(AbstractBarcodeBean bcBean, Canvas canvas) {
        this.bcBean = bcBean;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    private double getStartY() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getVerticalQuietZone();
        }
        return 0.0;
    }

    @Override
    public void startBarcode(String msg, String formattedMsg) {
        BarcodeDimension dim = this.bcBean.calcDimensions(msg);
        this.canvas.establishDimensions(dim);
        this.y = this.getStartY();
    }

    @Override
    public void startRow() {
        this.x = this.getStartX();
    }

    @Override
    public void startBarGroup(BarGroup type, String submsg) {
    }

    @Override
    public void addBar(boolean black, int width) {
        double w = this.bcBean.getBarWidth(width);
        if (black) {
            this.canvas.drawRectWH(this.x, this.y, w, this.bcBean.getBarHeight());
        }
        this.x += w;
    }

    @Override
    public void endBarGroup() {
    }

    @Override
    public void endRow() {
        this.y += this.bcBean.getBarHeight();
    }

    @Override
    public void endBarcode() {
    }
}

