/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.datamatrix;

import java.awt.Dimension;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.impl.ConfigurableBarcodeGenerator;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixBean;
import org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import org.krysalis.barcode4j.tools.Length;

public class DataMatrix
extends ConfigurableBarcodeGenerator
implements Configurable {
    public DataMatrix() {
        this.bean = new DataMatrixBean();
    }

    @Override
    public void configure(Configuration cfg) throws ConfigurationException {
        String size;
        String mws = cfg.getChild("module-width").getValue(null);
        if (mws != null) {
            Length mw = new Length(mws, "mm");
            this.getDataMatrixBean().setModuleWidth(mw.getValueAsMillimeter());
        }
        super.configure(cfg);
        String shape = cfg.getChild("shape").getValue(null);
        if (shape != null) {
            this.getDataMatrixBean().setShape(SymbolShapeHint.byName(shape));
        }
        if ((size = cfg.getChild("min-symbol-size").getValue(null)) != null) {
            this.getDataMatrixBean().setMinSize(this.parseSymbolSize(size));
        }
        if ((size = cfg.getChild("max-symbol-size").getValue(null)) != null) {
            this.getDataMatrixBean().setMaxSize(this.parseSymbolSize(size));
        }
    }

    private Dimension parseSymbolSize(String size) {
        Dimension dim;
        int idx = size.indexOf(120);
        if (idx > 0) {
            dim = new Dimension(Integer.parseInt(size.substring(0, idx)), Integer.parseInt(size.substring(idx + 1)));
        } else {
            int extent = Integer.parseInt(size);
            dim = new Dimension(extent, extent);
        }
        return dim;
    }

    public DataMatrixBean getDataMatrixBean() {
        return (DataMatrixBean)this.getBean();
    }
}

