/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.qr;

import java.awt.Dimension;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.impl.ConfigurableBarcodeGenerator;
import org.krysalis.barcode4j.impl.qr.QRCodeBean;
import org.krysalis.barcode4j.tools.Length;

public class QRCode
extends ConfigurableBarcodeGenerator
implements Configurable {
    public QRCode() {
        this.bean = new QRCodeBean();
    }

    @Override
    public void configure(Configuration cfg) throws ConfigurationException {
        String size;
        String ecLevel;
        String mws = cfg.getChild("module-width").getValue(null);
        if (mws != null) {
            Length mw = new Length(mws, "mm");
            this.getQRBean().setModuleWidth(mw.getValueAsMillimeter());
        }
        super.configure(cfg);
        String encoding = cfg.getChild("encoding").getValue(null);
        if (encoding != null) {
            this.getQRBean().setEncoding(encoding);
        }
        if ((ecLevel = cfg.getChild("ec-level").getValue(null)) != null && ecLevel.length() > 0) {
            this.getQRBean().setErrorCorrectionLevel(ecLevel.charAt(0));
        }
        if ((size = cfg.getChild("min-symbol-size").getValue(null)) != null) {
            this.getQRBean().setMinSize(this.parseSymbolSize(size));
        }
        if ((size = cfg.getChild("max-symbol-size").getValue(null)) != null) {
            this.getQRBean().setMaxSize(this.parseSymbolSize(size));
        }
    }

    private Dimension parseSymbolSize(String size) {
        Dimension dim;
        int idx = size.indexOf(120);
        if (idx > 0) {
            dim = new Dimension(Integer.parseInt(size.substring(0, idx)), Integer.parseInt(size.substring(idx + 1)));
        } else {
            int extent = Integer.parseInt(size);
            dim = new Dimension(extent, extent);
        }
        return dim;
    }

    public QRCodeBean getQRBean() {
        return (QRCodeBean)this.getBean();
    }
}

