/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExcelAbstractExporter;
import net.sf.jasperreports.engine.export.Grid;
import net.sf.jasperreports.engine.export.GridRow;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.XlsExporterConfiguration;
import net.sf.jasperreports.export.XlsReportConfiguration;

public abstract class JRXlsAbstractExporter<RC extends XlsReportConfiguration, C extends XlsExporterConfiguration, E extends JRExporterContext>
extends ExcelAbstractExporter<RC, C, E> {
    public JRXlsAbstractExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXlsAbstractExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    protected void exportReportToStream(OutputStream os) throws JRException, IOException {
        this.openWorkbook(os);
        this.sheetNamesMap = new HashMap();
        this.definedNamesMap = new HashMap();
        this.pageFormat = null;
        boolean pageExported = false;
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            if (!this.hasGlobalSheetNames()) {
                this.sheetNamesIndex = 0;
            }
            XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
            this.configureDefinedNames(configuration.getDefinedNames());
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                int endPageIndex;
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int n = endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                if (this.onePagePerSheet) {
                    this.pageIndex = startPageIndex;
                    while (this.pageIndex <= endPageIndex) {
                        this.checkInterrupted();
                        JRPrintPage page = pages.get(this.pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
                        this.exportPage(page, null, 0, null);
                        pageExported = true;
                        ++this.pageIndex;
                    }
                } else {
                    CutsInfo xCuts = JRGridLayout.calculateXCuts(this.getNature(), this.jasperPrint, startPageIndex, endPageIndex, configuration.getOffsetX() == null ? 0 : configuration.getOffsetX());
                    if (this.filter instanceof ResetableExporterFilter) {
                        ((ResetableExporterFilter)this.filter).reset();
                    }
                    int startRow = 0;
                    this.pageIndex = startPageIndex;
                    while (this.pageIndex <= endPageIndex) {
                        this.checkInterrupted();
                        JRPrintPage page = pages.get(this.pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
                        startRow = this.exportPage(page, xCuts, startRow, this.jasperPrint.getName());
                        pageExported = true;
                        ++this.pageIndex;
                    }
                }
            }
            if (this.reportIndex == items.size() - 1 && !pageExported) {
                this.exportEmptyReport();
            }
            this.sheetsBeforeCurrentReport = this.onePagePerSheet ? this.sheetIndex : this.sheetsBeforeCurrentReport + 1;
            ++this.reportIndex;
        }
        this.closeSheet();
        this.closeWorkbook(os);
    }

    protected int exportPage(JRPrintPage page, CutsInfo xCuts, int startRow, String defaultSheetName) throws JRException {
        boolean createXCuts;
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        int maxRowsPerSheet = this.getMaxRowsPerSheet();
        boolean isRemoveEmptySpaceBetweenRows = configuration.isRemoveEmptySpaceBetweenRows();
        boolean isRemoveEmptySpaceBetweenColumns = configuration.isRemoveEmptySpaceBetweenColumns();
        JRGridLayout layout = new JRGridLayout(this.getNature(), page.getElements(), (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight(), configuration.getOffsetX() == null ? 0 : configuration.getOffsetX(), configuration.getOffsetY() == null ? 0 : configuration.getOffsetY(), xCuts);
        Grid grid = layout.getGrid();
        boolean bl = createXCuts = xCuts == null;
        if (createXCuts) {
            xCuts = layout.getXCuts();
        }
        CutsInfo yCuts = layout.getYCuts();
        if (createXCuts || startRow == 0) {
            this.exportSheet(xCuts, yCuts, 0, defaultSheetName);
        }
        XlsRowLevelInfo levelInfo = new XlsRowLevelInfo();
        int skippedRows = 0;
        int rowIndex = startRow;
        int rowCount = grid.getRowCount();
        for (int y = 0; y < rowCount; ++y) {
            Cut yCut = yCuts.getCut(y);
            rowIndex = y - skippedRows + startRow;
            if (maxRowsPerSheet > 0 && rowIndex >= maxRowsPerSheet || yCut.isBreak()) {
                this.setRowLevels(levelInfo, null);
                this.exportSheet(xCuts, yCuts, y, defaultSheetName);
                startRow = 0;
                rowIndex = 0;
                skippedRows = y;
            }
            if (yCut.isCutNotEmpty() || (!isRemoveEmptySpaceBetweenRows || yCut.isCutSpanned()) && !this.collapseRowSpan) {
                GridRow gridRow = grid.getRow(y);
                int emptyCellColSpan = 0;
                this.mergeAndSetRowLevels(levelInfo, (SortedMap)yCut.getProperty("net.sf.jasperreports.export.xls.row.outline.level."), rowIndex);
                this.setRowHeight(rowIndex, this.collapseRowSpan ? layout.getMaxRowHeight(y) : JRGridLayout.getRowHeight(gridRow), yCuts.getCut(y), levelInfo);
                int emptyCols = 0;
                int rowSize = gridRow.size();
                for (int xCutIndex = 0; xCutIndex < rowSize; ++xCutIndex) {
                    Cut xCut = xCuts.getCut(xCutIndex);
                    boolean isEmptyCol = !xCut.isCutNotEmpty() && !xCut.isCutSpanned();
                    int colIndex = xCutIndex - (emptyCols += isRemoveEmptySpaceBetweenColumns && isEmptyCol ? 1 : 0);
                    if (colIndex > this.maxColumnIndex) {
                        throw new JRException("export.xls.common.column.index.beyond.limit", colIndex, this.maxColumnIndex);
                    }
                    JRExporterGridCell gridCell = gridRow.get(xCutIndex);
                    if (gridCell.getType() == 2) {
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                        }
                        this.addOccupiedCell((OccupiedGridCell)gridCell, colIndex, rowIndex);
                        continue;
                    }
                    if (gridCell.getType() == 3) {
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                        }
                        JRPrintElement element = gridCell.getElement();
                        String autofilter = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.auto.filter");
                        if ("Start".equals(autofilter)) {
                            this.autoFilterStart = "$" + JRStringUtil.getLetterNumeral(colIndex + 1, true) + "$" + (rowIndex + 1);
                        } else if ("End".equals(autofilter)) {
                            this.autoFilterEnd = "$" + JRStringUtil.getLetterNumeral(colIndex + 1, true) + "$" + (rowIndex + 1);
                        }
                        this.configureDefinedNames(this.getNature(), element);
                        if (element instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintRectangle) {
                            this.exportRectangle((JRPrintRectangle)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintEllipse) {
                            this.exportRectangle((JRPrintEllipse)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, gridCell, colIndex, rowIndex, emptyCols, y, layout);
                            continue;
                        }
                        if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintFrame) {
                            this.exportFrame((JRPrintFrame)element, gridCell, colIndex, y);
                            continue;
                        }
                        if (!(element instanceof JRGenericPrintElement)) continue;
                        this.exportGenericElement((JRGenericPrintElement)element, gridCell, colIndex, rowIndex, emptyCols, y, layout);
                        continue;
                    }
                    ++emptyCellColSpan;
                    if (isRemoveEmptySpaceBetweenColumns && isEmptyCol) continue;
                    this.addBlankCell(gridCell, colIndex, rowIndex);
                }
                ++rowIndex;
                continue;
            }
            ++skippedRows;
        }
        if (configuration.isForcePageBreaks().booleanValue()) {
            this.addRowBreak(rowCount - skippedRows + startRow - 1);
        }
        if (this.autoFilterStart != null) {
            this.setAutoFilter(this.autoFilterStart + ":" + (this.autoFilterEnd != null ? this.autoFilterEnd : this.autoFilterStart));
        } else if (this.autoFilterEnd != null) {
            this.setAutoFilter(this.autoFilterEnd + ":" + this.autoFilterEnd);
        }
        this.setRowLevels(levelInfo, null);
        JRExportProgressMonitor progressMonitor = configuration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
        return rowIndex;
    }

    protected SheetInfo getSheetProps(CutsInfo xCuts, CutsInfo yCuts, int startCutIndex) {
        SheetInfo sheetInfo = new SheetInfo();
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        int maxRowsPerSheet = this.getMaxRowsPerSheet();
        boolean isRemoveEmptySpaceBetweenRows = configuration.isRemoveEmptySpaceBetweenRows();
        sheetInfo.tabColor = configuration.getSheetTabColor();
        sheetInfo.ignoreCellBackground = configuration.isIgnoreCellBackground();
        sheetInfo.whitePageBackground = configuration.isWhitePageBackground();
        sheetInfo.ignoreCellBorder = configuration.isIgnoreCellBorder();
        boolean elementLevelRowFreeze = false;
        boolean elementLevelColumnFreeze = false;
        sheetInfo.rowFreezeIndex = configuration.getFreezeRow() == null ? -1 : Math.max(0, configuration.getFreezeRow() - 1);
        sheetInfo.columnFreezeIndex = configuration.getFreezeColumn() == null ? -1 : Math.max(0, this.getColumnIndex(configuration.getFreezeColumn()));
        sheetInfo.printSettings = new SheetInfo().new SheetInfo.SheetPrintSettings();
        int skippedRows = 0;
        int rowIndex = 0;
        int rowCount = yCuts.size() - 1;
        for (int y = startCutIndex; y < rowCount; ++y) {
            Cut yCut = yCuts.getCut(y);
            rowIndex = y - skippedRows;
            if (y > startCutIndex && (maxRowsPerSheet > 0 && rowIndex >= maxRowsPerSheet || yCut.isBreak())) break;
            if (yCut.isCutNotEmpty() || (!isRemoveEmptySpaceBetweenRows || yCut.isCutSpanned()) && !this.collapseRowSpan) {
                Integer freezeRow;
                Integer pageScale;
                Boolean whitePageBackground;
                Boolean ignoreCellBorder;
                Boolean ignoreCellBackground;
                Boolean showGridlines;
                Integer firstPageNumber;
                String color;
                Color tabColor;
                Float sheetRatio;
                String sheetName = (String)yCut.getProperty("net.sf.jasperreports.export.xls.sheet.name");
                if (sheetName != null) {
                    sheetInfo.sheetName = sheetName;
                }
                if ((sheetRatio = (Float)yCut.getProperty("net.sf.jasperreports.export.xls.column.width.ratio")) != null && (sheetInfo.columnWidthRatio == null || sheetInfo.columnWidthRatio.floatValue() < sheetRatio.floatValue())) {
                    sheetInfo.columnWidthRatio = sheetRatio;
                }
                if ((tabColor = JRColorUtil.getColor(color = (String)yCut.getProperty("net.sf.jasperreports.export.xls.sheet.tab.color"), null)) != null) {
                    sheetInfo.tabColor = tabColor;
                }
                if ((firstPageNumber = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.first.page.number")) != null) {
                    sheetInfo.sheetFirstPageNumber = firstPageNumber;
                }
                if ((showGridlines = (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.show.gridlines")) != null) {
                    sheetInfo.sheetShowGridlines = showGridlines;
                }
                if ((ignoreCellBackground = (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.ignore.cell.background")) != null) {
                    sheetInfo.ignoreCellBackground = ignoreCellBackground;
                }
                if ((ignoreCellBorder = (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.ignore.cell.border")) != null) {
                    sheetInfo.ignoreCellBorder = ignoreCellBorder;
                }
                if ((whitePageBackground = (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.white.page.background")) != null) {
                    sheetInfo.whitePageBackground = whitePageBackground;
                }
                sheetInfo.sheetPageScale = this.isValidScale(pageScale = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.page.scale")) ? pageScale : configuration.getPageScale();
                Integer freezeColumn = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.freeze.column.edge");
                if (!(freezeColumn == null || elementLevelColumnFreeze && freezeColumn <= sheetInfo.columnFreezeIndex)) {
                    sheetInfo.columnFreezeIndex = Math.max(0, freezeColumn);
                    elementLevelColumnFreeze = true;
                }
                if (!((freezeRow = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.freeze.row.edge")) == null || elementLevelRowFreeze && freezeRow <= sheetInfo.rowFreezeIndex)) {
                    sheetInfo.rowFreezeIndex = Math.max(0, freezeRow);
                    elementLevelRowFreeze = true;
                }
                sheetInfo.sheetPageScale = this.isValidScale(pageScale) ? pageScale : configuration.getPageScale();
                this.configurePrintSettings(sheetInfo.printSettings, yCut);
                this.configureHeaderFooter(sheetInfo.printSettings, yCut);
                ++rowIndex;
                continue;
            }
            ++skippedRows;
        }
        this.updatePrintSettings(sheetInfo.printSettings, configuration);
        this.updateHeaderFooter(sheetInfo.printSettings, configuration);
        return sheetInfo;
    }

    protected void configurePrintSettings(SheetInfo.SheetPrintSettings printSettings, Cut yCut) {
        Integer value = null;
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.height")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.height");
            if (printSettings.getPageHeight() == null || printSettings.getPageHeight() < value) {
                printSettings.setPageHeight(value);
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.width")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.width");
            if (printSettings.getPageWidth() == null || printSettings.getPageWidth() < value) {
                printSettings.setPageWidth(value);
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.top.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.top.margin");
            if (printSettings.getTopMargin() == null || printSettings.getTopMargin() < value) {
                printSettings.setTopMargin(value);
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.left.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.left.margin");
            if (printSettings.getLeftMargin() == null || printSettings.getLeftMargin() < value) {
                printSettings.setLeftMargin(value);
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.bottom.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.bottom.margin");
            if (printSettings.getBottomMargin() == null || printSettings.getBottomMargin() < value) {
                printSettings.setBottomMargin((Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.bottom.margin"));
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.page.right.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.right.margin");
            if (printSettings.getRightMargin() == null || printSettings.getRightMargin() < value) {
                printSettings.setRightMargin((Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.page.right.margin"));
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.header.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.header.margin");
            if (printSettings.getHeaderMargin() == null || printSettings.getHeaderMargin() < value) {
                printSettings.setHeaderMargin((Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.header.margin"));
            }
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.print.footer.margin")) {
            value = (Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.footer.margin");
            if (printSettings.getFooterMargin() == null || printSettings.getFooterMargin() < value) {
                printSettings.setFooterMargin((Integer)yCut.getProperty("net.sf.jasperreports.export.xls.print.footer.margin"));
            }
        }
    }

    protected void configureHeaderFooter(SheetInfo.SheetPrintSettings printSettings, Cut yCut) {
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.sheet.header.left")) {
            printSettings.setHeaderLeft((String)yCut.getProperty("net.sf.jasperreports.export.xls.sheet.header.left"));
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.sheet.header.center")) {
            printSettings.setHeaderCenter((String)yCut.getProperty("net.sf.jasperreports.export.xls.sheet.header.center"));
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.sheet.header.right")) {
            printSettings.setHeaderRight((String)yCut.getProperty("net.sf.jasperreports.export.xls.sheet.header.right"));
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.sheet.footer.left")) {
            printSettings.setFooterLeft((String)yCut.getProperty("net.sf.jasperreports.export.xls.sheet.footer.left"));
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.sheet.footer.center")) {
            printSettings.setFooterCenter((String)yCut.getProperty("net.sf.jasperreports.export.xls.sheet.footer.center"));
        }
        if (yCut.hasProperty("net.sf.jasperreports.export.xls.sheet.footer.right")) {
            printSettings.setFooterRight((String)yCut.getProperty("net.sf.jasperreports.export.xls.sheet.footer.right"));
        }
    }

    protected void exportSheet(CutsInfo xCuts, CutsInfo yCuts, int startCutIndex, String defaultSheetName) {
        if (this.sheetInfo != null) {
            this.closeSheet();
        }
        this.sheetInfo = this.getSheetProps(xCuts, yCuts, startCutIndex);
        this.sheetInfo.sheetName = this.getSheetName(this.sheetInfo.sheetName, defaultSheetName);
        this.sheetInfo.sheetFirstPageIndex = this.pageIndex;
        this.createSheet(xCuts, this.sheetInfo);
        ++this.sheetIndex;
        ++this.sheetNamesIndex;
        this.resetAutoFilters();
        this.setFreezePane(this.sheetInfo.rowFreezeIndex, this.sheetInfo.columnFreezeIndex);
        this.setColumnWidths(xCuts);
    }

    protected void setColumnWidths(CutsInfo xCuts) {
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        boolean isRemoveEmptySpaceBetweenColumns = configuration.isRemoveEmptySpaceBetweenColumns();
        float sheetRatio = this.sheetInfo.columnWidthRatio == null ? (configuration.getColumnWidthRatio() == null ? 1.0f : configuration.getColumnWidthRatio().floatValue()) : this.sheetInfo.columnWidthRatio.floatValue();
        sheetRatio = Math.max(1.0f, sheetRatio);
        int emptyCols = 0;
        for (int xCutIndex = 0; xCutIndex < xCuts.size() - 1; ++xCutIndex) {
            Cut xCut = xCuts.getCut(xCutIndex);
            if (!isRemoveEmptySpaceBetweenColumns || xCut.isCutNotEmpty() || xCut.isCutSpanned()) {
                Integer width = (Integer)xCut.getProperty("net.sf.jasperreports.export.xls.column.width");
                width = width == null ? (int)((float)(xCuts.getCutOffset(xCutIndex + 1) - xCuts.getCutOffset(xCutIndex)) * sheetRatio) : width;
                boolean isAutoFit = xCut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.column") && (Boolean)xCut.getProperty("net.sf.jasperreports.export.xls.auto.fit.column") != false;
                this.setColumnWidth(xCutIndex - emptyCols, width, isAutoFit);
                continue;
            }
            ++emptyCols;
        }
    }

    @Override
    protected void exportEmptyReport() throws JRException, IOException {
        this.pageFormat = this.jasperPrint.getPageFormat();
        this.exportPage(new JRBasePrintPage(), null, 0, this.jasperPrint.getName());
    }

    protected abstract void createSheet(CutsInfo var1, SheetInfo var2);

    protected abstract void setRowHeight(int var1, int var2, Cut var3, XlsRowLevelInfo var4) throws JRException;

    protected abstract void addBlankCell(JRExporterGridCell var1, int var2, int var3) throws JRException;

    protected abstract void addOccupiedCell(OccupiedGridCell var1, int var2, int var3) throws JRException;

    protected abstract void exportText(JRPrintText var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportImage(JRPrintImage var1, JRExporterGridCell var2, int var3, int var4, int var5, int var6, JRGridLayout var7) throws JRException;

    protected abstract void exportRectangle(JRPrintGraphicElement var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportLine(JRPrintLine var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportGenericElement(JRGenericPrintElement var1, JRExporterGridCell var2, int var3, int var4, int var5, int var6, JRGridLayout var7) throws JRException;

    public static class SheetInfo {
        public Integer sheetFirstPageIndex;
        public String sheetName;
        public Integer sheetFirstPageNumber;
        public Integer sheetPageScale;
        public Boolean sheetShowGridlines;
        public Color tabColor;
        public Boolean ignoreCellBorder;
        public Boolean ignoreCellBackground;
        public Boolean whitePageBackground;
        public Integer columnFreezeIndex;
        public Integer rowFreezeIndex;
        public Float columnWidthRatio;
        public SheetPrintSettings printSettings;

        public class SheetPrintSettings
        implements PrintPageFormat {
            private Integer pageHeight;
            private Integer pageWidth;
            private Integer topMargin;
            private Integer leftMargin;
            private Integer bottomMargin;
            private Integer rightMargin;
            private Integer headerMargin;
            private Integer footerMargin;
            private String headerLeft;
            private String headerCenter;
            private String headerRight;
            private String footerLeft;
            private String footerCenter;
            private String footerRight;
            private OrientationEnum orientation;

            @Override
            public Integer getPageHeight() {
                return this.pageHeight;
            }

            public void setPageHeight(Integer pageHeight) {
                this.pageHeight = pageHeight;
            }

            @Override
            public Integer getPageWidth() {
                return this.pageWidth;
            }

            public void setPageWidth(Integer pageWidth) {
                this.pageWidth = pageWidth;
            }

            @Override
            public Integer getTopMargin() {
                return this.topMargin;
            }

            public void setTopMargin(Integer topMargin) {
                this.topMargin = topMargin;
            }

            @Override
            public Integer getLeftMargin() {
                return this.leftMargin;
            }

            public void setLeftMargin(Integer leftMargin) {
                this.leftMargin = leftMargin;
            }

            @Override
            public Integer getBottomMargin() {
                return this.bottomMargin;
            }

            public void setBottomMargin(Integer bottomMargin) {
                this.bottomMargin = bottomMargin;
            }

            @Override
            public Integer getRightMargin() {
                return this.rightMargin;
            }

            public void setRightMargin(Integer rightMargin) {
                this.rightMargin = rightMargin;
            }

            public Integer getHeaderMargin() {
                return this.headerMargin;
            }

            public void setHeaderMargin(Integer headerMargin) {
                this.headerMargin = headerMargin;
            }

            public Integer getFooterMargin() {
                return this.footerMargin;
            }

            public void setFooterMargin(Integer footerMargin) {
                this.footerMargin = footerMargin;
            }

            public String getHeaderLeft() {
                return this.headerLeft;
            }

            public void setHeaderLeft(String headerLeft) {
                this.headerLeft = headerLeft;
            }

            public String getHeaderCenter() {
                return this.headerCenter;
            }

            public void setHeaderCenter(String headerCenter) {
                this.headerCenter = headerCenter;
            }

            public String getHeaderRight() {
                return this.headerRight;
            }

            public void setHeaderRight(String headerRight) {
                this.headerRight = headerRight;
            }

            public String getFooterLeft() {
                return this.footerLeft;
            }

            public void setFooterLeft(String footerLeft) {
                this.footerLeft = footerLeft;
            }

            public String getFooterCenter() {
                return this.footerCenter;
            }

            public void setFooterCenter(String footerCenter) {
                this.footerCenter = footerCenter;
            }

            public String getFooterRight() {
                return this.footerRight;
            }

            public void setFooterRight(String footerRight) {
                this.footerRight = footerRight;
            }

            @Override
            public OrientationEnum getOrientation() {
                return this.orientation;
            }

            public void setOrientation(OrientationEnum orientation) {
                this.orientation = orientation;
            }
        }
    }
}

