/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.supplychain.contracts.dtos;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.DTOMoney;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvoiceMoney;
import com.namasoft.modules.supplychain.contracts.dtos.DTORewardPointsRequest;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigDecimal;
import java.util.Date;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DTORedeemRequest {
    private EntityReferenceData config;
    private EntityReferenceData discountCouponGroup;
    private EntityReferenceData discountCouponBook;
    private EntityReferenceData pointsOwner;
    private EntityReferenceData doc;
    private String bookId;
    private String termId;
    private DTOGenericDimensions genericDimensions;
    private String rewardCode;
    private DTOMoney money;
    private Date atDate;
    private String mobile;
    private String countryCode;
    private BigDecimal redeemedAmount;
    private String otpValue;
    private String otpToken;
    private String couponId;
    private String registerId;

    public DTORedeemRequest() {
    }

    public DTORedeemRequest(DTORewardPointsRequest request) {
        this.setConfig(request.getRewardConfig());
        this.setPointsOwner(request.getPointsOwner());
        this.setRewardCode(request.getRewardCode());
        this.setAtDate(request.getValueDate());
        this.money = new DTOMoney();
        if (request.getMoney() == null) {
            request.setMoney(new DTOInvoiceMoney());
        }
        request.getMoney().updateNulls();
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)request.getMoney().getTotal())) {
            this.money.addAmount(request.getMoney().getTotal());
        }
        this.money.setCurrency(request.getMoney().getCurrency());
        this.setDoc(request.getOrder());
        this.setBookId(request.getBookId());
        this.setTermId(request.getTermId());
        this.setGenericDimensions(request.getGenericDimensions());
    }

    public EntityReferenceData getDiscountCouponGroup() {
        return this.discountCouponGroup;
    }

    public void setDiscountCouponGroup(EntityReferenceData discountCouponGroup) {
        this.discountCouponGroup = discountCouponGroup;
    }

    public DTOMoney getMoney() {
        return this.money;
    }

    public void setMoney(DTOMoney money) {
        this.money = money;
    }

    public EntityReferenceData getDoc() {
        return this.doc;
    }

    public void setDoc(EntityReferenceData doc) {
        this.doc = doc;
    }

    public String getBookId() {
        return this.bookId;
    }

    public void setBookId(String bookId) {
        this.bookId = bookId;
    }

    public String getTermId() {
        return this.termId;
    }

    public void setTermId(String termId) {
        this.termId = termId;
    }

    public DTOGenericDimensions getGenericDimensions() {
        return this.genericDimensions;
    }

    public void setGenericDimensions(DTOGenericDimensions genericDimensions) {
        this.genericDimensions = genericDimensions;
    }

    public String getRewardCode() {
        return this.rewardCode;
    }

    public void setRewardCode(String rewardCode) {
        this.rewardCode = rewardCode;
    }

    public Date getAtDate() {
        return this.atDate;
    }

    public void setAtDate(Date atDate) {
        this.atDate = atDate;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public EntityReferenceData getPointsOwner() {
        return this.pointsOwner;
    }

    public void setPointsOwner(EntityReferenceData pointsOwner) {
        this.pointsOwner = pointsOwner;
    }

    public EntityReferenceData getConfig() {
        return this.config;
    }

    public void setConfig(EntityReferenceData config) {
        this.config = config;
    }

    public EntityReferenceData getDiscountCouponBook() {
        return this.discountCouponBook;
    }

    public void setDiscountCouponBook(EntityReferenceData discountCouponBook) {
        this.discountCouponBook = discountCouponBook;
    }

    public String getOtpValue() {
        return this.otpValue;
    }

    public void setOtpValue(String otpValue) {
        this.otpValue = otpValue;
    }

    public String getOtpToken() {
        return this.otpToken;
    }

    public void setOtpToken(String otpToken) {
        this.otpToken = otpToken;
    }

    public String getCouponId() {
        return this.couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public BigDecimal getRedeemedAmount() {
        return this.redeemedAmount;
    }

    public void setRedeemedAmount(BigDecimal redeemedAmount) {
        this.redeemedAmount = redeemedAmount;
    }

    public String getRegisterId() {
        return this.registerId;
    }

    public void setRegisterId(String registerId) {
        this.registerId = registerId;
    }
}

