package com.namasoft.contracts.common.dtos;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.HasDTODimensionsRef;
import com.namasoft.common.constants.CommonConstants;
import com.namasoft.common.constants.DomainBaseEntities;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class EntityDimensionsDTO implements Serializable
{
	private static final long serialVersionUID = -4890358075434706913L;
	private EntityReferenceData legalEntity;
	private EntityReferenceData sector;
	private EntityReferenceData branch;
	private EntityReferenceData analysisSet;
	private EntityReferenceData department;
	private Boolean ignoreLoginAnalysisSet;
	private Boolean ignoreLoginBranch;
	private Boolean ignoreLoginDepartment;
	private Boolean ignoreLoginLegalEntity;
	private Boolean ignoreLoginSector;

	public EntityDimensionsDTO()
	{

	}

	public EntityDimensionsDTO(HasDTODimensionsRef masterFileDTO)
	{
		if (masterFileDTO == null)
			return;
		this.analysisSet = masterFileDTO.getAnalysisSet();
		this.branch = masterFileDTO.getBranch();
		this.department = masterFileDTO.getDepartment();
		this.legalEntity = masterFileDTO.getLegalEntity();
		this.sector = masterFileDTO.getSector();
	}

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public EntityReferenceData getSector()
	{
		return sector;
	}

	public void setSector(EntityReferenceData sector)
	{
		this.sector = sector;
	}

	public EntityReferenceData getBranch()
	{
		return branch;
	}

	public void setBranch(EntityReferenceData branch)
	{
		this.branch = branch;
	}

	public EntityReferenceData getAnalysisSet()
	{
		return analysisSet;
	}

	public void setAnalysisSet(EntityReferenceData analysisSet)
	{
		this.analysisSet = analysisSet;
	}

	public EntityReferenceData getDepartment()
	{
		return department;
	}

	public void setDepartment(EntityReferenceData department)
	{
		this.department = department;
	}

	public String toIdsString()
	{
		StringBuilder idsString = new StringBuilder();
		appendId(getAnalysisSet(), idsString);
		return idsString.toString();
	}

	private void appendId(EntityReferenceData dim, StringBuilder idsString)
	{
		if (ObjectChecker.isEmptyOrNull(dim))
			idsString.append("null").append(CommonConstants.HOPEFULLY_UNIQUE_FIELD_SEP);
		else
			idsString.append(dim.getEntityType()).append(":").append(dim.getId()).append(CommonConstants.HOPEFULLY_UNIQUE_FIELD_SEP);
	}

	public Boolean getIgnoreLoginAnalysisSet()
	{
		return ignoreLoginAnalysisSet;
	}

	public void setIgnoreLoginAnalysisSet(Boolean ignoreLoginAnalysisSet)
	{
		this.ignoreLoginAnalysisSet = ignoreLoginAnalysisSet;
	}

	public Boolean getIgnoreLoginBranch()
	{
		return ignoreLoginBranch;
	}

	public void setIgnoreLoginBranch(Boolean ignoreLoginBranch)
	{
		this.ignoreLoginBranch = ignoreLoginBranch;
	}

	public Boolean getIgnoreLoginDepartment()
	{
		return ignoreLoginDepartment;
	}

	public void setIgnoreLoginDepartment(Boolean ignoreLoginDepartment)
	{
		this.ignoreLoginDepartment = ignoreLoginDepartment;
	}

	public Boolean getIgnoreLoginLegalEntity()
	{
		return ignoreLoginLegalEntity;
	}

	public void setIgnoreLoginLegalEntity(Boolean ignoreLoginLegalEntity)
	{
		this.ignoreLoginLegalEntity = ignoreLoginLegalEntity;
	}

	public Boolean getIgnoreLoginSector()
	{
		return ignoreLoginSector;
	}

	public void setIgnoreLoginSector(Boolean ignoreLoginSector)
	{
		this.ignoreLoginSector = ignoreLoginSector;
	}

	public EntityReferenceData get(String dimType)
	{
		if (ObjectChecker.isEmptyOrNull(dimType))
			return null;
		switch (dimType)
		{
		case DomainBaseEntities.LegalEntity:
			return getLegalEntity();
		case DomainBaseEntities.Sector:
			return getSector();
		case DomainBaseEntities.Branch:
			return getBranch();
		case DomainBaseEntities.Department:
			return getDepartment();
		case DomainBaseEntities.AnalysisSet:
			return getAnalysisSet();
		default:
			return null;
		}

	}

	public Boolean getIgnore(String dimType)
	{
		if (ObjectChecker.isEmptyOrNull(dimType))
			return null;
		switch (dimType)
		{
		case DomainBaseEntities.LegalEntity:
			return getIgnoreLoginLegalEntity();
		case DomainBaseEntities.Sector:
			return getIgnoreLoginSector();
		case DomainBaseEntities.Branch:
			return getIgnoreLoginBranch();
		case DomainBaseEntities.Department:
			return getIgnoreLoginDepartment();
		case DomainBaseEntities.AnalysisSet:
			return getIgnoreLoginAnalysisSet();
		default:
			return null;
		}
	}

	public void ignoreLoginAnalysisSet(EntityReferenceData analysisSet)
	{
		setAnalysisSet(analysisSet);
		setIgnoreLoginAnalysisSet(true);
	}

	public void ignoreLoginSector(EntityReferenceData sector)
	{
		setSector(sector);
		setIgnoreLoginSector(true);
	}

	public void ignoreLoginBranch(EntityReferenceData branch)
	{
		setBranch(branch);
		setIgnoreLoginBranch(true);
	}

	public void ignoreLoginDepartment(EntityReferenceData department)
	{
		setDepartment(department);
		setIgnoreLoginDepartment(true);
	}

	public void ignoreLoginLegalEntity(EntityReferenceData legalEntity)
	{
		setIgnoreLoginLegalEntity(true);
		setLegalEntity(legalEntity);
	}
}
