package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.criteria.DTOCriteriaBuilder;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.utilities.ObjectChecker;

import java.math.BigDecimal;

public class AGGridNumberFilterModel extends AGGridISimpleFilterModel
{
	private BigDecimal filter;
	private BigDecimal filterTo;

	public AGGridNumberFilterModel()
	{
	}

	@Override
	public void appendExpression(DTOCriteriaBuilder.DTOExpressionBuilder expressionBuilder, String fieldId, String fieldType)
	{
		DTOCriteriaBuilder.DTOExpressionBuilder exp = expressionBuilder.and().field(fieldId);
		String filterStr;
		String filterToStr;
		if (ObjectChecker.areEqual(fieldType, FieldType.Integer))
		{
			filterStr = FieldTypesUtils.toString(DataTypes.INTEGER, ObjectChecker.toZeroIfNull(filter).intValue());
			filterToStr = FieldTypesUtils.toString(DataTypes.INTEGER, ObjectChecker.toZeroIfNull(filterTo).intValue());
		}
		else if (ObjectChecker.areEqual(fieldType, FieldType.Long))
		{
			filterStr = FieldTypesUtils.toString(DataTypes.LONG, ObjectChecker.toZeroIfNull(filter).longValue());
			filterToStr = FieldTypesUtils.toString(DataTypes.LONG, ObjectChecker.toZeroIfNull(filterTo).longValue());
		}
		else
		{
			filterStr = FieldTypesUtils.toString(DataTypes.BIGDECIMAL, ObjectChecker.toZeroIfNull(filter));
			filterToStr = FieldTypesUtils.toString(DataTypes.BIGDECIMAL, ObjectChecker.toZeroIfNull(filterTo));
		}
		switch (getType())
		{
		case blank -> exp.isNull();
		case notBlank -> exp.isNotNull();
		case equals -> exp.equal(filterStr);
		case notEqual -> exp.notEqual(filterStr);
		case greaterThan -> exp.greaterThan(filterStr);
		case greaterThanOrEqual -> exp.greaterThanOrEqual(filterStr);
		case lessThan -> exp.lessThan(filterStr);
		case lessThanOrEqual -> exp.lessThanOrEqual(filterStr);
		case inRange -> exp.greaterThanOrEqual(filterStr).and().field(fieldId).lessThanOrEqual(filterToStr);
		}
	}

	public BigDecimal getFilter()
	{
		return filter;
	}

	public void setFilter(BigDecimal filter)
	{
		this.filter = filter;
	}

	public BigDecimal getFilterTo()
	{
		return filterTo;
	}

	public void setFilterTo(BigDecimal filterTo)
	{
		this.filterTo = filterTo;
	}
}
