package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.specialserialization.FlatObjectUtilies;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.math.BigDecimal;
import java.util.UUID;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class PaymentGatewayReq extends NaMaDTO
{
	private String jsonRespFromGateway;
	private BigDecimal valueToPaid;
	private String terminalID;

	public PaymentGatewayReq()
	{
	}

	public PaymentGatewayReq(String responseFromGateway, BigDecimal valueToPaid, String terminalID)
	{
		this.jsonRespFromGateway = responseFromGateway;
		this.valueToPaid = valueToPaid;
		this.terminalID = terminalID;
	}

	public String getJsonRespFromGateway()
	{
		return jsonRespFromGateway;
	}

	public void setJsonRespFromGateway(String jsonRespFromGateway)
	{
		this.jsonRespFromGateway = jsonRespFromGateway;
	}

	public BigDecimal getValueToPaid()
	{
		return valueToPaid;
	}

	public void setValueToPaid(BigDecimal valueToPaid)
	{
		this.valueToPaid = valueToPaid;
	}

	public String getTerminalID()
	{
		return terminalID;
	}

	public void setTerminalID(String terminalID)
	{
		this.terminalID = terminalID;
	}
}
