package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.constants.OutputFormat;
import com.namasoft.common.constants.PrintingOption;
import com.namasoft.common.criteria.DTOFilledQuestionField;
import com.namasoft.common.objects.IPrintReportRequest;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class PrintReportRequest extends ServiceRequest implements ReportBasicParamters, IPrintReportRequest
{
	private String entityType;
	private String entityId;
	private String tabId;
	private String tempPrintId;
	private OutputFormat format;
	private PrintingOption printingOption;
	private String viewName;
	private List<String> idsList;
	private boolean form = true;
	private String monitorId;
	private String formReportId;
	private String menuCode;

	public PrintReportRequest(String reportId)
	{
		super();
	}

	public PrintReportRequest()
	{
		super();
	}

	public String getTempPrintId()
	{
		return tempPrintId;
	}

	public void setTempPrintId(String tempPrintId)
	{
		this.tempPrintId = tempPrintId;
	}

	public OutputFormat getFormat()
	{
		return format;
	}

	public void setFormat(OutputFormat format)
	{
		this.format = format;
	}

	public PrintingOption getPrintingOption()
	{
		return printingOption;
	}

	@Override
	public String entityType()
	{
		return getEntityType();
	}

	@Override
	public String entityId()
	{
		return getEntityId();
	}

	public void setPrintingOption(PrintingOption printingOption)
	{
		this.printingOption = printingOption;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public String getEntityId()
	{
		return entityId;
	}

	public void setEntityId(String entityId)
	{
		this.entityId = entityId;
	}

	public String getTabId()
	{
		return tabId;
	}

	public void setTabId(String tabId)
	{
		this.tabId = tabId;
	}

	public String getViewName()
	{
		return viewName;
	}

	public void setViewName(String viewName)
	{
		this.viewName = viewName;
	}

	public List<String> getIdsList()
	{
		return idsList;
	}

	public void setIdsList(List<String> idsList)
	{
		this.idsList = idsList;
	}

	public boolean isForm()
	{
		return form;
	}

	public void setForm(boolean form)
	{
		this.form = form;
	}

	public String getMonitorId()
	{
		return monitorId;
	}

	public void setMonitorId(String monitorId)
	{
		this.monitorId = monitorId;
	}

	public static RunReportRequest createRunRequest(List<DTOFilledQuestionField> parameters, String reportId, OutputFormat outputFormat,
			PrintingOption printingOption, String tempPrintId, String monitorId, Boolean runAsynchronous)
	{
		RunReportRequest request = new RunReportRequest();
		request.setFormat(outputFormat);
		request.setPrintingOption(printingOption);
		request.setReportId(reportId);
		request.setTempPrintId(tempPrintId);
		request.setParameters(parameters);
		request.setMonitorId(monitorId);
		request.setRunAsynchronous(runAsynchronous);
		return request;
	}

	public static PrintReportRequest createPrintFormRequest(OutputFormat outputFormat, PrintingOption printingOption, String entityType,
			String entityId, String tabId, String viewName, String monitorId, String formReportId)
	{
		PrintReportRequest printRequest = new PrintReportRequest();
		printRequest.setPrintingOption(printingOption);
		printRequest.setFormat(outputFormat);
		printRequest.setEntityType(entityType);
		printRequest.setEntityId(entityId);
		printRequest.setTabId(tabId);
		printRequest.setViewName(viewName);
		printRequest.setForm(true);
		printRequest.setMonitorId(monitorId);
		printRequest.setFormReportId(formReportId);
		return printRequest;
	}

	public static PrintReportRequest createPrintListRequest(OutputFormat outputFormat, PrintingOption printingOption, String entityType,
			List<String> listIds, String viewName, String monitorId, String menuCode)
	{
		PrintReportRequest printRequest = new PrintReportRequest();
		printRequest.setPrintingOption(printingOption);
		printRequest.setFormat(outputFormat);
		printRequest.setEntityType(entityType);
		printRequest.setViewName(viewName);
		printRequest.setIdsList(listIds);
		printRequest.setForm(false);
		printRequest.setMonitorId(monitorId);
		printRequest.setMenuCode(menuCode);
		return printRequest;
	}

	public void setFormReportId(String formReportId)
	{
		this.formReportId = formReportId;
	}

	public String getFormReportId()
	{
		return formReportId;
	}

	public String getMenuCode()
	{
		return menuCode;
	}

	public void setMenuCode(String menuCode)
	{
		this.menuCode = menuCode;
	}
}
