package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.IServiceRequest;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.*;
import jakarta.xml.bind.annotation.*;

import java.io.Serializable;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ServiceRequest implements Serializable, IServiceRequest
{
	private static final long serialVersionUID = -7466394683666422345L;
	private String expectedServerVersion;
	private String clientId;
	private String loginId;
	private Language lang;
	private String passwordHash;
	private String ip;
	private String otherInfo;
	private EntityDimensionsDTO dimensionsIds;
	private String userId;
	private Boolean doNotRememberLoginDimensions;
	private static LoginInfoInitializer loginInfoInitializer = null;
	private Boolean trackLogs;
	private transient String transientIp;
	private Boolean fromAutoSaveWithInput;
	private String apiKey;
	private String apiSecret;
	private Boolean fromVue;
	private String otpId;
	private String otpValue;

	public static void setLoginInfoInitializer(LoginInfoInitializer initializer)
	{
		ServiceRequest.loginInfoInitializer = initializer;
	}

	public static LoginInfoInitializer getLoginInfoInitializer()
	{
		return loginInfoInitializer;
	}

	public String getExpectedServerVersion()
	{
		return expectedServerVersion;
	}

	public void setExpectedServerVersion(String expectedServerVersion)
	{
		this.expectedServerVersion = expectedServerVersion;
	}

	public String getClientId()
	{
		return clientId;
	}

	public void setClientId(String clientId)
	{
		this.clientId = clientId;
	}

	public ServiceRequest()
	{
		if (loginInfoInitializer != null)
			loginInfoInitializer.initializeLoginInfo(this);
	}

	public ServiceRequest(String userId, String passwordHash)
	{
		this();
		setLoginId(userId);
		setPasswordHash(passwordHash);

	}

	public ServiceRequest(ServiceRequest request)
	{
		this();
		if (request != null)
		{
			this.expectedServerVersion = request.expectedServerVersion;
			this.clientId = request.clientId;
			this.loginId = request.loginId;
			this.lang = request.lang;
			this.passwordHash = request.passwordHash;
			this.ip = request.ip;
			this.otherInfo = request.otherInfo;
			this.apiKey = request.apiKey;
			this.apiSecret = request.apiSecret;
		}
	}

	public Language getLang()
	{
		return lang;
	}

	public void setLang(Language lang)
	{
		this.lang = lang;
	}

	@Override
	public String getLoginId()
	{
		return loginId;
	}

	public void setLoginId(String loginId)
	{
		this.loginId = loginId;
	}

	@Override
	public String getPasswordHash()
	{
		return passwordHash;
	}

	public void setPasswordHash(String passwordHash)
	{
		this.passwordHash = passwordHash;
	}

	public <T extends ServiceRequest> T copyAuthenticationInfoFrom(ServiceRequest from)
	{
		return (T) from.copyAuthenticationInfoTo(this);
	}

	public <T extends ServiceRequest> T copyAuthenticationInfoTo(T to)
	{
		to.setPasswordHash(getPasswordHash());
		to.setLoginId(getLoginId());
		to.setDimensionsIds(getDimensionsIds());
		to.setIp(getIp());
		to.setUserId(getUserId());
		to.setFromVue(getFromVue());
		to.setOtpId(getOtpId());
		to.setOtpValue(getOtpValue());
		return to;
	}

	@Override
	public String getIp()
	{
		return ObjectChecker.getFirstNotEmptyObj(ip, transientIp);
	}

	public void setIp(String ip)
	{
		this.ip = ip;
		if (ObjectChecker.isNotEmptyOrNull(ip))
			this.transientIp = ip;
	}

	public String getOtherInfo()
	{
		return otherInfo;
	}

	public void setOtherInfo(String otherInfo)
	{
		this.otherInfo = otherInfo;
	}

	public EntityDimensionsDTO getDimensionsIds()
	{
		return dimensionsIds;
	}

	public void setDimensionsIds(EntityDimensionsDTO dimensionsIds)
	{
		this.dimensionsIds = dimensionsIds;
	}

	public String getUserId()
	{
		return userId;
	}

	public void setUserId(String userId)
	{
		this.userId = userId;
	}

	public Boolean getDoNotRememberLoginDimensions()
	{
		return doNotRememberLoginDimensions;
	}

	public Boolean getTrackLogs()
	{
		return trackLogs;
	}

	public void setTrackLogs(Boolean trackLogs)
	{
		this.trackLogs = trackLogs;
	}

	public void setDoNotRememberLoginDimensions(Boolean doNotRememberLoginDimensions)
	{
		this.doNotRememberLoginDimensions = doNotRememberLoginDimensions;
	}

	public <T extends ServiceRequest> T userAndPasswordIfNotEmpty(String userId, String password)
	{
		if (ObjectChecker.isNotEmptyOrNull(userId))
			setLoginId(userId);
		if (ObjectChecker.isNotEmptyOrNull(password))
			setPasswordHash(password);
		return (T) this;
	}

	public <T extends ServiceRequest> T ip(String ip)
	{
		setIp(ip);
		return (T) this;
	}

	public void setFromAutoSaveWithInput(Boolean fromAutoSaveWithInput)
	{
		this.fromAutoSaveWithInput = fromAutoSaveWithInput;
	}

	public Boolean getFromAutoSaveWithInput()
	{
		return fromAutoSaveWithInput;
	}

	@Override
	public String getApiKey()
	{
		return apiKey;
	}

	public void setApiKey(String apiKey)
	{
		this.apiKey = apiKey;
	}

	@Override
	public String getApiSecret()
	{
		return apiSecret;
	}

	public void setApiSecret(String apiSecret)
	{
		this.apiSecret = apiSecret;
	}

	public Boolean getFromVue()
	{
		return fromVue;
	}

	public void setFromVue(Boolean fromVue)
	{
		this.fromVue = fromVue;
	}

	public String getOtpId()
	{
		return otpId;
	}

	public void setOtpId(String otpId)
	{
		this.otpId = otpId;
	}

	@Override
	public String getOtpValue()
	{
		return otpValue;
	}

	public void setOtpValue(String otpValue)
	{
		this.otpValue = otpValue;
	}
}
