package com.namasoft.contracts.common.dtos.results;

import java.math.BigDecimal;
import java.util.Date;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CurrencyRateResult extends NaMaDTO
{
	private EntityReferenceData mainCurrency;
	private EntityReferenceData slaveCurrency;
	private BigDecimal rate;
	private Date onDate;

	public CurrencyRateResult()
	{
		super();
	}

	public CurrencyRateResult(EntityReferenceData mainCurrency, EntityReferenceData slaveCurrency, BigDecimal rate, Date onDate)
	{
		this.rate = rate;
		this.slaveCurrency = slaveCurrency;
		this.mainCurrency = mainCurrency;
		this.onDate = onDate;
	}

	public EntityReferenceData getMainCurrency()
	{
		return mainCurrency;
	}

	public void setMainCurrency(EntityReferenceData mainCurrency)
	{
		this.mainCurrency = mainCurrency;
	}

	public EntityReferenceData getSlaveCurrency()
	{
		return slaveCurrency;
	}

	public void setSlaveCurrency(EntityReferenceData slaveCurrency)
	{
		this.slaveCurrency = slaveCurrency;
	}

	public BigDecimal getRate()
	{
		return rate;
	}

	public void setRate(BigDecimal rate)
	{
		this.rate = rate;
	}

	public Date getOnDate()
	{
		return onDate;
	}

	public void setOnDate(Date onDate)
	{
		this.onDate = onDate;
	}

}
