package com.namasoft.modules.commonbasic.contracts.invoicing;

import com.namasoft.common.flatobjects.EntityReferenceData;

import java.math.BigDecimal;

public interface IDTOInvoicePaymentLine
{
	BigDecimal getAfterFeesValue();

	BigDecimal getFeesTaxValue();

	BigDecimal getFeesValue();

	BigDecimal getPaidCash();

	BigDecimal getPaymentValue();

	BigDecimal getRemainingCash();

	default EntityReferenceData fetchDiscountCoupon()
	{
		return null;
	}

	EntityReferenceData getPaymentMethod();

	void setPaymentMethod(EntityReferenceData paymentMethod);

	void setFeesValue(BigDecimal value);

	void setAfterFeesValue(BigDecimal value);

	void setRemainingCash(BigDecimal value);

	void setPaidCash(BigDecimal value);

	void setPaymentValue(BigDecimal value);

	Boolean getDoNotAffectRemaining();
}
