package com.namasoft.modules.commonbasic.contracts.valueobjects;

import java.io.Serializable;
import java.math.BigDecimal;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.utilities.MoneyEffectType;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOInvoiceMoney extends GeneratedDTOInvoiceMoney implements Serializable
{
	public void updateNulls()
	{
		if (getHeaderDiscount() == null)
			setHeaderDiscount(new DTOMoneyEffectDetails());
		getHeaderDiscount().updateNulls();
		setTotal(NaMaMath.zeroIfNull(getTotal()));
		setAfterDiscount1(NaMaMath.zeroIfNull(getAfterDiscount1()));
		setAfterDiscount2(NaMaMath.zeroIfNull(getAfterDiscount2()));
		setAfterDiscount3(NaMaMath.zeroIfNull(getAfterDiscount3()));
		setAfterDiscount4(NaMaMath.zeroIfNull(getAfterDiscount4()));
		setAfterDiscount5(NaMaMath.zeroIfNull(getAfterDiscount5()));
		setAfterDiscount6(NaMaMath.zeroIfNull(getAfterDiscount6()));
		setAfterDiscount7(NaMaMath.zeroIfNull(getAfterDiscount7()));
		setAfterDiscount8(NaMaMath.zeroIfNull(getAfterDiscount8()));
		setAfterTaxValue(NaMaMath.zeroIfNull(getAfterTaxValue()));
		setAfterHTaxValue(NaMaMath.zeroIfNull(getAfterHTaxValue()));

		setTax1Total(NaMaMath.zeroIfNull(getTax1Total()));
		setTax2Total(NaMaMath.zeroIfNull(getTax2Total()));
		setTax3Total(NaMaMath.zeroIfNull(getTax3Total()));
		setTax4Total(NaMaMath.zeroIfNull(getTax4Total()));
		setDiscount1Total(NaMaMath.zeroIfNull(getDiscount1Total()));
		setDiscount2Total(NaMaMath.zeroIfNull(getDiscount2Total()));
		setDiscount3Total(NaMaMath.zeroIfNull(getDiscount3Total()));
		setDiscount4Total(NaMaMath.zeroIfNull(getDiscount4Total()));
		setDiscount5Total(NaMaMath.zeroIfNull(getDiscount5Total()));
		setDiscount6Total(NaMaMath.zeroIfNull(getDiscount6Total()));
		setDiscount7Total(NaMaMath.zeroIfNull(getDiscount7Total()));
		setDiscount8Total(NaMaMath.zeroIfNull(getDiscount8Total()));

		setCashAmount(NaMaMath.zeroIfNull(getCashAmount()));
		setNetValue(NaMaMath.zeroIfNull(getNetValue()));
		setRemaining(NaMaMath.zeroIfNull(getRemaining()));
		setTotalPaid(NaMaMath.zeroIfNull(getTotalPaid()));
		setTotalPaymentMethods(NaMaMath.zeroIfNull(getTotalPaymentMethods()));
		setVouchersPayments(NaMaMath.zeroIfNull(getVouchersPayments()));
	}

	public void resetAccumualtingValues()
	{
		setAfterDiscount1(BigDecimal.ZERO);
		setAfterDiscount2(BigDecimal.ZERO);
		setAfterDiscount3(BigDecimal.ZERO);
		setAfterDiscount4(BigDecimal.ZERO);
		setAfterDiscount5(BigDecimal.ZERO);
		setAfterDiscount6(BigDecimal.ZERO);
		setAfterDiscount7(BigDecimal.ZERO);
		setAfterDiscount8(BigDecimal.ZERO);
		setAfterTaxValue(BigDecimal.ZERO);
		setAfterHTaxValue(BigDecimal.ZERO);
		setTax1Total(BigDecimal.ZERO);
		setTax2Total(BigDecimal.ZERO);
		setTax3Total(BigDecimal.ZERO);
		setTax4Total(BigDecimal.ZERO);
		setDiscount1Total(BigDecimal.ZERO);
		setDiscount2Total(BigDecimal.ZERO);
		setDiscount3Total(BigDecimal.ZERO);
		setDiscount4Total(BigDecimal.ZERO);
		setDiscount5Total(BigDecimal.ZERO);
		setDiscount6Total(BigDecimal.ZERO);
		setDiscount7Total(BigDecimal.ZERO);
		setDiscount8Total(BigDecimal.ZERO);
		setNetValue(BigDecimal.ZERO);
		setTotal(BigDecimal.ZERO);
		if (getHeaderDiscount() == null)
			setHeaderDiscount(new DTOMoneyEffectDetails());
		getHeaderDiscount().setAfterValue(BigDecimal.ZERO);
		getHeaderDiscount().setValue(BigDecimal.ZERO);
	}

	public void updateAccumulatingField(BigDecimal lineTotal, BigDecimal discountValue, MoneyEffectType key)
	{
		if (ObjectChecker.areEqual(key, MoneyEffectType.Discount1))
		{
			setAfterDiscount1(getAfterDiscount1().add(lineTotal));
			setDiscount1Total(getDiscount1Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Discount2))
		{
			setAfterDiscount2(getAfterDiscount2().add(lineTotal));
			setDiscount2Total(getDiscount2Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Discount3))
		{
			setAfterDiscount3(getAfterDiscount3().add(lineTotal));
			setDiscount3Total(getDiscount3Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Discount4))
		{
			setAfterDiscount4(getAfterDiscount4().add(lineTotal));
			setDiscount4Total(getDiscount4Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Discount5))
		{
			setAfterDiscount5(getAfterDiscount5().add(lineTotal));
			setDiscount5Total(getDiscount5Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Discount6))
		{
			setAfterDiscount6(getAfterDiscount6().add(lineTotal));
			setDiscount6Total(getDiscount6Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Discount7))
		{
			setAfterDiscount7(getAfterDiscount7().add(lineTotal));
			setDiscount7Total(getDiscount7Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Discount8))
		{
			setAfterDiscount8(getAfterDiscount8().add(lineTotal));
			setDiscount8Total(getDiscount8Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Tax1))
		{
			setTax1Total(getTax1Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Tax2))
		{
			setTax2Total(getTax2Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Tax3))
		{
			setTax3Total(getTax3Total().add(discountValue));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Tax4))
		{
			setTax4Total(getTax4Total().add(discountValue));
		}

		if (ObjectChecker.areEqual(key, MoneyEffectType.HeaderDiscount))
		{
			getHeaderDiscount().setValue(getHeaderDiscount().getValue().add(discountValue));
			getHeaderDiscount().setAfterValue(getHeaderDiscount().getAfterValue().add(lineTotal));
		}
		if (ObjectChecker.areEqual(key, MoneyEffectType.Tax2))
			setAfterTaxValue(getAfterTaxValue().add(lineTotal));
		if (ObjectChecker.areEqual(key, MoneyEffectType.Tax4))
			setAfterHTaxValue(getAfterHTaxValue().add(lineTotal));
	}

	public void updateInvoiceMoney()
	{
		updateNulls();
		BigDecimal totalPaymentMethod = NaMaMath.zeroIfNull(getTotalPaymentMethods());
		BigDecimal vouchersPayments = NaMaMath.zeroIfNull(getVouchersPayments());
		BigDecimal notCashPaid = totalPaymentMethod.add(vouchersPayments);
		BigDecimal notPaidYet = getNetValue().subtract(notCashPaid);
		BigDecimal cashAmount = NaMaMath.zeroIfNull(getCashAmount());
		BigDecimal paidCash = NaMaMath.zeroIfNull(getPaidCash());
		BigDecimal remainigCash = BigDecimal.ZERO;
		if (ObjectChecker.isNotEmptyOrZero(paidCash))
		{
			cashAmount = notPaidYet.min(paidCash);
			remainigCash = paidCash.subtract(cashAmount);
		}
		BigDecimal accumulatedPaid = cashAmount.add(totalPaymentMethod).add(vouchersPayments);
		setTotalPaid(accumulatedPaid);
		BigDecimal remaining = getNetValue().subtract(accumulatedPaid);
		setRemaining(remaining);
		setCashAmount(cashAmount);
		setRemainingCash(remainigCash);
		setRemainingAfterLastSave(NaMaMath.subtract(getNetValue(), getTotalPaidAfterLastSave()));
	}

	public void setAccumulatingData(BigDecimal sumPrice, BigDecimal sumAfterDiscount1, BigDecimal sumAfterDiscount2, BigDecimal sumAfterDiscount3,
			BigDecimal sumAfterDiscount4, BigDecimal sumAfterDiscount5, BigDecimal sumAfterDiscount6, BigDecimal sumAfterDiscount7,
			BigDecimal sumAfterDiscount8, BigDecimal headerDiscount, BigDecimal sumAfterHeaderDiscount, BigDecimal sumNetValue, BigDecimal afterTax,
			BigDecimal afterHTax, BigDecimal sumD1, BigDecimal sumD2, BigDecimal sumD3, BigDecimal sumD4, BigDecimal sumD5, BigDecimal sumD6,
			BigDecimal sumD7, BigDecimal sumD8, BigDecimal sumT1, BigDecimal sumT2, BigDecimal sumT3, BigDecimal sumT4)
	{
		setTotal(sumPrice);
		setAfterDiscount1(sumAfterDiscount1);
		setAfterDiscount2(sumAfterDiscount2);
		setAfterDiscount3(sumAfterDiscount3);
		setAfterDiscount4(sumAfterDiscount4);
		setAfterDiscount5(sumAfterDiscount5);
		setAfterDiscount6(sumAfterDiscount6);
		setAfterDiscount7(sumAfterDiscount7);
		setAfterDiscount8(sumAfterDiscount8);

		setNetValue(sumNetValue);
		getHeaderDiscount().setAfterValue(sumAfterHeaderDiscount);
		getHeaderDiscount().setValue(headerDiscount);
		setAfterHTaxValue(afterHTax);
		setAfterTaxValue(afterTax);
		// this part assumes that discounts are calculated in their order, and
		// taxes are calculated at the end after discounts also
		setTax1Total(sumT1);
		setTax2Total(sumT2);
		setTax3Total(sumT3);
		setTax4Total(sumT4);
		setDiscount1Total(sumD1);
		setDiscount2Total(sumD2);
		setDiscount3Total(sumD3);
		setDiscount4Total(sumD4);
		setDiscount5Total(sumD5);
		setDiscount6Total(sumD6);
		setDiscount7Total(sumD7);
		setDiscount8Total(sumD8);
	}

}
