package com.namasoft.modules.commonbasic.contracts.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTOLocalEntity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Date;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTODLVDeliveryTransaction extends DTOLocalEntity implements Serializable
{
	private Date creationDate;
	private Date retryDeliveryDateTime;
	private Date valueDate;
	private EntityReferenceData deliveredBy;
	private EntityReferenceData deliveredByCar;
	private EntityReferenceData deliveryDocument;
	private EntityReferenceData origin;
	private String deliveryEntryId;
	private String deliveryStatus;
	private String shipment;
	public Date getCreationDate()
	{
		return creationDate;
	}

	public Date getRetryDeliveryDateTime()
	{
		return retryDeliveryDateTime;
	}

	public Date getValueDate()
	{
		return valueDate;
	}

	public EntityReferenceData getDeliveredBy()
	{
		return deliveredBy;
	}

	public EntityReferenceData getDeliveredByCar()
	{
		return deliveredByCar;
	}

	public EntityReferenceData getDeliveryDocument()
	{
		return deliveryDocument;
	}

	public EntityReferenceData getOrigin()
	{
		return origin;
	}

	public String getDeliveryEntryId()
	{
		return deliveryEntryId;
	}

	public String getDeliveryStatus()
	{
		return deliveryStatus;
	}

	public String getShipment()
	{
		return shipment;
	}

	public void setCreationDate(Date creationDate)
	{
		this.creationDate = creationDate;
	}

	public void setDeliveredBy(EntityReferenceData deliveredBy)
	{
		this.deliveredBy = deliveredBy;
	}

	public void setDeliveredByCar(EntityReferenceData deliveredByCar)
	{
		this.deliveredByCar = deliveredByCar;
	}

	public void setDeliveryDocument(EntityReferenceData deliveryDocument)
	{
		this.deliveryDocument = deliveryDocument;
	}

	public void setDeliveryEntryId(String deliveryEntryId)
	{
		this.deliveryEntryId = deliveryEntryId;
	}

	public void setDeliveryStatus(String deliveryStatus)
	{
		this.deliveryStatus = deliveryStatus;
	}

	public void setOrigin(EntityReferenceData origin)
	{
		this.origin = origin;
	}

	public void setRetryDeliveryDateTime(Date retryDeliveryDateTime)
	{
		this.retryDeliveryDateTime = retryDeliveryDateTime;
	}

	public void setShipment(String shipment)
	{
		this.shipment = shipment;
	}

	public void setValueDate(Date valueDate)
	{
		this.valueDate = valueDate;
	}

}
