package com.namasoft.common;

import java.io.Serializable;
import java.util.List;

import com.namasoft.common.utilities.ObjectChecker;

public class EntityActionDefintion implements Serializable
{
	private static final long serialVersionUID = -1503902807242281810L;
	private String id;
	private List<String> targetEntities;

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public List<String> getTargetEntities()
	{
		return targetEntities;
	}

	public void setTargetEntities(List<String> targetEntities)
	{
		this.targetEntities = targetEntities;
	}

	public boolean isApplicableForEntity(String entiyType)
	{
		if (ObjectChecker.isEmptyOrNull(getTargetEntities()))
			return true;
		return getTargetEntities().contains(entiyType);
	}
}
