package com.namasoft.common;

import com.namasoft.common.utilities.ObjectChecker;

import java.util.Arrays;

@SuppressWarnings("serial")
public class Triple<X, Y, Z> extends Tuple<X, Y>
{
	private Z z;

	public Triple()
	{
	}

	public Z getZ()
	{
		return z;
	}

	public void setZ(Z z)
	{
		this.z = z;
	}

	public Triple(X x, Y y, Z z)
	{
		super(x, y);
		this.z = z;
	}

	@Override
	public int hashCode()
	{
		return Arrays.asList(getX(), getY(), getZ()).hashCode();
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj instanceof Triple)
			return ObjectChecker.arePairsEqual(getX(), ((Triple) obj).getX(), getY(), ((Triple) obj).getY(), getZ(), ((Triple) obj).getZ());
		return super.equals(obj);
	}

}
