package com.namasoft.common.flatobjects;

import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.util.*;
import java.util.function.IntConsumer;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
@SuppressWarnings({ "rawtypes" })
public class DTOServerTask implements IDTOTask
{
	private String spid;
	private String secondSpId;
	private Date startTime;
	private EntityReferenceData user;
	private String message;
	private String progress;
	private String fromIP;
	private String taskId;
	private String secoondDBResourceName;
	private boolean markedForKill;
	private Date markedForKillOn;
	private transient Object taskThreadKey;
	private boolean report;
	private Integer reportPagesCount;
	private transient IntConsumer pagesCountListener;

	public void setPagesCountListener(IntConsumer pagesCountListener)
	{
		this.pagesCountListener = pagesCountListener;
	}

	public DTOServerTask(Date startTime, EntityReferenceData user, String message, String fromIP, String spid, Object taskThreadKey, String taskId)
	{
		this.startTime = startTime;
		this.user = user;
		this.message = message;
		this.fromIP = fromIP;
		this.taskId = taskId;
		if (ObjectChecker.isEmptyOrNull(this.taskId))
			this.taskId = UUID.randomUUID().toString();
		this.spid = spid;
		this.taskThreadKey = taskThreadKey;
	}

	public DTOServerTask()
	{
	}
	@Override
	public Date getStartTime()
	{
		return startTime;
	}

	public void setStartTime(Date startTime)
	{
		this.startTime = startTime;
	}
	@Override
	public EntityReferenceData getUser()
	{
		return user;
	}

	public void setUser(EntityReferenceData user)
	{
		this.user = user;
	}
	@Override
	public String getMessage()
	{
		return message;
	}

	public void setMessage(String message)
	{
		this.message = message;
	}
	@Override
	public String getFromIP()
	{
		return fromIP;
	}

	public void setFromIP(String fromIP)
	{
		this.fromIP = fromIP;
	}
	@Override
	public String getTaskId()
	{
		return taskId;
	}

	public void setTaskId(String taskId)
	{
		this.taskId = taskId;
	}

	public void setSpid(String spid)
	{
		this.spid = spid;
	}

	public String getSpid()
	{
		return spid;
	}
	@Override
	public boolean isMarkedForKill()
	{
		return markedForKill;
	}

	@Override
	public void updateProgress(String progress)
	{
		setProgress(progress);
	}

	@Override
	public void setMarkedForKill(boolean markedForKill)
	{
		this.markedForKill = markedForKill;
	}
	@Override
	public Date getMarkedForKillOn()
	{
		return markedForKillOn;
	}
	@Override
	public void setMarkedForKillOn(Date markedForKillOn)
	{
		this.markedForKillOn = markedForKillOn;
	}

	@XmlTransient
	public Object getTaskThreadKey()
	{
		return taskThreadKey;
	}

	public void setTaskThreadKey(Object taskThreadKey)
	{
		this.taskThreadKey = taskThreadKey;
	}

	public boolean isReport()
	{
		return report;
	}

	public void setReport(boolean report)
	{
		this.report = report;
	}

	@Override
	public String getProgress()
	{
		return progress;
	}

	public void setProgress(String progress)
	{
		this.progress = progress;
	}

	public String getSecondSpId()
	{
		return secondSpId;
	}

	public void setSecondSpId(String secondSpId)
	{
		this.secondSpId = secondSpId;
	}

	public String getSecoondDBResourceName()
	{
		return secoondDBResourceName;
	}

	public void setSecoondDBResourceName(String secoondDBResourceName)
	{
		this.secoondDBResourceName = secoondDBResourceName;
	}

	public void clearSecondResourceValues()
	{
		setSecoondDBResourceName("");
		setSecondSpId("");
	}

	public void updatePagesCount(int reportPagesCount)
	{
		setReportPagesCount(reportPagesCount);
		if (pagesCountListener != null)
			pagesCountListener.accept(reportPagesCount);
	}

	public Integer getReportPagesCount()
	{
		return reportPagesCount;
	}

	public void setReportPagesCount(Integer reportPagesCount)
	{
		this.reportPagesCount = reportPagesCount;
	}
}
