package com.namasoft.common.flatobjects;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.fieldids.Fields;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class FlatRecord extends NaMaDTO
{
	private String id;
	private String entityType;
	private String code;
	private String name1;
	private FlatObject record;
	private boolean inserted = false;
	private String error;

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public String getCode()
	{
		return code;
	}

	public void setCode(String code)
	{
		this.code = code;
	}

	public String getName1()
	{
		return name1;
	}

	public void setName1(String name1)
	{
		this.name1 = name1;
	}

	public FlatObject getRecord()
	{
		return record;
	}

	public void setRecord(FlatObject record)
	{
		this.record = record;
	}

	public static FlatRecord fromFlatObject(FlatObject record)
	{
		FlatRecord flatRecord = new FlatRecord();
		flatRecord.setRecord(record);
		flatRecord.setCode(Fields.code(record));
		flatRecord.setEntityType(Fields.entityType(record));
		flatRecord.setId(Fields.id(record));
		flatRecord.setName1(Fields.name1(record));
		return flatRecord;
	}

	public boolean isInserted()
	{
		return inserted;
	}

	public void setInserted(boolean inserted)
	{
		this.inserted = inserted;
	}

	public String getError()
	{
		return error;
	}

	public void setError(String error)
	{
		this.error = error;
	}

}
