package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.utilities.ObjectChecker;

abstract class AbsHttpRequestNode extends RenderNode
{
	protected final String nodeContent;

	public AbsHttpRequestNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, enderStr());
	}

	protected abstract String enderStr();
}
