package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ListViewUrlBuilder;

public class ListViewLinkCriteriaNode extends RenderNode implements IListViewLinkSubNode
{
	private final String nodeContent;

	public ListViewLinkCriteriaNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		throw new UnsupportedOperationException("The node " + describe() + " is misplaced.");
	}

	@Override
	public void apply(ListViewUrlBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		StringBuilder criteriaBuilder = new StringBuilder();
		renderSubNodes(criteriaBuilder, helper, currentLineNumber);
		builder.criteria(criteriaBuilder.toString());
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endlistcriteria");
	}
}
