package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;

abstract class PrefixSuffixCompositeNode extends RenderNode
{
	protected String nodeContent;

	public PrefixSuffixCompositeNode(String nodeContent)
	{
		super();
		this.nodeContent = nodeContent;
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		StringBuilder innerBuilder = new StringBuilder();
		innerBuilder.append(prefix(helper, currentLineNumber));
		renderSubNodes(innerBuilder, helper, currentLineNumber);
		innerBuilder.append(suffix(helper, currentLineNumber));
		builder.append(innerBuilder);
	}

	protected Object prefix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return "";
	}

	protected Object suffix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return "";
	}
}
