package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;

public class SubjectNode extends PrefixSuffixCompositeNode
{
	public SubjectNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	public boolean shouldSubNodeEndThis(RenderNode subNode)
	{
		return subNode instanceof MsgNode;
	}

	@Override
	protected Object prefix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return ComplexRenderer.START_MSG_SUBJECT;
	}

	@Override
	protected Object suffix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return ComplexRenderer.END_MSG_SUBJECT;
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endsubject");
	}
}
