package com.namasoft.common.layout;

import com.namasoft.common.layout.edit.*;
import com.namasoft.common.utilities.ObjectChecker;

public interface ActionPlaceholder extends TitledID
{
	CustomizedGUIActionInfo getCustomization();

	boolean shouldBeAdded();

	void setId(String s);

	void setTitle(NaMaText title);

	void setIconCode(String iconCode);

	default void updateIconCodeIfNotEmpty(Object iconCode)
	{
		if (ObjectChecker.isEmptyOrNull(iconCode))
			return;
		setIconCode(ObjectChecker.toStringOrNull(iconCode));
	}
}
